/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.guice.annotations.EscalatedClient;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.IndexTaskClientFactory;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.HashPartitionLocation;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialHashSegmentMergeIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.PartialSegmentMergeIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialSegmentMergeTask;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpec;
import org.joda.time.Interval;

public class PartialHashSegmentMergeTask
extends PartialSegmentMergeTask<HashBasedNumberedShardSpec, HashPartitionLocation> {
    public static final String TYPE = "partial_index_merge";
    private final HashedPartitionsSpec partitionsSpec;
    private final PartialHashSegmentMergeIngestionSpec ingestionSchema;

    @JsonCreator
    public PartialHashSegmentMergeTask(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="groupId") String groupId, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="supervisorTaskId") String supervisorTaskId, @JsonProperty(value="numAttempts") int numAttempts, @JsonProperty(value="spec") PartialHashSegmentMergeIngestionSpec ingestionSchema, @JsonProperty(value="context") Map<String, Object> context, @JacksonInject IndexingServiceClient indexingServiceClient, @JacksonInject IndexTaskClientFactory<ParallelIndexSupervisorTaskClient> taskClientFactory, @JacksonInject @EscalatedClient HttpClient shuffleClient) {
        super(PartialHashSegmentMergeTask.getOrMakeId(id, TYPE, ingestionSchema.getDataSchema().getDataSource()), groupId, taskResource, supervisorTaskId, ingestionSchema.getDataSchema(), (PartialSegmentMergeIOConfig)ingestionSchema.getIOConfig(), (ParallelIndexTuningConfig)ingestionSchema.getTuningConfig(), numAttempts, context, indexingServiceClient, taskClientFactory, shuffleClient);
        this.ingestionSchema = ingestionSchema;
        PartitionsSpec inputPartitionsSpec = ((ParallelIndexTuningConfig)ingestionSchema.getTuningConfig()).getGivenOrDefaultPartitionsSpec();
        Preconditions.checkArgument((boolean)(inputPartitionsSpec instanceof HashedPartitionsSpec), (Object)"hashed partitionsSpec required");
        this.partitionsSpec = (HashedPartitionsSpec)inputPartitionsSpec;
        Preconditions.checkNotNull((Object)this.partitionsSpec.getNumShards(), (Object)"hashed partitionsSpec numShards required");
    }

    @JsonProperty(value="spec")
    private PartialHashSegmentMergeIngestionSpec getIngestionSchema() {
        return this.ingestionSchema;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    HashBasedNumberedShardSpec createShardSpec(TaskToolbox toolbox, Interval interval, int partitionId) {
        return new HashBasedNumberedShardSpec(partitionId, ((Integer)Preconditions.checkNotNull((Object)this.partitionsSpec.getNumShards(), (Object)"numShards")).intValue(), this.partitionsSpec.getPartitionDimensions(), toolbox.getJsonMapper());
    }
}

