/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexPhaseRunner;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialHashSegmentMergeIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialHashSegmentMergeIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.PartialHashSegmentMergeTask;
import org.apache.druid.indexing.common.task.batch.parallel.PushedSegmentsReport;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskSpec;
import org.apache.druid.segment.indexing.DataSchema;

class PartialHashSegmentMergeParallelIndexTaskRunner
extends ParallelIndexPhaseRunner<PartialHashSegmentMergeTask, PushedSegmentsReport> {
    private static final String PHASE_NAME = "partial segment merge";
    private final DataSchema dataSchema;
    private final List<PartialHashSegmentMergeIOConfig> mergeIOConfigs;

    PartialHashSegmentMergeParallelIndexTaskRunner(TaskToolbox toolbox, String taskId, String groupId, DataSchema dataSchema, List<PartialHashSegmentMergeIOConfig> mergeIOConfigs, ParallelIndexTuningConfig tuningConfig, Map<String, Object> context, IndexingServiceClient indexingServiceClient) {
        super(toolbox, taskId, groupId, tuningConfig, context, indexingServiceClient);
        this.dataSchema = dataSchema;
        this.mergeIOConfigs = mergeIOConfigs;
    }

    @Override
    public String getName() {
        return PHASE_NAME;
    }

    @Override
    Iterator<SubTaskSpec<PartialHashSegmentMergeTask>> subTaskSpecIterator() {
        return this.mergeIOConfigs.stream().map(this::newTaskSpec).iterator();
    }

    @Override
    int estimateTotalNumSubTasks() {
        return this.mergeIOConfigs.size();
    }

    @VisibleForTesting
    SubTaskSpec<PartialHashSegmentMergeTask> newTaskSpec(PartialHashSegmentMergeIOConfig ioConfig) {
        final PartialHashSegmentMergeIngestionSpec ingestionSpec = new PartialHashSegmentMergeIngestionSpec(this.dataSchema, ioConfig, this.getTuningConfig());
        return new SubTaskSpec<PartialHashSegmentMergeTask>(this.getTaskId() + "_" + this.getAndIncrementNextSpecId(), this.getGroupId(), this.getTaskId(), this.getContext(), new InputSplit(ioConfig.getPartitionLocations())){

            @Override
            public PartialHashSegmentMergeTask newSubTask(int numAttempts) {
                return new PartialHashSegmentMergeTask(null, this.getGroupId(), null, this.getSupervisorTaskId(), numAttempts, ingestionSpec, this.getContext(), null, null, null);
            }
        };
    }
}

