/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.HashPartitionCachingLocalSegmentAllocator;
import org.apache.druid.indexing.common.task.IndexTaskClientFactory;
import org.apache.druid.indexing.common.task.IndexTaskSegmentAllocator;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.GeneratedHashPartitionsReport;
import org.apache.druid.indexing.common.task.batch.parallel.HashPartitionStat;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialSegmentGenerateTask;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.DefaultIndexTaskInputRowIteratorBuilder;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.ShardSpecFactory;
import org.joda.time.Interval;

public class PartialHashSegmentGenerateTask
extends PartialSegmentGenerateTask<GeneratedHashPartitionsReport> {
    public static final String TYPE = "partial_index_generate";
    private static final String PROP_SPEC = "spec";
    private final int numAttempts;
    private final ParallelIndexIngestionSpec ingestionSchema;
    private final String supervisorTaskId;

    @JsonCreator
    public PartialHashSegmentGenerateTask(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="groupId") String groupId, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="supervisorTaskId") String supervisorTaskId, @JsonProperty(value="numAttempts") int numAttempts, @JsonProperty(value="spec") ParallelIndexIngestionSpec ingestionSchema, @JsonProperty(value="context") Map<String, Object> context, @JacksonInject IndexingServiceClient indexingServiceClient, @JacksonInject IndexTaskClientFactory<ParallelIndexSupervisorTaskClient> taskClientFactory, @JacksonInject AppenderatorsManager appenderatorsManager) {
        super(PartialHashSegmentGenerateTask.getOrMakeId(id, TYPE, ingestionSchema.getDataSchema().getDataSource()), groupId, taskResource, supervisorTaskId, ingestionSchema, context, indexingServiceClient, taskClientFactory, appenderatorsManager, new DefaultIndexTaskInputRowIteratorBuilder());
        this.numAttempts = numAttempts;
        this.ingestionSchema = ingestionSchema;
        this.supervisorTaskId = supervisorTaskId;
    }

    @JsonProperty
    public int getNumAttempts() {
        return this.numAttempts;
    }

    @JsonProperty(value="spec")
    public ParallelIndexIngestionSpec getIngestionSchema() {
        return this.ingestionSchema;
    }

    @JsonProperty
    public String getSupervisorTaskId() {
        return this.supervisorTaskId;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        return this.tryTimeChunkLock(taskActionClient, this.getIngestionSchema().getDataSchema().getGranularitySpec().inputIntervals());
    }

    @Override
    IndexTaskSegmentAllocator createSegmentAllocator(TaskToolbox toolbox) throws IOException {
        return new HashPartitionCachingLocalSegmentAllocator(toolbox, this.getId(), this.supervisorTaskId, this.getDataSource(), this.createShardSpecs());
    }

    @Override
    GeneratedHashPartitionsReport createGeneratedPartitionsReport(TaskToolbox toolbox, List<DataSegment> segments) {
        List<HashPartitionStat> partitionStats = segments.stream().map(segment -> this.createPartitionStat(toolbox, (DataSegment)segment)).collect(Collectors.toList());
        return new GeneratedHashPartitionsReport(this.getId(), partitionStats);
    }

    private HashPartitionStat createPartitionStat(TaskToolbox toolbox, DataSegment segment) {
        return new HashPartitionStat(toolbox.getTaskExecutorNode().getHost(), toolbox.getTaskExecutorNode().getPortToUse(), toolbox.getTaskExecutorNode().isEnableTlsPort(), segment.getInterval(), segment.getShardSpec().getPartitionNum(), null, null);
    }

    private Map<Interval, Pair<ShardSpecFactory, Integer>> createShardSpecs() {
        GranularitySpec granularitySpec = this.ingestionSchema.getDataSchema().getGranularitySpec();
        ParallelIndexTuningConfig tuningConfig = this.ingestionSchema.getTuningConfig();
        HashedPartitionsSpec partitionsSpec = (HashedPartitionsSpec)tuningConfig.getGivenOrDefaultPartitionsSpec();
        return PartialHashSegmentGenerateTask.createShardSpecWithoutInputScan(granularitySpec, this.ingestionSchema.getIOConfig(), tuningConfig, (PartitionsSpec)partitionsSpec);
    }
}

