/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.guice.annotations.EscalatedClient;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.IndexTaskClientFactory;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.GenericPartitionLocation;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialGenericSegmentMergeIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialGenericSegmentMergeIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.PartialSegmentMergeIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialSegmentMergeTask;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;

public class PartialGenericSegmentMergeTask
extends PartialSegmentMergeTask<ShardSpec, GenericPartitionLocation> {
    public static final String TYPE = "partial_index_generic_merge";
    private final PartialGenericSegmentMergeIngestionSpec ingestionSchema;
    private final Table<Interval, Integer, ShardSpec> intervalAndIntegerToShardSpec;

    @JsonCreator
    public PartialGenericSegmentMergeTask(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="groupId") String groupId, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="supervisorTaskId") String supervisorTaskId, @JsonProperty(value="numAttempts") int numAttempts, @JsonProperty(value="spec") PartialGenericSegmentMergeIngestionSpec ingestionSchema, @JsonProperty(value="context") Map<String, Object> context, @JacksonInject IndexingServiceClient indexingServiceClient, @JacksonInject IndexTaskClientFactory<ParallelIndexSupervisorTaskClient> taskClientFactory, @JacksonInject @EscalatedClient HttpClient shuffleClient) {
        super(PartialGenericSegmentMergeTask.getOrMakeId(id, TYPE, ingestionSchema.getDataSchema().getDataSource()), groupId, taskResource, supervisorTaskId, ingestionSchema.getDataSchema(), (PartialSegmentMergeIOConfig)ingestionSchema.getIOConfig(), (ParallelIndexTuningConfig)ingestionSchema.getTuningConfig(), numAttempts, context, indexingServiceClient, taskClientFactory, shuffleClient);
        this.ingestionSchema = ingestionSchema;
        this.intervalAndIntegerToShardSpec = PartialGenericSegmentMergeTask.createIntervalAndIntegerToShardSpec(((PartialGenericSegmentMergeIOConfig)ingestionSchema.getIOConfig()).getPartitionLocations());
    }

    private static Table<Interval, Integer, ShardSpec> createIntervalAndIntegerToShardSpec(List<GenericPartitionLocation> partitionLocations) {
        HashBasedTable intervalAndIntegerToShardSpec = HashBasedTable.create();
        partitionLocations.forEach(arg_0 -> PartialGenericSegmentMergeTask.lambda$createIntervalAndIntegerToShardSpec$0((Table)intervalAndIntegerToShardSpec, partitionLocations, arg_0));
        return intervalAndIntegerToShardSpec;
    }

    @JsonProperty(value="spec")
    private PartialGenericSegmentMergeIngestionSpec getIngestionSchema() {
        return this.ingestionSchema;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    ShardSpec createShardSpec(TaskToolbox toolbox, Interval interval, int partitionId) {
        return (ShardSpec)Preconditions.checkNotNull((Object)this.intervalAndIntegerToShardSpec.get((Object)interval, (Object)partitionId), (String)"no shard spec exists for interval %s, partitionId %s: %s", (Object[])new Object[]{interval, partitionId, this.intervalAndIntegerToShardSpec.rowMap()});
    }

    private static /* synthetic */ void lambda$createIntervalAndIntegerToShardSpec$0(Table intervalAndIntegerToShardSpec, List partitionLocations, GenericPartitionLocation p) {
        ShardSpec currShardSpec = (ShardSpec)intervalAndIntegerToShardSpec.get((Object)p.getInterval(), (Object)p.getPartitionId());
        Preconditions.checkArgument((currShardSpec == null || p.getShardSpec().equals(currShardSpec) ? 1 : 0) != 0, (String)"interval %s, partitionId %s mismatched shard specs: %s", (Object[])new Object[]{p.getInterval(), p.getPartitionId(), partitionLocations});
        intervalAndIntegerToShardSpec.put((Object)p.getInterval(), (Object)p.getPartitionId(), (Object)p.getShardSpec());
    }
}

