/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexPhaseRunner;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialGenericSegmentMergeIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PartialGenericSegmentMergeIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.PartialGenericSegmentMergeTask;
import org.apache.druid.indexing.common.task.batch.parallel.PushedSegmentsReport;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskSpec;
import org.apache.druid.segment.indexing.DataSchema;

class PartialGenericSegmentMergeParallelIndexTaskRunner
extends ParallelIndexPhaseRunner<PartialGenericSegmentMergeTask, PushedSegmentsReport> {
    private static final String PHASE_NAME = "partial segment merge";
    private final DataSchema dataSchema;
    private final List<PartialGenericSegmentMergeIOConfig> mergeIOConfigs;

    PartialGenericSegmentMergeParallelIndexTaskRunner(TaskToolbox toolbox, String taskId, String groupId, DataSchema dataSchema, List<PartialGenericSegmentMergeIOConfig> mergeIOConfigs, ParallelIndexTuningConfig tuningConfig, Map<String, Object> context, IndexingServiceClient indexingServiceClient) {
        super(toolbox, taskId, groupId, tuningConfig, context, indexingServiceClient);
        this.dataSchema = dataSchema;
        this.mergeIOConfigs = mergeIOConfigs;
    }

    @Override
    public String getName() {
        return PHASE_NAME;
    }

    @Override
    Iterator<SubTaskSpec<PartialGenericSegmentMergeTask>> subTaskSpecIterator() {
        return this.mergeIOConfigs.stream().map(this::newTaskSpec).iterator();
    }

    @Override
    int estimateTotalNumSubTasks() {
        return this.mergeIOConfigs.size();
    }

    @VisibleForTesting
    SubTaskSpec<PartialGenericSegmentMergeTask> newTaskSpec(PartialGenericSegmentMergeIOConfig ioConfig) {
        final PartialGenericSegmentMergeIngestionSpec ingestionSpec = new PartialGenericSegmentMergeIngestionSpec(this.dataSchema, ioConfig, this.getTuningConfig());
        return new SubTaskSpec<PartialGenericSegmentMergeTask>(this.getTaskId() + "_" + this.getAndIncrementNextSpecId(), this.getGroupId(), this.getTaskId(), this.getContext(), new InputSplit(ioConfig.getPartitionLocations())){

            @Override
            public PartialGenericSegmentMergeTask newSubTask(int numAttempts) {
                return new PartialGenericSegmentMergeTask(null, this.getGroupId(), null, this.getSupervisorTaskId(), numAttempts, ingestionSpec, this.getContext(), null, null, null);
            }
        };
    }
}

