/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.data.input.HandlingInputRowIterator;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.ClientBasedTaskInfoProvider;
import org.apache.druid.indexing.common.task.IndexTaskClientFactory;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.DimensionDistributionReport;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTask;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.common.task.batch.parallel.PerfectRollupWorkerTask;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.StringDistribution;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.StringSketch;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.TimeDimTuple;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.TimeDimTupleFactory;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.TimeDimTupleFunnel;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.IndexTaskInputRowIteratorBuilder;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.RangePartitionIndexTaskInputRowIteratorBuilder;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class PartialDimensionDistributionTask
extends PerfectRollupWorkerTask {
    public static final String TYPE = "partial_dimension_distribution";
    private static final Logger LOG = new Logger(PartialDimensionDistributionTask.class);
    private static final boolean SKIP_NULL = true;
    private final int numAttempts;
    private final ParallelIndexIngestionSpec ingestionSchema;
    private final String supervisorTaskId;
    private final IndexingServiceClient indexingServiceClient;
    private final IndexTaskClientFactory<ParallelIndexSupervisorTaskClient> taskClientFactory;
    private final Supplier<DedupRowDimensionValueFilter> dedupRowDimValueFilterSupplier;

    @JsonCreator
    PartialDimensionDistributionTask(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="groupId") String groupId, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="supervisorTaskId") String supervisorTaskId, @JsonProperty(value="numAttempts") int numAttempts, @JsonProperty(value="spec") ParallelIndexIngestionSpec ingestionSchema, @JsonProperty(value="context") Map<String, Object> context, @JacksonInject IndexingServiceClient indexingServiceClient, @JacksonInject IndexTaskClientFactory<ParallelIndexSupervisorTaskClient> taskClientFactory) {
        this(id, groupId, taskResource, supervisorTaskId, numAttempts, ingestionSchema, context, indexingServiceClient, taskClientFactory, () -> new DedupRowDimensionValueFilter(ingestionSchema.getDataSchema().getGranularitySpec().getQueryGranularity()));
    }

    @VisibleForTesting
    PartialDimensionDistributionTask(@Nullable String id, String groupId, TaskResource taskResource, String supervisorTaskId, int numAttempts, ParallelIndexIngestionSpec ingestionSchema, Map<String, Object> context, IndexingServiceClient indexingServiceClient, IndexTaskClientFactory<ParallelIndexSupervisorTaskClient> taskClientFactory, Supplier<DedupRowDimensionValueFilter> dedupRowDimValueFilterSupplier) {
        super(PartialDimensionDistributionTask.getOrMakeId(id, TYPE, ingestionSchema.getDataSchema().getDataSource()), groupId, taskResource, ingestionSchema.getDataSchema(), ingestionSchema.getTuningConfig(), context);
        Preconditions.checkArgument((boolean)(ingestionSchema.getTuningConfig().getPartitionsSpec() instanceof SingleDimensionPartitionsSpec), (String)"%s partitionsSpec required", (Object[])new Object[]{"single_dim"});
        this.numAttempts = numAttempts;
        this.ingestionSchema = ingestionSchema;
        this.supervisorTaskId = supervisorTaskId;
        this.indexingServiceClient = indexingServiceClient;
        this.taskClientFactory = taskClientFactory;
        this.dedupRowDimValueFilterSupplier = dedupRowDimValueFilterSupplier;
    }

    @JsonProperty
    private int getNumAttempts() {
        return this.numAttempts;
    }

    @JsonProperty(value="spec")
    private ParallelIndexIngestionSpec getIngestionSchema() {
        return this.ingestionSchema;
    }

    @JsonProperty
    private String getSupervisorTaskId() {
        return this.supervisorTaskId;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        return this.tryTimeChunkLock(taskActionClient, this.getIngestionSchema().getDataSchema().getGranularitySpec().inputIntervals());
    }

    @Override
    public TaskStatus runTask(TaskToolbox toolbox) throws Exception {
        DataSchema dataSchema = this.ingestionSchema.getDataSchema();
        GranularitySpec granularitySpec = dataSchema.getGranularitySpec();
        ParallelIndexTuningConfig tuningConfig = this.ingestionSchema.getTuningConfig();
        SingleDimensionPartitionsSpec partitionsSpec = (SingleDimensionPartitionsSpec)tuningConfig.getPartitionsSpec();
        Preconditions.checkNotNull((Object)partitionsSpec, (Object)"partitionsSpec required in tuningConfig");
        String partitionDimension = partitionsSpec.getPartitionDimension();
        Preconditions.checkNotNull((Object)partitionDimension, (Object)"partitionDimension required in partitionsSpec");
        boolean isAssumeGrouped = partitionsSpec.isAssumeGrouped();
        InputSource inputSource = this.ingestionSchema.getIOConfig().getNonNullInputSource(this.ingestionSchema.getDataSchema().getParser());
        List metricsNames = Arrays.stream(dataSchema.getAggregators()).map(AggregatorFactory::getName).collect(Collectors.toList());
        InputFormat inputFormat = inputSource.needsFormat() ? ParallelIndexSupervisorTask.getInputFormat(this.ingestionSchema) : null;
        InputSourceReader inputSourceReader = dataSchema.getTransformSpec().decorate(inputSource.reader(new InputRowSchema(dataSchema.getTimestampSpec(), dataSchema.getDimensionsSpec(), metricsNames), inputFormat, toolbox.getIndexingTmpDir()));
        try (CloseableIterator inputRowIterator = inputSourceReader.read();
             HandlingInputRowIterator iterator = new RangePartitionIndexTaskInputRowIteratorBuilder(partitionDimension, true).delegate((CloseableIterator<InputRow>)inputRowIterator).granularitySpec(granularitySpec).nullRowRunnable(IndexTaskInputRowIteratorBuilder.NOOP_RUNNABLE).absentBucketIntervalConsumer(IndexTaskInputRowIteratorBuilder.NOOP_CONSUMER).build();){
            Map<Interval, StringDistribution> distribution = this.determineDistribution(iterator, granularitySpec, partitionDimension, isAssumeGrouped, tuningConfig.isLogParseExceptions(), tuningConfig.getMaxParseExceptions());
            this.sendReport(new DimensionDistributionReport(this.getId(), distribution));
        }
        return TaskStatus.success((String)this.getId());
    }

    private Map<Interval, StringDistribution> determineDistribution(HandlingInputRowIterator inputRowIterator, GranularitySpec granularitySpec, String partitionDimension, boolean isAssumeGrouped, boolean isLogParseExceptions, int maxParseExceptions) {
        HashMap<Interval, StringDistribution> intervalToDistribution = new HashMap<Interval, StringDistribution>();
        PassthroughRowDimensionValueFilter dimValueFilter = !isAssumeGrouped && granularitySpec.isRollup() ? (DimensionValueFilter)this.dedupRowDimValueFilterSupplier.get() : new PassthroughRowDimensionValueFilter();
        int numParseExceptions = 0;
        while (inputRowIterator.hasNext()) {
            try {
                InputRow inputRow = inputRowIterator.next();
                if (inputRow == null) continue;
                DateTime timestamp = inputRow.getTimestamp();
                Interval interval2 = (Interval)granularitySpec.bucketInterval(timestamp).get();
                StringDistribution stringDistribution = intervalToDistribution.computeIfAbsent(interval2, k -> new StringSketch());
                String dimensionValue = dimValueFilter.accept(interval2, timestamp, (String)Iterables.getOnlyElement((Iterable)inputRow.getDimension(partitionDimension)));
                if (dimensionValue == null) continue;
                stringDistribution.put(dimensionValue);
            }
            catch (ParseException e) {
                if (isLogParseExceptions) {
                    LOG.error((Throwable)e, "Encountered parse exception:", new Object[0]);
                }
                if (++numParseExceptions <= maxParseExceptions) continue;
                throw new RuntimeException("Max parse exceptions exceeded, terminating task...");
            }
        }
        dimValueFilter.getIntervalToMinDimensionValue().forEach((interval, min) -> ((StringDistribution)intervalToDistribution.get(interval)).putIfNewMin((String)min));
        dimValueFilter.getIntervalToMaxDimensionValue().forEach((interval, max) -> ((StringDistribution)intervalToDistribution.get(interval)).putIfNewMax((String)max));
        return intervalToDistribution;
    }

    private void sendReport(DimensionDistributionReport report) {
        ParallelIndexSupervisorTaskClient taskClient = this.taskClientFactory.build(new ClientBasedTaskInfoProvider(this.indexingServiceClient), this.getId(), 1, this.ingestionSchema.getTuningConfig().getChatHandlerTimeout(), this.ingestionSchema.getTuningConfig().getChatHandlerNumRetries());
        taskClient.report(this.supervisorTaskId, report);
    }

    private static class PassthroughRowDimensionValueFilter
    implements DimensionValueFilter {
        private final Map<Interval, String> intervalToMinDimensionValue = new HashMap<Interval, String>();
        private final Map<Interval, String> intervalToMaxDimensionValue = new HashMap<Interval, String>();

        PassthroughRowDimensionValueFilter() {
        }

        @Override
        @Nullable
        public String accept(Interval interval, DateTime timestamp, String dimensionValue) {
            this.updateMinDimensionValue(interval, dimensionValue);
            this.updateMaxDimensionValue(interval, dimensionValue);
            return dimensionValue;
        }

        private void updateMinDimensionValue(Interval interval, String dimensionValue) {
            this.intervalToMinDimensionValue.compute(interval, (intervalKey, currentMinValue) -> {
                if (currentMinValue == null || dimensionValue.compareTo((String)currentMinValue) < 0) {
                    return dimensionValue;
                }
                return currentMinValue;
            });
        }

        private void updateMaxDimensionValue(Interval interval, String dimensionValue) {
            this.intervalToMaxDimensionValue.compute(interval, (intervalKey, currentMaxValue) -> {
                if (currentMaxValue == null || dimensionValue.compareTo((String)currentMaxValue) > 0) {
                    return dimensionValue;
                }
                return currentMaxValue;
            });
        }

        @Override
        public Map<Interval, String> getIntervalToMinDimensionValue() {
            return this.intervalToMinDimensionValue;
        }

        @Override
        public Map<Interval, String> getIntervalToMaxDimensionValue() {
            return this.intervalToMaxDimensionValue;
        }
    }

    @VisibleForTesting
    static class DedupRowDimensionValueFilter
    implements DimensionValueFilter {
        private static final int BLOOM_FILTER_EXPECTED_INSERTIONS = 100000000;
        private static final double BLOOM_FILTER_EXPECTED_FALSE_POSITIVE_PROBABILTY = 0.001;
        private final PassthroughRowDimensionValueFilter delegate = new PassthroughRowDimensionValueFilter();
        private final TimeDimTupleFactory timeDimTupleFactory;
        private final BloomFilter<TimeDimTuple> timeDimTupleBloomFilter;

        DedupRowDimensionValueFilter(Granularity queryGranularity) {
            this(queryGranularity, 100000000, 0.001);
        }

        @VisibleForTesting
        DedupRowDimensionValueFilter(Granularity queryGranularity, int bloomFilterExpectedInsertions, double bloomFilterFalsePositiveProbability) {
            this.timeDimTupleFactory = new TimeDimTupleFactory(queryGranularity);
            this.timeDimTupleBloomFilter = BloomFilter.create((Funnel)TimeDimTupleFunnel.INSTANCE, (int)bloomFilterExpectedInsertions, (double)bloomFilterFalsePositiveProbability);
        }

        @Override
        @Nullable
        public String accept(Interval interval, DateTime timestamp, String dimensionValue) {
            this.delegate.accept(interval, timestamp, dimensionValue);
            TimeDimTuple timeDimTuple = this.timeDimTupleFactory.createWithBucketedTimestamp(timestamp, dimensionValue);
            if (this.timeDimTupleBloomFilter.mightContain((Object)timeDimTuple)) {
                return null;
            }
            this.timeDimTupleBloomFilter.put((Object)timeDimTuple);
            return dimensionValue;
        }

        @Override
        public Map<Interval, String> getIntervalToMinDimensionValue() {
            return this.delegate.getIntervalToMinDimensionValue();
        }

        @Override
        public Map<Interval, String> getIntervalToMaxDimensionValue() {
            return this.delegate.getIntervalToMaxDimensionValue();
        }
    }

    private static interface DimensionValueFilter {
        @Nullable
        public String accept(Interval var1, DateTime var2, String var3);

        public Map<Interval, String> getIntervalToMinDimensionValue();

        public Map<Interval, String> getIntervalToMaxDimensionValue();
    }
}

