/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.druid.indexing.common.IndexTaskClient;
import org.apache.druid.indexing.common.TaskInfoProvider;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskReport;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public class ParallelIndexSupervisorTaskClient
extends IndexTaskClient {
    ParallelIndexSupervisorTaskClient(HttpClient httpClient, ObjectMapper objectMapper, TaskInfoProvider taskInfoProvider, Duration httpTimeout, String callerId, long numRetries) {
        super(httpClient, objectMapper, taskInfoProvider, httpTimeout, callerId, 1, numRetries);
    }

    public SegmentIdWithShardSpec allocateSegment(String supervisorTaskId, DateTime timestamp) throws IOException {
        StringFullResponseHolder response = this.submitSmileRequest(supervisorTaskId, HttpMethod.POST, "segment/allocate", null, this.serialize(timestamp), true);
        if (!this.isSuccess(response)) {
            throw new ISE("task[%s] failed to allocate a new segment identifier with the HTTP code[%d] and content[%s]", new Object[]{supervisorTaskId, response.getStatus().getCode(), response.getContent()});
        }
        return this.deserialize(response.getContent(), new TypeReference<SegmentIdWithShardSpec>(){});
    }

    public void report(String supervisorTaskId, SubTaskReport report) {
        try {
            StringFullResponseHolder response = this.submitSmileRequest(supervisorTaskId, HttpMethod.POST, "report", null, this.serialize(report), true);
            if (!this.isSuccess(response)) {
                throw new ISE("Failed to send taskReports to task[%s] with the HTTP code [%d]", new Object[]{supervisorTaskId, response.getStatus().getCode()});
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

