/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.data.input.FirehoseFactoryToInputSourceAdaptor;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexPhaseRunner;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskReport;
import org.apache.druid.indexing.common.task.batch.parallel.SubTaskSpec;

abstract class InputSourceSplitParallelIndexTaskRunner<T extends Task, R extends SubTaskReport>
extends ParallelIndexPhaseRunner<T, R> {
    private final ParallelIndexIngestionSpec ingestionSchema;
    private final SplittableInputSource<?> baseInputSource;

    InputSourceSplitParallelIndexTaskRunner(TaskToolbox toolbox, String taskId, String groupId, ParallelIndexIngestionSpec ingestionSchema, Map<String, Object> context, IndexingServiceClient indexingServiceClient) {
        super(toolbox, taskId, groupId, ingestionSchema.getTuningConfig(), context, indexingServiceClient);
        this.ingestionSchema = ingestionSchema;
        this.baseInputSource = (SplittableInputSource)ingestionSchema.getIOConfig().getNonNullInputSource(ingestionSchema.getDataSchema().getParser());
    }

    @Override
    Iterator<SubTaskSpec<T>> subTaskSpecIterator() throws IOException {
        return this.baseInputSource.createSplits(this.ingestionSchema.getIOConfig().getInputFormat(), this.getTuningConfig().getSplitHintSpec()).map(this::newTaskSpec).iterator();
    }

    @Override
    final int estimateTotalNumSubTasks() throws IOException {
        return this.baseInputSource.estimateNumSplits(this.ingestionSchema.getIOConfig().getInputFormat(), this.getTuningConfig().getSplitHintSpec());
    }

    final SubTaskSpec<T> newTaskSpec(InputSplit split) {
        SplittableInputSource inputSource;
        FiniteFirehoseFactory firehoseFactory;
        if (this.baseInputSource instanceof FirehoseFactoryToInputSourceAdaptor) {
            firehoseFactory = ((FirehoseFactoryToInputSourceAdaptor)this.baseInputSource).getFirehoseFactory().withSplit(split);
            inputSource = null;
        } else {
            firehoseFactory = null;
            inputSource = this.baseInputSource.withSplit(split);
        }
        ParallelIndexIngestionSpec subTaskIngestionSpec = new ParallelIndexIngestionSpec(this.ingestionSchema.getDataSchema(), new ParallelIndexIOConfig((FirehoseFactory)firehoseFactory, (InputSource)inputSource, this.ingestionSchema.getIOConfig().getInputFormat(), this.ingestionSchema.getIOConfig().isAppendToExisting()), this.ingestionSchema.getTuningConfig());
        return this.createSubTaskSpec(this.getTaskId() + "_" + this.getAndIncrementNextSpecId(), this.getGroupId(), this.getTaskId(), this.getContext(), split, subTaskIngestionSpec, this.getIndexingServiceClient());
    }

    abstract SubTaskSpec<T> createSubTaskSpec(String var1, String var2, String var3, Map<String, Object> var4, InputSplit var5, ParallelIndexIngestionSpec var6, IndexingServiceClient var7);
}

