/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.task.batch.parallel.PartitionStat;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;

public class GenericPartitionStat
extends PartitionStat<ShardSpec> {
    private static final String PROP_SHARD_SPEC = "shardSpec";
    private final ShardSpec shardSpec;

    @JsonCreator
    public GenericPartitionStat(@JsonProperty(value="taskExecutorHost") String taskExecutorHost, @JsonProperty(value="taskExecutorPort") int taskExecutorPort, @JsonProperty(value="useHttps") boolean useHttps, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="shardSpec") ShardSpec shardSpec, @JsonProperty(value="numRows") @Nullable Integer numRows, @JsonProperty(value="sizeBytes") @Nullable Long sizeBytes) {
        super(taskExecutorHost, taskExecutorPort, useHttps, interval, numRows, sizeBytes);
        this.shardSpec = shardSpec;
    }

    @Override
    public int getPartitionId() {
        return this.shardSpec.getPartitionNum();
    }

    @Override
    @JsonProperty(value="shardSpec")
    ShardSpec getSecondaryPartition() {
        return this.shardSpec;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GenericPartitionStat that = (GenericPartitionStat)o;
        return Objects.equals(this.shardSpec, that.shardSpec);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.shardSpec);
    }
}

