/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.guava.Comparators;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class Tasks {
    public static final int DEFAULT_REALTIME_TASK_PRIORITY = 75;
    public static final int DEFAULT_BATCH_INDEX_TASK_PRIORITY = 50;
    public static final int DEFAULT_MERGE_TASK_PRIORITY = 25;
    public static final int DEFAULT_TASK_PRIORITY = 0;
    public static final long DEFAULT_LOCK_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    public static final boolean DEFAULT_FORCE_TIME_CHUNK_LOCK = true;
    public static final boolean DEFAULT_STORE_COMPACTION_STATE = false;
    public static final String PRIORITY_KEY = "priority";
    public static final String LOCK_TIMEOUT_KEY = "taskLockTimeout";
    public static final String FORCE_TIME_CHUNK_LOCK_KEY = "forceTimeChunkLock";
    public static final String STORE_COMPACTION_STATE_KEY = "storeCompactionState";

    public static SortedSet<Interval> computeCompactIntervals(SortedSet<Interval> intervals) {
        TreeSet<Interval> compactIntervals = new TreeSet<Interval>(Comparators.intervalsByStartThenEnd());
        ArrayList<Interval> toBeAccumulated = new ArrayList<Interval>();
        for (Interval interval : intervals) {
            if (toBeAccumulated.size() == 0) {
                toBeAccumulated.add(interval);
                continue;
            }
            if (((Interval)toBeAccumulated.get(toBeAccumulated.size() - 1)).abuts((ReadableInterval)interval)) {
                toBeAccumulated.add(interval);
                continue;
            }
            compactIntervals.add(JodaUtils.umbrellaInterval(toBeAccumulated));
            toBeAccumulated.clear();
            toBeAccumulated.add(interval);
        }
        if (toBeAccumulated.size() > 0) {
            compactIntervals.add(JodaUtils.umbrellaInterval(toBeAccumulated));
        }
        return compactIntervals;
    }
}

