/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.druid.indexing.common.task.CompactionInputSpec;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class SpecificSegmentsSpec
implements CompactionInputSpec {
    public static final String TYPE = "segments";
    private final List<String> segments;

    public static SpecificSegmentsSpec fromSegments(List<DataSegment> segments) {
        Preconditions.checkArgument((!segments.isEmpty() ? 1 : 0) != 0, (Object)"Empty segment list");
        return new SpecificSegmentsSpec(segments.stream().map(segment -> segment.getId().toString()).collect(Collectors.toList()));
    }

    @JsonCreator
    public SpecificSegmentsSpec(@JsonProperty(value="segments") List<String> segments) {
        this.segments = segments;
        Collections.sort(this.segments);
    }

    @JsonProperty
    public List<String> getSegments() {
        return this.segments;
    }

    @Override
    public Interval findInterval(String dataSource) {
        List segmentIds = this.segments.stream().map(segment -> SegmentId.tryParse((String)dataSource, (String)segment)).collect(Collectors.toList());
        return JodaUtils.umbrellaInterval((Iterable)segmentIds.stream().map(SegmentId::getInterval).collect(Collectors.toList()));
    }

    @Override
    public boolean validateSegments(List<DataSegment> latestSegments) {
        List thoseSegments = latestSegments.stream().map(segment -> segment.getId().toString()).sorted().collect(Collectors.toList());
        return this.segments.equals(thoseSegments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpecificSegmentsSpec that = (SpecificSegmentsSpec)o;
        return Objects.equals(this.segments, that.segments);
    }

    public int hashCode() {
        return Objects.hash(this.segments);
    }

    public String toString() {
        return "SpecificSegmentsSpec{segments=" + this.segments + '}';
    }
}

