/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.SegmentLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.actions.SegmentLockReleaseAction;
import org.apache.druid.indexing.common.actions.SegmentLockTryAcquireAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.task.AbstractBatchIndexTask;
import org.apache.druid.indexing.overlord.LockResult;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class SegmentLockHelper {
    private final Map<Interval, OverwritingRootGenerationPartitions> overwritingRootGenPartitions = new HashMap<Interval, OverwritingRootGenerationPartitions>();
    private final Set<DataSegment> lockedExistingSegments = new HashSet<DataSegment>();
    @Nullable
    private Granularity knownSegmentGranularity;

    public boolean hasLockedExistingSegments() {
        return !this.lockedExistingSegments.isEmpty();
    }

    public boolean hasOverwritingRootGenerationPartition(Interval interval) {
        return this.overwritingRootGenPartitions.containsKey(interval);
    }

    public Set<DataSegment> getLockedExistingSegments() {
        return Collections.unmodifiableSet(this.lockedExistingSegments);
    }

    public OverwritingRootGenerationPartitions getOverwritingRootGenerationPartition(Interval interval) {
        return this.overwritingRootGenPartitions.get(interval);
    }

    boolean verifyAndLockExistingSegments(TaskActionClient actionClient, List<DataSegment> segments) throws IOException {
        List<DataSegment> segmentsToLock = segments.stream().filter(segment -> !this.lockedExistingSegments.contains(segment)).collect(Collectors.toList());
        if (segmentsToLock.isEmpty()) {
            return true;
        }
        this.verifySegmentGranularity(segmentsToLock);
        return this.tryLockSegments(actionClient, segmentsToLock);
    }

    private void verifySegmentGranularity(List<DataSegment> segments) {
        Granularity granularityFromSegments = AbstractBatchIndexTask.findGranularityFromSegments(segments);
        if (granularityFromSegments != null) {
            if (this.knownSegmentGranularity == null) {
                this.knownSegmentGranularity = granularityFromSegments;
            } else {
                if (!this.knownSegmentGranularity.equals(granularityFromSegments)) {
                    throw new ISE("Found a different granularity from knownSegmentGranularity[%s] in segments[%s]", new Object[]{this.knownSegmentGranularity, segments});
                }
                List nonAlignedSegments = segments.stream().filter(segment -> !this.knownSegmentGranularity.isAligned(segment.getInterval())).collect(Collectors.toList());
                if (!nonAlignedSegments.isEmpty()) {
                    throw new ISE("Non-aligned segments[%s] for granularity[%s]", new Object[]{nonAlignedSegments.stream().map(DataSegment::getId).collect(Collectors.toList()), this.knownSegmentGranularity});
                }
            }
        } else {
            throw new ISE("Found different granularities in segments[%s]", new Object[]{segments.stream().map(DataSegment::getId).collect(Collectors.toList())});
        }
    }

    private boolean tryLockSegments(TaskActionClient actionClient, List<DataSegment> segments) throws IOException {
        Map<Interval, List<DataSegment>> intervalToSegments = SegmentLockHelper.groupSegmentsByInterval(segments);
        Closer lockCloserOnError = Closer.create();
        for (Map.Entry<Interval, List<DataSegment>> entry : intervalToSegments.entrySet()) {
            Interval interval = entry.getKey();
            List<DataSegment> segmentsInInterval = entry.getValue();
            boolean hasSameVersion = segmentsInInterval.stream().allMatch(segment -> segment.getVersion().equals(((DataSegment)segmentsInInterval.get(0)).getVersion()));
            Preconditions.checkState((boolean)hasSameVersion, (String)"Segments[%s] should have same version", (Object[])new Object[]{segmentsInInterval.stream().map(DataSegment::getId).collect(Collectors.toList())});
            List<LockResult> lockResults = actionClient.submit(new SegmentLockTryAcquireAction(TaskLockType.EXCLUSIVE, interval, segmentsInInterval.get(0).getVersion(), segmentsInInterval.stream().map(segment -> segment.getShardSpec().getPartitionNum()).collect(Collectors.toSet())));
            lockResults.stream().filter(LockResult::isOk).map(result -> (SegmentLock)result.getTaskLock()).forEach(segmentLock -> lockCloserOnError.register(() -> actionClient.submit(new SegmentLockReleaseAction(segmentLock.getInterval(), segmentLock.getPartitionId()))));
            if (lockResults.stream().anyMatch(result -> !result.isOk())) {
                lockCloserOnError.close();
                return false;
            }
            this.lockedExistingSegments.addAll(segmentsInInterval);
            this.verifyAndFindRootPartitionRangeAndMinorVersion(segmentsInInterval);
        }
        return true;
    }

    private void verifyAndFindRootPartitionRangeAndMinorVersion(List<DataSegment> inputSegments) {
        if (inputSegments.isEmpty()) {
            return;
        }
        ArrayList<DataSegment> sortedSegments = new ArrayList<DataSegment>(inputSegments);
        sortedSegments.sort((s1, s2) -> {
            if (s1.getStartRootPartitionId() != s2.getStartRootPartitionId()) {
                return Integer.compare(s1.getStartRootPartitionId(), s2.getStartRootPartitionId());
            }
            return Integer.compare(s1.getEndRootPartitionId(), s2.getEndRootPartitionId());
        });
        SegmentLockHelper.verifyRootPartitionIsAdjacentAndAtomicUpdateGroupIsFull(sortedSegments);
        Interval interval = ((DataSegment)sortedSegments.get(0)).getInterval();
        short prevMaxMinorVersion = (short)sortedSegments.stream().mapToInt(DataSegment::getMinorVersion).max().orElseThrow(() -> new ISE("Empty inputSegments", new Object[0]));
        this.overwritingRootGenPartitions.put(interval, new OverwritingRootGenerationPartitions(((DataSegment)sortedSegments.get(0)).getStartRootPartitionId(), ((DataSegment)sortedSegments.get(sortedSegments.size() - 1)).getEndRootPartitionId(), prevMaxMinorVersion));
    }

    public static void verifyRootPartitionIsAdjacentAndAtomicUpdateGroupIsFull(List<DataSegment> sortedSegments) {
        if (sortedSegments.isEmpty()) {
            return;
        }
        Preconditions.checkArgument((boolean)sortedSegments.stream().allMatch(segment -> segment.getInterval().equals((Object)((DataSegment)sortedSegments.get(0)).getInterval())));
        short atomicUpdateGroupSize = 1;
        for (int i = 0; i < sortedSegments.size() - 1; ++i) {
            DataSegment curSegment = sortedSegments.get(i);
            DataSegment nextSegment = sortedSegments.get(i + 1);
            if (curSegment.getStartRootPartitionId() == nextSegment.getStartRootPartitionId() && curSegment.getEndRootPartitionId() == nextSegment.getEndRootPartitionId()) {
                if (curSegment.getMinorVersion() != nextSegment.getMinorVersion() || curSegment.getAtomicUpdateGroupSize() != nextSegment.getAtomicUpdateGroupSize()) {
                    throw new ISE("segment[%s] and segment[%s] have the same rootPartitionRange, but different minorVersion or atomicUpdateGroupSize", new Object[]{curSegment, nextSegment});
                }
                atomicUpdateGroupSize = (short)(atomicUpdateGroupSize + 1);
                continue;
            }
            if (curSegment.getEndRootPartitionId() != nextSegment.getStartRootPartitionId()) {
                throw new ISE("Can't compact segments of non-consecutive rootPartition range", new Object[0]);
            }
            if (atomicUpdateGroupSize != curSegment.getAtomicUpdateGroupSize()) {
                throw new ISE("All atomicUpdateGroup must be compacted together", new Object[0]);
            }
            atomicUpdateGroupSize = 1;
        }
        if (atomicUpdateGroupSize != sortedSegments.get(sortedSegments.size() - 1).getAtomicUpdateGroupSize()) {
            throw new ISE("All atomicUpdateGroup must be compacted together", new Object[0]);
        }
    }

    private static Map<Interval, List<DataSegment>> groupSegmentsByInterval(List<DataSegment> segments) {
        HashMap<Interval, List<DataSegment>> map = new HashMap<Interval, List<DataSegment>>();
        for (DataSegment segment : segments) {
            map.computeIfAbsent(segment.getInterval(), k -> new ArrayList()).add(segment);
        }
        return map;
    }

    public static class OverwritingRootGenerationPartitions {
        private final int startRootPartitionId;
        private final int endRootPartitionId;
        private final short maxMinorVersion;

        private OverwritingRootGenerationPartitions(int startRootPartitionId, int endRootPartitionId, short maxMinorVersion) {
            this.startRootPartitionId = startRootPartitionId;
            this.endRootPartitionId = endRootPartitionId;
            this.maxMinorVersion = maxMinorVersion;
        }

        public int getStartRootPartitionId() {
            return this.startRootPartitionId;
        }

        public int getEndRootPartitionId() {
            return this.endRootPartitionId;
        }

        public short getMinorVersionForNewSegments() {
            return (short)(this.maxMinorVersion + 1);
        }
    }
}

