/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import java.io.IOException;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.indexing.appenderator.ActionBasedSegmentAllocator;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.SegmentAllocateAction;
import org.apache.druid.indexing.common.task.IndexTaskSegmentAllocator;
import org.apache.druid.indexing.common.task.SegmentLockHelper;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.partition.NumberedOverwritingShardSpecFactory;
import org.apache.druid.timeline.partition.NumberedShardSpecFactory;
import org.apache.druid.timeline.partition.ShardSpecFactory;
import org.joda.time.Interval;

public class RemoteSegmentAllocator
implements IndexTaskSegmentAllocator {
    private final String taskId;
    private final ActionBasedSegmentAllocator internalAllocator;

    RemoteSegmentAllocator(TaskToolbox toolbox, String taskId, DataSchema dataSchema, SegmentLockHelper segmentLockHelper, LockGranularity lockGranularity, boolean appendToExisting) {
        this.taskId = taskId;
        this.internalAllocator = new ActionBasedSegmentAllocator(toolbox.getTaskActionClient(), dataSchema, (schema, row, sequenceName, previousSegmentId, skipSegmentLineageCheck) -> {
            NumberedShardSpecFactory shardSpecFactory;
            GranularitySpec granularitySpec = schema.getGranularitySpec();
            Interval interval = (Interval)granularitySpec.bucketInterval(row.getTimestamp()).or((Object)granularitySpec.getSegmentGranularity().bucket(row.getTimestamp()));
            if (lockGranularity == LockGranularity.TIME_CHUNK) {
                return new SegmentAllocateAction(schema.getDataSource(), row.getTimestamp(), schema.getGranularitySpec().getQueryGranularity(), schema.getGranularitySpec().getSegmentGranularity(), sequenceName, previousSegmentId, skipSegmentLineageCheck, (ShardSpecFactory)NumberedShardSpecFactory.instance(), lockGranularity);
            }
            if (segmentLockHelper.hasLockedExistingSegments() && !appendToExisting) {
                SegmentLockHelper.OverwritingRootGenerationPartitions overwritingSegmentMeta = segmentLockHelper.getOverwritingRootGenerationPartition(interval);
                if (overwritingSegmentMeta == null) {
                    throw new ISE("Can't find overwritingSegmentMeta for interval[%s]", new Object[]{interval});
                }
                shardSpecFactory = new NumberedOverwritingShardSpecFactory(overwritingSegmentMeta.getStartRootPartitionId(), overwritingSegmentMeta.getEndRootPartitionId(), overwritingSegmentMeta.getMinorVersionForNewSegments());
            } else {
                shardSpecFactory = NumberedShardSpecFactory.instance();
            }
            return new SegmentAllocateAction(schema.getDataSource(), row.getTimestamp(), schema.getGranularitySpec().getQueryGranularity(), schema.getGranularitySpec().getSegmentGranularity(), sequenceName, previousSegmentId, skipSegmentLineageCheck, (ShardSpecFactory)shardSpecFactory, lockGranularity);
        });
    }

    public SegmentIdWithShardSpec allocate(InputRow row, String sequenceName, String previousSegmentId, boolean skipSegmentLineageCheck) throws IOException {
        return this.internalAllocator.allocate(row, sequenceName, previousSegmentId, skipSegmentLineageCheck);
    }

    @Override
    public String getSequenceName(Interval interval, InputRow inputRow) {
        return this.taskId;
    }
}

