/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.CachingLocalSegmentAllocatorHelper;
import org.apache.druid.indexing.common.task.IndexTaskSegmentAllocator;
import org.apache.druid.indexing.common.task.batch.parallel.distribution.PartitionBoundaries;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.SingleDimensionShardSpec;
import org.joda.time.Interval;

public class RangePartitionCachingLocalSegmentAllocator
implements IndexTaskSegmentAllocator {
    private final String dataSource;
    private final String partitionDimension;
    private final Map<Interval, PartitionBoundaries> intervalsToPartitions;
    private final IndexTaskSegmentAllocator delegate;

    public RangePartitionCachingLocalSegmentAllocator(TaskToolbox toolbox, String taskId, String supervisorTaskId, String dataSource, String partitionDimension, Map<Interval, PartitionBoundaries> intervalsToPartitions) throws IOException {
        this.dataSource = dataSource;
        this.partitionDimension = partitionDimension;
        this.intervalsToPartitions = intervalsToPartitions;
        this.delegate = new CachingLocalSegmentAllocatorHelper(toolbox, taskId, supervisorTaskId, this::getIntervalToSegmentIds);
    }

    private Map<Interval, List<SegmentIdWithShardSpec>> getIntervalToSegmentIds(Function<Interval, String> versionFinder) {
        HashMap intervalToSegmentIds = Maps.newHashMapWithExpectedSize((int)this.intervalsToPartitions.size());
        this.intervalsToPartitions.forEach((interval, partitionBoundaries) -> intervalToSegmentIds.put(interval, this.translatePartitionBoundaries((Interval)interval, (PartitionBoundaries)partitionBoundaries, versionFinder)));
        return intervalToSegmentIds;
    }

    private List<SegmentIdWithShardSpec> translatePartitionBoundaries(Interval interval, PartitionBoundaries partitionBoundaries, Function<Interval, String> versionFinder) {
        if (partitionBoundaries.isEmpty()) {
            return Collections.emptyList();
        }
        return IntStream.range(0, partitionBoundaries.size() - 1).mapToObj(i -> this.createSegmentIdWithShardSpec(interval, (String)versionFinder.apply(interval), (String)partitionBoundaries.get(i), (String)partitionBoundaries.get(i + 1), i)).collect(Collectors.toList());
    }

    private SegmentIdWithShardSpec createSegmentIdWithShardSpec(Interval interval, String version, String partitionStart, @Nullable String partitionEnd, int partitionNum) {
        return new SegmentIdWithShardSpec(this.dataSource, interval, version, (ShardSpec)new SingleDimensionShardSpec(this.partitionDimension, partitionStart, partitionEnd, partitionNum));
    }

    @Override
    public String getSequenceName(Interval interval, InputRow inputRow) {
        return this.delegate.getSequenceName(interval, inputRow);
    }

    public SegmentIdWithShardSpec allocate(InputRow row, String sequenceName, String previousSegmentId, boolean skipSegmentLineageCheck) throws IOException {
        return this.delegate.allocate(row, sequenceName, previousSegmentId, skipSegmentLineageCheck);
    }
}

