/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.LockListAction;
import org.apache.druid.indexing.common.task.IndexTaskSegmentAllocator;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.realtime.appenderator.SegmentAllocator;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

class LocalSegmentAllocator
implements IndexTaskSegmentAllocator {
    private final String taskId;
    private final SegmentAllocator internalAllocator;

    LocalSegmentAllocator(TaskToolbox toolbox, String taskId, String dataSource, GranularitySpec granularitySpec) throws IOException {
        this.taskId = taskId;
        HashMap counters = new HashMap();
        Map<Interval, String> intervalToVersion = toolbox.getTaskActionClient().submit(new LockListAction()).stream().collect(Collectors.toMap(TaskLock::getInterval, TaskLock::getVersion));
        this.internalAllocator = (row, sequenceName, previousSegmentId, skipSegmentLineageCheck) -> {
            DateTime timestamp = row.getTimestamp();
            Optional maybeInterval = granularitySpec.bucketInterval(timestamp);
            if (!maybeInterval.isPresent()) {
                throw new ISE("Could not find interval for timestamp [%s]", new Object[]{timestamp});
            }
            Interval interval = (Interval)maybeInterval.get();
            String version = intervalToVersion.entrySet().stream().filter(entry -> ((Interval)entry.getKey()).contains((ReadableInterval)interval)).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new ISE("Cannot find a version for interval[%s]", new Object[]{interval}));
            int partitionNum = counters.computeIfAbsent(interval, x -> new AtomicInteger()).getAndIncrement();
            return new SegmentIdWithShardSpec(dataSource, interval, version, (ShardSpec)new NumberedShardSpec(partitionNum, 0));
        };
    }

    @Override
    public String getSequenceName(Interval interval, InputRow inputRow) {
        return this.taskId;
    }

    public SegmentIdWithShardSpec allocate(InputRow row, String sequenceName, String previousSegmentId, boolean skipSegmentLineageCheck) throws IOException {
        return this.internalAllocator.allocate(row, sequenceName, previousSegmentId, skipSegmentLineageCheck);
    }
}

