/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.data.input.FirehoseFactoryToInputSourceAdaptor;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.indexer.Checks;
import org.apache.druid.indexer.IngestionState;
import org.apache.druid.indexer.Property;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.IngestionStatsAndErrorsTaskReport;
import org.apache.druid.indexing.common.IngestionStatsAndErrorsTaskReportData;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskReport;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.SegmentTransactionalInsertAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.stats.RowIngestionMeters;
import org.apache.druid.indexing.common.stats.RowIngestionMetersFactory;
import org.apache.druid.indexing.common.stats.RowIngestionMetersTotals;
import org.apache.druid.indexing.common.task.AbstractBatchIndexTask;
import org.apache.druid.indexing.common.task.HashPartitionCachingLocalSegmentAllocator;
import org.apache.druid.indexing.common.task.IndexTaskSegmentAllocator;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.LocalSegmentAllocator;
import org.apache.druid.indexing.common.task.RemoteSegmentAllocator;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.indexing.BatchIOConfig;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.IOConfig;
import org.apache.druid.segment.indexing.IngestionSpec;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.indexing.granularity.ArbitraryGranularitySpec;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.appenderator.SegmentsAndMetadata;
import org.apache.druid.segment.realtime.firehose.ChatHandler;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.ShardSpecFactory;
import org.apache.druid.utils.CircularBuffer;
import org.codehaus.plexus.util.FileUtils;
import org.joda.time.Interval;
import org.joda.time.Period;

public class IndexTask
extends AbstractBatchIndexTask
implements ChatHandler {
    private static final Logger log = new Logger(IndexTask.class);
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_128();
    private static final String TYPE = "index";
    @JsonIgnore
    private final IndexIngestionSpec ingestionSchema;
    @JsonIgnore
    private IngestionState ingestionState;
    @JsonIgnore
    private final AuthorizerMapper authorizerMapper;
    @JsonIgnore
    private final Optional<ChatHandlerProvider> chatHandlerProvider;
    @JsonIgnore
    private final RowIngestionMeters determinePartitionsMeters;
    @JsonIgnore
    private final RowIngestionMeters buildSegmentsMeters;
    @JsonIgnore
    private final CircularBuffer<Throwable> buildSegmentsSavedParseExceptions;
    @JsonIgnore
    private final CircularBuffer<Throwable> determinePartitionsSavedParseExceptions;
    @JsonIgnore
    private String errorMsg;
    @JsonIgnore
    private final AppenderatorsManager appenderatorsManager;

    private static String makeGroupId(IndexIngestionSpec ingestionSchema) {
        return IndexTask.makeGroupId(ingestionSchema.ioConfig.appendToExisting, ingestionSchema.dataSchema.getDataSource());
    }

    private static String makeGroupId(boolean isAppendToExisting, String dataSource) {
        if (isAppendToExisting) {
            return StringUtils.format((String)"%s_append_%s", (Object[])new Object[]{TYPE, dataSource});
        }
        return null;
    }

    @JsonCreator
    public IndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="spec") IndexIngestionSpec ingestionSchema, @JsonProperty(value="context") Map<String, Object> context, @JacksonInject AuthorizerMapper authorizerMapper, @JacksonInject ChatHandlerProvider chatHandlerProvider, @JacksonInject RowIngestionMetersFactory rowIngestionMetersFactory, @JacksonInject AppenderatorsManager appenderatorsManager) {
        this(id, IndexTask.makeGroupId(ingestionSchema), taskResource, ingestionSchema.dataSchema.getDataSource(), ingestionSchema, context, authorizerMapper, chatHandlerProvider, rowIngestionMetersFactory, appenderatorsManager);
    }

    public IndexTask(String id, String groupId, TaskResource resource, String dataSource, IndexIngestionSpec ingestionSchema, Map<String, Object> context, AuthorizerMapper authorizerMapper, ChatHandlerProvider chatHandlerProvider, RowIngestionMetersFactory rowIngestionMetersFactory, AppenderatorsManager appenderatorsManager) {
        super(IndexTask.getOrMakeId(id, TYPE, dataSource), groupId, resource, dataSource, context);
        this.ingestionSchema = ingestionSchema;
        this.authorizerMapper = authorizerMapper;
        this.chatHandlerProvider = Optional.fromNullable((Object)chatHandlerProvider);
        if (ingestionSchema.getTuningConfig().getMaxSavedParseExceptions() > 0) {
            this.determinePartitionsSavedParseExceptions = new CircularBuffer(ingestionSchema.getTuningConfig().getMaxSavedParseExceptions());
            this.buildSegmentsSavedParseExceptions = new CircularBuffer(ingestionSchema.getTuningConfig().getMaxSavedParseExceptions());
        } else {
            this.determinePartitionsSavedParseExceptions = null;
            this.buildSegmentsSavedParseExceptions = null;
        }
        this.ingestionState = IngestionState.NOT_STARTED;
        this.determinePartitionsMeters = rowIngestionMetersFactory.createRowIngestionMeters();
        this.buildSegmentsMeters = rowIngestionMetersFactory.createRowIngestionMeters();
        this.appenderatorsManager = appenderatorsManager;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        return this.determineLockGranularityAndTryLock(taskActionClient, this.ingestionSchema.dataSchema.getGranularitySpec());
    }

    @Override
    public boolean requireLockExistingSegments() {
        return IndexTask.isGuaranteedRollup(this.ingestionSchema.ioConfig, this.ingestionSchema.tuningConfig) || !this.ingestionSchema.ioConfig.isAppendToExisting();
    }

    @Override
    public List<DataSegment> findSegmentsToLock(TaskActionClient taskActionClient, List<Interval> intervals) throws IOException {
        return IndexTask.findInputSegments(this.getDataSource(), taskActionClient, intervals, this.ingestionSchema.ioConfig.firehoseFactory);
    }

    @Override
    public boolean isPerfectRollup() {
        return IndexTask.isGuaranteedRollup(this.ingestionSchema.ioConfig, this.ingestionSchema.tuningConfig);
    }

    @Override
    @Nullable
    public Granularity getSegmentGranularity() {
        GranularitySpec granularitySpec = this.ingestionSchema.getDataSchema().getGranularitySpec();
        if (granularitySpec instanceof ArbitraryGranularitySpec) {
            return null;
        }
        return granularitySpec.getSegmentGranularity();
    }

    @GET
    @Path(value="/unparseableEvents")
    @Produces(value={"application/json"})
    public Response getUnparseableEvents(@Context HttpServletRequest req, @QueryParam(value="full") String full) {
        IndexTaskUtils.datasourceAuthorizationCheck(req, Action.READ, this.getDataSource(), this.authorizerMapper);
        HashMap<String, List<String>> events = new HashMap<String, List<String>>();
        boolean needsDeterminePartitions = false;
        boolean needsBuildSegments = false;
        if (full != null) {
            needsDeterminePartitions = true;
            needsBuildSegments = true;
        } else {
            switch (this.ingestionState) {
                case DETERMINE_PARTITIONS: {
                    needsDeterminePartitions = true;
                    break;
                }
                case BUILD_SEGMENTS: 
                case COMPLETED: {
                    needsBuildSegments = true;
                    break;
                }
            }
        }
        if (needsDeterminePartitions) {
            events.put("determinePartitions", IndexTaskUtils.getMessagesFromSavedParseExceptions(this.determinePartitionsSavedParseExceptions));
        }
        if (needsBuildSegments) {
            events.put("buildSegments", IndexTaskUtils.getMessagesFromSavedParseExceptions(this.buildSegmentsSavedParseExceptions));
        }
        return Response.ok(events).build();
    }

    private Map<String, Object> doGetRowStats(String full) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        HashMap<String, RowIngestionMetersTotals> totalsMap = new HashMap<String, RowIngestionMetersTotals>();
        HashMap<String, Map<String, Object>> averagesMap = new HashMap<String, Map<String, Object>>();
        boolean needsDeterminePartitions = false;
        boolean needsBuildSegments = false;
        if (full != null) {
            needsDeterminePartitions = true;
            needsBuildSegments = true;
        } else {
            switch (this.ingestionState) {
                case DETERMINE_PARTITIONS: {
                    needsDeterminePartitions = true;
                    break;
                }
                case BUILD_SEGMENTS: 
                case COMPLETED: {
                    needsBuildSegments = true;
                    break;
                }
            }
        }
        if (needsDeterminePartitions) {
            totalsMap.put("determinePartitions", this.determinePartitionsMeters.getTotals());
            averagesMap.put("determinePartitions", this.determinePartitionsMeters.getMovingAverages());
        }
        if (needsBuildSegments) {
            totalsMap.put("buildSegments", this.buildSegmentsMeters.getTotals());
            averagesMap.put("buildSegments", this.buildSegmentsMeters.getMovingAverages());
        }
        returnMap.put("totals", totalsMap);
        returnMap.put("movingAverages", averagesMap);
        return returnMap;
    }

    @GET
    @Path(value="/rowStats")
    @Produces(value={"application/json"})
    public Response getRowStats(@Context HttpServletRequest req, @QueryParam(value="full") String full) {
        IndexTaskUtils.datasourceAuthorizationCheck(req, Action.READ, this.getDataSource(), this.authorizerMapper);
        return Response.ok(this.doGetRowStats(full)).build();
    }

    @GET
    @Path(value="/liveReports")
    @Produces(value={"application/json"})
    public Response getLiveReports(@Context HttpServletRequest req, @QueryParam(value="full") String full) {
        IndexTaskUtils.datasourceAuthorizationCheck(req, Action.READ, this.getDataSource(), this.authorizerMapper);
        HashMap returnMap = new HashMap();
        HashMap<String, Object> ingestionStatsAndErrors = new HashMap<String, Object>();
        HashMap<String, Object> payload = new HashMap<String, Object>();
        Map<String, Object> events = this.getTaskCompletionUnparseableEvents();
        payload.put("ingestionState", this.ingestionState);
        payload.put("unparseableEvents", events);
        payload.put("rowStats", this.doGetRowStats(full));
        ingestionStatsAndErrors.put("taskId", this.getId());
        ingestionStatsAndErrors.put("payload", payload);
        ingestionStatsAndErrors.put("type", "ingestionStatsAndErrors");
        returnMap.put("ingestionStatsAndErrors", ingestionStatsAndErrors);
        return Response.ok(returnMap).build();
    }

    @JsonProperty(value="spec")
    public IndexIngestionSpec getIngestionSchema() {
        return this.ingestionSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStatus runTask(TaskToolbox toolbox) {
        try {
            DataSchema dataSchema;
            if (this.chatHandlerProvider.isPresent()) {
                log.debug("Found chat handler of class[%s]", new Object[]{((ChatHandlerProvider)this.chatHandlerProvider.get()).getClass().getName()});
                if (((ChatHandlerProvider)this.chatHandlerProvider.get()).get(this.getId()).isPresent()) {
                    log.warn("Chat handler is already registered. Skipping chat handler registration.", new Object[0]);
                } else {
                    ((ChatHandlerProvider)this.chatHandlerProvider.get()).register(this.getId(), (ChatHandler)this, false);
                }
            } else {
                log.warn("No chat handler detected", new Object[0]);
            }
            boolean determineIntervals = !this.ingestionSchema.getDataSchema().getGranularitySpec().bucketIntervals().isPresent();
            InputSource inputSource = this.ingestionSchema.getIOConfig().getNonNullInputSource(this.ingestionSchema.getDataSchema().getParser());
            File tmpDir = toolbox.getIndexingTmpDir();
            FileUtils.forceMkdir((File)tmpDir);
            this.ingestionState = IngestionState.DETERMINE_PARTITIONS;
            IndexTuningConfig tuningConfig = this.ingestionSchema.tuningConfig;
            PartitionsSpec partitionsSpec = tuningConfig.getGivenOrDefaultPartitionsSpec();
            Map<Interval, Pair<ShardSpecFactory, Integer>> allocateSpec = this.determineShardSpecs(toolbox, inputSource, tmpDir, partitionsSpec);
            ArrayList<Interval> allocateIntervals = new ArrayList<Interval>(allocateSpec.keySet());
            if (determineIntervals) {
                if (!this.determineLockGranularityandTryLock(toolbox.getTaskActionClient(), allocateIntervals)) {
                    throw new ISE("Failed to get locks for intervals[%s]", new Object[]{allocateIntervals});
                }
                dataSchema = this.ingestionSchema.getDataSchema().withGranularitySpec(this.ingestionSchema.getDataSchema().getGranularitySpec().withIntervals((List)JodaUtils.condenseIntervals(allocateIntervals)));
            } else {
                dataSchema = this.ingestionSchema.getDataSchema();
            }
            this.ingestionState = IngestionState.BUILD_SEGMENTS;
            TaskStatus taskStatus = this.generateAndPublishSegments(toolbox, dataSchema, allocateSpec, inputSource, tmpDir, partitionsSpec);
            return taskStatus;
        }
        catch (Exception e) {
            log.error((Throwable)e, "Encountered exception in %s.", new Object[]{this.ingestionState});
            this.errorMsg = Throwables.getStackTraceAsString((Throwable)e);
            toolbox.getTaskReportFileWriter().write(this.getId(), this.getTaskCompletionReports());
            TaskStatus taskStatus = TaskStatus.failure((String)this.getId(), (String)this.errorMsg);
            return taskStatus;
        }
        finally {
            if (this.chatHandlerProvider.isPresent()) {
                ((ChatHandlerProvider)this.chatHandlerProvider.get()).unregister(this.getId());
            }
        }
    }

    private Map<String, TaskReport> getTaskCompletionReports() {
        return TaskReport.buildTaskReports(new IngestionStatsAndErrorsTaskReport(this.getId(), new IngestionStatsAndErrorsTaskReportData(this.ingestionState, this.getTaskCompletionUnparseableEvents(), this.getTaskCompletionRowStats(), this.errorMsg)));
    }

    private Map<String, Object> getTaskCompletionUnparseableEvents() {
        HashMap<String, Object> unparseableEventsMap = new HashMap<String, Object>();
        List<String> determinePartitionsParseExceptionMessages = IndexTaskUtils.getMessagesFromSavedParseExceptions(this.determinePartitionsSavedParseExceptions);
        List<String> buildSegmentsParseExceptionMessages = IndexTaskUtils.getMessagesFromSavedParseExceptions(this.buildSegmentsSavedParseExceptions);
        if (determinePartitionsParseExceptionMessages != null || buildSegmentsParseExceptionMessages != null) {
            unparseableEventsMap.put("determinePartitions", determinePartitionsParseExceptionMessages);
            unparseableEventsMap.put("buildSegments", buildSegmentsParseExceptionMessages);
        }
        return unparseableEventsMap;
    }

    private Map<String, Object> getTaskCompletionRowStats() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.put("determinePartitions", this.determinePartitionsMeters.getTotals());
        metrics.put("buildSegments", this.buildSegmentsMeters.getTotals());
        return metrics;
    }

    private Map<Interval, Pair<ShardSpecFactory, Integer>> determineShardSpecs(TaskToolbox toolbox, InputSource inputSource, File tmpDir, PartitionsSpec nonNullPartitionsSpec) throws IOException {
        ObjectMapper jsonMapper = toolbox.getJsonMapper();
        IndexTuningConfig tuningConfig = this.ingestionSchema.getTuningConfig();
        IndexIOConfig ioConfig = this.ingestionSchema.getIOConfig();
        GranularitySpec granularitySpec = this.ingestionSchema.getDataSchema().getGranularitySpec();
        boolean determineIntervals = !granularitySpec.bucketIntervals().isPresent();
        boolean determineNumPartitions = nonNullPartitionsSpec.needsDeterminePartitions(false);
        if (!determineNumPartitions && !determineIntervals) {
            log.info("Skipping determine partition scan", new Object[0]);
            return IndexTask.createShardSpecWithoutInputScan(granularitySpec, ioConfig, tuningConfig, nonNullPartitionsSpec);
        }
        return this.createShardSpecsFromInput(jsonMapper, this.ingestionSchema, inputSource, tmpDir, granularitySpec, nonNullPartitionsSpec, determineIntervals);
    }

    private Map<Interval, Pair<ShardSpecFactory, Integer>> createShardSpecsFromInput(ObjectMapper jsonMapper, IndexIngestionSpec ingestionSchema, InputSource inputSource, File tmpDir, GranularitySpec granularitySpec, PartitionsSpec nonNullPartitionsSpec, boolean determineIntervals) throws IOException {
        log.info("Determining intervals and shardSpecs", new Object[0]);
        long determineShardSpecsStartMillis = System.currentTimeMillis();
        Map<Interval, Optional<HyperLogLogCollector>> hllCollectors = this.collectIntervalsAndShardSpecs(jsonMapper, ingestionSchema, inputSource, tmpDir, granularitySpec, nonNullPartitionsSpec, determineIntervals);
        HashMap<Interval, Pair<ShardSpecFactory, Integer>> allocateSpecs = new HashMap<Interval, Pair<ShardSpecFactory, Integer>>();
        for (Map.Entry<Interval, Optional<HyperLogLogCollector>> entry : hllCollectors.entrySet()) {
            Interval interval = entry.getKey();
            if (IndexTask.isGuaranteedRollup(ingestionSchema.getIOConfig(), ingestionSchema.getTuningConfig())) {
                int numShards;
                assert (nonNullPartitionsSpec instanceof HashedPartitionsSpec);
                HashedPartitionsSpec partitionsSpec = (HashedPartitionsSpec)nonNullPartitionsSpec;
                HyperLogLogCollector collector = (HyperLogLogCollector)entry.getValue().orNull();
                if (partitionsSpec.needsDeterminePartitions(false)) {
                    long numRows = ((HyperLogLogCollector)Preconditions.checkNotNull((Object)collector, (Object)"HLL collector")).estimateCardinalityRound();
                    int nonNullMaxRowsPerSegment = partitionsSpec.getMaxRowsPerSegment() == null ? 5000000 : partitionsSpec.getMaxRowsPerSegment();
                    numShards = (int)Math.ceil((double)numRows / (double)nonNullMaxRowsPerSegment);
                    log.info("Estimated [%,d] rows of data for interval [%s], creating [%,d] shards", new Object[]{numRows, interval, numShards});
                } else {
                    numShards = partitionsSpec.getNumShards() == null ? 1 : partitionsSpec.getNumShards();
                    log.info("Creating [%,d] shards for interval [%s]", new Object[]{numShards, interval});
                }
                allocateSpecs.put(interval, IndexTask.createShardSpecFactoryForGuaranteedRollup(numShards, partitionsSpec.getPartitionDimensions()));
                continue;
            }
            allocateSpecs.put(interval, null);
        }
        log.info("Found intervals and shardSpecs in %,dms", new Object[]{System.currentTimeMillis() - determineShardSpecsStartMillis});
        return allocateSpecs;
    }

    /*
     * Exception decompiling
     */
    private Map<Interval, Optional<HyperLogLogCollector>> collectIntervalsAndShardSpecs(ObjectMapper jsonMapper, IndexIngestionSpec ingestionSchema, InputSource inputSource, File tmpDir, GranularitySpec granularitySpec, PartitionsSpec nonNullPartitionsSpec, boolean determineIntervals) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IndexTaskSegmentAllocator createSegmentAllocator(TaskToolbox toolbox, DataSchema dataSchema, Map<Interval, Pair<ShardSpecFactory, Integer>> allocateSpec) throws IOException {
        if (this.ingestionSchema.ioConfig.isAppendToExisting() || this.isUseSegmentLock()) {
            return new RemoteSegmentAllocator(toolbox, this.getId(), dataSchema, this.getSegmentLockHelper(), this.isUseSegmentLock() ? LockGranularity.SEGMENT : LockGranularity.TIME_CHUNK, this.ingestionSchema.ioConfig.isAppendToExisting());
        }
        if (IndexTask.isGuaranteedRollup(this.ingestionSchema.ioConfig, this.ingestionSchema.tuningConfig)) {
            return new HashPartitionCachingLocalSegmentAllocator(toolbox, this.getId(), this.getId(), this.getDataSource(), allocateSpec);
        }
        return new LocalSegmentAllocator(toolbox, this.getId(), this.getDataSource(), dataSchema.getGranularitySpec());
    }

    /*
     * Exception decompiling
     */
    private TaskStatus generateAndPublishSegments(TaskToolbox toolbox, DataSchema dataSchema, Map<Interval, Pair<ShardSpecFactory, Integer>> allocateSpec, InputSource inputSource, File tmpDir, PartitionsSpec partitionsSpec) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static SegmentsAndMetadata awaitPublish(ListenableFuture<SegmentsAndMetadata> publishFuture, long publishTimeout) throws ExecutionException, InterruptedException, TimeoutException {
        if (publishTimeout == 0L) {
            return (SegmentsAndMetadata)publishFuture.get();
        }
        return (SegmentsAndMetadata)publishFuture.get(publishTimeout, TimeUnit.MILLISECONDS);
    }

    private static InputFormat getInputFormat(IndexIngestionSpec ingestionSchema) {
        InputRowParser parser = ingestionSchema.getDataSchema().getParser();
        return ingestionSchema.getIOConfig().getNonNullInputFormat(parser == null ? null : parser.getParseSpec());
    }

    private static /* synthetic */ SegmentPublishResult lambda$generateAndPublishSegments$1(TaskToolbox toolbox, Set segmentsToBeOverwritten, Set segmentsToPublish, Object commitMetadata) throws IOException {
        return toolbox.getTaskActionClient().submit(SegmentTransactionalInsertAction.overwriteAction(segmentsToBeOverwritten, segmentsToPublish));
    }

    private static /* synthetic */ Optional lambda$collectIntervalsAndShardSpecs$0(Interval intv) {
        return Optional.of((Object)HyperLogLogCollector.makeLatestCollector());
    }

    public static class IndexTuningConfig
    implements TuningConfig,
    AppenderatorConfig {
        private static final IndexSpec DEFAULT_INDEX_SPEC = new IndexSpec();
        private static final int DEFAULT_MAX_PENDING_PERSISTS = 0;
        private static final boolean DEFAULT_GUARANTEE_ROLLUP = false;
        private static final boolean DEFAULT_REPORT_PARSE_EXCEPTIONS = false;
        private static final long DEFAULT_PUSH_TIMEOUT = 0L;
        private final int maxRowsInMemory;
        private final long maxBytesInMemory;
        @Nullable
        private final PartitionsSpec partitionsSpec;
        private final IndexSpec indexSpec;
        private final IndexSpec indexSpecForIntermediatePersists;
        private final File basePersistDirectory;
        private final int maxPendingPersists;
        private final boolean forceGuaranteedRollup;
        private final boolean reportParseExceptions;
        private final long pushTimeout;
        private final boolean logParseExceptions;
        private final int maxParseExceptions;
        private final int maxSavedParseExceptions;
        @Nullable
        private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;

        static IndexTuningConfig createDefault() {
            return new IndexTuningConfig();
        }

        @Nullable
        private static PartitionsSpec getDefaultPartitionsSpec(boolean forceGuaranteedRollup, @Nullable PartitionsSpec partitionsSpec, @Nullable Integer maxRowsPerSegment, @Nullable Long maxTotalRows, @Nullable Integer numShards, @Nullable List<String> partitionDimensions) {
            if (partitionsSpec == null) {
                if (forceGuaranteedRollup) {
                    if (maxRowsPerSegment != null || numShards != null || partitionDimensions != null && !partitionDimensions.isEmpty()) {
                        return new HashedPartitionsSpec(maxRowsPerSegment, numShards, partitionDimensions);
                    }
                    return null;
                }
                if (maxRowsPerSegment != null || maxTotalRows != null) {
                    return new DynamicPartitionsSpec(maxRowsPerSegment, maxTotalRows);
                }
                return null;
            }
            if (forceGuaranteedRollup) {
                if (!partitionsSpec.isForceGuaranteedRollupCompatibleType()) {
                    throw new ISE(partitionsSpec.getClass().getSimpleName() + " cannot be used for perfect rollup", new Object[0]);
                }
            } else if (!(partitionsSpec instanceof DynamicPartitionsSpec)) {
                throw new ISE("DynamicPartitionsSpec must be used for best-effort rollup", new Object[0]);
            }
            return partitionsSpec;
        }

        @JsonCreator
        public IndexTuningConfig(@JsonProperty(value="targetPartitionSize") @Deprecated @Nullable Integer targetPartitionSize, @JsonProperty(value="maxRowsPerSegment") @Deprecated @Nullable Integer maxRowsPerSegment, @JsonProperty(value="maxRowsInMemory") @Nullable Integer maxRowsInMemory, @JsonProperty(value="maxBytesInMemory") @Nullable Long maxBytesInMemory, @JsonProperty(value="maxTotalRows") @Deprecated @Nullable Long maxTotalRows, @JsonProperty(value="rowFlushBoundary") @Deprecated @Nullable Integer rowFlushBoundary_forBackCompatibility, @JsonProperty(value="numShards") @Deprecated @Nullable Integer numShards, @JsonProperty(value="partitionDimensions") @Deprecated @Nullable List<String> partitionDimensions, @JsonProperty(value="partitionsSpec") @Nullable PartitionsSpec partitionsSpec, @JsonProperty(value="indexSpec") @Nullable IndexSpec indexSpec, @JsonProperty(value="indexSpecForIntermediatePersists") @Nullable IndexSpec indexSpecForIntermediatePersists, @JsonProperty(value="maxPendingPersists") @Nullable Integer maxPendingPersists, @JsonProperty(value="forceGuaranteedRollup") @Nullable Boolean forceGuaranteedRollup, @JsonProperty(value="reportParseExceptions") @Deprecated @Nullable Boolean reportParseExceptions, @JsonProperty(value="publishTimeout") @Deprecated @Nullable Long publishTimeout, @JsonProperty(value="pushTimeout") @Nullable Long pushTimeout, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @JsonProperty(value="logParseExceptions") @Nullable Boolean logParseExceptions, @JsonProperty(value="maxParseExceptions") @Nullable Integer maxParseExceptions, @JsonProperty(value="maxSavedParseExceptions") @Nullable Integer maxSavedParseExceptions) {
            this(maxRowsInMemory != null ? maxRowsInMemory : rowFlushBoundary_forBackCompatibility, maxBytesInMemory != null ? maxBytesInMemory : 0L, IndexTuningConfig.getDefaultPartitionsSpec(forceGuaranteedRollup == null ? false : forceGuaranteedRollup, partitionsSpec, maxRowsPerSegment == null ? targetPartitionSize : maxRowsPerSegment, maxTotalRows, numShards, partitionDimensions), indexSpec, indexSpecForIntermediatePersists, maxPendingPersists, forceGuaranteedRollup, reportParseExceptions, pushTimeout != null ? pushTimeout : publishTimeout, null, segmentWriteOutMediumFactory, logParseExceptions, maxParseExceptions, maxSavedParseExceptions);
            Preconditions.checkArgument((targetPartitionSize == null || maxRowsPerSegment == null ? 1 : 0) != 0, (Object)"Can't use targetPartitionSize and maxRowsPerSegment together");
        }

        private IndexTuningConfig() {
            this(null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }

        private IndexTuningConfig(@Nullable Integer maxRowsInMemory, @Nullable Long maxBytesInMemory, @Nullable PartitionsSpec partitionsSpec, @Nullable IndexSpec indexSpec, @Nullable IndexSpec indexSpecForIntermediatePersists, @Nullable Integer maxPendingPersists, @Nullable Boolean forceGuaranteedRollup, @Nullable Boolean reportParseExceptions, @Nullable Long pushTimeout, @Nullable File basePersistDirectory, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @Nullable Boolean logParseExceptions, @Nullable Integer maxParseExceptions, @Nullable Integer maxSavedParseExceptions) {
            this.maxRowsInMemory = maxRowsInMemory == null ? 1000000 : maxRowsInMemory;
            this.maxBytesInMemory = maxBytesInMemory == null ? 0L : maxBytesInMemory;
            this.partitionsSpec = partitionsSpec;
            this.indexSpec = indexSpec == null ? DEFAULT_INDEX_SPEC : indexSpec;
            this.indexSpecForIntermediatePersists = indexSpecForIntermediatePersists == null ? this.indexSpec : indexSpecForIntermediatePersists;
            this.maxPendingPersists = maxPendingPersists == null ? 0 : maxPendingPersists;
            this.forceGuaranteedRollup = forceGuaranteedRollup == null ? false : forceGuaranteedRollup;
            this.reportParseExceptions = reportParseExceptions == null ? false : reportParseExceptions;
            this.pushTimeout = pushTimeout == null ? 0L : pushTimeout;
            this.basePersistDirectory = basePersistDirectory;
            this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
            if (this.reportParseExceptions) {
                this.maxParseExceptions = 0;
                this.maxSavedParseExceptions = maxSavedParseExceptions == null ? 0 : Math.min(1, maxSavedParseExceptions);
            } else {
                this.maxParseExceptions = maxParseExceptions == null ? Integer.MAX_VALUE : maxParseExceptions;
                this.maxSavedParseExceptions = maxSavedParseExceptions == null ? 0 : maxSavedParseExceptions;
            }
            this.logParseExceptions = logParseExceptions == null ? false : logParseExceptions;
        }

        public IndexTuningConfig withBasePersistDirectory(File dir) {
            return new IndexTuningConfig(this.maxRowsInMemory, this.maxBytesInMemory, this.partitionsSpec, this.indexSpec, this.indexSpecForIntermediatePersists, this.maxPendingPersists, this.forceGuaranteedRollup, this.reportParseExceptions, this.pushTimeout, dir, this.segmentWriteOutMediumFactory, this.logParseExceptions, this.maxParseExceptions, this.maxSavedParseExceptions);
        }

        public IndexTuningConfig withPartitionsSpec(PartitionsSpec partitionsSpec) {
            return new IndexTuningConfig(this.maxRowsInMemory, this.maxBytesInMemory, partitionsSpec, this.indexSpec, this.indexSpecForIntermediatePersists, this.maxPendingPersists, this.forceGuaranteedRollup, this.reportParseExceptions, this.pushTimeout, this.basePersistDirectory, this.segmentWriteOutMediumFactory, this.logParseExceptions, this.maxParseExceptions, this.maxSavedParseExceptions);
        }

        @JsonProperty
        public int getMaxRowsInMemory() {
            return this.maxRowsInMemory;
        }

        @JsonProperty
        public long getMaxBytesInMemory() {
            return this.maxBytesInMemory;
        }

        @JsonProperty
        @Nullable
        public PartitionsSpec getPartitionsSpec() {
            return this.partitionsSpec;
        }

        public PartitionsSpec getGivenOrDefaultPartitionsSpec() {
            if (this.partitionsSpec != null) {
                return this.partitionsSpec;
            }
            return this.forceGuaranteedRollup ? new HashedPartitionsSpec(null, null, null) : new DynamicPartitionsSpec(null, null);
        }

        @JsonProperty
        public IndexSpec getIndexSpec() {
            return this.indexSpec;
        }

        @JsonProperty
        public IndexSpec getIndexSpecForIntermediatePersists() {
            return this.indexSpecForIntermediatePersists;
        }

        @JsonProperty
        public int getMaxPendingPersists() {
            return this.maxPendingPersists;
        }

        @Deprecated
        @JsonProperty
        public boolean isBuildV9Directly() {
            return true;
        }

        @JsonProperty
        public boolean isForceGuaranteedRollup() {
            return this.forceGuaranteedRollup;
        }

        @JsonProperty
        public boolean isReportParseExceptions() {
            return this.reportParseExceptions;
        }

        @JsonProperty
        public long getPushTimeout() {
            return this.pushTimeout;
        }

        @Nullable
        @JsonProperty
        public SegmentWriteOutMediumFactory getSegmentWriteOutMediumFactory() {
            return this.segmentWriteOutMediumFactory;
        }

        @JsonProperty
        public boolean isLogParseExceptions() {
            return this.logParseExceptions;
        }

        @JsonProperty
        public int getMaxParseExceptions() {
            return this.maxParseExceptions;
        }

        @JsonProperty
        public int getMaxSavedParseExceptions() {
            return this.maxSavedParseExceptions;
        }

        @Nullable
        @Deprecated
        @JsonProperty
        public Integer getMaxRowsPerSegment() {
            return this.partitionsSpec == null ? null : this.partitionsSpec.getMaxRowsPerSegment();
        }

        @Nullable
        @Deprecated
        @JsonProperty
        public Long getMaxTotalRows() {
            return this.partitionsSpec instanceof DynamicPartitionsSpec ? ((DynamicPartitionsSpec)this.partitionsSpec).getMaxTotalRows() : null;
        }

        @Deprecated
        @Nullable
        @JsonProperty
        public Integer getNumShards() {
            return this.partitionsSpec instanceof HashedPartitionsSpec ? ((HashedPartitionsSpec)this.partitionsSpec).getNumShards() : null;
        }

        @Deprecated
        @JsonProperty
        public List<String> getPartitionDimensions() {
            return this.partitionsSpec instanceof HashedPartitionsSpec ? ((HashedPartitionsSpec)this.partitionsSpec).getPartitionDimensions() : Collections.emptyList();
        }

        public File getBasePersistDirectory() {
            return this.basePersistDirectory;
        }

        public Period getIntermediatePersistPeriod() {
            return new Period(Integer.MAX_VALUE);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexTuningConfig that = (IndexTuningConfig)o;
            return this.maxRowsInMemory == that.maxRowsInMemory && this.maxBytesInMemory == that.maxBytesInMemory && this.maxPendingPersists == that.maxPendingPersists && this.forceGuaranteedRollup == that.forceGuaranteedRollup && this.reportParseExceptions == that.reportParseExceptions && this.pushTimeout == that.pushTimeout && this.logParseExceptions == that.logParseExceptions && this.maxParseExceptions == that.maxParseExceptions && this.maxSavedParseExceptions == that.maxSavedParseExceptions && Objects.equals(this.partitionsSpec, that.partitionsSpec) && Objects.equals(this.indexSpec, that.indexSpec) && Objects.equals(this.indexSpecForIntermediatePersists, that.indexSpecForIntermediatePersists) && Objects.equals(this.basePersistDirectory, that.basePersistDirectory) && Objects.equals(this.segmentWriteOutMediumFactory, that.segmentWriteOutMediumFactory);
        }

        public int hashCode() {
            return Objects.hash(this.maxRowsInMemory, this.maxBytesInMemory, this.partitionsSpec, this.indexSpec, this.indexSpecForIntermediatePersists, this.basePersistDirectory, this.maxPendingPersists, this.forceGuaranteedRollup, this.reportParseExceptions, this.pushTimeout, this.logParseExceptions, this.maxParseExceptions, this.maxSavedParseExceptions, this.segmentWriteOutMediumFactory);
        }

        public String toString() {
            return "IndexTuningConfig{maxRowsInMemory=" + this.maxRowsInMemory + ", maxBytesInMemory=" + this.maxBytesInMemory + ", partitionsSpec=" + this.partitionsSpec + ", indexSpec=" + this.indexSpec + ", indexSpecForIntermediatePersists=" + this.indexSpecForIntermediatePersists + ", basePersistDirectory=" + this.basePersistDirectory + ", maxPendingPersists=" + this.maxPendingPersists + ", forceGuaranteedRollup=" + this.forceGuaranteedRollup + ", reportParseExceptions=" + this.reportParseExceptions + ", pushTimeout=" + this.pushTimeout + ", logParseExceptions=" + this.logParseExceptions + ", maxParseExceptions=" + this.maxParseExceptions + ", maxSavedParseExceptions=" + this.maxSavedParseExceptions + ", segmentWriteOutMediumFactory=" + this.segmentWriteOutMediumFactory + '}';
        }
    }

    @JsonTypeName(value="index")
    public static class IndexIOConfig
    implements BatchIOConfig {
        private static final boolean DEFAULT_APPEND_TO_EXISTING = false;
        private final FirehoseFactory firehoseFactory;
        private final InputSource inputSource;
        private final InputFormat inputFormat;
        private final boolean appendToExisting;

        @JsonCreator
        public IndexIOConfig(@Deprecated @JsonProperty(value="firehose") @Nullable FirehoseFactory firehoseFactory, @JsonProperty(value="inputSource") @Nullable InputSource inputSource, @JsonProperty(value="inputFormat") @Nullable InputFormat inputFormat, @JsonProperty(value="appendToExisting") @Nullable Boolean appendToExisting) {
            Checks.checkOneNotNullOrEmpty((List)ImmutableList.of((Object)new Property("firehose", (Object)firehoseFactory), (Object)new Property("inputSource", (Object)inputSource)));
            if (firehoseFactory != null && inputFormat != null) {
                throw new IAE("Cannot use firehose and inputFormat together. Try using inputSource instead of firehose.", new Object[0]);
            }
            this.firehoseFactory = firehoseFactory;
            this.inputSource = inputSource;
            this.inputFormat = inputFormat;
            this.appendToExisting = appendToExisting == null ? false : appendToExisting;
        }

        @Deprecated
        public IndexIOConfig(FirehoseFactory firehoseFactory, @Nullable Boolean appendToExisting) {
            this(firehoseFactory, null, null, appendToExisting);
        }

        @Nullable
        @JsonProperty(value="firehose")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @Deprecated
        public FirehoseFactory getFirehoseFactory() {
            return this.firehoseFactory;
        }

        @Nullable
        @JsonProperty
        public InputSource getInputSource() {
            return this.inputSource;
        }

        @Nullable
        @JsonProperty
        public InputFormat getInputFormat() {
            return this.inputFormat;
        }

        public InputSource getNonNullInputSource(@Nullable InputRowParser inputRowParser) {
            if (this.inputSource == null) {
                return new FirehoseFactoryToInputSourceAdaptor((FiniteFirehoseFactory)this.firehoseFactory, inputRowParser);
            }
            return this.inputSource;
        }

        public InputFormat getNonNullInputFormat(@Nullable ParseSpec parseSpec) {
            if (this.inputFormat == null) {
                return ((ParseSpec)Preconditions.checkNotNull((Object)parseSpec, (Object)"parseSpec")).toInputFormat();
            }
            return this.inputFormat;
        }

        @JsonProperty
        public boolean isAppendToExisting() {
            return this.appendToExisting;
        }
    }

    public static class IndexIngestionSpec
    extends IngestionSpec<IndexIOConfig, IndexTuningConfig> {
        private final DataSchema dataSchema;
        private final IndexIOConfig ioConfig;
        private final IndexTuningConfig tuningConfig;

        @JsonCreator
        public IndexIngestionSpec(@JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="ioConfig") IndexIOConfig ioConfig, @JsonProperty(value="tuningConfig") IndexTuningConfig tuningConfig) {
            super(dataSchema, (IOConfig)ioConfig, (TuningConfig)tuningConfig);
            if (dataSchema.getParserMap() != null && ioConfig.getInputSource() != null) {
                throw new IAE("Cannot use parser and inputSource together. Try using inputFormat instead of parser.", new Object[0]);
            }
            if (ioConfig.getInputSource() != null && ioConfig.getInputSource().needsFormat()) {
                Checks.checkOneNotNullOrEmpty((List)ImmutableList.of((Object)new Property("parser", (Object)dataSchema.getParserMap()), (Object)new Property("inputFormat", (Object)ioConfig.getInputFormat())));
            }
            this.dataSchema = dataSchema;
            this.ioConfig = ioConfig;
            this.tuningConfig = tuningConfig == null ? new IndexTuningConfig() : tuningConfig;
        }

        @JsonProperty(value="dataSchema")
        public DataSchema getDataSchema() {
            return this.dataSchema;
        }

        @JsonProperty(value="ioConfig")
        public IndexIOConfig getIOConfig() {
            return this.ioConfig;
        }

        @JsonProperty(value="tuningConfig")
        public IndexTuningConfig getTuningConfig() {
            return this.tuningConfig;
        }
    }

    static class ShardSpecs {
        private final Map<Interval, List<ShardSpec>> map;

        ShardSpecs(Map<Interval, List<ShardSpec>> map) {
            this.map = map;
        }

        ShardSpec getShardSpec(Interval interval, InputRow row) {
            List<ShardSpec> shardSpecs = this.map.get(interval);
            if (shardSpecs == null || shardSpecs.isEmpty()) {
                throw new ISE("Failed to get shardSpec for interval[%s]", new Object[]{interval});
            }
            return shardSpecs.get(0).getLookup(shardSpecs).getShardSpec(row.getTimestampFromEpoch(), row);
        }
    }
}

