/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.CachingLocalSegmentAllocatorHelper;
import org.apache.druid.indexing.common.task.IndexTaskSegmentAllocator;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.partition.ShardSpecFactory;
import org.joda.time.Interval;

public class HashPartitionCachingLocalSegmentAllocator
implements IndexTaskSegmentAllocator {
    private final TaskToolbox toolbox;
    private final String dataSource;
    private final Map<Interval, Pair<ShardSpecFactory, Integer>> allocateSpec;
    private final IndexTaskSegmentAllocator delegate;

    public HashPartitionCachingLocalSegmentAllocator(TaskToolbox toolbox, String taskId, String supervisorTaskId, String dataSource, Map<Interval, Pair<ShardSpecFactory, Integer>> allocateSpec) throws IOException {
        this.toolbox = toolbox;
        this.dataSource = dataSource;
        this.allocateSpec = allocateSpec;
        this.delegate = new CachingLocalSegmentAllocatorHelper(toolbox, taskId, supervisorTaskId, this::getIntervalToSegmentIds);
    }

    private Map<Interval, List<SegmentIdWithShardSpec>> getIntervalToSegmentIds(Function<Interval, String> versionFinder) {
        HashMap intervalToSegmentIds = Maps.newHashMapWithExpectedSize((int)this.allocateSpec.size());
        for (Map.Entry<Interval, Pair<ShardSpecFactory, Integer>> entry : this.allocateSpec.entrySet()) {
            Interval interval = entry.getKey();
            ShardSpecFactory shardSpecFactory = (ShardSpecFactory)entry.getValue().lhs;
            int numSegmentsToAllocate = (Integer)Preconditions.checkNotNull((Object)entry.getValue().rhs, (String)"numSegmentsToAllocate for interval[%s]", (Object[])new Object[]{interval});
            intervalToSegmentIds.put(interval, IntStream.range(0, numSegmentsToAllocate).mapToObj(i -> new SegmentIdWithShardSpec(this.dataSource, interval, (String)versionFinder.apply(interval), shardSpecFactory.create(this.toolbox.getJsonMapper(), i))).collect(Collectors.toList()));
        }
        return intervalToSegmentIds;
    }

    @Override
    public String getSequenceName(Interval interval, InputRow inputRow) {
        return this.delegate.getSequenceName(interval, inputRow);
    }

    public SegmentIdWithShardSpec allocate(InputRow row, String sequenceName, String previousSegmentId, boolean skipSegmentLineageCheck) throws IOException {
        return this.delegate.allocate(row, sequenceName, previousSegmentId, skipSegmentLineageCheck);
    }
}

