/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.guice.ExtensionsConfig;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.AbstractBatchIndexTask;
import org.apache.druid.indexing.common.task.HadoopIndexTask;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.utils.JvmUtils;

public abstract class HadoopTask
extends AbstractBatchIndexTask {
    private static final Logger log = new Logger(HadoopTask.class);
    private static final ExtensionsConfig EXTENSIONS_CONFIG;
    static final Injector INJECTOR;
    private final List<String> hadoopDependencyCoordinates;
    protected static final Predicate<URL> IS_DRUID_URL;

    protected HadoopTask(String id, String dataSource, List<String> hadoopDependencyCoordinates, Map<String, Object> context) {
        super(id, dataSource, context);
        this.hadoopDependencyCoordinates = hadoopDependencyCoordinates;
    }

    public List<String> getHadoopDependencyCoordinates() {
        return this.hadoopDependencyCoordinates == null ? null : ImmutableList.copyOf(this.hadoopDependencyCoordinates);
    }

    protected ClassLoader buildClassLoader(TaskToolbox toolbox) {
        return HadoopTask.buildClassLoader(this.hadoopDependencyCoordinates, toolbox.getConfig().getDefaultHadoopCoordinates());
    }

    public static ClassLoader buildClassLoader(List<String> hadoopDependencyCoordinates, List<String> defaultHadoopCoordinates) {
        String hadoopContainerDruidClasspathJars;
        List<String> finalHadoopDependencyCoordinates = hadoopDependencyCoordinates != null ? hadoopDependencyCoordinates : defaultHadoopCoordinates;
        ClassLoader taskClassLoader = HadoopIndexTask.class.getClassLoader();
        List jobURLs = taskClassLoader instanceof URLClassLoader ? Lists.newArrayList(Arrays.asList(((URLClassLoader)taskClassLoader).getURLs())) : JvmUtils.systemClassPath();
        ArrayList<URL> extensionURLs = new ArrayList<URL>();
        for (File extension : Initialization.getExtensionFilesToLoad((ExtensionsConfig)EXTENSIONS_CONFIG)) {
            URLClassLoader extensionLoader = Initialization.getClassLoaderForExtension((File)extension, (boolean)false);
            extensionURLs.addAll(Arrays.asList(extensionLoader.getURLs()));
        }
        jobURLs.addAll(extensionURLs);
        ArrayList<URL> localClassLoaderURLs = new ArrayList<URL>(jobURLs);
        for (File hadoopDependency : Initialization.getHadoopDependencyFilesToLoad(finalHadoopDependencyCoordinates, (ExtensionsConfig)EXTENSIONS_CONFIG)) {
            URLClassLoader hadoopLoader = Initialization.getClassLoaderForExtension((File)hadoopDependency, (boolean)false);
            localClassLoaderURLs.addAll(Arrays.asList(hadoopLoader.getURLs()));
        }
        ClassLoader parent = null;
        if (JvmUtils.isIsJava9Compatible()) {
            try {
                parent = (ClassLoader)ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        URLClassLoader classLoader = new URLClassLoader(localClassLoaderURLs.toArray(new URL[0]), parent);
        if (EXTENSIONS_CONFIG.getHadoopContainerDruidClasspath() == null) {
            hadoopContainerDruidClasspathJars = Joiner.on((String)File.pathSeparator).join((Iterable)jobURLs);
        } else {
            ArrayList hadoopContainerURLs = Lists.newArrayList((Iterable)Initialization.getURLsForClasspath((String)EXTENSIONS_CONFIG.getHadoopContainerDruidClasspath()));
            if (EXTENSIONS_CONFIG.getAddExtensionsToHadoopContainer()) {
                hadoopContainerURLs.addAll(extensionURLs);
            }
            hadoopContainerDruidClasspathJars = Joiner.on((String)File.pathSeparator).join((Iterable)hadoopContainerURLs);
        }
        log.info("Hadoop Container Druid Classpath is set to [%s]", new Object[]{hadoopContainerDruidClasspathJars});
        System.setProperty("druid.hadoop.internal.classpath", hadoopContainerDruidClasspathJars);
        return classLoader;
    }

    public static <InputType, OutputType> OutputType invokeForeignLoader(String clazzName, InputType input, ClassLoader loader) {
        log.debug("Launching [%s] on class loader [%s] with input class [%s]", new Object[]{clazzName, loader, input.getClass()});
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> clazz = loader.loadClass(clazzName);
            Method method = clazz.getMethod("runTask", input.getClass());
            Object object = method.invoke(null, input);
            return (OutputType)object;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    public static Object getForeignClassloaderObject(String clazzName, ClassLoader loader) {
        log.debug("Launching [%s] on class loader [%s]", new Object[]{clazzName, loader});
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> clazz = loader.loadClass(clazzName);
            Object obj = clazz.newInstance();
            return obj;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    static {
        INJECTOR = GuiceInjectors.makeStartupInjector();
        EXTENSIONS_CONFIG = (ExtensionsConfig)INJECTOR.getInstance(ExtensionsConfig.class);
        IS_DRUID_URL = new Predicate<URL>(){

            public boolean apply(@Nullable URL input) {
                try {
                    if (input == null) {
                        return false;
                    }
                    String fName = Paths.get(input.toURI()).getFileName().toString();
                    return fName.startsWith("druid") && fName.endsWith(".jar") && !fName.endsWith("selfcontained.jar");
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

