/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.indexer.HadoopDruidDetermineConfigurationJob;
import org.apache.druid.indexer.HadoopDruidIndexerConfig;
import org.apache.druid.indexer.HadoopDruidIndexerJob;
import org.apache.druid.indexer.HadoopIngestionSpec;
import org.apache.druid.indexer.IngestionState;
import org.apache.druid.indexer.MetadataStorageUpdaterJobHandler;
import org.apache.druid.indexer.TaskMetricsGetter;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.path.UsedSegmentsRetriever;
import org.apache.druid.indexing.common.IngestionStatsAndErrorsTaskReport;
import org.apache.druid.indexing.common.IngestionStatsAndErrorsTaskReportData;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TaskReport;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TimeChunkLockAcquireAction;
import org.apache.druid.indexing.common.actions.TimeChunkLockTryAcquireAction;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.HadoopTask;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.Tasks;
import org.apache.druid.indexing.hadoop.OverlordActionBasedUsedSegmentsRetriever;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.indexing.granularity.ArbitraryGranularitySpec;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.realtime.firehose.ChatHandler;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.timeline.DataSegment;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.joda.time.Interval;

public class HadoopIndexTask
extends HadoopTask
implements ChatHandler {
    private static final Logger log = new Logger(HadoopIndexTask.class);
    private static final String HADOOP_JOB_ID_FILENAME = "mapReduceJobId.json";
    private static final String TYPE = "index_hadoop";
    private TaskConfig taskConfig = null;
    @JsonIgnore
    private HadoopIngestionSpec spec;
    @JsonIgnore
    private final String classpathPrefix;
    @JsonIgnore
    private final ObjectMapper jsonMapper;
    @JsonIgnore
    private final AuthorizerMapper authorizerMapper;
    @JsonIgnore
    private final Optional<ChatHandlerProvider> chatHandlerProvider;
    @JsonIgnore
    private InnerProcessingStatsGetter determinePartitionsStatsGetter;
    @JsonIgnore
    private InnerProcessingStatsGetter buildSegmentsStatsGetter;
    @JsonIgnore
    private IngestionState ingestionState;
    @JsonIgnore
    private HadoopDetermineConfigInnerProcessingStatus determineConfigStatus = null;
    @JsonIgnore
    private HadoopIndexGeneratorInnerProcessingStatus buildSegmentsStatus = null;
    @JsonIgnore
    private String errorMsg;

    private static String getTheDataSource(HadoopIngestionSpec spec) {
        return spec.getDataSchema().getDataSource();
    }

    @JsonCreator
    public HadoopIndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="spec") HadoopIngestionSpec spec, @JsonProperty(value="hadoopCoordinates") String hadoopCoordinates, @JsonProperty(value="hadoopDependencyCoordinates") List<String> hadoopDependencyCoordinates, @JsonProperty(value="classpathPrefix") String classpathPrefix, @JacksonInject ObjectMapper jsonMapper, @JsonProperty(value="context") Map<String, Object> context, @JacksonInject AuthorizerMapper authorizerMapper, @JacksonInject ChatHandlerProvider chatHandlerProvider) {
        super(HadoopIndexTask.getOrMakeId(id, TYPE, HadoopIndexTask.getTheDataSource(spec)), HadoopIndexTask.getTheDataSource(spec), (List<String>)(hadoopDependencyCoordinates == null ? (hadoopCoordinates == null ? null : ImmutableList.of((Object)hadoopCoordinates)) : hadoopDependencyCoordinates), context);
        this.authorizerMapper = authorizerMapper;
        this.chatHandlerProvider = Optional.fromNullable((Object)chatHandlerProvider);
        this.spec = spec;
        Preconditions.checkArgument((this.spec.getIOConfig().getSegmentOutputPath() == null ? 1 : 0) != 0, (Object)"segmentOutputPath must be absent");
        Preconditions.checkArgument((this.spec.getTuningConfig().getWorkingPath() == null ? 1 : 0) != 0, (Object)"workingPath must be absent");
        Preconditions.checkArgument((this.spec.getIOConfig().getMetadataUpdateSpec() == null ? 1 : 0) != 0, (Object)"metadataUpdateSpec must be absent");
        this.classpathPrefix = classpathPrefix;
        this.jsonMapper = (ObjectMapper)Preconditions.checkNotNull((Object)jsonMapper, (Object)"null ObjectMappper");
        this.ingestionState = IngestionState.NOT_STARTED;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        Optional intervals = this.spec.getDataSchema().getGranularitySpec().bucketIntervals();
        if (intervals.isPresent()) {
            Interval interval = JodaUtils.umbrellaInterval((Iterable)JodaUtils.condenseIntervals((Iterable)((Iterable)intervals.get())));
            return taskActionClient.submit(new TimeChunkLockTryAcquireAction(TaskLockType.EXCLUSIVE, interval)) != null;
        }
        return true;
    }

    @Override
    public boolean requireLockExistingSegments() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<DataSegment> findSegmentsToLock(TaskActionClient taskActionClient, List<Interval> intervals) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPerfectRollup() {
        return true;
    }

    @Override
    @Nullable
    public Granularity getSegmentGranularity() {
        GranularitySpec granularitySpec = this.spec.getDataSchema().getGranularitySpec();
        if (granularitySpec instanceof ArbitraryGranularitySpec) {
            return null;
        }
        return granularitySpec.getSegmentGranularity();
    }

    @JsonProperty(value="spec")
    public HadoopIngestionSpec getSpec() {
        return this.spec;
    }

    @Override
    @JsonProperty
    public List<String> getHadoopDependencyCoordinates() {
        return super.getHadoopDependencyCoordinates();
    }

    @Override
    @JsonProperty
    public String getClasspathPrefix() {
        return this.classpathPrefix;
    }

    private String getHadoopJobIdFileName() {
        return this.getHadoopJobIdFile().getAbsolutePath();
    }

    private boolean hadoopJobIdFileExists() {
        return this.getHadoopJobIdFile().exists();
    }

    private File getHadoopJobIdFile() {
        return new File(this.taskConfig.getTaskDir(this.getId()), HADOOP_JOB_ID_FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStatus runTask(TaskToolbox toolbox) {
        try {
            this.taskConfig = toolbox.getConfig();
            if (this.chatHandlerProvider.isPresent()) {
                log.info("Found chat handler of class[%s]", new Object[]{((ChatHandlerProvider)this.chatHandlerProvider.get()).getClass().getName()});
                ((ChatHandlerProvider)this.chatHandlerProvider.get()).register(this.getId(), (ChatHandler)this, false);
            } else {
                log.warn("No chat handler detected", new Object[0]);
            }
            TaskStatus taskStatus = this.runInternal(toolbox);
            return taskStatus;
        }
        catch (Exception e) {
            Throwable effectiveException;
            if (e instanceof RuntimeException && e.getCause() instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)e.getCause();
                effectiveException = ite.getCause();
                log.error(effectiveException, "Got invocation target exception in run(), cause: ", new Object[0]);
            } else {
                effectiveException = e;
                log.error((Throwable)e, "Encountered exception in run():", new Object[0]);
            }
            this.errorMsg = Throwables.getStackTraceAsString((Throwable)effectiveException);
            toolbox.getTaskReportFileWriter().write(this.getId(), this.getTaskCompletionReports());
            TaskStatus taskStatus = TaskStatus.failure((String)this.getId(), (String)this.errorMsg);
            return taskStatus;
        }
        finally {
            if (this.chatHandlerProvider.isPresent()) {
                ((ChatHandlerProvider)this.chatHandlerProvider.get()).unregister(this.getId());
            }
        }
    }

    private TaskStatus runInternal(TaskToolbox toolbox) throws Exception {
        String version;
        HadoopIngestionSpec indexerSchema;
        this.registerResourceCloserOnAbnormalExit(config -> this.killHadoopJob());
        String hadoopJobIdFile = this.getHadoopJobIdFileName();
        ClassLoader loader = this.buildClassLoader(toolbox);
        boolean determineIntervals = !this.spec.getDataSchema().getGranularitySpec().bucketIntervals().isPresent();
        this.spec = HadoopIngestionSpec.updateSegmentListIfDatasourcePathSpecIsUsed((HadoopIngestionSpec)this.spec, (ObjectMapper)this.jsonMapper, (UsedSegmentsRetriever)new OverlordActionBasedUsedSegmentsRetriever(toolbox));
        Object determinePartitionsInnerProcessingRunner = HadoopIndexTask.getForeignClassloaderObject("org.apache.druid.indexing.common.task.HadoopIndexTask$HadoopDetermineConfigInnerProcessingRunner", loader);
        this.determinePartitionsStatsGetter = new InnerProcessingStatsGetter(determinePartitionsInnerProcessingRunner);
        String[] determinePartitionsInput = new String[]{toolbox.getJsonMapper().writeValueAsString((Object)this.spec), toolbox.getConfig().getHadoopWorkingPath(), toolbox.getSegmentPusher().getPathForHadoop(), hadoopJobIdFile};
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Class<?> determinePartitionsRunnerClass = determinePartitionsInnerProcessingRunner.getClass();
        Method determinePartitionsInnerProcessingRunTask = determinePartitionsRunnerClass.getMethod("runTask", determinePartitionsInput.getClass());
        try {
            Thread.currentThread().setContextClassLoader(loader);
            this.ingestionState = IngestionState.DETERMINE_PARTITIONS;
            String determineConfigStatusString = (String)determinePartitionsInnerProcessingRunTask.invoke(determinePartitionsInnerProcessingRunner, new Object[]{determinePartitionsInput});
            this.determineConfigStatus = (HadoopDetermineConfigInnerProcessingStatus)toolbox.getJsonMapper().readValue(determineConfigStatusString, HadoopDetermineConfigInnerProcessingStatus.class);
            indexerSchema = this.determineConfigStatus.getSchema();
            if (indexerSchema == null) {
                this.errorMsg = this.determineConfigStatus.getErrorMsg();
                toolbox.getTaskReportFileWriter().write(this.getId(), this.getTaskCompletionReports());
                TaskStatus taskStatus = TaskStatus.failure((String)this.getId(), (String)this.errorMsg);
                return taskStatus;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        if (determineIntervals) {
            Interval interval = JodaUtils.umbrellaInterval((Iterable)JodaUtils.condenseIntervals((Iterable)((Iterable)indexerSchema.getDataSchema().getGranularitySpec().bucketIntervals().get())));
            long lockTimeoutMs = this.getContextValue("taskLockTimeout", Tasks.DEFAULT_LOCK_TIMEOUT_MILLIS);
            TaskLock lock = (TaskLock)Preconditions.checkNotNull((Object)toolbox.getTaskActionClient().submit(new TimeChunkLockAcquireAction(TaskLockType.EXCLUSIVE, interval, lockTimeoutMs)), (String)"Cannot acquire a lock for interval[%s]", (Object[])new Object[]{interval});
            version = lock.getVersion();
        } else {
            List<TaskLock> locks = HadoopIndexTask.getTaskLocks(toolbox.getTaskActionClient());
            TaskLock myLock = (TaskLock)Iterables.getOnlyElement(locks);
            version = myLock.getVersion();
        }
        String specVersion = indexerSchema.getTuningConfig().getVersion();
        if (indexerSchema.getTuningConfig().isUseExplicitVersion()) {
            if (specVersion.compareTo(version) < 0) {
                version = specVersion;
            } else {
                log.error("Spec version can not be greater than or equal to the lock version, Spec version: [%s] Lock version: [%s].", new Object[]{specVersion, version});
                toolbox.getTaskReportFileWriter().write(this.getId(), null);
                return TaskStatus.failure((String)this.getId());
            }
        }
        log.info("Setting version to: %s", new Object[]{version});
        Object innerProcessingRunner = HadoopIndexTask.getForeignClassloaderObject("org.apache.druid.indexing.common.task.HadoopIndexTask$HadoopIndexGeneratorInnerProcessingRunner", loader);
        this.buildSegmentsStatsGetter = new InnerProcessingStatsGetter(innerProcessingRunner);
        String[] buildSegmentsInput = new String[]{toolbox.getJsonMapper().writeValueAsString((Object)indexerSchema), version, hadoopJobIdFile};
        Class<?> buildSegmentsRunnerClass = innerProcessingRunner.getClass();
        Method innerProcessingRunTask = buildSegmentsRunnerClass.getMethod("runTask", buildSegmentsInput.getClass());
        try {
            Thread.currentThread().setContextClassLoader(loader);
            this.ingestionState = IngestionState.BUILD_SEGMENTS;
            String jobStatusString = (String)innerProcessingRunTask.invoke(innerProcessingRunner, new Object[]{buildSegmentsInput});
            this.buildSegmentsStatus = (HadoopIndexGeneratorInnerProcessingStatus)toolbox.getJsonMapper().readValue(jobStatusString, HadoopIndexGeneratorInnerProcessingStatus.class);
            if (this.buildSegmentsStatus.getDataSegments() != null) {
                this.ingestionState = IngestionState.COMPLETED;
                toolbox.publishSegments(this.buildSegmentsStatus.getDataSegments());
                toolbox.getTaskReportFileWriter().write(this.getId(), this.getTaskCompletionReports());
                TaskStatus taskStatus = TaskStatus.success((String)this.getId(), null);
                return taskStatus;
            }
            this.errorMsg = this.buildSegmentsStatus.getErrorMsg();
            toolbox.getTaskReportFileWriter().write(this.getId(), this.getTaskCompletionReports());
            TaskStatus taskStatus = TaskStatus.failure((String)this.getId(), (String)this.errorMsg);
            return taskStatus;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    private void killHadoopJob() {
        if (this.hadoopJobIdFileExists() && !this.ingestionState.equals((Object)IngestionState.COMPLETED)) {
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            String hadoopJobIdFile = this.getHadoopJobIdFileName();
            try {
                ClassLoader loader = HadoopTask.buildClassLoader(this.getHadoopDependencyCoordinates(), this.taskConfig.getDefaultHadoopCoordinates());
                Object killMRJobInnerProcessingRunner = HadoopIndexTask.getForeignClassloaderObject("org.apache.druid.indexing.common.task.HadoopIndexTask$HadoopKillMRJobIdProcessingRunner", loader);
                String[] buildKillJobInput = new String[]{hadoopJobIdFile};
                Class<?> buildKillJobRunnerClass = killMRJobInnerProcessingRunner.getClass();
                Method innerProcessingRunTask = buildKillJobRunnerClass.getMethod("runTask", buildKillJobInput.getClass());
                Thread.currentThread().setContextClassLoader(loader);
                String[] killStatusString = (String[])innerProcessingRunTask.invoke(killMRJobInnerProcessingRunner, new Object[]{buildKillJobInput});
                log.info(StringUtils.format((String)"Tried killing job: [%s], status: [%s]", (Object[])new Object[]{killStatusString[0], killStatusString[1]}), new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
    }

    @GET
    @Path(value="/rowStats")
    @Produces(value={"application/json"})
    public Response getRowStats(@Context HttpServletRequest req, @QueryParam(value="windows") List<Integer> windows) {
        IndexTaskUtils.datasourceAuthorizationCheck(req, Action.READ, this.getDataSource(), this.authorizerMapper);
        HashMap returnMap = new HashMap();
        HashMap<String, Map<String, Number>> totalsMap = new HashMap<String, Map<String, Number>>();
        if (this.determinePartitionsStatsGetter != null) {
            totalsMap.put("determinePartitions", this.determinePartitionsStatsGetter.getTotalMetrics());
        }
        if (this.buildSegmentsStatsGetter != null) {
            totalsMap.put("buildSegments", this.buildSegmentsStatsGetter.getTotalMetrics());
        }
        returnMap.put("totals", totalsMap);
        return Response.ok(returnMap).build();
    }

    private Map<String, TaskReport> getTaskCompletionReports() {
        return TaskReport.buildTaskReports(new IngestionStatsAndErrorsTaskReport(this.getId(), new IngestionStatsAndErrorsTaskReportData(this.ingestionState, null, this.getTaskCompletionRowStats(), this.errorMsg)));
    }

    private Map<String, Object> getTaskCompletionRowStats() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        if (this.determineConfigStatus != null) {
            metrics.put("determinePartitions", this.determineConfigStatus.getMetrics());
        }
        if (this.buildSegmentsStatus != null) {
            metrics.put("buildSegments", this.buildSegmentsStatus.getMetrics());
        }
        return metrics;
    }

    public static class HadoopDetermineConfigInnerProcessingStatus {
        private final HadoopIngestionSpec schema;
        private final Map<String, Object> metrics;
        private final String errorMsg;

        @JsonCreator
        public HadoopDetermineConfigInnerProcessingStatus(@JsonProperty(value="schema") HadoopIngestionSpec schema, @JsonProperty(value="metrics") Map<String, Object> metrics, @JsonProperty(value="errorMsg") String errorMsg) {
            this.schema = schema;
            this.metrics = metrics;
            this.errorMsg = errorMsg;
        }

        @JsonProperty
        public HadoopIngestionSpec getSchema() {
            return this.schema;
        }

        @JsonProperty
        public Map<String, Object> getMetrics() {
            return this.metrics;
        }

        @JsonProperty
        public String getErrorMsg() {
            return this.errorMsg;
        }
    }

    public static class HadoopIndexGeneratorInnerProcessingStatus {
        private final List<DataSegment> dataSegments;
        private final Map<String, Object> metrics;
        private final String errorMsg;

        @JsonCreator
        public HadoopIndexGeneratorInnerProcessingStatus(@JsonProperty(value="dataSegments") List<DataSegment> dataSegments, @JsonProperty(value="metrics") Map<String, Object> metrics, @JsonProperty(value="errorMsg") String errorMsg) {
            this.dataSegments = dataSegments;
            this.metrics = metrics;
            this.errorMsg = errorMsg;
        }

        @JsonProperty
        public List<DataSegment> getDataSegments() {
            return this.dataSegments;
        }

        @JsonProperty
        public Map<String, Object> getMetrics() {
            return this.metrics;
        }

        @JsonProperty
        public String getErrorMsg() {
            return this.errorMsg;
        }
    }

    public static class HadoopKillMRJobIdProcessingRunner {
        public String[] runTask(String[] args) throws Exception {
            File hadoopJobIdFile = new File(args[0]);
            String jobId = null;
            try {
                if (hadoopJobIdFile.exists()) {
                    jobId = (String)HadoopDruidIndexerConfig.JSON_MAPPER.readValue(hadoopJobIdFile, String.class);
                }
            }
            catch (Exception e) {
                log.warn((Throwable)e, "exeption while reading hadoop job id from: [%s]", new Object[]{hadoopJobIdFile});
            }
            if (jobId != null) {
                int res = ToolRunner.run((Tool)new JobClient(), (String[])new String[]{"-kill", jobId});
                return new String[]{jobId, res == 0 ? "Success" : "Fail"};
            }
            return new String[]{jobId, "Fail"};
        }
    }

    public static class HadoopIndexGeneratorInnerProcessingRunner {
        private HadoopDruidIndexerJob job;

        public String runTask(String[] args) throws Exception {
            String schema = args[0];
            String version = args[1];
            String hadoopJobIdFile = args[2];
            HadoopIngestionSpec theSchema = (HadoopIngestionSpec)HadoopDruidIndexerConfig.JSON_MAPPER.readValue(schema, HadoopIngestionSpec.class);
            HadoopDruidIndexerConfig config = HadoopDruidIndexerConfig.fromSpec((HadoopIngestionSpec)theSchema.withTuningConfig(theSchema.getTuningConfig().withVersion(version)));
            MetadataStorageUpdaterJobHandler maybeHandler = config.isUpdaterJobSpecSet() ? (MetadataStorageUpdaterJobHandler)HadoopTask.INJECTOR.getInstance(MetadataStorageUpdaterJobHandler.class) : null;
            this.job = new HadoopDruidIndexerJob(config, maybeHandler);
            this.job.setHadoopJobIdFile(hadoopJobIdFile);
            log.info("Starting a hadoop index generator job...", new Object[0]);
            try {
                if (this.job.run()) {
                    return HadoopDruidIndexerConfig.JSON_MAPPER.writeValueAsString((Object)new HadoopIndexGeneratorInnerProcessingStatus(this.job.getPublishedSegments(), this.job.getStats(), null));
                }
                return HadoopDruidIndexerConfig.JSON_MAPPER.writeValueAsString((Object)new HadoopIndexGeneratorInnerProcessingStatus(null, this.job.getStats(), this.job.getErrorMessage()));
            }
            catch (Exception e) {
                log.error((Throwable)e, "Encountered exception in HadoopIndexGeneratorInnerProcessing.", new Object[0]);
                return HadoopDruidIndexerConfig.JSON_MAPPER.writeValueAsString((Object)new HadoopIndexGeneratorInnerProcessingStatus(null, this.job.getStats(), e.getMessage()));
            }
        }

        public Map<String, Object> getStats() {
            if (this.job == null) {
                return null;
            }
            return this.job.getStats();
        }
    }

    public static class HadoopDetermineConfigInnerProcessingRunner {
        private HadoopDruidDetermineConfigurationJob job;

        public String runTask(String[] args) throws Exception {
            String schema = args[0];
            String workingPath = args[1];
            String segmentOutputPath = args[2];
            String hadoopJobIdFile = args[3];
            HadoopIngestionSpec theSchema = (HadoopIngestionSpec)HadoopDruidIndexerConfig.JSON_MAPPER.readValue(schema, HadoopIngestionSpec.class);
            HadoopDruidIndexerConfig config = HadoopDruidIndexerConfig.fromSpec((HadoopIngestionSpec)theSchema.withIOConfig(theSchema.getIOConfig().withSegmentOutputPath(segmentOutputPath)).withTuningConfig(theSchema.getTuningConfig().withWorkingPath(workingPath)));
            this.job = new HadoopDruidDetermineConfigurationJob(config);
            this.job.setHadoopJobIdFile(hadoopJobIdFile);
            log.info("Starting a hadoop determine configuration job...", new Object[0]);
            if (this.job.run()) {
                return HadoopDruidIndexerConfig.JSON_MAPPER.writeValueAsString((Object)new HadoopDetermineConfigInnerProcessingStatus(config.getSchema(), this.job.getStats(), null));
            }
            return HadoopDruidIndexerConfig.JSON_MAPPER.writeValueAsString((Object)new HadoopDetermineConfigInnerProcessingStatus(null, this.job.getStats(), this.job.getErrorMessage()));
        }

        public Map<String, Object> getStats() {
            if (this.job == null) {
                return null;
            }
            return this.job.getStats();
        }
    }

    public static class InnerProcessingStatsGetter
    implements TaskMetricsGetter {
        static final List<String> KEYS = ImmutableList.of((Object)"rowsProcessed", (Object)"rowsProcessedWithErrors", (Object)"rowsThrownAway", (Object)"rowsUnparseable");
        private final Method getStatsMethod;
        private final Object innerProcessingRunner;

        public InnerProcessingStatsGetter(Object innerProcessingRunner) {
            try {
                Class<?> aClazz = innerProcessingRunner.getClass();
                this.getStatsMethod = aClazz.getMethod("getStats", new Class[0]);
                this.innerProcessingRunner = innerProcessingRunner;
            }
            catch (NoSuchMethodException nsme) {
                throw new RuntimeException(nsme);
            }
        }

        public List<String> getKeys() {
            return KEYS;
        }

        @Nullable
        public Map<String, Number> getTotalMetrics() {
            try {
                Map statsMap = (Map)this.getStatsMethod.invoke(this.innerProcessingRunner, new Object[0]);
                if (statsMap == null) {
                    return null;
                }
                long curProcessed = (Long)statsMap.get("rowsProcessed");
                long curProcessedWithErrors = (Long)statsMap.get("rowsProcessedWithErrors");
                long curThrownAway = (Long)statsMap.get("rowsThrownAway");
                long curUnparseable = (Long)statsMap.get("rowsUnparseable");
                return ImmutableMap.of((Object)"rowsProcessed", (Object)curProcessed, (Object)"rowsProcessedWithErrors", (Object)curProcessedWithErrors, (Object)"rowsThrownAway", (Object)curThrownAway, (Object)"rowsUnparseable", (Object)curUnparseable);
            }
            catch (Exception e) {
                log.error((Throwable)e, "Got exception from getTotalMetrics(): ", new Object[0]);
                return null;
            }
        }
    }
}

