/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.DoubleDimensionSchema;
import org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexer.Checks;
import org.apache.druid.indexer.Property;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.RetryPolicyFactory;
import org.apache.druid.indexing.common.SegmentLoaderFactory;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.RetrieveUsedSegmentsAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.stats.RowIngestionMetersFactory;
import org.apache.druid.indexing.common.task.AbstractBatchIndexTask;
import org.apache.druid.indexing.common.task.CompactionIOConfig;
import org.apache.druid.indexing.common.task.CompactionInputSpec;
import org.apache.druid.indexing.common.task.CompactionIntervalSpec;
import org.apache.druid.indexing.common.task.CurrentSubTaskHolder;
import org.apache.druid.indexing.common.task.IndexTask;
import org.apache.druid.indexing.common.task.SpecificSegmentsSpec;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIOConfig;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexIngestionSpec;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTask;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexTuningConfig;
import org.apache.druid.indexing.input.DruidInputSource;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.GranularityType;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.PartitionHolder;
import org.joda.time.Interval;
import org.joda.time.Period;

public class CompactionTask
extends AbstractBatchIndexTask {
    public static final String CTX_KEY_APPENDERATOR_TRACKING_TASK_ID = "appenderatorTrackingTaskId";
    private static final Logger log = new Logger(CompactionTask.class);
    private static final String TYPE = "compact";
    private final CompactionIOConfig ioConfig;
    @Nullable
    private final DimensionsSpec dimensionsSpec;
    @Nullable
    private final AggregatorFactory[] metricsSpec;
    @Nullable
    private final Granularity segmentGranularity;
    @Nullable
    private final ParallelIndexTuningConfig tuningConfig;
    private final ObjectMapper jsonMapper;
    @JsonIgnore
    private final SegmentProvider segmentProvider;
    @JsonIgnore
    private final PartitionConfigurationManager partitionConfigurationManager;
    @JsonIgnore
    private final AuthorizerMapper authorizerMapper;
    @JsonIgnore
    private final ChatHandlerProvider chatHandlerProvider;
    @JsonIgnore
    private final RowIngestionMetersFactory rowIngestionMetersFactory;
    @JsonIgnore
    private final CoordinatorClient coordinatorClient;
    private final IndexingServiceClient indexingServiceClient;
    @JsonIgnore
    private final SegmentLoaderFactory segmentLoaderFactory;
    @JsonIgnore
    private final RetryPolicyFactory retryPolicyFactory;
    @JsonIgnore
    private final AppenderatorsManager appenderatorsManager;
    @JsonIgnore
    private final CurrentSubTaskHolder currentSubTaskHolder = new CurrentSubTaskHolder((taskObject, config) -> {
        ParallelIndexSupervisorTask indexTask = (ParallelIndexSupervisorTask)taskObject;
        indexTask.stopGracefully((TaskConfig)config);
    });

    @JsonCreator
    public CompactionTask(@JsonProperty(value="id") String id, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") @Deprecated @Nullable Interval interval, @JsonProperty(value="segments") @Deprecated @Nullable List<DataSegment> segments, @JsonProperty(value="ioConfig") @Nullable CompactionIOConfig ioConfig, @JsonProperty(value="dimensions") @Nullable DimensionsSpec dimensions, @JsonProperty(value="dimensionsSpec") @Nullable DimensionsSpec dimensionsSpec, @JsonProperty(value="metricsSpec") @Nullable AggregatorFactory[] metricsSpec, @JsonProperty(value="segmentGranularity") @Nullable Granularity segmentGranularity, @JsonProperty(value="tuningConfig") @Nullable TuningConfig tuningConfig, @JsonProperty(value="context") @Nullable Map<String, Object> context, @JacksonInject ObjectMapper jsonMapper, @JacksonInject AuthorizerMapper authorizerMapper, @JacksonInject ChatHandlerProvider chatHandlerProvider, @JacksonInject RowIngestionMetersFactory rowIngestionMetersFactory, @JacksonInject CoordinatorClient coordinatorClient, @JacksonInject @Nullable IndexingServiceClient indexingServiceClient, @JacksonInject SegmentLoaderFactory segmentLoaderFactory, @JacksonInject RetryPolicyFactory retryPolicyFactory, @JacksonInject AppenderatorsManager appenderatorsManager) {
        super(CompactionTask.getOrMakeId(id, TYPE, dataSource), null, taskResource, dataSource, context);
        Checks.checkOneNotNullOrEmpty((List)ImmutableList.of((Object)new Property("ioConfig", (Object)ioConfig), (Object)new Property("interval", (Object)interval), (Object)new Property("segments", segments)));
        this.ioConfig = ioConfig != null ? ioConfig : (interval != null ? new CompactionIOConfig(new CompactionIntervalSpec(interval, null)) : new CompactionIOConfig(SpecificSegmentsSpec.fromSegments(segments)));
        this.dimensionsSpec = dimensionsSpec == null ? dimensions : dimensionsSpec;
        this.metricsSpec = metricsSpec;
        this.segmentGranularity = segmentGranularity;
        this.tuningConfig = tuningConfig != null ? CompactionTask.getTuningConfig(tuningConfig) : null;
        this.jsonMapper = jsonMapper;
        this.segmentProvider = new SegmentProvider(dataSource, this.ioConfig.getInputSpec());
        this.partitionConfigurationManager = new PartitionConfigurationManager(this.tuningConfig);
        this.authorizerMapper = authorizerMapper;
        this.chatHandlerProvider = chatHandlerProvider;
        this.rowIngestionMetersFactory = rowIngestionMetersFactory;
        this.indexingServiceClient = indexingServiceClient;
        this.coordinatorClient = coordinatorClient;
        this.segmentLoaderFactory = segmentLoaderFactory;
        this.retryPolicyFactory = retryPolicyFactory;
        this.appenderatorsManager = appenderatorsManager;
    }

    @VisibleForTesting
    static ParallelIndexTuningConfig getTuningConfig(TuningConfig tuningConfig) {
        if (tuningConfig instanceof ParallelIndexTuningConfig) {
            return (ParallelIndexTuningConfig)tuningConfig;
        }
        if (tuningConfig instanceof IndexTask.IndexTuningConfig) {
            IndexTask.IndexTuningConfig indexTuningConfig = (IndexTask.IndexTuningConfig)tuningConfig;
            return new ParallelIndexTuningConfig(null, indexTuningConfig.getMaxRowsPerSegment(), indexTuningConfig.getMaxRowsPerSegment(), indexTuningConfig.getMaxBytesInMemory(), indexTuningConfig.getMaxTotalRows(), indexTuningConfig.getNumShards(), null, indexTuningConfig.getPartitionsSpec(), indexTuningConfig.getIndexSpec(), indexTuningConfig.getIndexSpecForIntermediatePersists(), indexTuningConfig.getMaxPendingPersists(), indexTuningConfig.isForceGuaranteedRollup(), indexTuningConfig.isReportParseExceptions(), indexTuningConfig.getPushTimeout(), indexTuningConfig.getSegmentWriteOutMediumFactory(), null, null, null, null, null, null, null, null, indexTuningConfig.isLogParseExceptions(), indexTuningConfig.getMaxParseExceptions(), indexTuningConfig.getMaxSavedParseExceptions());
        }
        throw new ISE("Unknown tuningConfig type: [%s], Must be either [%s] or [%s]", new Object[]{tuningConfig.getClass().getName(), ParallelIndexTuningConfig.class.getName(), IndexTask.IndexTuningConfig.class.getName()});
    }

    @JsonProperty
    public CompactionIOConfig getIoConfig() {
        return this.ioConfig;
    }

    @JsonProperty
    @Nullable
    public DimensionsSpec getDimensionsSpec() {
        return this.dimensionsSpec;
    }

    @JsonProperty
    @Nullable
    public AggregatorFactory[] getMetricsSpec() {
        return this.metricsSpec;
    }

    @Override
    @JsonProperty
    @Nullable
    public Granularity getSegmentGranularity() {
        return this.segmentGranularity;
    }

    @Nullable
    @JsonProperty
    public ParallelIndexTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public int getPriority() {
        return this.getContextValue("priority", 25);
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        List<DataSegment> segments = this.segmentProvider.checkAndGetSegments(taskActionClient);
        return this.determineLockGranularityandTryLockWithSegments(taskActionClient, segments);
    }

    @Override
    public boolean requireLockExistingSegments() {
        return true;
    }

    @Override
    public List<DataSegment> findSegmentsToLock(TaskActionClient taskActionClient, List<Interval> intervals) throws IOException {
        return ImmutableList.copyOf(taskActionClient.submit(new RetrieveUsedSegmentsAction(this.getDataSource(), null, intervals, Segments.ONLY_VISIBLE)));
    }

    @Override
    public boolean isPerfectRollup() {
        return this.tuningConfig != null && this.tuningConfig.isForceGuaranteedRollup();
    }

    @Override
    public TaskStatus runTask(TaskToolbox toolbox) throws Exception {
        List<ParallelIndexIngestionSpec> ingestionSpecs = CompactionTask.createIngestionSchema(toolbox, this.segmentProvider, this.partitionConfigurationManager, this.dimensionsSpec, this.metricsSpec, this.segmentGranularity, this.jsonMapper, this.coordinatorClient, this.segmentLoaderFactory, this.retryPolicyFactory);
        List indexTaskSpecs = IntStream.range(0, ingestionSpecs.size()).mapToObj(i -> {
            String subtaskId = this.tuningConfig == null || this.tuningConfig.getMaxNumConcurrentSubTasks() == 1 ? this.createIndexTaskSpecId(i) : this.getId();
            return this.newTask(subtaskId, (ParallelIndexIngestionSpec)((Object)((Object)ingestionSpecs.get(i))));
        }).collect(Collectors.toList());
        if (indexTaskSpecs.isEmpty()) {
            log.warn("Can't find segments from inputSpec[%s], nothing to do.", new Object[]{this.ioConfig.getInputSpec()});
            return TaskStatus.failure((String)this.getId());
        }
        this.registerResourceCloserOnAbnormalExit(this.currentSubTaskHolder);
        int totalNumSpecs = indexTaskSpecs.size();
        log.info("Generated [%d] compaction task specs", new Object[]{totalNumSpecs});
        int failCnt = 0;
        for (ParallelIndexSupervisorTask eachSpec : indexTaskSpecs) {
            String json = this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)eachSpec);
            if (!this.currentSubTaskHolder.setTask(eachSpec)) {
                log.info("Task is asked to stop. Finish as failed.", new Object[0]);
                return TaskStatus.failure((String)this.getId());
            }
            try {
                if (eachSpec.isReady(toolbox.getTaskActionClient())) {
                    log.info("Running indexSpec: " + json, new Object[0]);
                    TaskStatus eachResult = eachSpec.run(toolbox);
                    if (eachResult.isSuccess()) continue;
                    ++failCnt;
                    log.warn("Failed to run indexSpec: [%s].\nTrying the next indexSpec.", new Object[]{json});
                    continue;
                }
                ++failCnt;
                log.warn("indexSpec is not ready: [%s].\nTrying the next indexSpec.", new Object[]{json});
            }
            catch (Exception e) {
                ++failCnt;
                log.warn((Throwable)e, "Failed to run indexSpec: [%s].\nTrying the next indexSpec.", new Object[]{json});
            }
        }
        log.info("Run [%d] specs, [%d] succeeded, [%d] failed", new Object[]{totalNumSpecs, totalNumSpecs - failCnt, failCnt});
        return failCnt == 0 ? TaskStatus.success((String)this.getId()) : TaskStatus.failure((String)this.getId());
    }

    @VisibleForTesting
    ParallelIndexSupervisorTask newTask(String taskId, ParallelIndexIngestionSpec ingestionSpec) {
        return new ParallelIndexSupervisorTask(taskId, this.getGroupId(), this.getTaskResource(), ingestionSpec, this.createContextForSubtask(), this.indexingServiceClient, this.chatHandlerProvider, this.authorizerMapper, this.rowIngestionMetersFactory, this.appenderatorsManager);
    }

    @VisibleForTesting
    Map<String, Object> createContextForSubtask() {
        HashMap<String, Object> newContext = new HashMap<String, Object>(this.getContext());
        newContext.put(CTX_KEY_APPENDERATOR_TRACKING_TASK_ID, this.getId());
        newContext.put("priority", this.getPriority());
        return newContext;
    }

    private String createIndexTaskSpecId(int i) {
        return StringUtils.format((String)"%s_%d", (Object[])new Object[]{this.getId(), i});
    }

    @VisibleForTesting
    static List<ParallelIndexIngestionSpec> createIngestionSchema(TaskToolbox toolbox, SegmentProvider segmentProvider, PartitionConfigurationManager partitionConfigurationManager, @Nullable DimensionsSpec dimensionsSpec, @Nullable AggregatorFactory[] metricsSpec, @Nullable Granularity segmentGranularity, ObjectMapper jsonMapper, CoordinatorClient coordinatorClient, SegmentLoaderFactory segmentLoaderFactory, RetryPolicyFactory retryPolicyFactory) throws IOException, SegmentLoadingException {
        Pair<Map<DataSegment, File>, List<TimelineObjectHolder<String, DataSegment>>> pair = CompactionTask.prepareSegments(toolbox, segmentProvider);
        Map segmentFileMap = (Map)pair.lhs;
        List timelineSegments = (List)pair.rhs;
        if (timelineSegments.size() == 0) {
            return Collections.emptyList();
        }
        List<Pair<QueryableIndex, DataSegment>> queryableIndexAndSegments = CompactionTask.loadSegments(timelineSegments, segmentFileMap, toolbox.getIndexIO());
        ParallelIndexTuningConfig compactionTuningConfig = partitionConfigurationManager.computeTuningConfig();
        if (segmentGranularity == null) {
            TreeMap intervalToSegments = new TreeMap(Comparators.intervalsByStartThenEnd());
            queryableIndexAndSegments.forEach(p -> intervalToSegments.computeIfAbsent(((DataSegment)p.rhs).getInterval(), k -> new ArrayList()).add(p));
            ArrayList<ParallelIndexIngestionSpec> specs = new ArrayList<ParallelIndexIngestionSpec>(intervalToSegments.size());
            for (Map.Entry entry : intervalToSegments.entrySet()) {
                Interval interval = (Interval)entry.getKey();
                List segmentsToCompact = (List)entry.getValue();
                DataSchema dataSchema = CompactionTask.createDataSchema(segmentProvider.dataSource, segmentsToCompact, dimensionsSpec, metricsSpec, GranularityType.fromPeriod((Period)interval.toPeriod()).getDefaultGranularity(), jsonMapper);
                specs.add(new ParallelIndexIngestionSpec(dataSchema, CompactionTask.createIoConfig(toolbox, dataSchema, interval, coordinatorClient, segmentLoaderFactory, retryPolicyFactory), compactionTuningConfig));
            }
            return specs;
        }
        DataSchema dataSchema = CompactionTask.createDataSchema(segmentProvider.dataSource, queryableIndexAndSegments, dimensionsSpec, metricsSpec, segmentGranularity, jsonMapper);
        return Collections.singletonList(new ParallelIndexIngestionSpec(dataSchema, CompactionTask.createIoConfig(toolbox, dataSchema, segmentProvider.interval, coordinatorClient, segmentLoaderFactory, retryPolicyFactory), compactionTuningConfig));
    }

    private static ParallelIndexIOConfig createIoConfig(TaskToolbox toolbox, DataSchema dataSchema, Interval interval, CoordinatorClient coordinatorClient, SegmentLoaderFactory segmentLoaderFactory, RetryPolicyFactory retryPolicyFactory) {
        return new ParallelIndexIOConfig(null, (InputSource)new DruidInputSource(dataSchema.getDataSource(), interval, null, null, dataSchema.getDimensionsSpec().getDimensionNames(), Arrays.stream(dataSchema.getAggregators()).map(AggregatorFactory::getName).collect(Collectors.toList()), toolbox.getIndexIO(), coordinatorClient, segmentLoaderFactory, retryPolicyFactory), null, false);
    }

    private static Pair<Map<DataSegment, File>, List<TimelineObjectHolder<String, DataSegment>>> prepareSegments(TaskToolbox toolbox, SegmentProvider segmentProvider) throws IOException, SegmentLoadingException {
        List<DataSegment> usedSegments = segmentProvider.checkAndGetSegments(toolbox.getTaskActionClient());
        Map<DataSegment, File> segmentFileMap = toolbox.fetchSegments(usedSegments);
        List timelineSegments = VersionedIntervalTimeline.forSegments(usedSegments).lookup(segmentProvider.interval);
        return Pair.of(segmentFileMap, (Object)timelineSegments);
    }

    private static DataSchema createDataSchema(String dataSource, List<Pair<QueryableIndex, DataSegment>> queryableIndexAndSegments, @Nullable DimensionsSpec dimensionsSpec, @Nullable AggregatorFactory[] metricsSpec, Granularity segmentGranularity, ObjectMapper jsonMapper) {
        for (Pair<QueryableIndex, DataSegment> pair2 : queryableIndexAndSegments) {
            QueryableIndex index = (QueryableIndex)pair2.lhs;
            if (index.getMetadata() != null) continue;
            throw new RE("Index metadata doesn't exist for segment[%s]", new Object[]{((DataSegment)pair2.rhs).getId()});
        }
        boolean rollup = queryableIndexAndSegments.stream().allMatch(pair -> {
            Boolean isRollup = ((QueryableIndex)pair.lhs).getMetadata().isRollup();
            return isRollup != null && isRollup != false;
        });
        Interval totalInterval = JodaUtils.umbrellaInterval((Iterable)queryableIndexAndSegments.stream().map(p -> ((DataSegment)p.rhs).getInterval()).collect(Collectors.toList()));
        UniformGranularitySpec granularitySpec = new UniformGranularitySpec((Granularity)Preconditions.checkNotNull((Object)segmentGranularity), Granularities.NONE, Boolean.valueOf(rollup), Collections.singletonList(totalInterval));
        DimensionsSpec finalDimensionsSpec = dimensionsSpec == null ? CompactionTask.createDimensionsSpec(queryableIndexAndSegments) : dimensionsSpec;
        AggregatorFactory[] finalMetricsSpec = metricsSpec == null ? CompactionTask.createMetricsSpec(queryableIndexAndSegments) : CompactionTask.convertToCombiningFactories(metricsSpec);
        return new DataSchema(dataSource, new TimestampSpec(null, null, null), finalDimensionsSpec, finalMetricsSpec, (GranularitySpec)granularitySpec, null);
    }

    private static AggregatorFactory[] createMetricsSpec(List<Pair<QueryableIndex, DataSegment>> queryableIndexAndSegments) {
        List aggregatorFactories = queryableIndexAndSegments.stream().map(pair -> ((QueryableIndex)pair.lhs).getMetadata().getAggregators()).collect(Collectors.toList());
        AggregatorFactory[] mergedAggregators = AggregatorFactory.mergeAggregators(aggregatorFactories);
        if (mergedAggregators == null) {
            throw new ISE("Failed to merge aggregators[%s]", new Object[]{aggregatorFactories});
        }
        return mergedAggregators;
    }

    private static AggregatorFactory[] convertToCombiningFactories(AggregatorFactory[] metricsSpec) {
        return (AggregatorFactory[])Arrays.stream(metricsSpec).map(AggregatorFactory::getCombiningFactory).toArray(AggregatorFactory[]::new);
    }

    private static DimensionsSpec createDimensionsSpec(List<Pair<QueryableIndex, DataSegment>> queryableIndices) {
        HashBiMap uniqueDims = HashBiMap.create();
        HashMap<String, DimensionSchema> dimensionSchemaMap = new HashMap<String, DimensionSchema>();
        Comparator intervalComparator = Comparators.intervalsByStartThenEnd();
        for (int i2 = 0; i2 < queryableIndices.size() - 1; ++i2) {
            Interval shouldBeLarger;
            Interval shouldBeSmaller = ((QueryableIndex)queryableIndices.get((int)i2).lhs).getDataInterval();
            Preconditions.checkState((intervalComparator.compare(shouldBeSmaller, shouldBeLarger = ((QueryableIndex)queryableIndices.get((int)(i2 + 1)).lhs).getDataInterval()) <= 0 ? 1 : 0) != 0, (String)"QueryableIndexes are not sorted! Interval[%s] of segment[%s] is laster than interval[%s] of segment[%s]", (Object[])new Object[]{shouldBeSmaller, ((DataSegment)queryableIndices.get((int)i2).rhs).getId(), shouldBeLarger, ((DataSegment)queryableIndices.get((int)(i2 + 1)).rhs).getId()});
        }
        int index = 0;
        for (Pair pair : Lists.reverse(queryableIndices)) {
            QueryableIndex queryableIndex = (QueryableIndex)pair.lhs;
            Map dimensionHandlerMap = queryableIndex.getDimensionHandlers();
            for (String dimension : queryableIndex.getAvailableDimensions()) {
                ColumnHolder columnHolder = (ColumnHolder)Preconditions.checkNotNull((Object)queryableIndex.getColumnHolder(dimension), (String)"Cannot find column for dimension[%s]", (Object[])new Object[]{dimension});
                if (uniqueDims.containsKey((Object)dimension)) continue;
                DimensionHandler dimensionHandler = (DimensionHandler)Preconditions.checkNotNull(dimensionHandlerMap.get(dimension), (String)"Cannot find dimensionHandler for dimension[%s]", (Object[])new Object[]{dimension});
                uniqueDims.put((Object)dimension, (Object)index++);
                dimensionSchemaMap.put(dimension, CompactionTask.createDimensionSchema(columnHolder.getCapabilities().getType(), dimension, dimensionHandler.getMultivalueHandling(), columnHolder.getCapabilities().hasBitmapIndexes()));
            }
        }
        BiMap orderedDims = uniqueDims.inverse();
        List dimensionSchemas = IntStream.range(0, orderedDims.size()).mapToObj(i -> {
            String dimName = (String)orderedDims.get((Object)i);
            return (DimensionSchema)Preconditions.checkNotNull(dimensionSchemaMap.get(dimName), (String)"Cannot find dimension[%s] from dimensionSchemaMap", (Object[])new Object[]{dimName});
        }).collect(Collectors.toList());
        return new DimensionsSpec(dimensionSchemas, null, null);
    }

    private static List<Pair<QueryableIndex, DataSegment>> loadSegments(List<TimelineObjectHolder<String, DataSegment>> timelineObjectHolders, Map<DataSegment, File> segmentFileMap, IndexIO indexIO) throws IOException {
        ArrayList<Pair<QueryableIndex, DataSegment>> segments = new ArrayList<Pair<QueryableIndex, DataSegment>>();
        for (TimelineObjectHolder<String, DataSegment> timelineObjectHolder : timelineObjectHolders) {
            PartitionHolder partitionHolder = timelineObjectHolder.getObject();
            for (PartitionChunk chunk : partitionHolder) {
                DataSegment segment = (DataSegment)chunk.getObject();
                QueryableIndex queryableIndex = indexIO.loadIndex((File)Preconditions.checkNotNull((Object)segmentFileMap.get(segment), (String)"File for segment %s", (Object[])new Object[]{segment.getId()}));
                segments.add((Pair<QueryableIndex, DataSegment>)Pair.of((Object)queryableIndex, (Object)segment));
            }
        }
        return segments;
    }

    private static DimensionSchema createDimensionSchema(ValueType type, String name, DimensionSchema.MultiValueHandling multiValueHandling, boolean hasBitmapIndexes) {
        switch (type) {
            case FLOAT: {
                Preconditions.checkArgument((multiValueHandling == null ? 1 : 0) != 0, (String)"multi-value dimension [%s] is not supported for float type yet", (Object[])new Object[]{name});
                return new FloatDimensionSchema(name);
            }
            case LONG: {
                Preconditions.checkArgument((multiValueHandling == null ? 1 : 0) != 0, (String)"multi-value dimension [%s] is not supported for long type yet", (Object[])new Object[]{name});
                return new LongDimensionSchema(name);
            }
            case DOUBLE: {
                Preconditions.checkArgument((multiValueHandling == null ? 1 : 0) != 0, (String)"multi-value dimension [%s] is not supported for double type yet", (Object[])new Object[]{name});
                return new DoubleDimensionSchema(name);
            }
            case STRING: {
                return new StringDimensionSchema(name, multiValueHandling, Boolean.valueOf(hasBitmapIndexes));
            }
        }
        throw new ISE("Unsupported value type[%s] for dimension[%s]", new Object[]{type, name});
    }

    public static class Builder {
        private final String dataSource;
        private final ObjectMapper jsonMapper;
        private final AuthorizerMapper authorizerMapper;
        private final ChatHandlerProvider chatHandlerProvider;
        private final RowIngestionMetersFactory rowIngestionMetersFactory;
        private final IndexingServiceClient indexingServiceClient;
        private final CoordinatorClient coordinatorClient;
        private final SegmentLoaderFactory segmentLoaderFactory;
        private final RetryPolicyFactory retryPolicyFactory;
        private final AppenderatorsManager appenderatorsManager;
        private CompactionIOConfig ioConfig;
        @Nullable
        private DimensionsSpec dimensionsSpec;
        @Nullable
        private AggregatorFactory[] metricsSpec;
        @Nullable
        private Granularity segmentGranularity;
        @Nullable
        private TuningConfig tuningConfig;
        @Nullable
        private Map<String, Object> context;

        public Builder(String dataSource, ObjectMapper jsonMapper, AuthorizerMapper authorizerMapper, ChatHandlerProvider chatHandlerProvider, RowIngestionMetersFactory rowIngestionMetersFactory, IndexingServiceClient indexingServiceClient, CoordinatorClient coordinatorClient, SegmentLoaderFactory segmentLoaderFactory, RetryPolicyFactory retryPolicyFactory, AppenderatorsManager appenderatorsManager) {
            this.dataSource = dataSource;
            this.jsonMapper = jsonMapper;
            this.authorizerMapper = authorizerMapper;
            this.chatHandlerProvider = chatHandlerProvider;
            this.rowIngestionMetersFactory = rowIngestionMetersFactory;
            this.indexingServiceClient = indexingServiceClient;
            this.coordinatorClient = coordinatorClient;
            this.segmentLoaderFactory = segmentLoaderFactory;
            this.retryPolicyFactory = retryPolicyFactory;
            this.appenderatorsManager = appenderatorsManager;
        }

        public Builder interval(Interval interval) {
            return this.inputSpec(new CompactionIntervalSpec(interval, null));
        }

        public Builder segments(List<DataSegment> segments) {
            return this.inputSpec(SpecificSegmentsSpec.fromSegments(segments));
        }

        public Builder inputSpec(CompactionInputSpec inputSpec) {
            this.ioConfig = new CompactionIOConfig(inputSpec);
            return this;
        }

        public Builder dimensionsSpec(DimensionsSpec dimensionsSpec) {
            this.dimensionsSpec = dimensionsSpec;
            return this;
        }

        public Builder metricsSpec(AggregatorFactory[] metricsSpec) {
            this.metricsSpec = metricsSpec;
            return this;
        }

        public Builder segmentGranularity(Granularity segmentGranularity) {
            this.segmentGranularity = segmentGranularity;
            return this;
        }

        public Builder tuningConfig(TuningConfig tuningConfig) {
            this.tuningConfig = tuningConfig;
            return this;
        }

        public Builder context(Map<String, Object> context) {
            this.context = context;
            return this;
        }

        public CompactionTask build() {
            return new CompactionTask(null, null, this.dataSource, null, null, this.ioConfig, null, this.dimensionsSpec, this.metricsSpec, this.segmentGranularity, this.tuningConfig, this.context, this.jsonMapper, this.authorizerMapper, this.chatHandlerProvider, this.rowIngestionMetersFactory, this.coordinatorClient, this.indexingServiceClient, this.segmentLoaderFactory, this.retryPolicyFactory, this.appenderatorsManager);
        }
    }

    @VisibleForTesting
    static class PartitionConfigurationManager {
        @Nullable
        private final ParallelIndexTuningConfig tuningConfig;

        PartitionConfigurationManager(@Nullable ParallelIndexTuningConfig tuningConfig) {
            this.tuningConfig = tuningConfig;
        }

        @Nullable
        ParallelIndexTuningConfig computeTuningConfig() {
            ParallelIndexTuningConfig newTuningConfig = this.tuningConfig == null ? ParallelIndexTuningConfig.defaultConfig() : this.tuningConfig;
            PartitionsSpec partitionsSpec = newTuningConfig.getGivenOrDefaultPartitionsSpec();
            if (partitionsSpec instanceof DynamicPartitionsSpec) {
                DynamicPartitionsSpec dynamicPartitionsSpec = (DynamicPartitionsSpec)partitionsSpec;
                partitionsSpec = new DynamicPartitionsSpec(dynamicPartitionsSpec.getMaxRowsPerSegment(), Long.valueOf(dynamicPartitionsSpec.getMaxTotalRowsOr(Long.MAX_VALUE)));
            }
            return newTuningConfig.withPartitionsSpec(partitionsSpec);
        }
    }

    @VisibleForTesting
    static class SegmentProvider {
        private final String dataSource;
        private final CompactionInputSpec inputSpec;
        private final Interval interval;

        SegmentProvider(String dataSource, CompactionInputSpec inputSpec) {
            this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource);
            this.inputSpec = inputSpec;
            this.interval = inputSpec.findInterval(dataSource);
        }

        List<DataSegment> checkAndGetSegments(TaskActionClient actionClient) throws IOException {
            ArrayList<DataSegment> latestSegments = new ArrayList<DataSegment>(actionClient.submit(new RetrieveUsedSegmentsAction(this.dataSource, this.interval, null, Segments.ONLY_VISIBLE)));
            if (!this.inputSpec.validateSegments(latestSegments)) {
                throw new ISE("Specified segments in the spec are different from the current used segments. Possibly new segments would have been added or some segments have been unpublished.", new Object[0]);
            }
            return latestSegments;
        }
    }
}

