/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.client.indexing.TaskStatusResponse;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskInfoProvider;

public class ClientBasedTaskInfoProvider
implements TaskInfoProvider {
    private final IndexingServiceClient client;

    @Inject
    public ClientBasedTaskInfoProvider(IndexingServiceClient client) {
        this.client = client;
    }

    @Override
    public TaskLocation getTaskLocation(String id) {
        TaskStatusResponse response = this.client.getTaskStatus(id);
        return response == null ? TaskLocation.unknown() : response.getStatus().getLocation();
    }

    @Override
    public Optional<TaskStatus> getTaskStatus(String id) {
        TaskStatusResponse response = this.client.getTaskStatus(id);
        return response == null ? Optional.absent() : Optional.of((Object)TaskStatus.fromCode((String)id, (TaskState)response.getStatus().getStatusCode()));
    }
}

