/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.LockListAction;
import org.apache.druid.indexing.common.actions.SurrogateAction;
import org.apache.druid.indexing.common.task.IndexTask;
import org.apache.druid.indexing.common.task.IndexTaskSegmentAllocator;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

class CachingLocalSegmentAllocatorHelper
implements IndexTaskSegmentAllocator {
    private final String taskId;
    private final Map<String, SegmentIdWithShardSpec> sequenceNameToSegmentId;
    private final IndexTask.ShardSpecs shardSpecs;

    CachingLocalSegmentAllocatorHelper(TaskToolbox toolbox, String taskId, String supervisorTaskId, IntervalToSegmentIdsCreator intervalToSegmentIdsCreator) throws IOException {
        this.taskId = taskId;
        this.sequenceNameToSegmentId = new HashMap<String, SegmentIdWithShardSpec>();
        Map<Interval, String> intervalToVersion = ((List)toolbox.getTaskActionClient().submit(new SurrogateAction(supervisorTaskId, new LockListAction()))).stream().collect(Collectors.toMap(TaskLock::getInterval, TaskLock::getVersion));
        Function<Interval, String> versionFinder = interval -> CachingLocalSegmentAllocatorHelper.findVersion(intervalToVersion, interval);
        Map<Interval, List<SegmentIdWithShardSpec>> intervalToIds = intervalToSegmentIdsCreator.create(versionFinder);
        HashMap<Interval, List<ShardSpec>> shardSpecMap = new HashMap<Interval, List<ShardSpec>>();
        for (Map.Entry<Interval, List<SegmentIdWithShardSpec>> entry : intervalToIds.entrySet()) {
            Interval interval2 = entry.getKey();
            List<SegmentIdWithShardSpec> idsPerInterval = intervalToIds.get(interval2);
            for (SegmentIdWithShardSpec segmentIdentifier : idsPerInterval) {
                shardSpecMap.computeIfAbsent(interval2, k -> new ArrayList()).add(segmentIdentifier.getShardSpec());
                this.sequenceNameToSegmentId.put(this.getSequenceName(interval2, segmentIdentifier.getShardSpec()), segmentIdentifier);
            }
        }
        this.shardSpecs = new IndexTask.ShardSpecs(shardSpecMap);
    }

    private static String findVersion(Map<Interval, String> intervalToVersion, Interval interval) {
        return intervalToVersion.entrySet().stream().filter(entry -> ((Interval)entry.getKey()).contains((ReadableInterval)interval)).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new ISE("Cannot find a version for interval[%s]", new Object[]{interval}));
    }

    public SegmentIdWithShardSpec allocate(InputRow row, String sequenceName, String previousSegmentId, boolean skipSegmentLineageCheck) {
        return this.sequenceNameToSegmentId.get(sequenceName);
    }

    @Override
    public String getSequenceName(Interval interval, InputRow inputRow) {
        return this.getSequenceName(interval, this.shardSpecs.getShardSpec(interval, inputRow));
    }

    private String getSequenceName(Interval interval, ShardSpec shardSpec) {
        return StringUtils.format((String)"%s_%s_%d", (Object[])new Object[]{this.taskId, interval, shardSpec.getPartitionNum()});
    }

    @FunctionalInterface
    static interface IntervalToSegmentIdsCreator {
        public Map<Interval, List<SegmentIdWithShardSpec>> create(Function<Interval, String> var1);
    }
}

