/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import org.apache.druid.indexing.appenderator.ActionBasedUsedSegmentChecker;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.realtime.appenderator.AppenderatorsManager;
import org.apache.druid.segment.realtime.appenderator.BatchAppenderatorDriver;
import org.apache.druid.segment.realtime.appenderator.SegmentAllocator;
import org.apache.druid.segment.realtime.appenderator.UsedSegmentChecker;

public final class BatchAppenderators {
    public static Appenderator newAppenderator(String taskId, AppenderatorsManager appenderatorsManager, FireDepartmentMetrics metrics, TaskToolbox toolbox, DataSchema dataSchema, AppenderatorConfig appenderatorConfig, boolean storeCompactionState) {
        return BatchAppenderators.newAppenderator(taskId, appenderatorsManager, metrics, toolbox, dataSchema, appenderatorConfig, toolbox.getSegmentPusher(), storeCompactionState);
    }

    public static Appenderator newAppenderator(String taskId, AppenderatorsManager appenderatorsManager, FireDepartmentMetrics metrics, TaskToolbox toolbox, DataSchema dataSchema, AppenderatorConfig appenderatorConfig, DataSegmentPusher segmentPusher, boolean storeCompactionState) {
        return appenderatorsManager.createOfflineAppenderatorForTask(taskId, dataSchema, appenderatorConfig.withBasePersistDirectory(toolbox.getPersistDir()), storeCompactionState, metrics, segmentPusher, toolbox.getJsonMapper(), toolbox.getIndexIO(), (IndexMerger)toolbox.getIndexMergerV9());
    }

    public static BatchAppenderatorDriver newDriver(Appenderator appenderator, TaskToolbox toolbox, SegmentAllocator segmentAllocator) {
        return new BatchAppenderatorDriver(appenderator, segmentAllocator, (UsedSegmentChecker)new ActionBasedUsedSegmentChecker(toolbox.getTaskActionClient()), toolbox.getDataSegmentKiller());
    }

    private BatchAppenderators() {
    }
}

