/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.RetrieveUsedSegmentsAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TimeChunkLockTryAcquireAction;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.IndexTask;
import org.apache.druid.indexing.common.task.SegmentLockHelper;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.TaskResourceCleaner;
import org.apache.druid.indexing.firehose.IngestSegmentFirehoseFactory;
import org.apache.druid.indexing.firehose.WindowedSegmentId;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.GranularityType;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Partitions;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.HashBasedNumberedShardSpecFactory;
import org.apache.druid.timeline.partition.ShardSpecFactory;
import org.joda.time.Interval;
import org.joda.time.Period;

public abstract class AbstractBatchIndexTask
extends AbstractTask {
    private static final Logger log = new Logger(AbstractBatchIndexTask.class);
    private final SegmentLockHelper segmentLockHelper;
    @GuardedBy(value="this")
    private final TaskResourceCleaner resourceCloserOnAbnormalExit = new TaskResourceCleaner();
    private boolean useSegmentLock;
    @GuardedBy(value="this")
    private boolean stopped = false;

    protected AbstractBatchIndexTask(String id, String dataSource, Map<String, Object> context) {
        super(id, dataSource, context);
        this.segmentLockHelper = new SegmentLockHelper();
    }

    protected AbstractBatchIndexTask(String id, @Nullable String groupId, @Nullable TaskResource taskResource, String dataSource, @Nullable Map<String, Object> context) {
        super(id, groupId, taskResource, dataSource, context);
        this.segmentLockHelper = new SegmentLockHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        AbstractBatchIndexTask abstractBatchIndexTask = this;
        synchronized (abstractBatchIndexTask) {
            if (this.stopped) {
                return TaskStatus.failure((String)this.getId());
            }
            Thread currentThread = Thread.currentThread();
            this.resourceCloserOnAbnormalExit.register(config -> currentThread.interrupt());
        }
        return this.runTask(toolbox);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopGracefully(TaskConfig taskConfig) {
        AbstractBatchIndexTask abstractBatchIndexTask = this;
        synchronized (abstractBatchIndexTask) {
            this.stopped = true;
            this.resourceCloserOnAbnormalExit.clean(taskConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerResourceCloserOnAbnormalExit(Consumer<TaskConfig> cleaner) {
        AbstractBatchIndexTask abstractBatchIndexTask = this;
        synchronized (abstractBatchIndexTask) {
            this.resourceCloserOnAbnormalExit.register(cleaner);
        }
    }

    public abstract TaskStatus runTask(TaskToolbox var1) throws Exception;

    public abstract boolean requireLockExistingSegments();

    public abstract List<DataSegment> findSegmentsToLock(TaskActionClient var1, List<Interval> var2) throws IOException;

    public abstract boolean isPerfectRollup();

    @Nullable
    public abstract Granularity getSegmentGranularity();

    @Override
    public int getPriority() {
        return this.getContextValue("priority", 50);
    }

    public boolean isUseSegmentLock() {
        return this.useSegmentLock;
    }

    public SegmentLockHelper getSegmentLockHelper() {
        return this.segmentLockHelper;
    }

    protected boolean determineLockGranularityAndTryLock(TaskActionClient client, GranularitySpec granularitySpec) throws IOException {
        ArrayList intervals = granularitySpec.bucketIntervals().isPresent() ? new ArrayList((Collection)granularitySpec.bucketIntervals().get()) : Collections.emptyList();
        return this.determineLockGranularityandTryLock(client, intervals);
    }

    boolean determineLockGranularityandTryLock(TaskActionClient client, List<Interval> intervals) throws IOException {
        boolean forceTimeChunkLock = this.getContextValue("forceTimeChunkLock", true);
        if (forceTimeChunkLock) {
            log.info("[%s] is set to true in task context. Use timeChunk lock", new Object[]{"forceTimeChunkLock"});
            this.useSegmentLock = false;
            if (!intervals.isEmpty()) {
                return this.tryTimeChunkLock(client, intervals);
            }
            return true;
        }
        if (!intervals.isEmpty()) {
            LockGranularityDetermineResult result = this.determineSegmentGranularity(client, intervals);
            this.useSegmentLock = result.lockGranularity == LockGranularity.SEGMENT;
            return this.tryLockWithDetermineResult(client, result);
        }
        return true;
    }

    boolean determineLockGranularityandTryLockWithSegments(TaskActionClient client, List<DataSegment> segments) throws IOException {
        boolean forceTimeChunkLock = this.getContextValue("forceTimeChunkLock", true);
        if (forceTimeChunkLock) {
            log.info("[%s] is set to true in task context. Use timeChunk lock", new Object[]{"forceTimeChunkLock"});
            this.useSegmentLock = false;
            return this.tryTimeChunkLock(client, new ArrayList<Interval>(segments.stream().map(DataSegment::getInterval).collect(Collectors.toSet())));
        }
        LockGranularityDetermineResult result = this.determineSegmentGranularity(segments);
        this.useSegmentLock = result.lockGranularity == LockGranularity.SEGMENT;
        return this.tryLockWithDetermineResult(client, result);
    }

    private LockGranularityDetermineResult determineSegmentGranularity(TaskActionClient client, List<Interval> intervals) throws IOException {
        if (this.requireLockExistingSegments()) {
            if (this.isPerfectRollup()) {
                log.info("Using timeChunk lock for perfect rollup", new Object[0]);
                return new LockGranularityDetermineResult(LockGranularity.TIME_CHUNK, intervals, null);
            }
            if (!intervals.isEmpty()) {
                return this.determineSegmentGranularity(this.findSegmentsToLock(client, intervals));
            }
            log.info("Using segment lock for empty intervals", new Object[0]);
            return new LockGranularityDetermineResult(LockGranularity.SEGMENT, null, Collections.emptyList());
        }
        log.info("Using segment lock since we don't have to lock existing segments", new Object[0]);
        return new LockGranularityDetermineResult(LockGranularity.SEGMENT, null, Collections.emptyList());
    }

    private boolean tryLockWithDetermineResult(TaskActionClient client, LockGranularityDetermineResult result) throws IOException {
        if (result.lockGranularity == LockGranularity.TIME_CHUNK) {
            return this.tryTimeChunkLock(client, (List)Preconditions.checkNotNull((Object)result.intervals, (Object)"intervals"));
        }
        return this.segmentLockHelper.verifyAndLockExistingSegments(client, (List)Preconditions.checkNotNull((Object)result.segments, (Object)"segments"));
    }

    protected boolean tryTimeChunkLock(TaskActionClient client, List<Interval> intervals) throws IOException {
        HashSet<Interval> uniqueIntervals = new HashSet<Interval>();
        for (Interval interval : JodaUtils.condenseIntervals(intervals)) {
            Granularity segmentGranularity = this.getSegmentGranularity();
            if (segmentGranularity == null) {
                uniqueIntervals.add(interval);
                continue;
            }
            Iterables.addAll(uniqueIntervals, (Iterable)segmentGranularity.getIterable(interval));
        }
        for (Interval interval : uniqueIntervals) {
            TaskLock lock = client.submit(new TimeChunkLockTryAcquireAction(TaskLockType.EXCLUSIVE, interval));
            if (lock != null) continue;
            return false;
        }
        return true;
    }

    private LockGranularityDetermineResult determineSegmentGranularity(List<DataSegment> segments) {
        if (segments.isEmpty()) {
            log.info("Using segment lock for empty segments", new Object[0]);
            return new LockGranularityDetermineResult(LockGranularity.SEGMENT, null, Collections.emptyList());
        }
        if (this.requireLockExistingSegments()) {
            Granularity granularityFromSegments = AbstractBatchIndexTask.findGranularityFromSegments(segments);
            Granularity segmentGranularityFromSpec = this.getSegmentGranularity();
            List intervals = segments.stream().map(DataSegment::getInterval).collect(Collectors.toList());
            if (granularityFromSegments == null || segmentGranularityFromSpec != null && (!granularityFromSegments.equals(segmentGranularityFromSpec) || segments.stream().anyMatch(segment -> !segmentGranularityFromSpec.isAligned(segment.getInterval())))) {
                log.info("Detected segmentGranularity change. Using timeChunk lock", new Object[0]);
                return new LockGranularityDetermineResult(LockGranularity.TIME_CHUNK, intervals, null);
            }
            VersionedIntervalTimeline timeline = VersionedIntervalTimeline.forSegments(segments);
            Set segmentsToLock = timeline.findNonOvershadowedObjectsInInterval(JodaUtils.umbrellaInterval(intervals), Partitions.ONLY_COMPLETE);
            log.info("No segmentGranularity change detected and it's not perfect rollup. Using segment lock", new Object[0]);
            return new LockGranularityDetermineResult(LockGranularity.SEGMENT, null, new ArrayList(segmentsToLock));
        }
        log.info("Using segment lock since we don't have to lock existing segments", new Object[0]);
        return new LockGranularityDetermineResult(LockGranularity.SEGMENT, null, Collections.emptyList());
    }

    public static boolean isGuaranteedRollup(IndexTask.IndexIOConfig ioConfig, IndexTask.IndexTuningConfig tuningConfig) {
        Preconditions.checkState((!tuningConfig.isForceGuaranteedRollup() || !ioConfig.isAppendToExisting() ? 1 : 0) != 0, (Object)"Perfect rollup cannot be guaranteed when appending to existing dataSources");
        return tuningConfig.isForceGuaranteedRollup();
    }

    static Pair<ShardSpecFactory, Integer> createShardSpecFactoryForGuaranteedRollup(int numShards, @Nullable List<String> partitionDimensions) {
        return Pair.of((Object)new HashBasedNumberedShardSpecFactory(partitionDimensions, numShards), (Object)numShards);
    }

    @Nullable
    static Granularity findGranularityFromSegments(List<DataSegment> segments) {
        if (segments.isEmpty()) {
            return null;
        }
        Period firstSegmentPeriod = segments.get(0).getInterval().toPeriod();
        boolean allHasSameGranularity = segments.stream().allMatch(segment -> firstSegmentPeriod.equals((Object)segment.getInterval().toPeriod()));
        if (allHasSameGranularity) {
            return GranularityType.fromPeriod((Period)firstSegmentPeriod).getDefaultGranularity();
        }
        return null;
    }

    protected static Map<Interval, Pair<ShardSpecFactory, Integer>> createShardSpecWithoutInputScan(GranularitySpec granularitySpec, IndexTask.IndexIOConfig ioConfig, IndexTask.IndexTuningConfig tuningConfig, @Nonnull PartitionsSpec nonNullPartitionsSpec) {
        HashMap<Interval, Pair<ShardSpecFactory, Integer>> allocateSpec = new HashMap<Interval, Pair<ShardSpecFactory, Integer>>();
        SortedSet intervals = (SortedSet)granularitySpec.bucketIntervals().get();
        if (AbstractBatchIndexTask.isGuaranteedRollup(ioConfig, tuningConfig)) {
            assert (nonNullPartitionsSpec instanceof HashedPartitionsSpec);
            HashedPartitionsSpec partitionsSpec = (HashedPartitionsSpec)nonNullPartitionsSpec;
            int numShards = partitionsSpec.getNumShards() == null ? 1 : partitionsSpec.getNumShards();
            for (Interval interval : intervals) {
                allocateSpec.put(interval, AbstractBatchIndexTask.createShardSpecFactoryForGuaranteedRollup(numShards, partitionsSpec.getPartitionDimensions()));
            }
        } else {
            for (Interval interval : intervals) {
                allocateSpec.put(interval, null);
            }
        }
        return allocateSpec;
    }

    protected static List<DataSegment> findInputSegments(String dataSource, TaskActionClient actionClient, List<Interval> intervalsToRead, FirehoseFactory firehoseFactory) throws IOException {
        if (firehoseFactory instanceof IngestSegmentFirehoseFactory) {
            List<WindowedSegmentId> inputSegments = ((IngestSegmentFirehoseFactory)firehoseFactory).getSegments();
            if (inputSegments == null) {
                Interval inputInterval = (Interval)Preconditions.checkNotNull((Object)((IngestSegmentFirehoseFactory)firehoseFactory).getInterval(), (Object)"input interval");
                return ImmutableList.copyOf(actionClient.submit(new RetrieveUsedSegmentsAction(dataSource, inputInterval, null, Segments.ONLY_VISIBLE)));
            }
            List inputSegmentIds = inputSegments.stream().map(WindowedSegmentId::getSegmentId).collect(Collectors.toList());
            Collection<DataSegment> dataSegmentsInIntervals = actionClient.submit(new RetrieveUsedSegmentsAction(dataSource, null, inputSegments.stream().flatMap(windowedSegmentId -> windowedSegmentId.getIntervals().stream()).collect(Collectors.toSet()), Segments.ONLY_VISIBLE));
            return dataSegmentsInIntervals.stream().filter(segment -> inputSegmentIds.contains(segment.getId().toString())).collect(Collectors.toList());
        }
        return ImmutableList.copyOf(actionClient.submit(new RetrieveUsedSegmentsAction(dataSource, null, intervalsToRead, Segments.ONLY_VISIBLE)));
    }

    private static class LockGranularityDetermineResult {
        private final LockGranularity lockGranularity;
        @Nullable
        private final List<Interval> intervals;
        @Nullable
        private final List<DataSegment> segments;

        private LockGranularityDetermineResult(LockGranularity lockGranularity, @Nullable List<Interval> intervals, @Nullable List<DataSegment> segments) {
            this.lockGranularity = lockGranularity;
            this.intervals = intervals;
            this.segments = segments;
        }
    }
}

