/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.stats;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.indexing.common.stats.RowIngestionMeters;
import org.apache.druid.indexing.common.stats.RowIngestionMetersTotals;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.AbstractMonitor;
import org.apache.druid.java.util.metrics.MonitorUtils;
import org.apache.druid.segment.realtime.FireDepartment;
import org.apache.druid.segment.realtime.FireDepartmentMetrics;

public class TaskRealtimeMetricsMonitor
extends AbstractMonitor {
    private static final EmittingLogger log = new EmittingLogger(TaskRealtimeMetricsMonitor.class);
    private final FireDepartment fireDepartment;
    private final RowIngestionMeters rowIngestionMeters;
    private final Map<String, String[]> dimensions;
    private FireDepartmentMetrics previousFireDepartmentMetrics;
    private RowIngestionMetersTotals previousRowIngestionMetersTotals;

    public TaskRealtimeMetricsMonitor(FireDepartment fireDepartment, RowIngestionMeters rowIngestionMeters, Map<String, String[]> dimensions) {
        this.fireDepartment = fireDepartment;
        this.rowIngestionMeters = rowIngestionMeters;
        this.dimensions = ImmutableMap.copyOf(dimensions);
        this.previousFireDepartmentMetrics = new FireDepartmentMetrics();
        this.previousRowIngestionMetersTotals = new RowIngestionMetersTotals(0L, 0L, 0L, 0L);
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        FireDepartmentMetrics metrics = this.fireDepartment.getMetrics().snapshot();
        RowIngestionMetersTotals rowIngestionMetersTotals = this.rowIngestionMeters.getTotals();
        ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setDimension("dataSource", (Object)this.fireDepartment.getDataSchema().getDataSource());
        MonitorUtils.addDimensionsToBuilder((ServiceMetricEvent.Builder)builder, this.dimensions);
        long thrownAway = rowIngestionMetersTotals.getThrownAway() - this.previousRowIngestionMetersTotals.getThrownAway();
        if (thrownAway > 0L) {
            log.warn("[%,d] events thrown away. Possible causes: null events, events filtered out by transformSpec, or events outside earlyMessageRejectionPeriod / lateMessageRejectionPeriod.", new Object[]{thrownAway});
        }
        emitter.emit(builder.build("ingest/events/thrownAway", (Number)thrownAway));
        long unparseable = rowIngestionMetersTotals.getUnparseable() - this.previousRowIngestionMetersTotals.getUnparseable();
        if (unparseable > 0L) {
            log.error("[%,d] unparseable events discarded. Turn on debug logging to see exception stack trace.", new Object[]{unparseable});
        }
        emitter.emit(builder.build("ingest/events/unparseable", (Number)unparseable));
        long processedWithError = rowIngestionMetersTotals.getProcessedWithError() - this.previousRowIngestionMetersTotals.getProcessedWithError();
        if (processedWithError > 0L) {
            log.error("[%,d] events processed with errors! Set logParseExceptions to true in the ingestion spec to log these errors.", new Object[]{processedWithError});
        }
        emitter.emit(builder.build("ingest/events/processedWithError", (Number)processedWithError));
        emitter.emit(builder.build("ingest/events/processed", (Number)(rowIngestionMetersTotals.getProcessed() - this.previousRowIngestionMetersTotals.getProcessed())));
        long dedup = metrics.dedup() - this.previousFireDepartmentMetrics.dedup();
        if (dedup > 0L) {
            log.warn("[%,d] duplicate events!", new Object[]{dedup});
        }
        emitter.emit(builder.build("ingest/events/duplicate", (Number)dedup));
        emitter.emit(builder.build("ingest/rows/output", (Number)(metrics.rowOutput() - this.previousFireDepartmentMetrics.rowOutput())));
        emitter.emit(builder.build("ingest/persists/count", (Number)(metrics.numPersists() - this.previousFireDepartmentMetrics.numPersists())));
        emitter.emit(builder.build("ingest/persists/time", (Number)(metrics.persistTimeMillis() - this.previousFireDepartmentMetrics.persistTimeMillis())));
        emitter.emit(builder.build("ingest/persists/cpu", (Number)(metrics.persistCpuTime() - this.previousFireDepartmentMetrics.persistCpuTime())));
        emitter.emit(builder.build("ingest/persists/backPressure", (Number)(metrics.persistBackPressureMillis() - this.previousFireDepartmentMetrics.persistBackPressureMillis())));
        emitter.emit(builder.build("ingest/persists/failed", (Number)(metrics.failedPersists() - this.previousFireDepartmentMetrics.failedPersists())));
        emitter.emit(builder.build("ingest/handoff/failed", (Number)(metrics.failedHandoffs() - this.previousFireDepartmentMetrics.failedHandoffs())));
        emitter.emit(builder.build("ingest/merge/time", (Number)(metrics.mergeTimeMillis() - this.previousFireDepartmentMetrics.mergeTimeMillis())));
        emitter.emit(builder.build("ingest/merge/cpu", (Number)(metrics.mergeCpuTime() - this.previousFireDepartmentMetrics.mergeCpuTime())));
        emitter.emit(builder.build("ingest/handoff/count", (Number)(metrics.handOffCount() - this.previousFireDepartmentMetrics.handOffCount())));
        emitter.emit(builder.build("ingest/sink/count", (Number)metrics.sinkCount()));
        emitter.emit(builder.build("ingest/events/messageGap", (Number)metrics.messageGap()));
        this.previousRowIngestionMetersTotals = rowIngestionMetersTotals;
        this.previousFireDepartmentMetrics = metrics;
        return true;
    }
}

