/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;

public class RetrieveUsedSegmentsAction
implements TaskAction<Collection<DataSegment>> {
    @JsonIgnore
    private final String dataSource;
    @JsonIgnore
    private final List<Interval> intervals;
    @JsonIgnore
    private final Segments visibility;

    @JsonCreator
    public RetrieveUsedSegmentsAction(@JsonProperty(value="dataSource") String dataSource, @Deprecated @JsonProperty(value="interval") Interval interval, @JsonProperty(value="intervals") Collection<Interval> intervals, @JsonProperty(value="visibility") @Nullable Segments visibility) {
        this.dataSource = dataSource;
        Preconditions.checkArgument((interval == null || intervals == null ? 1 : 0) != 0, (Object)"please specify intervals only");
        Object theIntervals = null;
        if (interval != null) {
            theIntervals = ImmutableList.of((Object)interval);
        } else if (intervals != null && intervals.size() > 0) {
            theIntervals = JodaUtils.condenseIntervals(intervals);
        }
        this.intervals = (List)Preconditions.checkNotNull((Object)theIntervals, (Object)"no intervals found");
        this.visibility = visibility != null ? visibility : Segments.ONLY_VISIBLE;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public List<Interval> getIntervals() {
        return this.intervals;
    }

    @JsonProperty
    public Segments getVisibility() {
        return this.visibility;
    }

    @Override
    public TypeReference<Collection<DataSegment>> getReturnTypeReference() {
        return new TypeReference<Collection<DataSegment>>(){};
    }

    @Override
    public Collection<DataSegment> perform(Task task, TaskActionToolbox toolbox) {
        return toolbox.getIndexerMetadataStorageCoordinator().getUsedSegmentsForIntervals(this.dataSource, this.intervals, this.visibility);
    }

    @Override
    public boolean isAudited() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetrieveUsedSegmentsAction that = (RetrieveUsedSegmentsAction)o;
        if (!this.dataSource.equals(that.dataSource)) {
            return false;
        }
        if (!this.intervals.equals(that.intervals)) {
            return false;
        }
        return this.visibility.equals((Object)that.visibility);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.intervals, this.visibility);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{dataSource='" + this.dataSource + '\'' + ", intervals=" + this.intervals + ", visibility=" + this.visibility + '}';
    }
}

