/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.actions.TaskAuditLogConfig;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;

public class LocalTaskActionClient
implements TaskActionClient {
    private static final EmittingLogger log = new EmittingLogger(LocalTaskActionClient.class);
    private final ConcurrentHashMap<Class<? extends TaskAction>, AtomicInteger> actionCountMap = new ConcurrentHashMap();
    private final Task task;
    private final TaskStorage storage;
    private final TaskActionToolbox toolbox;
    private final TaskAuditLogConfig auditLogConfig;

    public LocalTaskActionClient(Task task, TaskStorage storage, TaskActionToolbox toolbox, TaskAuditLogConfig auditLogConfig) {
        this.task = task;
        this.storage = storage;
        this.toolbox = toolbox;
        this.auditLogConfig = auditLogConfig;
    }

    @Override
    public <RetType> RetType submit(TaskAction<RetType> taskAction) {
        log.info("Performing action for task[%s]: %s", new Object[]{this.task.getId(), taskAction});
        if (this.auditLogConfig.isEnabled() && taskAction.isAudited()) {
            try {
                long auditLogStartTime = System.currentTimeMillis();
                this.storage.addAuditLog(this.task, taskAction);
                this.emitTimerMetric("task/action/log/time", System.currentTimeMillis() - auditLogStartTime);
            }
            catch (Exception e) {
                String actionClass = taskAction.getClass().getName();
                log.makeAlert((Throwable)e, "Failed to record action in audit log", new Object[0]).addData("task", (Object)this.task.getId()).addData("actionClass", (Object)actionClass).emit();
                throw new ISE((Throwable)e, "Failed to record action [%s] in audit log", new Object[]{actionClass});
            }
        }
        long performStartTime = System.currentTimeMillis();
        RetType result = taskAction.perform(this.task, this.toolbox);
        this.emitTimerMetric("task/action/run/time", System.currentTimeMillis() - performStartTime);
        this.actionCountMap.computeIfAbsent(taskAction.getClass(), k -> new AtomicInteger()).incrementAndGet();
        return result;
    }

    @VisibleForTesting
    public int getActionCount(Class<? extends TaskAction> actionClass) {
        AtomicInteger count = this.actionCountMap.get(actionClass);
        return count == null ? 0 : count.get();
    }

    private void emitTimerMetric(String metric, long time) {
        ServiceMetricEvent.Builder metricBuilder = ServiceMetricEvent.builder();
        IndexTaskUtils.setTaskDimensions(metricBuilder, this.task);
        this.toolbox.getEmitter().emit(metricBuilder.build(metric, (Number)Math.max(0L, time)));
    }
}

