/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.File;
import java.util.concurrent.ExecutorService;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.discovery.DataNodeService;
import org.apache.druid.discovery.DruidNodeAnnouncer;
import org.apache.druid.discovery.LookupNodeService;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Parent;
import org.apache.druid.guice.annotations.Processing;
import org.apache.druid.guice.annotations.RemoteChatHandler;
import org.apache.druid.indexing.common.SegmentLoaderFactory;
import org.apache.druid.indexing.common.TaskReportFileWriter;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.worker.IntermediaryDataManager;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.MonitorScheduler;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.loading.DataSegmentArchiver;
import org.apache.druid.segment.loading.DataSegmentKiller;
import org.apache.druid.segment.loading.DataSegmentMover;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.realtime.plumber.SegmentHandoffNotifierFactory;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.server.coordination.DataSegmentServerAnnouncer;

public class TaskToolboxFactory {
    private final TaskConfig config;
    private final DruidNode taskExecutorNode;
    private final TaskActionClientFactory taskActionClientFactory;
    private final ServiceEmitter emitter;
    private final DataSegmentPusher segmentPusher;
    private final DataSegmentKiller dataSegmentKiller;
    private final DataSegmentMover dataSegmentMover;
    private final DataSegmentArchiver dataSegmentArchiver;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final DataSegmentServerAnnouncer serverAnnouncer;
    private final SegmentHandoffNotifierFactory handoffNotifierFactory;
    private final Provider<QueryRunnerFactoryConglomerate> queryRunnerFactoryConglomerateProvider;
    private final ExecutorService queryExecutorService;
    private final MonitorScheduler monitorScheduler;
    private final SegmentLoaderFactory segmentLoaderFactory;
    private final ObjectMapper jsonMapper;
    private final IndexIO indexIO;
    private final Cache cache;
    private final CacheConfig cacheConfig;
    private final CachePopulatorStats cachePopulatorStats;
    private final IndexMergerV9 indexMergerV9;
    private final DruidNodeAnnouncer druidNodeAnnouncer;
    private final DruidNode druidNode;
    private final LookupNodeService lookupNodeService;
    private final DataNodeService dataNodeService;
    private final TaskReportFileWriter taskReportFileWriter;
    private final IntermediaryDataManager intermediaryDataManager;

    @Inject
    public TaskToolboxFactory(TaskConfig config, @Parent DruidNode taskExecutorNode, TaskActionClientFactory taskActionClientFactory, ServiceEmitter emitter, DataSegmentPusher segmentPusher, DataSegmentKiller dataSegmentKiller, DataSegmentMover dataSegmentMover, DataSegmentArchiver dataSegmentArchiver, DataSegmentAnnouncer segmentAnnouncer, DataSegmentServerAnnouncer serverAnnouncer, SegmentHandoffNotifierFactory handoffNotifierFactory, Provider<QueryRunnerFactoryConglomerate> queryRunnerFactoryConglomerateProvider, @Processing ExecutorService queryExecutorService, MonitorScheduler monitorScheduler, SegmentLoaderFactory segmentLoaderFactory, @Json ObjectMapper jsonMapper, IndexIO indexIO, Cache cache, CacheConfig cacheConfig, CachePopulatorStats cachePopulatorStats, IndexMergerV9 indexMergerV9, DruidNodeAnnouncer druidNodeAnnouncer, @RemoteChatHandler DruidNode druidNode, LookupNodeService lookupNodeService, DataNodeService dataNodeService, TaskReportFileWriter taskReportFileWriter, IntermediaryDataManager intermediaryDataManager) {
        this.config = config;
        this.taskExecutorNode = taskExecutorNode;
        this.taskActionClientFactory = taskActionClientFactory;
        this.emitter = emitter;
        this.segmentPusher = segmentPusher;
        this.dataSegmentKiller = dataSegmentKiller;
        this.dataSegmentMover = dataSegmentMover;
        this.dataSegmentArchiver = dataSegmentArchiver;
        this.segmentAnnouncer = segmentAnnouncer;
        this.serverAnnouncer = serverAnnouncer;
        this.handoffNotifierFactory = handoffNotifierFactory;
        this.queryRunnerFactoryConglomerateProvider = queryRunnerFactoryConglomerateProvider;
        this.queryExecutorService = queryExecutorService;
        this.monitorScheduler = monitorScheduler;
        this.segmentLoaderFactory = segmentLoaderFactory;
        this.jsonMapper = jsonMapper;
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"Null IndexIO");
        this.cache = cache;
        this.cacheConfig = cacheConfig;
        this.cachePopulatorStats = cachePopulatorStats;
        this.indexMergerV9 = indexMergerV9;
        this.druidNodeAnnouncer = druidNodeAnnouncer;
        this.druidNode = druidNode;
        this.lookupNodeService = lookupNodeService;
        this.dataNodeService = dataNodeService;
        this.taskReportFileWriter = taskReportFileWriter;
        this.intermediaryDataManager = intermediaryDataManager;
    }

    public TaskToolbox build(Task task) {
        File taskWorkDir = this.config.getTaskWorkDir(task.getId());
        return new TaskToolbox(this.config, this.taskExecutorNode, this.taskActionClientFactory.create(task), this.emitter, this.segmentPusher, this.dataSegmentKiller, this.dataSegmentMover, this.dataSegmentArchiver, this.segmentAnnouncer, this.serverAnnouncer, this.handoffNotifierFactory, this.queryRunnerFactoryConglomerateProvider, this.queryExecutorService, this.monitorScheduler, this.segmentLoaderFactory.manufacturate(taskWorkDir), this.jsonMapper, taskWorkDir, this.indexIO, this.cache, this.cacheConfig, this.cachePopulatorStats, this.indexMergerV9, this.druidNodeAnnouncer, this.druidNode, this.lookupNodeService, this.dataNodeService, this.taskReportFileWriter, this.intermediaryDataManager);
    }
}

