/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.io.File;
import java.util.Collections;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.loading.SegmentLoader;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.SegmentLoaderLocalCacheManager;
import org.apache.druid.segment.loading.StorageLocationConfig;

public class SegmentLoaderFactory {
    private final IndexIO indexIO;
    private final ObjectMapper jsonMapper;

    @Inject
    public SegmentLoaderFactory(IndexIO indexIO, @Json ObjectMapper mapper) {
        this.indexIO = indexIO;
        this.jsonMapper = mapper;
    }

    public SegmentLoader manufacturate(File storageDir) {
        return new SegmentLoaderLocalCacheManager(this.indexIO, new SegmentLoaderConfig().withLocations(Collections.singletonList(new StorageLocationConfig(storageDir, null, null))), this.jsonMapper);
    }
}

