/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.gcs;

import com.google.api.gax.paging.Page;
import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.ResUploadType;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.storage.api.StorageEntity;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperate;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcsStorageOperator
implements Closeable,
StorageOperate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GcsStorageOperator.class);
    private Storage gcsStorage;
    private String bucketName;
    private String credential;

    public void init() {
        try {
            this.credential = this.readCredentials();
            this.bucketName = this.readBucketName();
            this.gcsStorage = this.buildGcsStorage(this.credential);
            this.checkBucketNameExists(this.bucketName);
        }
        catch (IOException e) {
            log.error("GCS Storage operator init failed", (Throwable)e);
        }
    }

    protected Storage buildGcsStorage(String credential) throws IOException {
        return (Storage)((StorageOptions.Builder)StorageOptions.newBuilder().setCredentials((Credentials)ServiceAccountCredentials.fromStream((InputStream)Files.newInputStream(Paths.get(credential, new String[0]), new OpenOption[0])))).build().getService();
    }

    protected String readCredentials() {
        return PropertyUtils.getString((String)"resource.google.cloud.storage.credential");
    }

    protected String readBucketName() {
        return PropertyUtils.getString((String)"resource.google.cloud.storage.bucket.name");
    }

    public void createTenantDirIfNotExists(String tenantCode) throws Exception {
        this.mkdir(tenantCode, this.getGcsResDir(tenantCode));
        this.mkdir(tenantCode, this.getGcsUdfDir(tenantCode));
    }

    public String getResDir(String tenantCode) {
        return this.getGcsResDir(tenantCode) + "/";
    }

    public String getUdfDir(String tenantCode) {
        return this.getGcsUdfDir(tenantCode) + "/";
    }

    public String getResourceFullName(String tenantCode, String fileName) {
        if (fileName.startsWith("/")) {
            fileName.replaceFirst("/", "");
        }
        return String.format("%s/%s", this.getGcsResDir(tenantCode), fileName);
    }

    public String getResourceFileName(String tenantCode, String fullName) {
        String resDir = this.getResDir(tenantCode);
        return fullName.replaceFirst(resDir, "");
    }

    public String getFileName(ResourceType resourceType, String tenantCode, String fileName) {
        if (fileName.startsWith("/")) {
            fileName = fileName.replaceFirst("/", "");
        }
        return this.getDir(resourceType, tenantCode) + fileName;
    }

    public void download(String tenantCode, String srcFilePath, String dstFilePath, boolean overwrite) throws IOException {
        File dstFile = new File(dstFilePath);
        if (dstFile.isDirectory()) {
            Files.delete(dstFile.toPath());
        } else {
            Files.createDirectories(dstFile.getParentFile().toPath(), new FileAttribute[0]);
        }
        Blob blob = this.gcsStorage.get(BlobId.of((String)this.bucketName, (String)srcFilePath));
        blob.downloadTo(Paths.get(dstFilePath, new String[0]));
    }

    public boolean exists(String fullName) throws IOException {
        return this.isObjectExists(fullName);
    }

    public boolean delete(String filePath, boolean recursive) throws IOException {
        try {
            if (this.isObjectExists(filePath)) {
                this.gcsStorage.delete(BlobId.of((String)this.bucketName, (String)filePath));
            }
            return true;
        }
        catch (Exception e) {
            log.error("delete the object error,the resource path is {}", (Object)filePath);
            return false;
        }
    }

    public boolean delete(String fullName, List<String> childrenPathList, boolean recursive) throws IOException {
        childrenPathList.add(fullName);
        boolean result = true;
        for (String filePath : childrenPathList) {
            if (this.delete(filePath, recursive)) continue;
            result = false;
        }
        return result;
    }

    public boolean copy(String srcPath, String dstPath, boolean deleteSource, boolean overwrite) throws IOException {
        BlobId source = BlobId.of((String)this.bucketName, (String)srcPath);
        BlobId target = BlobId.of((String)this.bucketName, (String)dstPath);
        this.gcsStorage.copy(Storage.CopyRequest.newBuilder().setSource(source).setTarget(target).build());
        if (deleteSource) {
            this.gcsStorage.delete(source);
        }
        return true;
    }

    public boolean upload(String tenantCode, String srcFile, String dstPath, boolean deleteSource, boolean overwrite) throws IOException {
        try {
            BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)BlobId.of((String)this.bucketName, (String)dstPath)).build();
            Path srcPath = Paths.get(srcFile, new String[0]);
            this.gcsStorage.create(blobInfo, Files.readAllBytes(srcPath), new Storage.BlobTargetOption[0]);
            if (deleteSource) {
                Files.delete(srcPath);
            }
            return true;
        }
        catch (Exception e) {
            log.error("upload failed,the bucketName is {},the filePath is {}", (Object)this.bucketName, (Object)dstPath);
            return false;
        }
    }

    public List<String> vimFile(String tenantCode, String filePath, int skipLineNums, int limit) throws IOException {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            log.error("file path:{} is blank", (Object)filePath);
            return Collections.emptyList();
        }
        Blob blob = this.gcsStorage.get(BlobId.of((String)this.bucketName, (String)filePath));
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(blob.getContent(new Blob.BlobSourceOption[0]))));){
            Stream<String> stream = bufferedReader.lines().skip(skipLineNums).limit(limit);
            List<String> list = stream.collect(Collectors.toList());
            return list;
        }
    }

    public void deleteTenant(String tenantCode) throws Exception {
        this.deleteTenantCode(tenantCode);
    }

    protected void deleteTenantCode(String tenantCode) {
        this.deleteDirectory(this.getResDir(tenantCode));
        this.deleteDirectory(this.getUdfDir(tenantCode));
    }

    public String getDir(ResourceType resourceType, String tenantCode) {
        switch (resourceType) {
            case UDF: {
                return this.getUdfDir(tenantCode);
            }
            case FILE: {
                return this.getResDir(tenantCode);
            }
            case ALL: {
                return this.getGcsDataBasePath();
            }
        }
        return "";
    }

    protected void deleteDirectory(String directoryName) {
        if (this.isObjectExists(directoryName)) {
            this.gcsStorage.delete(BlobId.of((String)this.bucketName, (String)directoryName));
        }
    }

    public String getGcsResDir(String tenantCode) {
        return String.format("%s/resources", this.getGcsTenantDir(tenantCode));
    }

    public String getGcsUdfDir(String tenantCode) {
        return String.format("%s/udfs", this.getGcsTenantDir(tenantCode));
    }

    public String getGcsTenantDir(String tenantCode) {
        return String.format("%s/%s", this.getGcsDataBasePath(), tenantCode);
    }

    public String getGcsDataBasePath() {
        if ("/".equals(RESOURCE_UPLOAD_PATH)) {
            return "";
        }
        return RESOURCE_UPLOAD_PATH.replaceFirst("/", "");
    }

    public boolean mkdir(String tenantCode, String path) throws IOException {
        String objectName = path + "/";
        if (!this.isObjectExists(objectName)) {
            BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)BlobId.of((String)this.bucketName, (String)objectName)).build();
            this.gcsStorage.create(blobInfo, "".getBytes(StandardCharsets.UTF_8), new Storage.BlobTargetOption[0]);
        }
        return true;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.gcsStorage != null) {
                this.gcsStorage.close();
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public ResUploadType returnStorageType() {
        return ResUploadType.GCS;
    }

    public List<StorageEntity> listFilesStatusRecursively(String path, String defaultPath, String tenantCode, ResourceType type) {
        ArrayList<StorageEntity> storageEntityList = new ArrayList<StorageEntity>();
        LinkedList<StorageEntity> foldersToFetch = new LinkedList<StorageEntity>();
        StorageEntity initialEntity = null;
        try {
            initialEntity = this.getFileStatus(path, defaultPath, tenantCode, type);
        }
        catch (Exception e) {
            log.error("error while listing files status recursively, path: {}", (Object)path, (Object)e);
            return storageEntityList;
        }
        foldersToFetch.add(initialEntity);
        while (!foldersToFetch.isEmpty()) {
            String pathToExplore = ((StorageEntity)foldersToFetch.pop()).getFullName();
            try {
                List<StorageEntity> tempList = this.listFilesStatus(pathToExplore, defaultPath, tenantCode, type);
                for (StorageEntity temp : tempList) {
                    if (!temp.isDirectory()) continue;
                    foldersToFetch.add(temp);
                }
                storageEntityList.addAll(tempList);
            }
            catch (Exception e) {
                log.error("error while listing files stat:wus recursively, path: {}", (Object)pathToExplore, (Object)e);
            }
        }
        return storageEntityList;
    }

    public List<StorageEntity> listFilesStatus(String path, String defaultPath, String tenantCode, ResourceType type) throws Exception {
        Page blobs;
        ArrayList<StorageEntity> storageEntityList = new ArrayList<StorageEntity>();
        try {
            blobs = this.gcsStorage.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)path), Storage.BlobListOption.currentDirectory()});
        }
        catch (Exception e) {
            throw new RuntimeException("Get GCS file list exception. ", e);
        }
        if (blobs == null) {
            return storageEntityList;
        }
        for (Blob blob : blobs.iterateAll()) {
            if (path.equals(blob.getName())) continue;
            if (blob.isDirectory()) {
                String suffix = StringUtils.difference((String)path, (String)blob.getName());
                String fileName = StringUtils.difference((String)defaultPath, (String)blob.getName());
                StorageEntity entity = new StorageEntity();
                entity.setAlias(suffix);
                entity.setFileName(fileName);
                entity.setFullName(blob.getName());
                entity.setDirectory(true);
                entity.setUserName(tenantCode);
                entity.setType(type);
                entity.setSize(0L);
                entity.setCreateTime(null);
                entity.setUpdateTime(null);
                entity.setPfullName(path);
                storageEntityList.add(entity);
                continue;
            }
            String[] aliasArr = blob.getName().split("/");
            String alias = aliasArr[aliasArr.length - 1];
            String fileName = StringUtils.difference((String)defaultPath, (String)blob.getName());
            StorageEntity entity = new StorageEntity();
            entity.setAlias(alias);
            entity.setFileName(fileName);
            entity.setFullName(blob.getName());
            entity.setDirectory(false);
            entity.setUserName(tenantCode);
            entity.setType(type);
            entity.setSize(blob.getSize().longValue());
            entity.setCreateTime(Date.from(blob.getCreateTimeOffsetDateTime().toInstant()));
            entity.setUpdateTime(Date.from(blob.getUpdateTimeOffsetDateTime().toInstant()));
            entity.setPfullName(path);
            storageEntityList.add(entity);
        }
        return storageEntityList;
    }

    public StorageEntity getFileStatus(String path, String defaultPath, String tenantCode, ResourceType type) throws Exception {
        if (path.endsWith("/")) {
            String alias = this.findDirAlias(path);
            String fileName = StringUtils.difference((String)defaultPath, (String)path);
            StorageEntity entity = new StorageEntity();
            entity.setAlias(alias);
            entity.setFileName(fileName);
            entity.setFullName(path);
            entity.setDirectory(true);
            entity.setUserName(tenantCode);
            entity.setType(type);
            entity.setSize(0L);
            return entity;
        }
        if (this.isObjectExists(path)) {
            Blob blob = this.gcsStorage.get(BlobId.of((String)this.bucketName, (String)path));
            String[] aliasArr = blob.getName().split("/");
            String alias = aliasArr[aliasArr.length - 1];
            String fileName = StringUtils.difference((String)defaultPath, (String)blob.getName());
            StorageEntity entity = new StorageEntity();
            entity.setAlias(alias);
            entity.setFileName(fileName);
            entity.setFullName(blob.getName());
            entity.setDirectory(false);
            entity.setUserName(tenantCode);
            entity.setType(type);
            entity.setSize(blob.getSize().longValue());
            entity.setCreateTime(Date.from(blob.getCreateTimeOffsetDateTime().toInstant()));
            entity.setUpdateTime(Date.from(blob.getUpdateTimeOffsetDateTime().toInstant()));
            return entity;
        }
        throw new FileNotFoundException("Object is not found in GCS Bucket: " + this.bucketName);
    }

    protected boolean isObjectExists(String objectName) {
        Blob blob = this.gcsStorage.get(BlobId.of((String)this.bucketName, (String)objectName));
        return blob != null && blob.exists(new Blob.BlobSourceOption[0]);
    }

    public void checkBucketNameExists(String bucketName) {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            throw new IllegalArgumentException("resource.google.cloud.storage.bucket.name is blank");
        }
        boolean exist = false;
        for (Bucket bucket : this.gcsStorage.list(new Storage.BucketListOption[0]).iterateAll()) {
            if (!bucketName.equals(bucket.getName())) continue;
            exist = true;
            break;
        }
        if (!exist) {
            throw new IllegalArgumentException("bucketName: " + bucketName + " is not exists, you need to create them by yourself");
        }
        log.info("bucketName: {} has been found", (Object)bucketName);
    }

    private String findDirAlias(String dirPath) {
        if (!dirPath.endsWith("/")) {
            return dirPath;
        }
        Path path = Paths.get(dirPath, new String[0]);
        return path.getName(path.getNameCount() - 1) + "/";
    }

    @Generated
    public Storage getGcsStorage() {
        return this.gcsStorage;
    }

    @Generated
    public String getBucketName() {
        return this.bucketName;
    }

    @Generated
    public String getCredential() {
        return this.credential;
    }

    @Generated
    public void setGcsStorage(Storage gcsStorage) {
        this.gcsStorage = gcsStorage;
    }

    @Generated
    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Generated
    public void setCredential(String credential) {
        this.credential = credential;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GcsStorageOperator)) {
            return false;
        }
        GcsStorageOperator other = (GcsStorageOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Storage this$gcsStorage = this.getGcsStorage();
        Storage other$gcsStorage = other.getGcsStorage();
        if (this$gcsStorage == null ? other$gcsStorage != null : !this$gcsStorage.equals(other$gcsStorage)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        String this$credential = this.getCredential();
        String other$credential = other.getCredential();
        return !(this$credential == null ? other$credential != null : !this$credential.equals(other$credential));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GcsStorageOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Storage $gcsStorage = this.getGcsStorage();
        result = result * 59 + ($gcsStorage == null ? 43 : $gcsStorage.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        String $credential = this.getCredential();
        result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GcsStorageOperator(gcsStorage=" + this.getGcsStorage() + ", bucketName=" + this.getBucketName() + ", credential=" + this.getCredential() + ")";
    }
}

