/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.integ;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.directory.api.ldap.codec.api.BinaryAttributeDetector;
import org.apache.directory.api.ldap.codec.api.DefaultConfigurableBinaryAttributeDetector;
import org.apache.directory.api.util.Network;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.LdapConnectionConfig;
import org.apache.directory.ldap.client.api.LdapConnectionFactory;
import org.apache.directory.ldap.client.api.LdapConnectionPool;
import org.apache.directory.ldap.client.api.LdapConnectionValidator;
import org.apache.directory.ldap.client.template.LdapConnectionTemplate;
import org.apache.directory.server.annotations.CreateLdapConnectionPool;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateLdapConnectionPoolExtension
implements BeforeAllCallback,
AfterAllCallback {
    private static final Logger LOG = LoggerFactory.getLogger(CreateLdapConnectionPoolExtension.class);
    private static final String LDAP_CONNECTION_TEMPLATE = "ldapConnectionTemplate";
    private static final String LDAP_CONNECTION_FACTORY = "ldapConnectionFactory";
    private static final String LDAP_CONNECTION_POOL = "ldapConnectionPool";
    private LdapConnectionFactory ldapConnectionFactory;

    private void setLdapConnectionTemplate(ExtensionContext context, LdapConnectionTemplate ldapConnectionTemplate) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class testClass = (Class)context.getTestClass().get();
        try {
            Field field = testClass.getField(LDAP_CONNECTION_TEMPLATE);
            field.set(null, ldapConnectionTemplate);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private void setLdapConnectionPool(ExtensionContext context, LdapConnectionPool ldapConnectionPool) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class testClass = (Class)context.getTestClass().get();
        try {
            Field field = testClass.getField(LDAP_CONNECTION_POOL);
            field.set(null, ldapConnectionPool);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private void setLdapConnectionFactory(ExtensionContext context, LdapConnectionFactory ldapConnectionFactory) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class testClass = (Class)context.getTestClass().get();
        try {
            Field field = testClass.getField(LDAP_CONNECTION_FACTORY);
            field.set(null, ldapConnectionFactory);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private LdapServer getLdapServer(ExtensionContext context) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Class testClass = (Class)context.getTestClass().get();
        Field field = testClass.getField("classLdapServer");
        if (field != null) {
            return (LdapServer)field.get(testClass);
        }
        return null;
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        AnnotatedElement annotations = (AnnotatedElement)context.getTestClass().get();
        CreateLdapConnectionPool createLdapConnectionPool = annotations.getAnnotation(CreateLdapConnectionPool.class);
        LdapServer ldapServer = this.getLdapServer(context);
        if (createLdapConnectionPool != null) {
            LOG.trace("Creating connection pool to new ldap server");
            Class factoryClass = createLdapConnectionPool.factoryClass();
            Class connectionFactoryClass = createLdapConnectionPool.connectionFactoryClass();
            Class validatorClass = createLdapConnectionPool.validatorClass();
            LdapConnectionPool ldapConnectionPool = this.createLdapConnectionPool(createLdapConnectionPool, ldapServer, factoryClass, connectionFactoryClass, validatorClass);
            LdapConnectionTemplate ldapConnectionTemplate = new LdapConnectionTemplate(ldapConnectionPool);
            this.setLdapConnectionTemplate(context, ldapConnectionTemplate);
            this.setLdapConnectionFactory(context, this.ldapConnectionFactory);
            this.setLdapConnectionPool(context, ldapConnectionPool);
        }
    }

    private LdapConnectionPool createLdapConnectionPool(CreateLdapConnectionPool createLdapConnectionPool, LdapServer ldapServer, Class<? extends PooledObjectFactory<LdapConnection>> factoryClass, Class<? extends LdapConnectionFactory> connectionFactoryClass, Class<? extends LdapConnectionValidator> validatorClass) {
        PooledObjectFactory poolableLdapConnectionFactory;
        Constructor<? extends LdapConnectionFactory> constructor;
        LdapConnectionConfig config = new LdapConnectionConfig();
        config.setLdapHost(Network.LOOPBACK_HOSTNAME);
        config.setLdapPort(ldapServer.getPort());
        config.setName("uid=admin,ou=system");
        config.setCredentials("secret");
        if (createLdapConnectionPool.additionalBinaryAttributes() != null && createLdapConnectionPool.additionalBinaryAttributes().length > 0) {
            DefaultConfigurableBinaryAttributeDetector binaryAttributeDetector = new DefaultConfigurableBinaryAttributeDetector();
            binaryAttributeDetector.addBinaryAttribute(createLdapConnectionPool.additionalBinaryAttributes());
            config.setBinaryAttributeDetector((BinaryAttributeDetector)binaryAttributeDetector);
        }
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setLifo(createLdapConnectionPool.lifo());
        poolConfig.setMaxTotal(createLdapConnectionPool.maxActive());
        poolConfig.setMaxIdle(createLdapConnectionPool.maxIdle());
        poolConfig.setMaxWaitMillis(createLdapConnectionPool.maxWait());
        poolConfig.setMinEvictableIdleTimeMillis(createLdapConnectionPool.minEvictableIdleTimeMillis());
        poolConfig.setMinIdle(createLdapConnectionPool.minIdle());
        poolConfig.setNumTestsPerEvictionRun(createLdapConnectionPool.numTestsPerEvictionRun());
        poolConfig.setSoftMinEvictableIdleTimeMillis(createLdapConnectionPool.softMinEvictableIdleTimeMillis());
        poolConfig.setTestOnBorrow(createLdapConnectionPool.testOnBorrow());
        poolConfig.setTestOnReturn(createLdapConnectionPool.testOnReturn());
        poolConfig.setTestWhileIdle(createLdapConnectionPool.testWhileIdle());
        poolConfig.setTimeBetweenEvictionRunsMillis(createLdapConnectionPool.timeBetweenEvictionRunsMillis());
        poolConfig.setBlockWhenExhausted(createLdapConnectionPool.whenExhaustedAction() == 1);
        try {
            constructor = connectionFactoryClass.getConstructor(LdapConnectionConfig.class);
            this.ldapConnectionFactory = constructor.newInstance(config);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid connectionFactoryClass " + connectionFactoryClass.getName() + ": " + e.getMessage(), e);
        }
        try {
            Method timeoutSetter = connectionFactoryClass.getMethod("setTimeOut", Long.TYPE);
            if (timeoutSetter != null) {
                timeoutSetter.invoke((Object)this.ldapConnectionFactory, createLdapConnectionPool.timeout());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid connectionFactoryClass " + connectionFactoryClass.getName() + ", missing setTimeOut(long): " + e.getMessage(), e);
        }
        try {
            constructor = factoryClass.getConstructor(LdapConnectionFactory.class);
            poolableLdapConnectionFactory = (PooledObjectFactory)constructor.newInstance(this.ldapConnectionFactory);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid factoryClass " + factoryClass.getName() + ": " + e.getMessage(), e);
        }
        try {
            Method setValidator = factoryClass.getMethod("setValidator", LdapConnectionValidator.class);
            if (setValidator != null) {
                setValidator.invoke((Object)poolableLdapConnectionFactory, validatorClass.newInstance());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid connectionFactoryClass " + connectionFactoryClass.getName() + ", missing setTimeOut(long): " + e.getMessage(), e);
        }
        return new LdapConnectionPool(poolableLdapConnectionFactory, poolConfig);
    }

    public void afterAll(ExtensionContext context) throws Exception {
    }
}

