/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.sasl;

import javax.security.sasl.SaslServer;
import org.apache.directory.api.ldap.codec.api.SaslFilter;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.sasl.MechanismHandler;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMechanismHandler
implements MechanismHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMechanismHandler.class);

    protected void insertSaslFilter(LdapSession ldapSession) {
        LOG.debug("Inserting SaslFilter to engage negotiated security layer.");
        IoSession ioSession = ldapSession.getIoSession();
        IoFilterChain chain = ioSession.getFilterChain();
        if (!chain.contains("SASL_FILTER")) {
            SaslServer saslServer = (SaslServer)ldapSession.getSaslProperty("saslServer");
            chain.addBefore("codec", "SASL_FILTER", (IoFilter)new SaslFilter(saslServer));
        }
        ioSession.setAttribute((Object)SaslFilter.DISABLE_SECURITY_LAYER_ONCE, (Object)Boolean.TRUE);
    }
}

