/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import org.apache.directory.server.core.avltree.Marshaller;
import org.apache.directory.server.core.partition.impl.btree.jdbm.BTreeRedirect;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.asn1.codec.binary.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTreeRedirectMarshaller
implements Marshaller<BTreeRedirect> {
    static final int SIZE = 9;
    public static final BTreeRedirectMarshaller INSTANCE = new BTreeRedirectMarshaller();

    public final byte[] serialize(BTreeRedirect redirect) throws IOException {
        byte[] bites = new byte[]{1, (byte)(redirect.recId >> 56), (byte)(redirect.recId >> 48), (byte)(redirect.recId >> 40), (byte)(redirect.recId >> 32), (byte)(redirect.recId >> 24), (byte)(redirect.recId >> 16), (byte)(redirect.recId >> 8), (byte)redirect.recId};
        return bites;
    }

    public final BTreeRedirect deserialize(byte[] bites) throws IOException {
        if (bites == null || bites.length != 9 || bites[0] != 1) {
            if (bites != null) {
                throw new IOException(I18n.err((String)I18n.ERR_568, (Object[])new Object[]{new String(Hex.encodeHex((byte[])bites))}));
            }
            throw new IOException(I18n.err((String)I18n.ERR_569, (Object[])new Object[0]));
        }
        long recId = bites[1] + (bites[1] < 0 ? 256 : 0);
        recId <<= 8;
        recId += (long)(bites[2] + (bites[2] < 0 ? 256 : 0));
        recId <<= 8;
        recId += (long)(bites[3] + (bites[3] < 0 ? 256 : 0));
        recId <<= 8;
        recId += (long)(bites[4] + (bites[4] < 0 ? 256 : 0));
        recId <<= 8;
        recId += (long)(bites[5] + (bites[5] < 0 ? 256 : 0));
        recId <<= 8;
        recId += (long)(bites[6] + (bites[6] < 0 ? 256 : 0));
        recId <<= 8;
        recId += (long)(bites[7] + (bites[7] < 0 ? 256 : 0));
        recId <<= 8;
        return new BTreeRedirect(recId += (long)(bites[8] + (bites[8] < 0 ? 256 : 0)));
    }

    public static boolean isRedirect(byte[] bites) {
        return bites != null && bites.length == 9 && bites[0] == 1;
    }
}

