/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authn;

import java.net.SocketAddress;
import org.apache.directory.api.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.api.ldap.model.exception.LdapNoPermissionException;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.interceptor.context.BindOperationContext;
import org.apache.directory.server.core.authn.AbstractAuthenticator;
import org.apache.directory.server.i18n.I18n;
import org.apache.mina.core.session.IoSession;

public class AnonymousAuthenticator
extends AbstractAuthenticator {
    public AnonymousAuthenticator() {
        super(AuthenticationLevel.NONE);
    }

    @Override
    public LdapPrincipal authenticate(BindOperationContext bindContext) throws LdapNoPermissionException {
        if (this.getDirectoryService().isAllowAnonymousAccess()) {
            LOG.info("Authentication as anonymous");
            LdapPrincipal principal = this.getDirectoryService().getAdminSession().getAnonymousPrincipal();
            IoSession session = bindContext.getIoSession();
            if (session != null) {
                SocketAddress clientAddress = session.getRemoteAddress();
                principal.setClientAddress(clientAddress);
                SocketAddress serverAddress = session.getServiceAddress();
                principal.setServerAddress(serverAddress);
            }
            return principal;
        }
        LOG.info("Cannot authenticate as anonymous, the server does not allow it");
        throw new LdapNoPermissionException(I18n.err((I18n)I18n.ERR_228, (Object[])new Object[0]));
    }
}

