/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.ApproximateNode;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.GreaterEqNode;
import org.apache.directory.api.ldap.model.filter.LessEqNode;
import org.apache.directory.api.ldap.model.filter.NotNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.filter.ScopeNode;
import org.apache.directory.api.ldap.model.filter.SubstringNode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.normalizers.NoOpNormalizer;
import org.apache.directory.api.util.exception.NotImplementedException;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.SingletonIndexCursor;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.PartitionSearchResult;
import org.apache.directory.server.xdbm.search.cursor.ApproximateCursor;
import org.apache.directory.server.xdbm.search.cursor.ChildrenCursor;
import org.apache.directory.server.xdbm.search.cursor.DescendantCursor;
import org.apache.directory.server.xdbm.search.evaluator.ApproximateEvaluator;
import org.apache.directory.server.xdbm.search.impl.EvaluatorBuilder;

public class CursorBuilder {
    private Store db = null;
    private EvaluatorBuilder evaluatorBuilder;

    public CursorBuilder(Store db, EvaluatorBuilder evaluatorBuilder) {
        this.db = db;
        this.evaluatorBuilder = evaluatorBuilder;
    }

    public <T> long build(ExprNode node, PartitionSearchResult searchResult) throws Exception {
        Object count = node.get("count");
        if (count != null && (Long)count == 0L) {
            return 0L;
        }
        switch (node.getAssertionType()) {
            case APPROXIMATE: {
                return this.computeApproximate((ApproximateNode)node, searchResult);
            }
            case EQUALITY: {
                return this.computeEquality((EqualityNode)node, searchResult);
            }
            case GREATEREQ: {
                return this.computeGreaterEq((GreaterEqNode)node, searchResult);
            }
            case LESSEQ: {
                return this.computeLessEq((LessEqNode)node, searchResult);
            }
            case PRESENCE: {
                return this.computePresence((PresenceNode)node, searchResult);
            }
            case SCOPE: {
                if (((ScopeNode)node).getScope() == SearchScope.ONELEVEL) {
                    return this.computeOneLevelScope((ScopeNode)node, searchResult);
                }
                return this.computeSubLevelScope((ScopeNode)node, searchResult);
            }
            case SUBSTRING: {
                return this.computeSubstring((SubstringNode)node, searchResult);
            }
            case AND: {
                return this.computeAnd((AndNode)node, searchResult);
            }
            case NOT: {
                return this.computeNot((NotNode)node, searchResult);
            }
            case OR: {
                return this.computeOr((OrNode)node, searchResult);
            }
            case ASSERTION: 
            case EXTENSIBLE: {
                throw new NotImplementedException();
            }
        }
        throw new IllegalStateException(I18n.err(I18n.ERR_260, new Object[]{node.getAssertionType()}));
    }

    private <T> long computeApproximate(ApproximateNode<T> node, PartitionSearchResult searchResult) throws Exception {
        ApproximateCursor cursor = new ApproximateCursor(this.db, (ApproximateEvaluator)this.evaluatorBuilder.build(node));
        int nbResults = 0;
        Set<String> uuidSet = searchResult.getCandidateSet();
        while (cursor.next()) {
            Object indexEntry = cursor.get();
            String uuid = (String)((IndexEntry)indexEntry).getId();
            if (uuidSet.contains(uuid)) continue;
            uuidSet.add(uuid);
            ++nbResults;
        }
        cursor.close();
        return nbResults;
    }

    private <T> long computeEquality(EqualityNode<T> node, PartitionSearchResult searchResult) throws Exception {
        Cursor<IndexEntry<?, String>> userIdxCursor;
        Set thisCandidates = (Set)node.get("candidates");
        if (thisCandidates != null) {
            Set<String> candidates = searchResult.getCandidateSet();
            for (String candidate : thisCandidates) {
                candidates.add(candidate);
            }
            return thisCandidates.size();
        }
        AttributeType attributeType = node.getAttributeType();
        Value value = node.getValue();
        int nbResults = 0;
        if (this.db.hasIndexOn(attributeType)) {
            Index<?, String> userIndex = this.db.getIndex(attributeType);
            userIdxCursor = userIndex.forwardCursor(value.getValue());
            Set<String> uuidSet = searchResult.getCandidateSet();
            while (userIdxCursor.next()) {
                IndexEntry<?, String> indexEntry = userIdxCursor.get();
                String uuid = indexEntry.getId();
                if (uuidSet.contains(uuid)) continue;
                uuidSet.add(uuid);
                ++nbResults;
            }
        } else {
            return Long.MAX_VALUE;
        }
        userIdxCursor.close();
        return nbResults;
    }

    private <T> long computeGreaterEq(GreaterEqNode<T> node, PartitionSearchResult searchResult) throws Exception {
        Cursor<IndexEntry<?, String>> userIdxCursor;
        AttributeType attributeType = node.getAttributeType();
        Value value = node.getValue();
        int nbResults = 0;
        if (this.db.hasIndexOn(attributeType)) {
            Index<?, String> userIndex = this.db.getIndex(attributeType);
            userIdxCursor = userIndex.forwardCursor();
            IndexEntry<Object, Object> indexEntry = new IndexEntry();
            indexEntry.setKey(value.getValue());
            userIdxCursor.before(indexEntry);
            Set<String> uuidSet = searchResult.getCandidateSet();
            while (userIdxCursor.next()) {
                indexEntry = userIdxCursor.get();
                String uuid = (String)indexEntry.getId();
                if (uuidSet.contains(uuid)) continue;
                uuidSet.add(uuid);
                ++nbResults;
            }
        } else {
            return Long.MAX_VALUE;
        }
        userIdxCursor.close();
        return nbResults;
    }

    private <T> long computeLessEq(LessEqNode<T> node, PartitionSearchResult searchResult) throws Exception {
        Cursor<IndexEntry<?, String>> userIdxCursor;
        AttributeType attributeType = node.getAttributeType();
        Value value = node.getValue();
        int nbResults = 0;
        if (this.db.hasIndexOn(attributeType)) {
            Index<?, String> userIndex = this.db.getIndex(attributeType);
            userIdxCursor = userIndex.forwardCursor();
            IndexEntry<Object, Object> indexEntry = new IndexEntry();
            indexEntry.setKey(value.getValue());
            userIdxCursor.after(indexEntry);
            Set<String> uuidSet = searchResult.getCandidateSet();
            while (userIdxCursor.previous()) {
                indexEntry = userIdxCursor.get();
                String uuid = (String)indexEntry.getId();
                if (uuidSet.contains(uuid)) continue;
                uuidSet.add(uuid);
                ++nbResults;
            }
        } else {
            return Long.MAX_VALUE;
        }
        userIdxCursor.close();
        return nbResults;
    }

    private <T> long computePresence(PresenceNode node, PartitionSearchResult searchResult) throws Exception {
        Cursor<IndexEntry<String, String>> presenceCursor;
        AttributeType attributeType = node.getAttributeType();
        int nbResults = 0;
        if (this.db.hasIndexOn(attributeType)) {
            presenceCursor = this.db.getPresenceIndex().forwardCursor(attributeType.getOid());
            IndexEntry<Object, Object> indexEntry = new IndexEntry();
            Set<String> uuidSet = searchResult.getCandidateSet();
            while (presenceCursor.next()) {
                indexEntry = presenceCursor.get();
                String uuid = (String)indexEntry.getId();
                if (uuidSet.contains(uuid)) continue;
                uuidSet.add(uuid);
                ++nbResults;
            }
        } else {
            return Long.MAX_VALUE;
        }
        presenceCursor.close();
        return nbResults;
    }

    private long computeOneLevelScope(ScopeNode node, PartitionSearchResult searchResult) throws Exception {
        int nbResults = 0;
        Cursor<IndexEntry<ParentIdAndRdn, String>> rdnCursor = this.db.getRdnIndex().forwardCursor();
        IndexEntry startingPos = new IndexEntry();
        startingPos.setKey(new ParentIdAndRdn(node.getBaseId(), (Rdn[])null));
        rdnCursor.before(startingPos);
        ChildrenCursor scopeCursor = new ChildrenCursor(this.db, node.getBaseId(), rdnCursor);
        Set<String> candidateSet = searchResult.getCandidateSet();
        while (scopeCursor.next()) {
            IndexEntry indexEntry = (IndexEntry)scopeCursor.get();
            String uuid = (String)indexEntry.getId();
            if (searchResult.isDerefAlways() || searchResult.isDerefInSearching()) {
                Dn aliasedDn = this.db.getAliasIndex().reverseLookup(uuid);
                if (aliasedDn != null) {
                    aliasedDn.apply(this.evaluatorBuilder.getSchemaManager());
                    String aliasedId = this.db.getEntryId(aliasedDn);
                    if (candidateSet.contains(aliasedId)) continue;
                    candidateSet.add(aliasedId);
                    ++nbResults;
                    continue;
                }
                if (candidateSet.contains(uuid)) continue;
                candidateSet.add(uuid);
                ++nbResults;
                continue;
            }
            if (candidateSet.contains(uuid)) continue;
            candidateSet.add(uuid);
            ++nbResults;
        }
        scopeCursor.close();
        return nbResults;
    }

    private long computeSubLevelScope(ScopeNode node, PartitionSearchResult searchResult) throws Exception {
        String contextEntryId = this.db.getEntryId(((Partition)((Object)this.db)).getSuffixDn());
        if (node.getBaseId() == contextEntryId) {
            return Long.MAX_VALUE;
        }
        int nbResults = 0;
        String baseId = node.getBaseId();
        ParentIdAndRdn parentIdAndRdn = this.db.getRdnIndex().reverseLookup(baseId);
        IndexEntry<ParentIdAndRdn, String> startingPos = new IndexEntry<ParentIdAndRdn, String>();
        startingPos.setKey(parentIdAndRdn);
        startingPos.setId(baseId);
        SingletonIndexCursor<ParentIdAndRdn> rdnCursor = new SingletonIndexCursor<ParentIdAndRdn>(startingPos);
        String parentId = parentIdAndRdn.getParentId();
        DescendantCursor scopeCursor = new DescendantCursor(this.db, baseId, parentId, rdnCursor);
        Set<String> candidateSet = searchResult.getCandidateSet();
        while (scopeCursor.next()) {
            IndexEntry indexEntry = (IndexEntry)scopeCursor.get();
            String uuid = (String)indexEntry.getId();
            if (searchResult.isDerefAlways() || searchResult.isDerefInSearching()) {
                Dn aliasedDn = this.db.getAliasIndex().reverseLookup(uuid);
                if (aliasedDn != null) {
                    aliasedDn.apply(this.evaluatorBuilder.getSchemaManager());
                    String aliasedId = this.db.getEntryId(aliasedDn);
                    if (candidateSet.contains(aliasedId)) continue;
                    candidateSet.add(aliasedId);
                    ++nbResults;
                    ScopeNode newScopeNode = new ScopeNode(node.getDerefAliases(), aliasedDn, aliasedId, node.getScope());
                    nbResults = (int)((long)nbResults + this.computeSubLevelScope(newScopeNode, searchResult));
                    continue;
                }
                if (candidateSet.contains(uuid)) continue;
                candidateSet.add(uuid);
                ++nbResults;
                continue;
            }
            if (candidateSet.contains(uuid)) continue;
            candidateSet.add(uuid);
            ++nbResults;
        }
        scopeCursor.close();
        return nbResults;
    }

    private long computeSubstring(SubstringNode node, PartitionSearchResult searchResult) throws Exception {
        AttributeType attributeType = node.getAttributeType();
        if (this.db.hasIndexOn(attributeType)) {
            Index<?, String> userIndex = this.db.getIndex(attributeType);
            Cursor<IndexEntry<?, String>> cursor = userIndex.forwardCursor();
            IndexEntry<String, Object> indexEntry = new IndexEntry();
            indexEntry.setKey(node.getInitial());
            cursor.before(indexEntry);
            int nbResults = 0;
            MatchingRule rule = attributeType.getSubstring();
            if (rule == null) {
                rule = attributeType.getEquality();
            }
            Normalizer normalizer = rule != null ? rule.getNormalizer() : new NoOpNormalizer(attributeType.getSyntaxOid());
            Pattern regexp = attributeType.getSyntax().isHumanReadable() ? node.getRegex(normalizer) : null;
            Set<String> uuidSet = searchResult.getCandidateSet();
            while (cursor.next()) {
                indexEntry = cursor.get();
                String key = (String)indexEntry.getKey();
                if (!regexp.matcher(key).matches()) {
                    cursor.close();
                    return nbResults;
                }
                String uuid = (String)indexEntry.getId();
                if (uuidSet.contains(uuid)) continue;
                uuidSet.add(uuid);
                ++nbResults;
            }
            cursor.close();
            return nbResults;
        }
        return Long.MAX_VALUE;
    }

    private <T> long computeOr(OrNode node, PartitionSearchResult searchResult) throws Exception {
        List<ExprNode> children = node.getChildren();
        long nbOrResults = 0L;
        for (ExprNode child : children) {
            long nbResults;
            Object count = child.get("count");
            if (count != null && (Long)count == 0L) {
                long countLong = (Long)count;
                if (countLong == 0L) continue;
                if (countLong == Long.MAX_VALUE) {
                    return countLong;
                }
            }
            if ((nbResults = this.build(child, searchResult)) == Long.MAX_VALUE) {
                return nbResults;
            }
            nbOrResults += nbResults;
        }
        return nbOrResults;
    }

    private long computeAnd(AndNode node, PartitionSearchResult searchResult) throws Exception {
        int minIndex = 0;
        long minValue = Long.MAX_VALUE;
        long value = Long.MAX_VALUE;
        List<ExprNode> children = node.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            ExprNode child = children.get(i);
            Object count = child.get("count");
            if (count == null) continue;
            value = (Long)count;
            if (value == 0L) {
                return 0L;
            }
            if (value >= minValue) continue;
            minValue = value;
            minIndex = i;
        }
        ExprNode minChild = children.get(minIndex);
        long nbResults = this.build(minChild, searchResult);
        return nbResults;
    }

    private long computeNot(NotNode node, PartitionSearchResult searchResult) throws Exception {
        List<ExprNode> children = node.getChildren();
        ExprNode child = children.get(0);
        Object count = child.get("count");
        if (count == null) {
            return Long.MAX_VALUE;
        }
        long value = (Long)count;
        if (value == Long.MAX_VALUE) {
            return 0L;
        }
        return Long.MAX_VALUE;
    }
}

