/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.shared;

import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.DitContentRule;
import org.apache.directory.api.ldap.model.schema.DitStructureRule;
import org.apache.directory.api.ldap.model.schema.LdapComparator;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MatchingRuleUse;
import org.apache.directory.api.ldap.model.schema.NameForm;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.SchemaObjectRenderer;
import org.apache.directory.api.ldap.model.schema.SchemaUtils;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.ldap.model.schema.registries.NormalizerRegistry;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.interceptor.context.FilteringOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;

public class SchemaService {
    private static Entry schemaSubentry;
    private static Object schemaSubentrLock;

    private static Attribute generateComparators(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.lookupAttributeTypeRegistry("comparators"));
        for (LdapComparator comparator : schemaManager.getComparatorRegistry()) {
            attr.add(SchemaUtils.render(comparator));
        }
        return attr;
    }

    private static Attribute generateNormalizers(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("normalizers"));
        NormalizerRegistry nr = schemaManager.getNormalizerRegistry();
        for (Normalizer normalizer : nr) {
            attr.add(SchemaUtils.render(normalizer));
        }
        return attr;
    }

    private static Attribute generateSyntaxCheckers(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("syntaxCheckers"));
        for (SyntaxChecker syntaxChecker : schemaManager.getSyntaxCheckerRegistry()) {
            attr.add(SchemaUtils.render(syntaxChecker));
        }
        return attr;
    }

    private static Attribute generateObjectClasses(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("objectClasses"));
        for (ObjectClass objectClass : schemaManager.getObjectClassRegistry()) {
            attr.add(SchemaObjectRenderer.SUBSCHEMA_SUBENTRY_RENDERER.render(objectClass));
        }
        return attr;
    }

    private static Attribute generateAttributeTypes(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("attributeTypes"));
        for (AttributeType attributeType : schemaManager.getAttributeTypeRegistry()) {
            attr.add(SchemaObjectRenderer.SUBSCHEMA_SUBENTRY_RENDERER.render(attributeType));
        }
        return attr;
    }

    private static Attribute generateMatchingRules(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("matchingRules"));
        for (MatchingRule matchingRule : schemaManager.getMatchingRuleRegistry()) {
            attr.add(SchemaObjectRenderer.SUBSCHEMA_SUBENTRY_RENDERER.render(matchingRule));
        }
        return attr;
    }

    private static Attribute generateMatchingRuleUses(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("matchingRuleUse"));
        for (MatchingRuleUse matchingRuleUse : schemaManager.getMatchingRuleUseRegistry()) {
            attr.add(SchemaObjectRenderer.SUBSCHEMA_SUBENTRY_RENDERER.render(matchingRuleUse));
        }
        return attr;
    }

    private static Attribute generateSyntaxes(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("ldapSyntaxes"));
        for (LdapSyntax syntax : schemaManager.getLdapSyntaxRegistry()) {
            attr.add(SchemaObjectRenderer.SUBSCHEMA_SUBENTRY_RENDERER.render(syntax));
        }
        return attr;
    }

    private static Attribute generateDitContextRules(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("ditContentRules"));
        for (DitContentRule ditContentRule : schemaManager.getDITContentRuleRegistry()) {
            attr.add(SchemaObjectRenderer.SUBSCHEMA_SUBENTRY_RENDERER.render(ditContentRule));
        }
        return attr;
    }

    private static Attribute generateDitStructureRules(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("ditStructureRules"));
        for (DitStructureRule ditStructureRule : schemaManager.getDITStructureRuleRegistry()) {
            attr.add(SchemaObjectRenderer.SUBSCHEMA_SUBENTRY_RENDERER.render(ditStructureRule));
        }
        return attr;
    }

    private static Attribute generateNameForms(SchemaManager schemaManager) throws LdapException {
        DefaultAttribute attr = new DefaultAttribute(schemaManager.getAttributeType("nameForms"));
        for (NameForm nameForm : schemaManager.getNameFormRegistry()) {
            attr.add(SchemaObjectRenderer.SUBSCHEMA_SUBENTRY_RENDERER.render(nameForm));
        }
        return attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateSchemaSubentry(SchemaManager schemaManager, Entry mods) throws LdapException {
        DefaultEntry attrs = new DefaultEntry(schemaManager, mods.getDn());
        attrs.put("objectClass", "top", "subschema", "subentry", "apacheSubschema");
        attrs.put("cn", "schema");
        attrs.put(SchemaService.generateComparators(schemaManager));
        attrs.put(SchemaService.generateNormalizers(schemaManager));
        attrs.put(SchemaService.generateSyntaxCheckers(schemaManager));
        attrs.put(SchemaService.generateObjectClasses(schemaManager));
        attrs.put(SchemaService.generateAttributeTypes(schemaManager));
        attrs.put(SchemaService.generateMatchingRules(schemaManager));
        attrs.put(SchemaService.generateMatchingRuleUses(schemaManager));
        attrs.put(SchemaService.generateSyntaxes(schemaManager));
        attrs.put(SchemaService.generateDitContextRules(schemaManager));
        attrs.put(SchemaService.generateDitStructureRules(schemaManager));
        attrs.put(SchemaService.generateNameForms(schemaManager));
        attrs.put("subtreeSpecification", "{}");
        Attribute createTimestamp = mods.get("createTimestamp");
        attrs.put("createTimestamp", createTimestamp.get());
        attrs.put("creatorsName", "uid=admin,ou=system");
        Attribute schemaModifyTimestamp = mods.get("schemaModifyTimestamp");
        attrs.put("modifyTimestamp", schemaModifyTimestamp.get());
        Attribute schemaModifiersName = mods.get("schemaModifiersName");
        attrs.put("modifiersName", schemaModifiersName.get());
        Object object = schemaSubentrLock;
        synchronized (object) {
            schemaSubentry = attrs;
        }
    }

    private static void addAttribute(Entry attrs, String id) throws LdapException {
        Attribute attr = schemaSubentry.get(id);
        if (attr != null && attr.size() > 0) {
            attrs.put(attr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Entry getSubschemaEntryImmutable(DirectoryService directoryService) throws LdapException {
        Object object = schemaSubentrLock;
        synchronized (object) {
            if (schemaSubentry == null) {
                Dn schemaModificationAttributesDn = new Dn(directoryService.getSchemaManager(), "ou=schemaModifications,ou=schema");
                SchemaService.generateSchemaSubentry(directoryService.getSchemaManager(), directoryService.getSchemaPartition().lookup(new LookupOperationContext(null, schemaModificationAttributesDn)));
            }
            return schemaSubentry.clone();
        }
    }

    public static Entry getSubschemaEntryCloned(DirectoryService directoryService) throws LdapException {
        if (schemaSubentry == null) {
            Dn schemaModificationAttributesDn = new Dn(directoryService.getSchemaManager(), "ou=schemaModifications,ou=schema");
            SchemaService.generateSchemaSubentry(directoryService.getSchemaManager(), directoryService.getSchemaPartition().lookup(new LookupOperationContext(null, schemaModificationAttributesDn)));
        }
        return schemaSubentry.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Entry getSubschemaEntry(DirectoryService directoryService, FilteringOperationContext operationContext) throws LdapException {
        SchemaManager schemaManager = directoryService.getSchemaManager();
        DefaultEntry attrs = new DefaultEntry(schemaManager, Dn.ROOT_DSE);
        Object object = schemaSubentrLock;
        synchronized (object) {
            Dn schemaModificationAttributesDn = new Dn(directoryService.getSchemaManager(), "ou=schemaModifications,ou=schema");
            Entry mods = directoryService.getSchemaPartition().lookup(new LookupOperationContext(null, schemaModificationAttributesDn, SchemaConstants.ALL_ATTRIBUTES_ARRAY));
            SchemaService.generateSchemaSubentry(schemaManager, mods);
            SchemaService.addAttribute(attrs, "comparators");
            SchemaService.addAttribute(attrs, "normalizers");
            SchemaService.addAttribute(attrs, "syntaxCheckers");
            SchemaService.addAttribute(attrs, "objectClasses");
            SchemaService.addAttribute(attrs, "attributeTypes");
            SchemaService.addAttribute(attrs, "matchingRules");
            SchemaService.addAttribute(attrs, "matchingRuleUse");
            SchemaService.addAttribute(attrs, "ldapSyntaxes");
            SchemaService.addAttribute(attrs, "ditContentRules");
            SchemaService.addAttribute(attrs, "ditStructureRules");
            SchemaService.addAttribute(attrs, "nameForms");
            SchemaService.addAttribute(attrs, "subtreeSpecification");
            SchemaService.addAttribute(attrs, "objectClass");
            SchemaService.addAttribute(attrs, "cn");
            SchemaService.addAttribute(attrs, "createTimestamp");
            SchemaService.addAttribute(attrs, "creatorsName");
            SchemaService.addAttribute(attrs, "modifyTimestamp");
            SchemaService.addAttribute(attrs, "modifiersName");
            SchemaService.addAttribute(attrs, "entryUUID");
            SchemaService.addAttribute(attrs, "entryDN");
        }
        ClonedServerEntry result = new ClonedServerEntry(attrs);
        return result;
    }

    static {
        schemaSubentrLock = new Object();
    }
}

