/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.mavibot;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.util.TupleReaderWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdifTupleReaderWriter
implements TupleReaderWriter<Dn, String> {
    private LdifReader reader = null;
    private static final Logger LOG = LoggerFactory.getLogger(LdifTupleReaderWriter.class);

    @Override
    public Tuple<Dn, String> readSortedTuple(DataInputStream in) {
        try {
            if (in.available() > 0) {
                Tuple<Dn, String> t = new Tuple<Dn, String>();
                t.setKey(new Dn(in.readUTF()));
                t.setValue(in.readUTF());
                return t;
            }
        }
        catch (Exception e) {
            LOG.error("Failed to read a sorted tuple", e);
        }
        return null;
    }

    @Override
    public Tuple<Dn, String> readUnsortedTuple(DataInputStream in) {
        try {
            if (this.reader == null) {
                this.reader = new LdifReader(in);
            }
        }
        catch (Exception e) {
            String msg = "Failed to open the LDIF input stream";
            LOG.error(msg, e);
            throw new RuntimeException(msg, e);
        }
        Tuple<Dn, String> t = null;
        if (this.reader.hasNext()) {
            LdifEntry ldifEntry = this.reader.next();
            if (ldifEntry == null) {
                throw new IllegalStateException("Received null entry while parsing, check the LDIF file for possible incorrect/corrupted entries");
            }
            t = new Tuple<Dn, String>();
            t.setKey(ldifEntry.getDn());
            t.setValue(ldifEntry.getOffset() + ":" + ldifEntry.getLengthBeforeParsing());
        }
        return t;
    }

    @Override
    public void storeSortedTuple(Tuple<Dn, String> t, DataOutputStream out) throws IOException {
        out.writeUTF(t.getKey().getName());
        out.writeUTF(t.getValue());
    }
}

