/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.integ;

import java.lang.reflect.Method;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.directory.server.annotations.CreateKdcServer;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.changelog.ChangeLog;
import org.apache.directory.server.core.factory.DSAnnotationProcessor;
import org.apache.directory.server.core.factory.DefaultDirectoryServiceFactory;
import org.apache.directory.server.core.factory.DirectoryServiceFactory;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.ldap.LdapServer;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameworkRunner
extends BlockJUnit4ClassRunner {
    private static final Logger LOG = LoggerFactory.getLogger(FrameworkRunner.class);
    private static final String SET_SERVICE_METHOD_NAME = "setService";
    private static final String SET_LDAP_SERVER_METHOD_NAME = "setLdapServer";
    private static final String SET_KDC_SERVER_METHOD_NAME = "setKdcServer";
    private DirectoryService classDS;
    private LdapServer classLdapServer;
    private KdcServer classKdcServer;

    public FrameworkRunner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(RunNotifier notifier) {
        CreateLdapServer classLdapServerBuilder = (CreateLdapServer)this.getDescription().getAnnotation(CreateLdapServer.class);
        try {
            this.classDS = DSAnnotationProcessor.getDirectoryService(this.getDescription());
            long revision = 0L;
            DirectoryService directoryService = null;
            if (this.classDS != null) {
                directoryService = this.classDS;
                DSAnnotationProcessor.applyLdifs(this.getDescription(), this.classDS);
            } else {
                DirectoryServiceFactory dsf = (DirectoryServiceFactory)DefaultDirectoryServiceFactory.class.newInstance();
                directoryService = dsf.getDirectoryService();
                directoryService.getChangeLog().setEnabled(true);
                dsf.init("default" + UUID.randomUUID().toString());
                this.classDS = directoryService;
                DSAnnotationProcessor.loadSchemas(this.getDescription(), directoryService);
                DSAnnotationProcessor.applyLdifs(this.getDescription(), directoryService);
            }
            if (classLdapServerBuilder != null) {
                this.classLdapServer = ServerAnnotationProcessor.createLdapServer(this.getDescription(), directoryService);
            }
            if (this.classKdcServer == null) {
                int minPort = this.getMinPort();
                this.classKdcServer = ServerAnnotationProcessor.getKdcServer(this.getDescription(), directoryService, minPort + 1);
            }
            DirectoryServiceFactory dsFactory = (DirectoryServiceFactory)DefaultDirectoryServiceFactory.class.newInstance();
            PartitionFactory partitionFactory = dsFactory.getPartitionFactory();
            LOG.debug("Using partition factory {}", (Object)partitionFactory.getClass().getSimpleName());
            super.run(notifier);
            if (this.classLdapServer != null) {
                this.classLdapServer.stop();
            }
            if (this.classKdcServer != null) {
                this.classKdcServer.stop();
            }
            if (this.classDS != null) {
                LOG.debug("Shuting down DS for {}", (Object)this.classDS.getInstanceId());
                this.classDS.shutdown();
                FileUtils.deleteDirectory(this.classDS.getInstanceLayout().getInstanceDirectory());
            } else {
                this.revert(directoryService, revision);
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_181, this.getTestClass().getName()));
            LOG.error(e.getLocalizedMessage());
            notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)e));
        }
        finally {
            this.classDS = null;
            this.classLdapServer = null;
            this.classKdcServer = null;
        }
    }

    private int getMinPort() {
        int minPort = 0;
        return minPort;
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        LdapServer methodLdapServer = null;
        KdcServer methodKdcServer = null;
        if (method.getAnnotation(Ignore.class) != null) {
            Description description = this.describeChild(method);
            notifier.fireTestIgnored(description);
            return;
        }
        Description suiteDescription = null;
        Description classDescription = this.getDescription();
        Description methodDescription = this.describeChild(method);
        CreateLdapServer methodLdapServerBuilder = (CreateLdapServer)methodDescription.getAnnotation(CreateLdapServer.class);
        CreateKdcServer methodKdcServerBuilder = (CreateKdcServer)methodDescription.getAnnotation(CreateKdcServer.class);
        try {
            DirectoryService directoryService = null;
            long revision = 0L;
            DirectoryService methodDS = DSAnnotationProcessor.getDirectoryService(methodDescription);
            if (methodDS != null) {
                DSAnnotationProcessor.applyLdifs(suiteDescription, methodDS);
                DSAnnotationProcessor.applyLdifs(classDescription, methodDS);
                DSAnnotationProcessor.applyLdifs(methodDescription, methodDS);
                directoryService = methodDS;
            } else if (this.classDS != null) {
                directoryService = this.classDS;
                revision = this.getCurrentRevision(directoryService);
                DSAnnotationProcessor.applyLdifs(methodDescription, directoryService);
            } else if (this.classLdapServer != null) {
                directoryService = this.classLdapServer.getDirectoryService();
                revision = this.getCurrentRevision(directoryService);
                DSAnnotationProcessor.applyLdifs(methodDescription, directoryService);
            } else if (this.classKdcServer != null) {
                directoryService = this.classKdcServer.getDirectoryService();
                revision = this.getCurrentRevision(directoryService);
                DSAnnotationProcessor.applyLdifs(methodDescription, directoryService);
            }
            if (methodLdapServerBuilder != null) {
                methodLdapServer = ServerAnnotationProcessor.createLdapServer(methodDescription, directoryService);
            }
            if (methodKdcServerBuilder != null) {
                int minPort = this.getMinPort();
                methodKdcServer = ServerAnnotationProcessor.getKdcServer(methodDescription, directoryService, minPort + 1);
            }
            Method setService = null;
            try {
                setService = this.getTestClass().getJavaClass().getMethod(SET_SERVICE_METHOD_NAME, DirectoryService.class);
                setService.invoke((Object)this.getTestClass().getJavaClass(), directoryService);
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
            Method setLdapServer = null;
            try {
                setLdapServer = this.getTestClass().getJavaClass().getMethod(SET_LDAP_SERVER_METHOD_NAME, LdapServer.class);
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
            Method setKdcServer = null;
            try {
                setKdcServer = this.getTestClass().getJavaClass().getMethod(SET_KDC_SERVER_METHOD_NAME, KdcServer.class);
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
            DirectoryService oldLdapServerDirService = null;
            DirectoryService oldKdcServerDirService = null;
            if (methodLdapServer != null) {
                methodLdapServer.setDirectoryService(directoryService);
                setLdapServer.invoke((Object)this.getTestClass().getJavaClass(), methodLdapServer);
            } else if (this.classLdapServer != null) {
                oldLdapServerDirService = this.classLdapServer.getDirectoryService();
                this.classLdapServer.setDirectoryService(directoryService);
                setLdapServer.invoke((Object)this.getTestClass().getJavaClass(), this.classLdapServer);
            }
            if (methodKdcServer != null) {
                methodKdcServer.setDirectoryService(directoryService);
                setKdcServer.invoke((Object)this.getTestClass().getJavaClass(), methodKdcServer);
            } else if (this.classKdcServer != null) {
                oldKdcServerDirService = this.classKdcServer.getDirectoryService();
                this.classKdcServer.setDirectoryService(directoryService);
                setKdcServer.invoke((Object)this.getTestClass().getJavaClass(), this.classKdcServer);
            }
            super.runChild(method, notifier);
            if (methodLdapServer != null) {
                methodLdapServer.stop();
            }
            if (oldLdapServerDirService != null) {
                this.classLdapServer.setDirectoryService(oldLdapServerDirService);
            }
            if (oldKdcServerDirService != null) {
                this.classKdcServer.setDirectoryService(oldKdcServerDirService);
            }
            if (methodDS != null) {
                LOG.debug("Shuting down DS for {}", (Object)methodDS.getInstanceId());
                methodDS.shutdown();
                FileUtils.deleteDirectory(methodDS.getInstanceLayout().getInstanceDirectory());
            } else {
                this.revert(directoryService, revision);
            }
        }
        catch (Exception e) {
            LOG.error(I18n.err(I18n.ERR_182, method.getName()));
            LOG.error("", e);
            notifier.fireTestFailure(new Failure(this.getDescription(), (Throwable)e));
        }
    }

    private long getCurrentRevision(DirectoryService dirService) throws Exception {
        if (dirService != null && dirService.getChangeLog().isEnabled()) {
            long revision = dirService.getChangeLog().getCurrentRevision();
            LOG.debug("Create revision {}", (Object)revision);
            return revision;
        }
        return 0L;
    }

    private void revert(DirectoryService dirService, long revision) throws Exception {
        if (dirService == null) {
            return;
        }
        ChangeLog cl = dirService.getChangeLog();
        if (cl.isEnabled() && revision < cl.getCurrentRevision()) {
            LOG.debug("Revert revision {}", (Object)revision);
            dirService.revert(revision);
        }
    }
}

