/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.avltree.AvlSingletonOrOrderedSetCursor;
import org.apache.directory.server.core.avltree.SingletonOrOrderedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvlTreeMapNoDupsWrapperCursor<K, V>
extends AbstractCursor<Tuple<K, V>> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger(Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private final AvlSingletonOrOrderedSetCursor<K, V> wrapped;
    private final Tuple<K, V> returnedTuple = new Tuple();

    public AvlTreeMapNoDupsWrapperCursor(AvlSingletonOrOrderedSetCursor<K, V> wrapped) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating AvlTreeMapNoDupsWrapperCursor {}", (Object)this);
        }
        this.wrapped = wrapped;
    }

    public void afterKey(K key) throws Exception {
        this.wrapped.afterKey(key);
    }

    public void afterValue(K key, V value) throws Exception {
        throw new UnsupportedOperationException("This Cursor does not support duplicate keys.");
    }

    public void beforeKey(K key) throws Exception {
        this.wrapped.beforeKey(key);
    }

    public void beforeValue(K key, V value) throws Exception {
        throw new UnsupportedOperationException("This Cursor does not support duplicate keys.");
    }

    @Override
    public void after(Tuple<K, V> element) throws LdapException, CursorException {
        this.wrapped.afterKey(element.getKey());
    }

    @Override
    public void afterLast() throws LdapException, CursorException {
        this.wrapped.afterLast();
    }

    @Override
    public boolean available() {
        return this.wrapped.available();
    }

    @Override
    public void before(Tuple<K, V> element) throws LdapException, CursorException {
        this.wrapped.beforeKey(element.getKey());
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException {
        this.wrapped.beforeFirst();
    }

    @Override
    public boolean first() throws LdapException, CursorException {
        return this.wrapped.first();
    }

    @Override
    public Tuple<K, V> get() throws CursorException {
        if (this.wrapped.available()) {
            Object tuple = this.wrapped.get();
            if (((SingletonOrOrderedSet)((Tuple)tuple).getValue()).isOrderedSet()) {
                ((SingletonOrOrderedSet)((Tuple)tuple).getValue()).getOrderedSet().printTree();
            }
            this.returnedTuple.setBoth(((Tuple)tuple).getKey(), ((SingletonOrOrderedSet)((Tuple)tuple).getValue()).getSingleton());
            return this.returnedTuple;
        }
        throw new InvalidCursorPositionException();
    }

    @Override
    public boolean last() throws LdapException, CursorException {
        return this.wrapped.last();
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        return this.wrapped.next();
    }

    @Override
    public boolean previous() throws LdapException, CursorException {
        return this.wrapped.previous();
    }

    @Override
    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing AvlTreeMapNoDupsWrapperCursor {}", (Object)this);
        }
        this.wrapped.close();
    }

    @Override
    public void close(Exception reason) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing AvlTreeMapNoDupsWrapperCursor {}", (Object)this);
        }
        this.wrapped.close(reason);
    }
}

