/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Comparator;
import java.util.UUID;
import org.apache.directory.mavibot.btree.AbstractValueHolder;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeFactory;
import org.apache.directory.mavibot.btree.PersistedBTree;
import org.apache.directory.mavibot.btree.PersistedBTreeConfiguration;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.TupleCursor;
import org.apache.directory.mavibot.btree.ValueCursor;
import org.apache.directory.mavibot.btree.ValueHolder;
import org.apache.directory.mavibot.btree.exception.BTreeAlreadyCreatedException;
import org.apache.directory.mavibot.btree.exception.BTreeAlreadyManagedException;
import org.apache.directory.mavibot.btree.exception.BTreeCreationException;
import org.apache.directory.mavibot.btree.serializer.IntSerializer;
import org.apache.directory.mavibot.btree.serializer.LongSerializer;

class PersistedValueHolder<V>
extends AbstractValueHolder<V> {
    protected PersistedBTree<V, V> parentBtree;
    private byte[] raw;
    private boolean isDeserialized = false;
    private boolean isRawUpToDate = false;

    PersistedValueHolder(BTree<?, V> parentBtree, int nbValues, byte[] raw) {
        this.parentBtree = (PersistedBTree)parentBtree;
        this.valueSerializer = parentBtree.getValueSerializer();
        this.raw = raw;
        this.isRawUpToDate = true;
        this.valueThresholdUp = PersistedBTree.valueThresholdUp;
        this.valueThresholdLow = PersistedBTree.valueThresholdLow;
        if (nbValues <= this.valueThresholdUp) {
            this.valueArray = (Object[])Array.newInstance(this.valueSerializer.getType(), nbValues);
        }
    }

    PersistedValueHolder(BTree<?, V> parentBtree, V ... values) {
        this.parentBtree = (PersistedBTree)parentBtree;
        this.valueSerializer = parentBtree.getValueSerializer();
        this.valueThresholdUp = PersistedBTree.valueThresholdUp;
        this.valueThresholdLow = PersistedBTree.valueThresholdLow;
        if (values != null) {
            int nbValues = values.length;
            if (nbValues < PersistedBTree.valueThresholdUp) {
                this.valueArray = (Object[])Array.newInstance(this.valueSerializer.getType(), nbValues);
                try {
                    System.arraycopy(values, 0, this.valueArray, 0, values.length);
                }
                catch (ArrayStoreException ase) {
                    ase.printStackTrace();
                    throw ase;
                }
            } else {
                this.createSubTree();
                for (V value : values) {
                    try {
                        this.valueBtree.insert(value, value);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            this.valueArray = (Object[])Array.newInstance(this.valueSerializer.getType(), 0);
        }
        this.isDeserialized = true;
    }

    @Override
    public ValueCursor<V> getCursor() {
        this.checkAndDeserialize();
        return super.getCursor();
    }

    byte[] getRaw() {
        if (this.isRawUpToDate) {
            return this.raw;
        }
        if (this.isSubBtree()) {
            long btreeOffset = ((PersistedBTree)this.valueBtree).getBtreeOffset();
            this.raw = LongSerializer.serialize(btreeOffset);
        } else {
            byte[][] valueBytes = new byte[this.valueArray.length * 2][];
            int length = 0;
            int pos = 0;
            for (Object value : this.valueArray) {
                byte[] bytes = this.valueSerializer.serialize(value);
                length += bytes.length;
                byte[] sizeBytes = IntSerializer.serialize(bytes.length);
                length += sizeBytes.length;
                valueBytes[pos++] = sizeBytes;
                valueBytes[pos++] = bytes;
            }
            this.raw = new byte[length];
            pos = 0;
            for (byte[] bytes : valueBytes) {
                System.arraycopy(bytes, 0, this.raw, pos, bytes.length);
                pos += bytes.length;
            }
        }
        this.isRawUpToDate = true;
        return this.raw;
    }

    @Override
    public int size() {
        this.checkAndDeserialize();
        if (this.valueArray == null) {
            return (int)this.valueBtree.getNbElems();
        }
        return this.valueArray.length;
    }

    @Override
    protected void createSubTree() {
        try {
            PersistedBTreeConfiguration configuration = new PersistedBTreeConfiguration();
            configuration.setAllowDuplicates(false);
            configuration.setKeySerializer(this.valueSerializer);
            configuration.setName(UUID.randomUUID().toString());
            configuration.setValueSerializer(this.valueSerializer);
            configuration.setParentBTree(this.parentBtree);
            configuration.setSubBtree(true);
            this.valueBtree = BTreeFactory.createPersistedBTree(configuration);
            try {
                this.parentBtree.getRecordManager().manage(this.valueBtree, true);
                this.raw = null;
            }
            catch (BTreeAlreadyManagedException e) {
                throw new BTreeAlreadyCreatedException(e);
            }
        }
        catch (IOException e) {
            throw new BTreeCreationException(e);
        }
    }

    void setSubBtree(BTree<V, V> subBtree) {
        this.valueBtree = subBtree;
        this.raw = null;
        this.valueArray = null;
        this.isDeserialized = true;
        this.isRawUpToDate = false;
    }

    private void checkAndDeserialize() {
        if (!this.isDeserialized) {
            if (this.valueArray == null) {
                this.deserializeSubBtree();
            } else {
                this.deserializeArray();
            }
            this.isDeserialized = true;
        }
    }

    @Override
    public void add(V value) {
        this.checkAndDeserialize();
        super.add(value);
        this.isRawUpToDate = false;
        this.raw = null;
    }

    private V removeFromArray(V value) {
        this.checkAndDeserialize();
        int pos = this.findPos(value);
        if (pos < 0) {
            return null;
        }
        Object[] newValueArray = (Object[])Array.newInstance(this.valueSerializer.getType(), this.valueArray.length - 1);
        System.arraycopy(this.valueArray, 0, newValueArray, 0, pos);
        System.arraycopy(this.valueArray, pos + 1, newValueArray, pos, this.valueArray.length - pos - 1);
        Object removedValue = this.valueArray[pos];
        this.valueArray = newValueArray;
        return (V)removedValue;
    }

    private V removeFromBtree(V removedValue) {
        this.checkAndDeserialize();
        if (this.btreeContains(removedValue)) {
            try {
                if (this.valueBtree.getNbElems() - 1L < (long)PersistedBTree.valueThresholdLow) {
                    int nbValues = (int)(this.valueBtree.getNbElems() - 1L);
                    this.valueArray = (Object[])Array.newInstance(this.valueSerializer.getType(), nbValues);
                    TupleCursor cursor = this.valueBtree.browse();
                    V returnedValue = null;
                    int pos = 0;
                    while (cursor.hasNext()) {
                        Tuple tuple = cursor.next();
                        Object value = tuple.getKey();
                        if (this.valueSerializer.getComparator().compare(removedValue, value) == 0) {
                            returnedValue = (V)value;
                            continue;
                        }
                        this.valueArray[pos++] = value;
                    }
                    return returnedValue;
                }
                Tuple removedTuple = this.valueBtree.delete(removedValue);
                if (removedTuple != null) {
                    return removedTuple.getKey();
                }
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    @Override
    public V remove(V value) {
        V removedValue = null;
        removedValue = this.valueArray != null ? (V)this.removeFromArray(value) : (V)this.removeFromBtree(value);
        this.isRawUpToDate = false;
        this.raw = null;
        return removedValue;
    }

    @Override
    public boolean contains(V checkedValue) {
        this.checkAndDeserialize();
        return super.contains(checkedValue);
    }

    private int findPos(V value) {
        int result;
        if (this.valueArray.length == 0) {
            return -1;
        }
        int pivot = this.valueArray.length / 2;
        int low = 0;
        int high = this.valueArray.length - 1;
        Comparator<Object> comparator = this.valueSerializer.getComparator();
        while (high > low) {
            switch (high - low) {
                case 1: {
                    result = comparator.compare(value, this.valueArray[pivot]);
                    if (result == 0) {
                        return pivot;
                    }
                    if (result < 0) {
                        if (pivot == low) {
                            return -(low + 1);
                        }
                        result = comparator.compare(value, this.valueArray[low]);
                        if (result == 0) {
                            return low;
                        }
                        if (result < 0) {
                            return -(low + 1);
                        }
                        return -(low + 2);
                    }
                    if (pivot == high) {
                        return -(high + 2);
                    }
                    result = comparator.compare(value, this.valueArray[high]);
                    if (result == 0) {
                        return high;
                    }
                    if (result < 0) {
                        return -(high + 1);
                    }
                    return -(high + 2);
                }
            }
            result = comparator.compare(value, this.valueArray[pivot]);
            if (result == 0) {
                return pivot;
            }
            if (result < 0) {
                high = pivot - 1;
            } else {
                low = pivot + 1;
            }
            pivot = (high + low) / 2;
        }
        result = comparator.compare(value, this.valueArray[pivot]);
        if (result == 0) {
            return pivot;
        }
        if (result < 0) {
            return -(pivot + 1);
        }
        return -(pivot + 2);
    }

    @Override
    public ValueHolder<V> clone() throws CloneNotSupportedException {
        PersistedValueHolder copy = (PersistedValueHolder)super.clone();
        if (this.valueArray != null) {
            copy.valueArray = (Object[])Array.newInstance(this.valueSerializer.getType(), this.valueArray.length);
            System.arraycopy(this.valueArray, 0, copy.valueArray, 0, this.valueArray.length);
        }
        if (this.isRawUpToDate) {
            copy.raw = new byte[this.raw.length];
            System.arraycopy(this.raw, 0, copy.raw, 0, this.raw.length);
        }
        return copy;
    }

    private void deserializeArray() {
        int index = 0;
        int pos = 0;
        while (pos < this.raw.length) {
            try {
                int size = IntSerializer.deserialize(this.raw, pos);
                Object value = this.valueSerializer.fromBytes(this.raw, pos += 4);
                pos += size;
                this.valueArray[index++] = value;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void deserializeSubBtree() {
        long offset = LongSerializer.deserialize(this.raw);
        this.valueBtree = this.parentBtree.getRecordManager().loadDupsBTree(offset);
    }

    long getOffset() {
        if (this.valueArray == null) {
            return ((PersistedBTree)this.valueBtree).getBtreeOffset();
        }
        return -1L;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ValueHolder[").append(this.valueSerializer.getClass().getSimpleName());
        if (!this.isDeserialized) {
            sb.append(", isRaw[").append(this.raw.length).append("]");
        } else if (this.valueArray == null) {
            sb.append(", SubBTree");
        } else {
            sb.append(", array{");
            if (this.valueArray == null) {
                sb.append("}");
            } else {
                boolean isFirst = true;
                for (Object value : this.valueArray) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append("/");
                    }
                    sb.append(value);
                }
                sb.append("}");
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

