/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.standalone;

import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.ldap.codec.BasicControlDecorator;
import org.apache.directory.api.ldap.codec.api.CodecControl;
import org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.ExtendedRequestDecorator;
import org.apache.directory.api.ldap.codec.api.ExtendedResponseDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.ExtendedRequestImpl;
import org.apache.directory.api.ldap.model.message.ExtendedResponseImpl;
import org.apache.directory.api.ldap.model.message.controls.OpaqueControl;
import org.apache.directory.api.util.Strings;
import org.apache.directory.api.util.exception.NotImplementedException;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneLdapApiService
implements LdapApiService {
    private static final Logger LOG = LoggerFactory.getLogger(StandaloneLdapApiService.class);
    private Map<String, ControlFactory<?, ?>> controlFactories = new HashMap();
    private Map<String, ExtendedOperationFactory<?, ?>> extendendOperationsFactories = new HashMap();
    private ProtocolCodecFactory protocolCodecFactory;
    public static final String CONTROLS_LIST = "apacheds.controls";
    public static final String EXTENDED_OPERATIONS_LIST = "apacheds.extendedOperations";
    private static final String OLD_DEFAULT_CONTROLS_LIST = "default.controls";
    private static final String OLD_EXTRA_CONTROLS_LIST = "extra.controls";
    private static final String OLD_DEFAULT_EXTENDED_OPERATION_REQUESTS_LIST = "default.extendedOperation.requests";
    private static final String OLD_DEFAULT_EXTENDED_OPERATION_RESPONSES_LIST = "default.extendedOperation.responses";
    private static final String OLD_EXTRA_EXTENDED_OPERATION_LIST = "extra.extendedOperations";

    public StandaloneLdapApiService() throws Exception {
        this.loadControls();
        this.loadExtendedOperations();
        if (this.protocolCodecFactory == null) {
            try {
                Class<?> clazz = Class.forName("org.apache.directory.api.ldap.codec.protocol.mina.LdapProtocolCodecFactory");
                this.protocolCodecFactory = (ProtocolCodecFactory)clazz.newInstance();
            }
            catch (Exception cause) {
                throw new RuntimeException("Failed to load default codec factory.", cause);
            }
        }
    }

    private void loadControls() throws Exception {
        ArrayList<String> controlsList = new ArrayList<String>();
        String controlsString = System.getProperty(CONTROLS_LIST);
        if (!Strings.isEmpty((String)controlsString)) {
            for (String control : controlsString.split(",")) {
                controlsList.add(control);
            }
        } else {
            String oldExtraControlsString;
            String oldDefaultControlsString = System.getProperty(OLD_DEFAULT_CONTROLS_LIST);
            if (!Strings.isEmpty((String)oldDefaultControlsString)) {
                for (String control : oldDefaultControlsString.split(",")) {
                    controlsList.add(control);
                }
            }
            if (!Strings.isEmpty((String)(oldExtraControlsString = System.getProperty(OLD_EXTRA_CONTROLS_LIST)))) {
                for (String control : oldExtraControlsString.split(",")) {
                    controlsList.add(control);
                }
            }
        }
        if (controlsList.size() > 0) {
            for (String control : controlsList) {
                this.loadControl(control);
            }
        }
    }

    private void loadControl(String control) throws Exception {
        Class[] types = new Class[]{LdapApiService.class};
        Class<?> clazz = Class.forName(control);
        Constructor<?> constructor = clazz.getConstructor(types);
        ControlFactory factory = (ControlFactory)constructor.newInstance(this);
        this.controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered control factory: {}", (Object)factory.getOid());
    }

    private void loadExtendedOperations() throws Exception {
        ArrayList<String> extendedOperationsList = new ArrayList<String>();
        String defaultExtendedOperationsList = System.getProperty(EXTENDED_OPERATIONS_LIST);
        if (!Strings.isEmpty((String)defaultExtendedOperationsList)) {
            for (String extendedOperation : defaultExtendedOperationsList.split(",")) {
                extendedOperationsList.add(extendedOperation);
            }
        } else {
            String oldDefaultControlsString;
            String oldExtendedOperationsResponseString;
            String oldExtendedOperationsRequestsString = System.getProperty(OLD_DEFAULT_EXTENDED_OPERATION_REQUESTS_LIST);
            if (!Strings.isEmpty((String)oldExtendedOperationsRequestsString)) {
                for (String extendedOperation : oldExtendedOperationsRequestsString.split(",")) {
                    extendedOperationsList.add(extendedOperation);
                }
            }
            if (!Strings.isEmpty((String)(oldExtendedOperationsResponseString = System.getProperty(OLD_DEFAULT_EXTENDED_OPERATION_RESPONSES_LIST)))) {
                for (String extendedOperation : oldExtendedOperationsResponseString.split(",")) {
                    extendedOperationsList.add(extendedOperation);
                }
            }
            if (!Strings.isEmpty((String)(oldDefaultControlsString = System.getProperty(OLD_EXTRA_EXTENDED_OPERATION_LIST)))) {
                for (String extendedOperation : oldDefaultControlsString.split(",")) {
                    extendedOperationsList.add(extendedOperation);
                }
            }
        }
        if (extendedOperationsList.size() > 0) {
            for (String extendedOperation : extendedOperationsList) {
                this.loadExtendedOperation(extendedOperation);
            }
        }
    }

    private void loadExtendedOperation(String extendedOperation) throws Exception {
        Class[] types = new Class[]{LdapApiService.class};
        Class<?> clazz = Class.forName(extendedOperation);
        Constructor<?> constructor = clazz.getConstructor(types);
        ExtendedOperationFactory factory = (ExtendedOperationFactory)constructor.newInstance(this);
        this.extendendOperationsFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled extended operation factory: {}", (Object)factory.getOid());
    }

    public ControlFactory<?, ?> registerControl(ControlFactory<?, ?> factory) {
        return this.controlFactories.put(factory.getOid(), factory);
    }

    public ControlFactory<?, ?> unregisterControl(String oid) {
        return this.controlFactories.remove(oid);
    }

    public Iterator<String> registeredControls() {
        return Collections.unmodifiableSet(this.controlFactories.keySet()).iterator();
    }

    public boolean isControlRegistered(String oid) {
        return this.controlFactories.containsKey(oid);
    }

    public Iterator<String> registeredExtendedRequests() {
        return Collections.unmodifiableSet(this.extendendOperationsFactories.keySet()).iterator();
    }

    public ExtendedOperationFactory<?, ?> registerExtendedRequest(ExtendedOperationFactory<?, ?> factory) {
        return this.extendendOperationsFactories.put(factory.getOid(), factory);
    }

    public ProtocolCodecFactory getProtocolCodecFactory() {
        return this.protocolCodecFactory;
    }

    public ProtocolCodecFactory registerProtocolCodecFactory(ProtocolCodecFactory protocolCodecFactory) {
        ProtocolCodecFactory old = this.protocolCodecFactory;
        this.protocolCodecFactory = protocolCodecFactory;
        return old;
    }

    public CodecControl<? extends Control> newControl(String oid) {
        ControlFactory<?, ?> factory = this.controlFactories.get(oid);
        if (factory == null) {
            return new BasicControlDecorator((LdapApiService)this, (Control)new OpaqueControl(oid));
        }
        return factory.newCodecControl();
    }

    public CodecControl<? extends Control> newControl(Control control) {
        if (control == null) {
            throw new NullPointerException("Control argument was null.");
        }
        if (control instanceof CodecControl) {
            return (CodecControl)control;
        }
        ControlFactory<?, ?> factory = this.controlFactories.get(control.getOid());
        if (factory == null) {
            return new BasicControlDecorator((LdapApiService)this, control);
        }
        return factory.newCodecControl(control);
    }

    public javax.naming.ldap.Control toJndiControl(Control control) throws EncoderException {
        CodecControl<? extends Control> decorator = this.newControl(control);
        ByteBuffer bb = ByteBuffer.allocate(decorator.computeLength());
        decorator.encode(bb);
        bb.flip();
        BasicControl jndiControl = new BasicControl(control.getOid(), control.isCritical(), bb.array());
        return jndiControl;
    }

    public Control fromJndiControl(javax.naming.ldap.Control control) throws DecoderException {
        ControlFactory<?, ?> factory = this.controlFactories.get(control.getID());
        if (factory == null) {
            OpaqueControl ourControl = new OpaqueControl(control.getID());
            ourControl.setCritical(control.isCritical());
            BasicControlDecorator decorator = new BasicControlDecorator((LdapApiService)this, (Control)ourControl);
            decorator.setValue(control.getEncodedValue());
            return decorator;
        }
        CodecControl ourControl = factory.newCodecControl();
        ourControl.setCritical(control.isCritical());
        ourControl.setValue(control.getEncodedValue());
        ourControl.decode(control.getEncodedValue());
        return ourControl;
    }

    public Asn1Container newMessageContainer() {
        return new LdapMessageContainer((LdapApiService)this);
    }

    public ExtendedResponse toJndi(org.apache.directory.api.ldap.model.message.ExtendedResponse modelResponse) throws EncoderException {
        throw new NotImplementedException("Figure out how to transform");
    }

    public org.apache.directory.api.ldap.model.message.ExtendedResponse fromJndi(ExtendedResponse jndiResponse) throws DecoderException {
        throw new NotImplementedException("Figure out how to transform");
    }

    public ExtendedOperationFactory<?, ?> unregisterExtendedRequest(String oid) {
        return this.extendendOperationsFactories.remove(oid);
    }

    public org.apache.directory.api.ldap.model.message.ExtendedRequest<?> fromJndi(ExtendedRequest jndiRequest) throws DecoderException {
        ExtendedRequestDecorator decorator = (ExtendedRequestDecorator)this.newExtendedRequest(jndiRequest.getID(), jndiRequest.getEncodedValue());
        return decorator;
    }

    public ExtendedRequest toJndi(final org.apache.directory.api.ldap.model.message.ExtendedRequest<?> modelRequest) throws EncoderException {
        byte[] value;
        final String oid = modelRequest.getRequestName();
        if (modelRequest instanceof ExtendedRequestDecorator) {
            ExtendedRequestDecorator decorator = (ExtendedRequestDecorator)modelRequest;
            value = decorator.getRequestValue();
        } else {
            ExtendedOperationFactory<?, ?> extendedRequestFactory = this.extendendOperationsFactories.get(modelRequest.getRequestName());
            ExtendedRequestDecorator decorator = extendedRequestFactory.decorate(modelRequest);
            value = decorator.getRequestValue();
        }
        ExtendedRequest jndiRequest = new ExtendedRequest(){
            private static final long serialVersionUID = -4160980385909987475L;

            @Override
            public String getID() {
                return oid;
            }

            @Override
            public byte[] getEncodedValue() {
                return value;
            }

            @Override
            public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
                ExtendedOperationFactory factory = (ExtendedOperationFactory)StandaloneLdapApiService.this.extendendOperationsFactories.get(modelRequest.getRequestName());
                try {
                    final ExtendedResponseDecorator resp = (ExtendedResponseDecorator)factory.newResponse(berValue);
                    ExtendedResponse jndiResponse = new ExtendedResponse(){
                        private static final long serialVersionUID = -7686354122066100703L;

                        @Override
                        public String getID() {
                            return oid;
                        }

                        @Override
                        public byte[] getEncodedValue() {
                            return resp.getResponseValue();
                        }
                    };
                    return jndiResponse;
                }
                catch (DecoderException e) {
                    NamingException ne = new NamingException("Unable to decode encoded response value: " + Strings.dumpBytes((byte[])berValue));
                    ne.setRootCause(e);
                    throw ne;
                }
            }
        };
        return jndiRequest;
    }

    public <E extends org.apache.directory.api.ldap.model.message.ExtendedResponse> E newExtendedResponse(String responseName, int messageId, byte[] serializedResponse) throws DecoderException {
        ExtendedResponseDecorator resp;
        ExtendedOperationFactory<?, ?> extendedRequestFactory = this.extendendOperationsFactories.get(responseName);
        if (extendedRequestFactory != null) {
            resp = (ExtendedResponseDecorator)extendedRequestFactory.newResponse(serializedResponse);
        } else {
            resp = new ExtendedResponseDecorator((LdapApiService)this, (org.apache.directory.api.ldap.model.message.ExtendedResponse)new ExtendedResponseImpl(responseName));
            resp.setResponseValue(serializedResponse);
            resp.setResponseName(responseName);
        }
        resp.setMessageId(messageId);
        return (E)resp;
    }

    public org.apache.directory.api.ldap.model.message.ExtendedRequest<?> newExtendedRequest(String oid, byte[] value) {
        org.apache.directory.api.ldap.model.message.ExtendedRequest req = null;
        ExtendedOperationFactory<?, ?> extendedRequestFactory = this.extendendOperationsFactories.get(oid);
        if (extendedRequestFactory != null) {
            req = value == null ? extendedRequestFactory.newRequest() : extendedRequestFactory.newRequest(value);
        } else {
            ExtendedRequestDecorator decorator = new ExtendedRequestDecorator((LdapApiService)this, (org.apache.directory.api.ldap.model.message.ExtendedRequest)new ExtendedRequestImpl());
            decorator.setRequestName(oid);
            decorator.setRequestValue(value);
            req = decorator;
        }
        return req;
    }

    public ExtendedRequestDecorator<?, ?> decorate(org.apache.directory.api.ldap.model.message.ExtendedRequest<?> decoratedMessage) {
        ExtendedRequestDecorator req = null;
        ExtendedOperationFactory<?, ?> extendedRequestFactory = this.extendendOperationsFactories.get(decoratedMessage.getRequestName());
        req = extendedRequestFactory != null ? extendedRequestFactory.decorate(decoratedMessage) : new ExtendedRequestDecorator((LdapApiService)this, decoratedMessage);
        return req;
    }

    public ExtendedResponseDecorator<?> decorate(org.apache.directory.api.ldap.model.message.ExtendedResponse decoratedMessage) {
        ExtendedResponseDecorator resp = null;
        ExtendedOperationFactory<?, ?> extendedRequestFactory = this.extendendOperationsFactories.get(decoratedMessage.getResponseName());
        resp = extendedRequestFactory != null ? extendedRequestFactory.decorate(decoratedMessage) : new ExtendedResponseDecorator((LdapApiService)this, decoratedMessage);
        return resp;
    }

    public boolean isExtendedOperationRegistered(String oid) {
        return this.extendendOperationsFactories.containsKey(oid);
    }
}

