/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.FloatsSketchSortedView;
import org.apache.datasketches.quantilescommon.FloatsSortedViewIterator;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllFloatsSketchTest {
    private static final String LS = System.getProperty("line.separator");
    private static final double PMF_EPS_FOR_K_8 = KllSketch.getNormalizedRankError((int)8, (boolean)true);
    private static final double PMF_EPS_FOR_K_128 = KllSketch.getNormalizedRankError((int)128, (boolean)true);
    private static final double PMF_EPS_FOR_K_256 = KllSketch.getNormalizedRankError((int)256, (boolean)true);
    private static final double NUMERIC_NOISE_TOLERANCE = 1.0E-6;
    private static final DefaultMemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();
    private static final boolean enablePrinting = false;

    @Test
    public void empty() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(Float.NaN);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)0L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)0);
        try {
            sketch.getRank(0.0f);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getQuantile(0.5);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getQuantiles(new double[]{0.0});
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getPMF(new float[]{0.0f});
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getCDF(new float[]{0.0f});
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertNotNull((Object)sketch.toString(true, true));
        Assert.assertNotNull((Object)sketch.toString());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void getQuantileInvalidArg() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(1.0f);
        sketch.getQuantile(-1.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void getQuantilesInvalidArg() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(1.0f);
        sketch.getQuantiles(new double[]{2.0});
    }

    @Test
    public void oneValue() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(1.0f);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)1L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)1);
        Assert.assertEquals((double)sketch.getRank(0.0f, QuantileSearchCriteria.EXCLUSIVE), (double)0.0);
        Assert.assertEquals((double)sketch.getRank(1.0f, QuantileSearchCriteria.EXCLUSIVE), (double)0.0);
        Assert.assertEquals((double)sketch.getRank(2.0f, QuantileSearchCriteria.EXCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getRank(0.0f, QuantileSearchCriteria.INCLUSIVE), (double)0.0);
        Assert.assertEquals((double)sketch.getRank(1.0f, QuantileSearchCriteria.INCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getRank(2.0f, QuantileSearchCriteria.INCLUSIVE), (double)1.0);
        Assert.assertEquals((float)sketch.getMinItem(), (float)1.0f);
        Assert.assertEquals((float)sketch.getMaxItem(), (float)1.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE), (float)1.0f);
        Assert.assertEquals((float)sketch.getQuantile(0.5, QuantileSearchCriteria.INCLUSIVE), (float)1.0f);
    }

    @Test
    public void tenValues() {
        int i;
        int i2;
        int i3;
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance((int)20);
        for (i3 = 1; i3 <= 10; ++i3) {
            sketch.update((float)i3);
        }
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)10L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)10);
        for (i3 = 1; i3 <= 10; ++i3) {
            Assert.assertEquals((double)sketch.getRank((float)i3, QuantileSearchCriteria.EXCLUSIVE), (double)((double)(i3 - 1) / 10.0));
            Assert.assertEquals((double)sketch.getRank((float)i3, QuantileSearchCriteria.INCLUSIVE), (double)((double)i3 / 10.0));
        }
        float[] qArr = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f};
        double[] rOut = sketch.getRanks(qArr);
        for (i2 = 0; i2 < qArr.length; ++i2) {
            Assert.assertEquals((double)rOut[i2], (double)((double)(i2 + 1) / 10.0));
        }
        rOut = sketch.getRanks(qArr, QuantileSearchCriteria.EXCLUSIVE);
        for (i2 = 0; i2 < qArr.length; ++i2) {
            Assert.assertEquals((double)rOut[i2], (double)((double)i2 / 10.0));
        }
        for (i2 = 0; i2 >= 10; ++i2) {
            double rank = (double)i2 / 10.0;
            float q = rank == 1.0 ? (float)i2 : (float)(i2 + 1);
            Assert.assertEquals((float)sketch.getQuantile(rank, QuantileSearchCriteria.EXCLUSIVE), (float)q);
            q = (float)(rank == 0.0 ? (double)i2 + 1.0 : (double)i2);
            Assert.assertEquals((float)sketch.getQuantile(rank, QuantileSearchCriteria.INCLUSIVE), (float)q);
        }
        float[] quantiles = sketch.getQuantiles(new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0}, QuantileSearchCriteria.EXCLUSIVE);
        for (i = 0; i <= 10; ++i) {
            Assert.assertEquals((float)sketch.getQuantile((double)i / 10.0, QuantileSearchCriteria.EXCLUSIVE), (float)quantiles[i]);
        }
        quantiles = sketch.getQuantiles(new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0}, QuantileSearchCriteria.INCLUSIVE);
        for (i = 0; i <= 10; ++i) {
            Assert.assertEquals((float)sketch.getQuantile((double)i / 10.0, QuantileSearchCriteria.INCLUSIVE), (float)quantiles[i]);
        }
    }

    @Test
    public void manyValuesEstimationMode() {
        int i;
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        int n = 1000000;
        for (i = 0; i < 1000000; ++i) {
            sketch.update((float)i);
        }
        Assert.assertEquals((long)sketch.getN(), (long)1000000L);
        for (i = 0; i < 1000000; ++i) {
            double trueRank = (double)i / 1000000.0;
            Assert.assertEquals((double)sketch.getRank((float)i), (double)trueRank, (double)PMF_EPS_FOR_K_256, (String)("for value " + i));
        }
        double[] pmf = sketch.getPMF(new float[]{500000.0f});
        Assert.assertEquals((int)pmf.length, (int)2);
        Assert.assertEquals((double)pmf[0], (double)0.5, (double)PMF_EPS_FOR_K_256);
        Assert.assertEquals((double)pmf[1], (double)0.5, (double)PMF_EPS_FOR_K_256);
        Assert.assertEquals((float)sketch.getMinItem(), (float)0.0f);
        Assert.assertEquals((float)sketch.getMaxItem(), (float)999999.0f);
        double[] fractions = new double[1001];
        double[] reverseFractions = new double[1001];
        for (int i2 = 0; i2 <= 1000; ++i2) {
            fractions[i2] = (double)i2 / 1000.0;
            reverseFractions[1000 - i2] = fractions[i2];
        }
        float[] quantiles = sketch.getQuantiles(fractions);
        float[] reverseQuantiles = sketch.getQuantiles(reverseFractions);
        float previousQuantile = 0.0f;
        for (int i3 = 0; i3 <= 1000; ++i3) {
            float quantile = sketch.getQuantile(fractions[i3]);
            Assert.assertEquals((float)quantile, (float)quantiles[i3]);
            Assert.assertEquals((float)quantile, (float)reverseQuantiles[1000 - i3]);
            Assert.assertTrue((previousQuantile <= quantile ? 1 : 0) != 0);
            previousQuantile = quantile;
        }
    }

    @Test
    public void getRankGetCdfGetPmfConsistency() {
        int i;
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        int n = 1000;
        float[] values = new float[1000];
        for (int i2 = 0; i2 < 1000; ++i2) {
            sketch.update((float)i2);
            values[i2] = i2;
        }
        double[] ranks = sketch.getCDF(values);
        double[] pmf = sketch.getPMF(values);
        double sumPmf = 0.0;
        for (i = 0; i < 1000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i]), (double)1.0E-6, (String)("rank vs CDF for value " + i));
            Assert.assertEquals((double)ranks[i], (double)(sumPmf += pmf[i]), (double)1.0E-6, (String)("CDF vs PMF for value " + i));
        }
        Assert.assertEquals((double)(sumPmf += pmf[1000]), (double)1.0, (double)1.0E-6);
        Assert.assertEquals((double)ranks[1000], (double)1.0, (double)1.0E-6);
        ranks = sketch.getCDF(values, QuantileSearchCriteria.INCLUSIVE);
        pmf = sketch.getPMF(values, QuantileSearchCriteria.INCLUSIVE);
        sumPmf = 0.0;
        for (i = 0; i < 1000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i], QuantileSearchCriteria.INCLUSIVE), (double)1.0E-6, (String)("rank vs CDF for value " + i));
            Assert.assertEquals((double)ranks[i], (double)(sumPmf += pmf[i]), (double)1.0E-6, (String)("CDF vs PMF for value " + i));
        }
        Assert.assertEquals((double)(sumPmf += pmf[1000]), (double)1.0, (double)1.0E-6);
        Assert.assertEquals((double)ranks[1000], (double)1.0, (double)1.0E-6);
    }

    @Test
    public void merge() {
        KllFloatsSketch sketch1 = KllFloatsSketch.newHeapInstance();
        KllFloatsSketch sketch2 = KllFloatsSketch.newHeapInstance();
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((float)i * 1.0f);
            sketch2.update((float)(20000 - i - 1) * 1.0f);
        }
        Assert.assertEquals((float)sketch1.getMinItem(), (float)0.0f);
        Assert.assertEquals((float)sketch1.getMaxItem(), (float)9999.0f);
        Assert.assertEquals((float)sketch2.getMinItem(), (float)10000.0f);
        Assert.assertEquals((float)sketch2.getMaxItem(), (float)19999.0f);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)20000L);
        Assert.assertEquals((float)sketch1.getMinItem(), (float)0.0f);
        Assert.assertEquals((float)sketch1.getMaxItem(), (float)19999.0f);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)10000.0, (double)(20000.0 * PMF_EPS_FOR_K_256));
    }

    @Test
    public void mergeLowerK() {
        KllFloatsSketch sketch1 = KllFloatsSketch.newHeapInstance((int)256);
        KllFloatsSketch sketch2 = KllFloatsSketch.newHeapInstance((int)128);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((float)i);
            sketch2.update((float)(20000 - i - 1));
        }
        Assert.assertEquals((float)sketch1.getMinItem(), (float)0.0f);
        Assert.assertEquals((float)sketch1.getMaxItem(), (float)9999.0f);
        Assert.assertEquals((float)sketch2.getMinItem(), (float)10000.0f);
        Assert.assertEquals((float)sketch2.getMaxItem(), (float)19999.0f);
        Assert.assertTrue((sketch1.getNormalizedRankError(false) < sketch2.getNormalizedRankError(false) ? 1 : 0) != 0);
        Assert.assertTrue((sketch1.getNormalizedRankError(true) < sketch2.getNormalizedRankError(true) ? 1 : 0) != 0);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(false), (double)sketch2.getNormalizedRankError(false));
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)sketch2.getNormalizedRankError(true));
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)20000L);
        Assert.assertEquals((float)sketch1.getMinItem(), (float)0.0f);
        Assert.assertEquals((float)sketch1.getMaxItem(), (float)19999.0f);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)10000.0, (double)(20000.0 * PMF_EPS_FOR_K_128));
    }

    @Test
    public void mergeEmptyLowerK() {
        KllFloatsSketch sketch1 = KllFloatsSketch.newHeapInstance((int)256);
        KllFloatsSketch sketch2 = KllFloatsSketch.newHeapInstance((int)128);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((float)i);
        }
        double rankErrorBeforeMerge = sketch1.getNormalizedRankError(true);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)rankErrorBeforeMerge);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)10000L);
        Assert.assertEquals((float)sketch1.getMinItem(), (float)0.0f);
        Assert.assertEquals((float)sketch1.getMaxItem(), (float)9999.0f);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)5000.0, (double)(10000.0 * PMF_EPS_FOR_K_256));
        sketch2.merge((KllSketch)sketch1);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)10000L);
        Assert.assertEquals((float)sketch1.getMinItem(), (float)0.0f);
        Assert.assertEquals((float)sketch1.getMaxItem(), (float)9999.0f);
        Assert.assertEquals((double)sketch1.getQuantile(0.5), (double)5000.0, (double)(10000.0 * PMF_EPS_FOR_K_256));
    }

    @Test
    public void mergeExactModeLowerK() {
        KllFloatsSketch sketch1 = KllFloatsSketch.newHeapInstance((int)256);
        KllFloatsSketch sketch2 = KllFloatsSketch.newHeapInstance((int)128);
        int n = 10000;
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((float)i);
        }
        sketch2.update(1.0f);
        double rankErrorBeforeMerge = sketch1.getNormalizedRankError(true);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)rankErrorBeforeMerge);
    }

    @Test
    public void mergeMinMinValueFromOther() {
        KllFloatsSketch sketch1 = KllFloatsSketch.newHeapInstance();
        KllFloatsSketch sketch2 = KllFloatsSketch.newHeapInstance();
        sketch1.update(1.0f);
        sketch2.update(2.0f);
        sketch2.merge((KllSketch)sketch1);
        Assert.assertEquals((float)sketch2.getMinItem(), (float)1.0f);
    }

    @Test
    public void mergeMinAndMaxFromOther() {
        KllFloatsSketch sketch1 = KllFloatsSketch.newHeapInstance();
        for (int i = 1; i <= 1000000; ++i) {
            sketch1.update((float)i);
        }
        KllFloatsSketch sketch2 = KllFloatsSketch.newHeapInstance((int)10);
        sketch2.merge((KllSketch)sketch1);
        Assert.assertEquals((float)sketch2.getMinItem(), (float)1.0f);
        Assert.assertEquals((float)sketch2.getMaxItem(), (float)1000000.0f);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void kTooSmall() {
        KllFloatsSketch.newHeapInstance((int)7);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void kTooLarge() {
        KllFloatsSketch.newHeapInstance((int)65536);
    }

    @Test
    public void minK() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance((int)8);
        for (int i = 0; i < 1000; ++i) {
            sketch.update((float)i);
        }
        Assert.assertEquals((int)sketch.getK(), (int)8);
        Assert.assertEquals((double)sketch.getQuantile(0.5), (double)500.0, (double)(1000.0 * PMF_EPS_FOR_K_8));
    }

    @Test
    public void maxK() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance((int)65535);
        for (int i = 0; i < 1000; ++i) {
            sketch.update((float)i);
        }
        Assert.assertEquals((int)sketch.getK(), (int)65535);
        Assert.assertEquals((double)sketch.getQuantile(0.5), (double)500.0, (double)(1000.0 * PMF_EPS_FOR_K_256));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void outOfOrderSplitPoints() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(0.0f);
        sketch.getCDF(new float[]{1.0f, 0.0f});
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void nanSplitPoint() {
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        sketch.update(0.0f);
        sketch.getCDF(new float[]{Float.NaN});
    }

    @Test
    public void checkReset() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 100; ++i) {
            sk.update((float)i);
        }
        long n1 = sk.getN();
        float min1 = sk.getMinItem();
        float max1 = sk.getMaxItem();
        sk.reset();
        for (int i = 1; i <= 100; ++i) {
            sk.update((float)i);
        }
        long n2 = sk.getN();
        float min2 = sk.getMinItem();
        float max2 = sk.getMaxItem();
        Assert.assertEquals((long)n2, (long)n1);
        Assert.assertEquals((float)min2, (float)min1);
        Assert.assertEquals((float)max2, (float)max1);
    }

    @Test
    public void checkReadOnlyUpdate() {
        KllFloatsSketch sk1 = KllFloatsSketch.newHeapInstance((int)20);
        Memory mem = Memory.wrap((byte[])sk1.toByteArray());
        KllFloatsSketch sk2 = KllFloatsSketch.wrap((Memory)mem);
        try {
            sk2.update(1.0f);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkNewDirectInstanceAndSize() {
        WritableMemory wmem = WritableMemory.allocate((int)3000);
        KllFloatsSketch.newDirectInstance((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        try {
            KllFloatsSketch.newDirectInstance(null, (MemoryRequestServer)memReqSvr);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            KllFloatsSketch.newDirectInstance((WritableMemory)wmem, null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        int updateSize = KllSketch.getMaxSerializedSizeBytes((int)200, (long)0L, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)true);
        int compactSize = KllSketch.getMaxSerializedSizeBytes((int)200, (long)0L, (KllSketch.SketchType)KllSketch.SketchType.FLOATS_SKETCH, (boolean)false);
        Assert.assertTrue((compactSize < updateSize ? 1 : 0) != 0);
    }

    @Test
    public void sortedView() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance();
        sk.update(3.0f);
        sk.update(1.0f);
        sk.update(2.0f);
        FloatsSketchSortedView view = sk.getSortedView();
        FloatsSortedViewIterator itr = view.iterator();
        Assert.assertEquals((boolean)itr.next(), (boolean)true);
        Assert.assertEquals((float)itr.getQuantile(), (float)1.0f);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.EXCLUSIVE), (long)0L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.INCLUSIVE), (long)1L);
        Assert.assertEquals((boolean)itr.next(), (boolean)true);
        Assert.assertEquals((float)itr.getQuantile(), (float)2.0f);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.EXCLUSIVE), (long)1L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.INCLUSIVE), (long)2L);
        Assert.assertEquals((boolean)itr.next(), (boolean)true);
        Assert.assertEquals((float)itr.getQuantile(), (float)3.0f);
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.EXCLUSIVE), (long)2L);
        Assert.assertEquals((long)itr.getNaturalRank(QuantileSearchCriteria.INCLUSIVE), (long)3L);
        Assert.assertEquals((boolean)itr.next(), (boolean)false);
    }

    @Test
    public void checkCDF_PDF() {
        int i;
        double[] cdfI = new double[]{0.25, 0.5, 0.75, 1.0, 1.0};
        double[] cdfE = new double[]{0.0, 0.25, 0.5, 0.75, 1.0};
        double[] pmfI = new double[]{0.25, 0.25, 0.25, 0.25, 0.0};
        double[] pmfE = new double[]{0.0, 0.25, 0.25, 0.25, 0.25};
        double toll = 1.0E-10;
        KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance();
        float[] floatIn = new float[]{10.0f, 20.0f, 30.0f, 40.0f};
        for (int i2 = 0; i2 < floatIn.length; ++i2) {
            sketch.update(floatIn[i2]);
        }
        float[] sp = new float[]{10.0f, 20.0f, 30.0f, 40.0f};
        KllFloatsSketchTest.println("SplitPoints:");
        for (int i3 = 0; i3 < sp.length; ++i3) {
            KllFloatsSketchTest.printf("%10.2f", Float.valueOf(sp[i3]));
        }
        KllFloatsSketchTest.println("");
        KllFloatsSketchTest.println("INCLUSIVE:");
        double[] cdf = sketch.getCDF(sp, QuantileSearchCriteria.INCLUSIVE);
        double[] pmf = sketch.getPMF(sp, QuantileSearchCriteria.INCLUSIVE);
        KllFloatsSketchTest.printf("%10s%10s" + LS, "CDF", "PMF");
        for (i = 0; i < cdf.length; ++i) {
            KllFloatsSketchTest.printf("%10.2f%10.2f" + LS, cdf[i], pmf[i]);
            Assert.assertEquals((double)cdf[i], (double)cdfI[i], (double)1.0E-10);
            Assert.assertEquals((double)pmf[i], (double)pmfI[i], (double)1.0E-10);
        }
        KllFloatsSketchTest.println("EXCLUSIVE");
        cdf = sketch.getCDF(sp, QuantileSearchCriteria.EXCLUSIVE);
        pmf = sketch.getPMF(sp, QuantileSearchCriteria.EXCLUSIVE);
        KllFloatsSketchTest.printf("%10s%10s" + LS, "CDF", "PMF");
        for (i = 0; i < cdf.length; ++i) {
            KllFloatsSketchTest.printf("%10.2f%10.2f" + LS, cdf[i], pmf[i]);
            Assert.assertEquals((double)cdf[i], (double)cdfE[i], (double)1.0E-10);
            Assert.assertEquals((double)pmf[i], (double)pmfE[i], (double)1.0E-10);
        }
    }

    @Test
    public void checkWrapCase1Floats() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((float)i);
        }
        Memory mem = Memory.wrap((byte[])sk.toByteArray());
        KllFloatsSketch sk2 = KllFloatsSketch.wrap((Memory)mem);
        Assert.assertTrue((boolean)mem.isReadOnly());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertFalse((boolean)sk2.isDirect());
    }

    @Test
    public void checkWritableWrapCase6And2Floats() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((float)i);
        }
        WritableMemory wmem = WritableMemory.writableWrap((byte[])KllHelper.toByteArray((KllSketch)sk, (boolean)true));
        KllFloatsSketch sk2 = KllFloatsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        Assert.assertFalse((boolean)wmem.isReadOnly());
        Assert.assertFalse((boolean)sk2.isReadOnly());
        Assert.assertFalse((boolean)sk2.isDirect());
    }

    @Test
    public void checkKllSketchCase5Floats() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((float)i);
        }
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        KllFloatsSketch sk2 = KllFloatsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        Assert.assertFalse((boolean)wmem.isReadOnly());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertFalse((boolean)sk2.isDirect());
    }

    @Test
    public void checkKllSketchCase3Floats() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((float)i);
        }
        Memory mem = Memory.wrap((byte[])KllHelper.toByteArray((KllSketch)sk, (boolean)true));
        WritableMemory wmem = (WritableMemory)mem;
        KllFloatsSketch sk2 = KllFloatsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        Assert.assertTrue((boolean)wmem.isReadOnly());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertFalse((boolean)sk2.isDirect());
    }

    @Test
    public void checkKllSketchCase7Floats() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((float)i);
        }
        Memory mem = Memory.wrap((byte[])KllHelper.toByteArray((KllSketch)sk, (boolean)true));
        WritableMemory wmem = (WritableMemory)mem;
        KllFloatsSketch sk2 = KllFloatsSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        Assert.assertTrue((boolean)wmem.isReadOnly());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertFalse((boolean)sk2.isDirect());
    }

    @Test
    public void checkReadOnlyExceptions() {
        int[] intArr = new int[]{};
        int intV = 2;
        int idx = 1;
        KllFloatsSketch sk1 = KllFloatsSketch.newHeapInstance((int)20);
        Memory mem = Memory.wrap((byte[])sk1.toByteArray());
        KllFloatsSketch sk2 = KllFloatsSketch.wrap((Memory)mem);
        try {
            sk2.setLevelsArray(intArr);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setLevelsArrayAt(idx, intV);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkIsSameResource() {
        WritableMemory reg2;
        int cap = 128;
        WritableMemory wmem = WritableMemory.allocate((int)cap);
        WritableMemory reg1 = wmem.writableRegion(0L, 64L);
        Assert.assertFalse((reg1 == (reg2 = wmem.writableRegion(64L, 64L)) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)reg1.isSameResource((Object)reg2));
        WritableMemory reg3 = wmem.writableRegion(0L, 64L);
        Assert.assertFalse((reg1 == reg3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)reg1.isSameResource((Object)reg3));
        byte[] byteArr1 = KllFloatsSketch.newHeapInstance((int)20).toByteArray();
        reg1.putByteArray(0L, byteArr1, 0, byteArr1.length);
        KllFloatsSketch sk1 = KllFloatsSketch.wrap((Memory)reg1);
        byte[] byteArr2 = KllFloatsSketch.newHeapInstance((int)20).toByteArray();
        reg2.putByteArray(0L, byteArr2, 0, byteArr2.length);
        Assert.assertFalse((boolean)sk1.isSameResource((Memory)reg2));
        byte[] byteArr3 = KllFloatsSketch.newHeapInstance((int)20).toByteArray();
        reg3.putByteArray(0L, byteArr3, 0, byteArr3.length);
        Assert.assertTrue((boolean)sk1.isSameResource((Memory)reg3));
    }

    @Test
    public void checkSortedViewAfterReset() {
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)20);
        sk.update(1.0f);
        FloatsSketchSortedView sv = sk.getSortedView();
        float fsv = sv.getQuantile(1.0, QuantileSearchCriteria.INCLUSIVE);
        Assert.assertEquals((float)fsv, (float)1.0f);
        sk.reset();
        try {
            sk.getSortedView();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkVectorUpdate() {
        int rem;
        boolean withLevels = false;
        boolean withLevelsAndItems = true;
        int k = 20;
        int n = 108;
        int maxVsz = 40;
        KllFloatsSketch sk = KllFloatsSketch.newHeapInstance((int)k);
        int j = 1;
        while ((rem = n - j + 1) > 0) {
            int vecSz = Math.min(rem, maxVsz);
            float[] v = new float[vecSz];
            for (int i = 0; i < vecSz; ++i) {
                v[i] = j++;
            }
            sk.update(v, 0, vecSz);
        }
        KllFloatsSketchTest.println(LS + "#<<< END STATE # >>>");
        KllFloatsSketchTest.println(sk.toString(withLevels, withLevelsAndItems));
        KllFloatsSketchTest.println("");
        Assert.assertEquals((long)sk.getN(), (long)108L);
        Assert.assertEquals((float)sk.getMaxItem(), (float)108.0f);
        Assert.assertEquals((float)sk.getMinItem(), (float)1.0f);
    }

    @Test
    public void vectorizedUpdates() {
        boolean trials = true;
        boolean M = true;
        int N = 1000;
        int K = 256;
        float[] values = new float[1000];
        float vIn = 1.0f;
        long totN = 0L;
        long startTime = System.nanoTime();
        for (int t = 0; t < 1; ++t) {
            KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance((int)256);
            for (int m = 0; m < 1; ++m) {
                for (int n = 0; n < 1000; ++n) {
                    vIn += 1.0f;
                }
                sketch.update(values, 0, 1000);
            }
            totN = sketch.getN();
            Assert.assertEquals((long)totN, (long)1000L);
            Assert.assertEquals((float)sketch.getMinItem(), (float)1.0f);
            Assert.assertEquals((float)sketch.getMaxItem(), (float)totN);
            Assert.assertEquals((double)sketch.getQuantile(0.5), (double)((float)((double)totN / 2.0)), (double)((double)totN * PMF_EPS_FOR_K_256 * 2.0));
        }
        long runTime = System.nanoTime() - startTime;
        KllFloatsSketchTest.println("Vectorized Updates");
        KllFloatsSketchTest.printf("  Vector size : %,12d" + LS, 1000);
        KllFloatsSketchTest.printf("  Num Vectors : %,12d" + LS, 1);
        KllFloatsSketchTest.printf("  Total Input : %,12d" + LS, totN);
        KllFloatsSketchTest.printf("  Run Time mS : %,12.3f" + LS, (double)runTime / 1000000.0);
        double trialTime = (double)runTime / 1000000.0;
        KllFloatsSketchTest.printf("  mS / Trial  : %,12.3f" + LS, trialTime);
        double updateTime = (double)runTime / (1.0 * (double)totN * 1.0);
        KllFloatsSketchTest.printf("  nS / Update : %,12.3f" + LS, updateTime);
    }

    @Test
    public void nonVectorizedUpdates() {
        boolean trials = true;
        boolean M = true;
        int N = 1000;
        int K = 256;
        float[] values = new float[1000];
        float vIn = 1.0f;
        long totN = 0L;
        long startTime = System.nanoTime();
        for (int t = 0; t < 1; ++t) {
            KllFloatsSketch sketch = KllFloatsSketch.newHeapInstance((int)256);
            for (int m = 0; m < 1; ++m) {
                for (int n = 0; n < 1000; ++n) {
                    vIn += 1.0f;
                }
                for (int i = 0; i < 1000; ++i) {
                    sketch.update(values[i]);
                }
            }
            totN = sketch.getN();
            Assert.assertEquals((long)totN, (long)1000L);
            Assert.assertEquals((double)sketch.getMinItem(), (double)1.0);
            Assert.assertEquals((float)sketch.getMaxItem(), (float)totN);
            Assert.assertEquals((double)sketch.getQuantile(0.5), (double)((float)((double)totN / 2.0)), (double)((double)totN * PMF_EPS_FOR_K_256 * 2.0));
        }
        long runTime = System.nanoTime() - startTime;
        KllFloatsSketchTest.println("Vectorized Updates");
        KllFloatsSketchTest.printf("  Vector size : %,12d" + LS, 1000);
        KllFloatsSketchTest.printf("  Num Vectors : %,12d" + LS, 1);
        KllFloatsSketchTest.printf("  Total Input : %,12d" + LS, totN);
        KllFloatsSketchTest.printf("  Run Time mS : %,12.3f" + LS, (double)runTime / 1000000.0);
        double trialTime = (double)runTime / 1000000.0;
        KllFloatsSketchTest.printf("  mS / Trial  : %,12.3f" + LS, trialTime);
        double updateTime = (double)runTime / (1.0 * (double)totN * 1.0);
        KllFloatsSketchTest.printf("  nS / Update : %,12.3f" + LS, updateTime);
    }

    private static final void printf(String format, Object ... args) {
    }

    private static final void println(Object o) {
    }
}

