/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.TestUtil;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.IntegerSummary;
import org.apache.datasketches.tuple.IntegerSummaryDeserializer;
import org.apache.datasketches.tuple.IntegerSummaryFactory;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Sketches;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.UpdatableSketch;
import org.apache.datasketches.tuple.UpdatableSketchBuilder;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.datasketches.tuple.adouble.DoubleSummaryDeserializer;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUnion;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TupleCrossLanguageTest {
    @Test(groups={"check_cpp_historical_files"})
    public void serialVersion1Compatibility() throws IOException {
        byte[] byteArr = Files.readAllBytes(TestUtil.cppHistPath.resolve("CompactSketchWithDoubleSummary4K_serialVersion1.sk"));
        Sketch sketch = Sketches.heapifySketch((Memory)Memory.wrap((byte[])byteArr), (SummaryDeserializer)new DoubleSummaryDeserializer());
        Assert.assertTrue((boolean)sketch.isEstimationMode());
        Assert.assertEquals((double)sketch.getEstimate(), (double)8192.0, (double)8110.08);
        Assert.assertEquals((int)sketch.getRetainedEntries(), (int)4096);
        int count = 0;
        TupleSketchIterator it = sketch.iterator();
        while (it.next()) {
            Assert.assertEquals((double)((DoubleSummary)it.getSummary()).getValue(), (double)1.0);
            ++count;
        }
        Assert.assertEquals((int)count, (int)4096);
    }

    @Test(groups={"check_cpp_historical_files"})
    public void version2Compatibility() throws IOException {
        byte[] byteArr = Files.readAllBytes(TestUtil.cppHistPath.resolve("TupleWithTestIntegerSummary4kTrimmedSerVer2.sk"));
        Sketch sketch1 = Sketches.heapifySketch((Memory)Memory.wrap((byte[])byteArr), (SummaryDeserializer)new IntegerSummaryDeserializer());
        int lgK = 12;
        int K = 4096;
        UpdatableSketchBuilder builder = new UpdatableSketchBuilder((SummaryFactory)new IntegerSummaryFactory());
        UpdatableSketch updatableSketch = builder.build();
        for (int i = 0; i < 8192; ++i) {
            updatableSketch.update((long)i, (Object)1);
        }
        updatableSketch.trim();
        CompactSketch sketch2 = updatableSketch.compact();
        Assert.assertEquals((int)sketch1.getRetainedEntries(), (int)sketch2.getRetainedEntries());
        Assert.assertEquals((long)sketch1.getThetaLong(), (long)sketch2.getThetaLong());
        Assert.assertEquals((boolean)sketch1.isEmpty(), (boolean)sketch2.isEmpty());
        Assert.assertEquals((boolean)sketch1.isEstimationMode(), (boolean)sketch2.isEstimationMode());
    }

    @Test(groups={"check_cpp_files"})
    public void deserializeFromCppIntegerSummary() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            byte[] bytes = Files.readAllBytes(TestUtil.cppPath.resolve("tuple_int_n" + n + "_cpp.sk"));
            Sketch sketch = Sketches.heapifySketch((Memory)Memory.wrap((byte[])bytes), (SummaryDeserializer)new IntegerSummaryDeserializer());
            Assert.assertTrue((boolean)(n == 0 ? sketch.isEmpty() : !sketch.isEmpty()));
            Assert.assertTrue((boolean)(n > 1000 ? sketch.isEstimationMode() : !sketch.isEstimationMode()));
            Assert.assertEquals((double)sketch.getEstimate(), (double)n, (double)((double)n * 0.03));
            TupleSketchIterator it = sketch.iterator();
            while (it.next()) {
                Assert.assertTrue((it.getHash() < sketch.getThetaLong() ? 1 : 0) != 0);
                Assert.assertTrue((((IntegerSummary)it.getSummary()).getValue() < n ? 1 : 0) != 0);
            }
        }
    }

    @Test(groups={"generate_java_files"})
    public void generateForCppIntegerSummary() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            UpdatableSketch sk = new UpdatableSketchBuilder((SummaryFactory)new IntegerSummaryFactory()).build();
            for (int i = 0; i < n; ++i) {
                sk.update((long)i, (Object)i);
            }
            Files.newOutputStream(TestUtil.javaPath.resolve("tuple_int_n" + n + "_java.sk"), new OpenOption[0]).write(sk.compact().toByteArray());
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class}, groups={"check_cpp_historical_files"})
    public void noSupportHeapifyV0_9_1() throws Exception {
        byte[] byteArr = Files.readAllBytes(TestUtil.cppHistPath.resolve("ArrayOfDoublesUnion_v0.9.1.sk"));
        ArrayOfDoublesUnion.heapify((Memory)Memory.wrap((byte[])byteArr));
    }

    @Test(expectedExceptions={SketchesArgumentException.class}, groups={"check_cpp_historical_files"})
    public void noSupportWrapV0_9_1() throws Exception {
        byte[] byteArr = Files.readAllBytes(TestUtil.cppHistPath.resolve("ArrayOfDoublesUnion_v0.9.1.sk"));
        ArrayOfDoublesUnion.wrap((WritableMemory)WritableMemory.writableWrap((byte[])byteArr));
    }
}

