/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.ClassicUtil;
import org.apache.datasketches.quantiles.DoublesMergeImpl;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchAccessor;
import org.apache.datasketches.quantiles.DoublesSketchBuilder;
import org.apache.datasketches.quantiles.DoublesUnion;
import org.apache.datasketches.quantiles.DoublesUtil;
import org.apache.datasketches.quantiles.HeapUpdateDoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesUtil;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HeapUpdateDoublesSketchTest {
    @BeforeMethod
    public void setUp() {
        DoublesSketch.rand.setSeed(32749L);
    }

    @Test
    public void checkEndToEnd() {
        int n;
        int k = 256;
        UpdateDoublesSketch qs = DoublesSketch.builder().setK(k).build();
        UpdateDoublesSketch qs2 = DoublesSketch.builder().setK(k).build();
        for (int item = n = 1000000; item >= 1; --item) {
            if (item % 4 == 0) {
                qs.update((double)item);
                continue;
            }
            qs2.update((double)item);
        }
        Assert.assertEquals((long)(qs.getN() + qs2.getN()), (long)n);
        DoublesUnion union = DoublesUnion.heapify((DoublesSketch)qs);
        union.union((DoublesSketch)qs2);
        UpdateDoublesSketch result = union.getResult();
        int numPhiValues = 99;
        double[] phiArr = new double[numPhiValues];
        for (int q = 1; q <= 99; ++q) {
            phiArr[q - 1] = (double)q / 100.0;
        }
        double[] splitPoints = result.getQuantiles(phiArr);
        for (int q = 1; q <= 99; ++q) {
            double reported = splitPoints[q - 1];
            double nominal = 1000000.0 * (double)q / 100.0;
            Assert.assertTrue((reported >= nominal - 10000.0 ? 1 : 0) != 0);
            Assert.assertTrue((reported <= nominal + 10000.0 ? 1 : 0) != 0);
        }
        double[] pmfResult = result.getPMF(splitPoints);
        double subtotal = 0.0;
        for (int q = 1; q <= 100; ++q) {
            double phi = (double)q / 100.0;
            Assert.assertTrue(((subtotal += pmfResult[q - 1]) >= phi - 0.01 ? 1 : 0) != 0);
            Assert.assertTrue((subtotal <= phi + 0.01 ? 1 : 0) != 0);
        }
        double[] cdfResult = result.getCDF(splitPoints);
        for (int q = 1; q <= 100; ++q) {
            subtotal = cdfResult[q - 1];
            double phi = (double)q / 100.0;
            Assert.assertTrue((subtotal >= phi - 0.01 ? 1 : 0) != 0);
            Assert.assertTrue((subtotal <= phi + 0.01 ? 1 : 0) != 0);
        }
        Assert.assertEquals((double)result.getRank(500000.0), (double)0.5, (double)0.01);
    }

    @Test
    public void checkSmallMinMax() {
        int k = 32;
        int n = 8;
        UpdateDoublesSketch qs1 = DoublesSketch.builder().setK(k).build();
        UpdateDoublesSketch qs2 = DoublesSketch.builder().setK(k).build();
        UpdateDoublesSketch qs3 = DoublesSketch.builder().setK(k).build();
        for (int i = n; i >= 1; --i) {
            qs1.update((double)i);
            qs2.update((double)(10 + i));
            qs3.update((double)i);
        }
        Assert.assertEquals((double)qs1.getQuantile(0.0, QuantileSearchCriteria.EXCLUSIVE), (double)1.0);
        Assert.assertEquals((double)qs1.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE), (double)5.0);
        Assert.assertEquals((double)qs1.getQuantile(1.0, QuantileSearchCriteria.EXCLUSIVE), (double)8.0);
        Assert.assertEquals((double)qs2.getQuantile(0.0, QuantileSearchCriteria.EXCLUSIVE), (double)11.0);
        Assert.assertEquals((double)qs2.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE), (double)15.0);
        Assert.assertEquals((double)qs2.getQuantile(1.0, QuantileSearchCriteria.EXCLUSIVE), (double)18.0);
        Assert.assertEquals((double)qs3.getQuantile(0.0, QuantileSearchCriteria.EXCLUSIVE), (double)1.0);
        Assert.assertEquals((double)qs3.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE), (double)5.0);
        Assert.assertEquals((double)qs3.getQuantile(1.0, QuantileSearchCriteria.EXCLUSIVE), (double)8.0);
        double[] queries = new double[]{0.0, 0.5, 1.0};
        double[] resultsA = qs1.getQuantiles(queries, QuantileSearchCriteria.EXCLUSIVE);
        Assert.assertEquals((double)resultsA[0], (double)1.0);
        Assert.assertEquals((double)resultsA[1], (double)5.0);
        Assert.assertEquals((double)resultsA[2], (double)8.0);
        DoublesUnion union1 = DoublesUnion.heapify((DoublesSketch)qs1);
        union1.union((DoublesSketch)qs2);
        UpdateDoublesSketch result1 = union1.getResult();
        DoublesUnion union2 = DoublesUnion.heapify((DoublesSketch)qs2);
        union2.union((DoublesSketch)qs3);
        UpdateDoublesSketch result2 = union2.getResult();
        double[] resultsB = result1.getQuantiles(queries, QuantileSearchCriteria.EXCLUSIVE);
        Assert.assertEquals((double)resultsB[0], (double)1.0);
        Assert.assertEquals((double)resultsB[1], (double)11.0);
        Assert.assertEquals((double)resultsB[2], (double)18.0);
        double[] resultsC = result2.getQuantiles(queries, QuantileSearchCriteria.EXCLUSIVE);
        Assert.assertEquals((double)resultsC[0], (double)1.0);
        Assert.assertEquals((double)resultsC[1], (double)11.0);
        Assert.assertEquals((double)resultsC[2], (double)18.0);
    }

    @Test
    public void checkMisc() {
        int k = 128;
        int n = 10000;
        UpdateDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(k, n);
        qs.update(Double.NaN);
        int n2 = (int)qs.getN();
        Assert.assertEquals((int)n2, (int)n);
        qs.reset();
        Assert.assertEquals((long)qs.getN(), (long)0L);
    }

    @Test
    public void checkToStringDetail() {
        int k = 128;
        int n = 1000000;
        UpdateDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(k, 0);
        String s = qs.toString();
        s = qs.toString(false, true);
        qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(k, n);
        s = qs.toString();
        s = qs.toString(false, true);
        int n2 = (int)qs.getN();
        Assert.assertEquals((int)n2, (int)n);
        qs.update(Double.NaN);
        qs.reset();
        Assert.assertEquals((long)qs.getN(), (long)0L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkConstructorException() {
        DoublesSketch.builder().setK(0).build();
    }

    @Test
    public void checkPreLongsFlagsAndSize() {
        UpdateDoublesSketch ds = DoublesSketch.builder().build();
        byte[] byteArr = ds.toByteArray(true);
        Assert.assertEquals((int)byteArr.length, (int)8);
        byteArr = ds.toByteArray(false);
        Assert.assertEquals((int)byteArr.length, (int)8);
        Assert.assertEquals((int)byteArr[3], (int)4);
        ds.update(1.0);
        byteArr = ds.toByteArray(true);
        Assert.assertEquals((int)byteArr.length, (int)40);
        byteArr = ds.toByteArray(false);
        Assert.assertEquals((int)byteArr.length, (int)64);
    }

    @Test
    public void checkPreLongsFlagsSerVerB() {
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer((int)4, (int)1, (int)1);
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer((int)0, (int)1, (int)5);
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer((int)4, (int)2, (int)1);
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer((int)0, (int)2, (int)2);
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer((int)12, (int)3, (int)1);
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer((int)12, (int)3, (int)2);
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer((int)4, (int)3, (int)2);
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer((int)8, (int)3, (int)2);
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer((int)0, (int)3, (int)2);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkPreLongsFlagsSerVer3() {
        HeapUpdateDoublesSketch.checkPreLongsFlagsSerVer((int)4, (int)1, (int)2);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkGetQuantiles() {
        int k = 128;
        int n = 1000000;
        UpdateDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(k, n);
        double[] frac = new double[]{-0.5};
        qs.getQuantiles(frac);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkGetQuantile() {
        int k = 128;
        int n = 1000000;
        UpdateDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(k, n);
        double frac = -0.5;
        qs.getQuantile(frac);
    }

    public void summaryCheckViaMemory() {
        UpdateDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(256, 1000000);
        String s = qs.toString();
        HeapUpdateDoublesSketchTest.println(s);
        HeapUpdateDoublesSketchTest.println("");
        WritableMemory srcMem = WritableMemory.writableWrap((byte[])qs.toByteArray());
        HeapUpdateDoublesSketch qs2 = HeapUpdateDoublesSketch.heapifyInstance((Memory)srcMem);
        s = qs2.toString();
        HeapUpdateDoublesSketchTest.println(s);
    }

    @Test
    public void checkComputeNumLevelsNeeded() {
        int n = 0x100000;
        int k = 128;
        int lvls1 = ClassicUtil.computeNumLevelsNeeded((int)k, (long)n);
        int lvls2 = (int)Math.max(Math.floor(Util.log2((double)((double)n / (double)k))), 0.0);
        Assert.assertEquals((int)lvls1, (int)lvls2);
    }

    @Test
    public void checkComputeBitPattern() {
        int n = 0x100000;
        int k = 128;
        long bitP = ClassicUtil.computeBitPattern((int)k, (long)n);
        Assert.assertEquals((long)bitP, (long)((long)n / (2L * (long)k)));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkValidateSplitPointsOrder() {
        double[] arr = new double[]{2.0, 1.0};
        QuantilesUtil.checkDoublesSplitPointsOrder((double[])arr);
    }

    @Test
    public void checkGetStorageBytes() {
        int k = 128;
        UpdateDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(k, 0);
        int stor = qs.getCurrentCompactSerializedSizeBytes();
        Assert.assertEquals((int)stor, (int)8);
        qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(k, 2 * k);
        stor = qs.getCurrentCompactSerializedSizeBytes();
        int retItems = ClassicUtil.computeRetainedItems((int)k, (long)(2 * k));
        Assert.assertEquals((int)stor, (int)(32 + (retItems << 3)));
        qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(k, 2 * k - 1);
        stor = qs.getCurrentCompactSerializedSizeBytes();
        retItems = ClassicUtil.computeRetainedItems((int)k, (long)(2 * k - 1));
        Assert.assertEquals((int)stor, (int)(32 + (retItems << 3)));
    }

    @Test
    public void checkGetStorageBytes2() {
        int k = 128;
        long v = 1L;
        UpdateDoublesSketch qs = DoublesSketch.builder().setK(k).build();
        for (int i = 0; i < 1000; ++i) {
            qs.update((double)v++);
            byte[] byteArr = qs.toByteArray(false);
            Assert.assertEquals((int)byteArr.length, (int)qs.getCurrentUpdatableSerializedSizeBytes());
        }
    }

    @Test
    public void checkMerge() {
        int k = 128;
        int n = 1000000;
        UpdateDoublesSketch qs1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(k, n, 0);
        UpdateDoublesSketch qs2 = HeapUpdateDoublesSketchTest.buildAndLoadQS(k, 0, 0);
        DoublesUnion union = DoublesUnion.heapify((DoublesSketch)qs2);
        union.union((DoublesSketch)qs1);
        UpdateDoublesSketch result = union.getResult();
        double med1 = qs1.getQuantile(0.5);
        double med2 = result.getQuantile(0.5);
        Assert.assertEquals((double)med1, (double)med2, (double)0.0);
    }

    @Test
    public void checkReverseMerge() {
        int k = 128;
        UpdateDoublesSketch qs1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(k, 1000, 0);
        UpdateDoublesSketch qs2 = HeapUpdateDoublesSketchTest.buildAndLoadQS(2 * k, 1000, 1000);
        DoublesUnion union = DoublesUnion.heapify((DoublesSketch)qs2);
        union.union((DoublesSketch)qs1);
        UpdateDoublesSketch result = union.getResult();
        Assert.assertEquals((int)result.getK(), (int)k);
    }

    @Test
    public void checkInternalBuildHistogram() {
        int k = 128;
        int n = 1000000;
        UpdateDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(k, n, 0);
        double eps = qs.getNormalizedRankError(true);
        double[] spts = new double[]{100000.0, 500000.0, 900000.0};
        double[] fracArr = qs.getPMF(spts);
        Assert.assertEquals((double)fracArr[0], (double)0.1, (double)eps);
        Assert.assertEquals((double)fracArr[1], (double)0.4, (double)eps);
        Assert.assertEquals((double)fracArr[2], (double)0.4, (double)eps);
        Assert.assertEquals((double)fracArr[3], (double)0.1, (double)eps);
    }

    @Test
    public void checkComputeBaseBufferCount() {
        int n = 0x100000;
        int k = 128;
        long bbCnt = ClassicUtil.computeBaseBufferItems((int)k, (long)n);
        Assert.assertEquals((long)bbCnt, (long)((long)n % (2L * (long)k)));
    }

    @Test
    public void checkToFromByteArray() {
        HeapUpdateDoublesSketchTest.checkToFromByteArray2(128, 1300);
        HeapUpdateDoublesSketchTest.checkToFromByteArray2(4, 7);
        HeapUpdateDoublesSketchTest.checkToFromByteArray2(4, 8);
        HeapUpdateDoublesSketchTest.checkToFromByteArray2(4, 9);
    }

    private static void checkToFromByteArray2(int k, int n) {
        double f;
        UpdateDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(k, n);
        byte[] byteArr = qs.toByteArray(true);
        Memory mem = Memory.wrap((byte[])byteArr);
        UpdateDoublesSketch qs2 = UpdateDoublesSketch.heapify((Memory)mem);
        for (double f2 = 0.1; f2 < 0.95; f2 += 0.1) {
            Assert.assertEquals((double)qs.getQuantile(f2), (double)qs2.getQuantile(f2), (double)0.0);
        }
        byteArr = qs.toByteArray(false);
        mem = Memory.wrap((byte[])byteArr);
        qs2 = DoublesSketch.heapify((Memory)mem);
        DoublesSketchAccessor dsa = DoublesSketchAccessor.wrap((DoublesSketch)qs2);
        dsa.sort();
        for (f = 0.1; f < 0.95; f += 0.1) {
            Assert.assertEquals((double)qs.getQuantile(f), (double)qs2.getQuantile(f), (double)0.0);
        }
        byteArr = qs.toByteArray(false);
        mem = Memory.wrap((byte[])byteArr);
        qs2 = DoublesSketch.heapify((Memory)mem);
        for (f = 0.1; f < 0.95; f += 0.1) {
            Assert.assertEquals((double)qs.getQuantile(f), (double)qs2.getQuantile(f), (double)0.0);
        }
    }

    @Test
    public void checkEmpty() {
        int k = 128;
        UpdateDoublesSketch qs1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(k, 0);
        byte[] byteArr = qs1.toByteArray();
        Memory mem = Memory.wrap((byte[])byteArr);
        DoublesSketch qs2 = DoublesSketch.heapify((Memory)mem);
        Assert.assertTrue((boolean)qs2.isEmpty());
        int expectedSizeBytes = 8;
        Assert.assertEquals((int)byteArr.length, (int)8);
        try {
            qs2.getQuantile(0.5);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            qs2.getQuantiles(new double[]{0.0, 0.5, 1.0});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            qs2.getRank(0.0);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkMemTooSmall1() {
        Memory mem = Memory.wrap((byte[])new byte[7]);
        HeapUpdateDoublesSketch.heapifyInstance((Memory)mem);
        Assert.fail();
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkSerVer() {
        DoublesUtil.checkDoublesSerVer((int)0, (int)1);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkFamilyID() {
        ClassicUtil.checkFamilyID((int)3);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkMemCapacityException() {
        int k = 128;
        long n = 1000L;
        int serVer = 3;
        int combBufItemCap = ClassicUtil.computeCombinedBufferItemCapacity((int)k, (long)n);
        int memCapBytes = combBufItemCap + 4 << 3;
        int badCapBytes = memCapBytes - 1;
        HeapUpdateDoublesSketch.checkHeapMemCapacity((int)k, (long)n, (boolean)false, (int)serVer, (long)badCapBytes);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBufAllocAndCap() {
        int k = 128;
        long n = 1000L;
        int serVer = 3;
        int combBufItemCap = ClassicUtil.computeCombinedBufferItemCapacity((int)k, (long)n);
        int memCapBytes = combBufItemCap + 4 << 3;
        int memCapBytesV1 = combBufItemCap + 5 << 3;
        HeapUpdateDoublesSketch.checkHeapMemCapacity((int)k, (long)n, (boolean)false, (int)1, (long)memCapBytesV1);
        HeapUpdateDoublesSketch.checkHeapMemCapacity((int)k, (long)n, (boolean)false, (int)serVer, (long)(memCapBytes - 1));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkPreLongsFlagsCap() {
        int preLongs = 5;
        int flags = 4;
        int memCap = 8;
        ClassicUtil.checkPreLongsFlagsCap((int)preLongs, (int)flags, (long)memCap);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkPreLongsFlagsCap2() {
        int preLongs = 5;
        int flags = 0;
        int memCap = 8;
        ClassicUtil.checkPreLongsFlagsCap((int)preLongs, (int)flags, (long)memCap);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkFlags() {
        int flags = 1;
        ClassicUtil.checkHeapFlags((int)flags);
    }

    @Test
    public void checkZeroPatternReturn() {
        int k = 128;
        UpdateDoublesSketch qs1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(k, 64);
        byte[] byteArr = qs1.toByteArray();
        Memory mem = Memory.wrap((byte[])byteArr);
        HeapUpdateDoublesSketch.heapifyInstance((Memory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadDownSamplingRatio() {
        int k1 = 64;
        UpdateDoublesSketch qs1 = HeapUpdateDoublesSketchTest.buildAndLoadQS(k1, k1);
        qs1.downSample((DoublesSketch)qs1, 2 * k1, null);
    }

    @Test
    public void checkImproperKvalues() {
        HeapUpdateDoublesSketchTest.checksForImproperK(0);
        HeapUpdateDoublesSketchTest.checksForImproperK(65536);
    }

    static void testDownSampling(int bigK, int smallK) {
        HeapUpdateDoublesSketch sketch1 = HeapUpdateDoublesSketch.newInstance((int)bigK);
        HeapUpdateDoublesSketch sketch2 = HeapUpdateDoublesSketch.newInstance((int)smallK);
        for (int i = 127; i >= 1; --i) {
            sketch1.update((double)i);
            sketch2.update((double)i);
        }
        HeapUpdateDoublesSketch downSketch = (HeapUpdateDoublesSketch)sketch1.downSample((DoublesSketch)sketch1, smallK, null);
        HeapUpdateDoublesSketchTest.println(ClassicUtil.LS + "Sk1" + ClassicUtil.LS);
        String s1 = sketch1.toString(true, true);
        HeapUpdateDoublesSketchTest.println(s1);
        HeapUpdateDoublesSketchTest.println(ClassicUtil.LS + "Down" + ClassicUtil.LS);
        String down = downSketch.toString(true, true);
        HeapUpdateDoublesSketchTest.println(down);
        HeapUpdateDoublesSketchTest.println(ClassicUtil.LS + "Sk2" + ClassicUtil.LS);
        String s2 = sketch2.toString(true, true);
        HeapUpdateDoublesSketchTest.println(s2);
        Assert.assertEquals((int)downSketch.getNumRetained(), (int)sketch2.getNumRetained());
    }

    @Test
    public void checkDownSampling() {
        HeapUpdateDoublesSketchTest.testDownSampling(4, 4);
        HeapUpdateDoublesSketchTest.testDownSampling(16, 4);
    }

    @Test
    public void testDownSampling2() {
        HeapUpdateDoublesSketch sketch1 = HeapUpdateDoublesSketch.newInstance((int)8);
        HeapUpdateDoublesSketch sketch2 = HeapUpdateDoublesSketch.newInstance((int)2);
        DoublesSketch downSketch = sketch1.downSample((DoublesSketch)sketch1, 2, null);
        Assert.assertTrue((boolean)HeapUpdateDoublesSketchTest.sameStructurePredicate((DoublesSketch)sketch2, downSketch));
        for (int i = 0; i < 50; ++i) {
            sketch1.update((double)i);
            sketch2.update((double)i);
            downSketch = sketch1.downSample((DoublesSketch)sketch1, 2, null);
            Assert.assertTrue((boolean)HeapUpdateDoublesSketchTest.sameStructurePredicate((DoublesSketch)sketch2, downSketch));
        }
    }

    @Test
    public void testDownSampling3() {
        int k1 = 8;
        int k2 = 2;
        int n = 50;
        UpdateDoublesSketch sketch1 = DoublesSketch.builder().setK(k1).build();
        UpdateDoublesSketch sketch2 = DoublesSketch.builder().setK(k2).build();
        for (int i = 0; i < n; ++i) {
            sketch1.update((double)i);
            sketch2.update((double)i);
            DoublesSketch downSketch = sketch1.downSample((DoublesSketch)sketch1, k2, null);
            Assert.assertTrue((boolean)HeapUpdateDoublesSketchTest.sameStructurePredicate((DoublesSketch)sketch2, downSketch));
        }
    }

    @Test
    public void testDownSampling3withMem() {
        int k1 = 8;
        int k2 = 2;
        int n = 50;
        UpdateDoublesSketch sketch1 = DoublesSketch.builder().setK(k1).build();
        UpdateDoublesSketch sketch2 = DoublesSketch.builder().setK(k2).build();
        int bytes = DoublesSketch.getUpdatableStorageBytes((int)k2, (long)n);
        WritableMemory mem = WritableMemory.writableWrap((byte[])new byte[bytes]);
        for (int i = 0; i < n; ++i) {
            sketch1.update((double)i);
            sketch2.update((double)i);
            DoublesSketch downSketch = sketch1.downSample((DoublesSketch)sketch1, k2, mem);
            Assert.assertTrue((boolean)HeapUpdateDoublesSketchTest.sameStructurePredicate((DoublesSketch)sketch2, downSketch));
        }
    }

    @Test
    public void testDownSampling4() {
        for (int n1 = 0; n1 < 50; ++n1) {
            HeapUpdateDoublesSketch bigSketch = HeapUpdateDoublesSketch.newInstance((int)8);
            for (int i1 = 1; i1 <= n1; ++i1) {
                bigSketch.update((double)i1);
            }
            for (int n2 = 0; n2 < 50; ++n2) {
                HeapUpdateDoublesSketch directSketch = HeapUpdateDoublesSketch.newInstance((int)2);
                for (int i1 = 1; i1 <= n1; ++i1) {
                    directSketch.update((double)i1);
                }
                for (int i2 = 1; i2 <= n2; ++i2) {
                    directSketch.update((double)i2);
                }
                HeapUpdateDoublesSketch smlSketch = HeapUpdateDoublesSketch.newInstance((int)2);
                for (int i2 = 1; i2 <= n2; ++i2) {
                    smlSketch.update((double)i2);
                }
                DoublesMergeImpl.downSamplingMergeInto((DoublesSketch)bigSketch, (UpdateDoublesSketch)smlSketch);
                Assert.assertTrue((boolean)HeapUpdateDoublesSketchTest.sameStructurePredicate((DoublesSketch)directSketch, (DoublesSketch)smlSketch));
            }
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void testDownSamplingExceptions1() {
        UpdateDoublesSketch qs1 = DoublesSketch.builder().setK(4).build();
        UpdateDoublesSketch qs2 = DoublesSketch.builder().setK(3).build();
        DoublesMergeImpl.mergeInto((DoublesSketch)qs2, (UpdateDoublesSketch)qs1);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void testDownSamplingExceptions2() {
        UpdateDoublesSketch qs1 = DoublesSketch.builder().setK(4).build();
        UpdateDoublesSketch qs2 = DoublesSketch.builder().setK(7).build();
        DoublesMergeImpl.mergeInto((DoublesSketch)qs2, (UpdateDoublesSketch)qs1);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void testDownSamplingExceptions3() {
        UpdateDoublesSketch qs1 = DoublesSketch.builder().setK(4).build();
        UpdateDoublesSketch qs2 = DoublesSketch.builder().setK(12).build();
        DoublesMergeImpl.mergeInto((DoublesSketch)qs2, (UpdateDoublesSketch)qs1);
    }

    public void quantilesCheckViaMemory() {
        int k = 256;
        int n = 1000000;
        UpdateDoublesSketch qs = HeapUpdateDoublesSketchTest.buildAndLoadQS(k, n);
        double[] ranks = new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0};
        String s = HeapUpdateDoublesSketchTest.getRanksTable((DoublesSketch)qs, ranks);
        HeapUpdateDoublesSketchTest.println(s);
        HeapUpdateDoublesSketchTest.println("");
        Memory srcMem = Memory.wrap((byte[])qs.toByteArray());
        HeapUpdateDoublesSketch qs2 = HeapUpdateDoublesSketch.heapifyInstance((Memory)srcMem);
        HeapUpdateDoublesSketchTest.println(HeapUpdateDoublesSketchTest.getRanksTable((DoublesSketch)qs2, ranks));
    }

    static String getRanksTable(DoublesSketch qs, double[] ranks) {
        double rankError = qs.getNormalizedRankError(false);
        double[] values = qs.getQuantiles(ranks);
        double maxV = qs.getMaxItem();
        double minV = qs.getMinItem();
        double delta = maxV - minV;
        HeapUpdateDoublesSketchTest.println("Note: This prints the relative value errors for illustration.");
        HeapUpdateDoublesSketchTest.println("The quantiles sketch does not and can not guarantee relative value errors");
        StringBuilder sb = new StringBuilder();
        sb.append(ClassicUtil.LS);
        sb.append("N = ").append(qs.getN()).append(ClassicUtil.LS);
        sb.append("K = ").append(qs.getK()).append(ClassicUtil.LS);
        String formatStr1 = "%10s%15s%10s%15s%10s%10s";
        String formatStr2 = "%10.1f%15.5f%10.0f%15.5f%10.5f%10.5f";
        String hdr = String.format(formatStr1, "Rank", "ValueLB", "<= Value", "<= ValueUB", "RelErrLB", "RelErrUB");
        sb.append(hdr).append(ClassicUtil.LS);
        for (int i = 0; i < ranks.length; ++i) {
            double rank = ranks[i];
            double value = values[i];
            if (rank == 0.0) {
                Assert.assertEquals((double)value, (double)minV, (double)0.0);
                continue;
            }
            if (rank == 1.0) {
                Assert.assertEquals((double)value, (double)maxV, (double)0.0);
                continue;
            }
            double rankUB = rank + rankError;
            double valueUB = minV + delta * rankUB;
            double rankLB = Math.max(rank - rankError, 0.0);
            double valueLB = minV + delta * rankLB;
            Assert.assertTrue((value < valueUB ? 1 : 0) != 0);
            Assert.assertTrue((value > valueLB ? 1 : 0) != 0);
            double valRelPctErrUB = valueUB / value - 1.0;
            double valRelPctErrLB = valueLB / value - 1.0;
            String row = String.format(formatStr2, rank, valueLB, value, valueUB, valRelPctErrLB, valRelPctErrUB);
            sb.append(row).append(ClassicUtil.LS);
        }
        return sb.toString();
    }

    @Test
    public void checkKisTwo() {
        int k = 2;
        UpdateDoublesSketch qs1 = DoublesSketch.builder().setK(k).build();
        double err = qs1.getNormalizedRankError(false);
        Assert.assertTrue((err < 1.0 ? 1 : 0) != 0);
        byte[] arr = qs1.toByteArray(true);
        Assert.assertEquals((int)arr.length, (int)DoublesSketch.getCompactSerialiedSizeBytes((int)k, (long)0L));
        qs1.update(1.0);
        arr = qs1.toByteArray(true);
        Assert.assertEquals((int)arr.length, (int)DoublesSketch.getCompactSerialiedSizeBytes((int)k, (long)1L));
    }

    @Test
    public void checkKisTwoDeprecated() {
        int k = 2;
        UpdateDoublesSketch qs1 = DoublesSketch.builder().setK(k).build();
        double err = qs1.getNormalizedRankError(false);
        Assert.assertTrue((err < 1.0 ? 1 : 0) != 0);
        byte[] arr = qs1.toByteArray(true);
        Assert.assertEquals((int)arr.length, (int)DoublesSketch.getCompactSerialiedSizeBytes((int)k, (long)0L));
        Assert.assertEquals((int)arr.length, (int)qs1.getCurrentCompactSerializedSizeBytes());
        qs1.update(1.0);
        arr = qs1.toByteArray(true);
        Assert.assertEquals((int)arr.length, (int)DoublesSketch.getCompactSerialiedSizeBytes((int)k, (long)1L));
        Assert.assertEquals((int)arr.length, (int)qs1.getCurrentCompactSerializedSizeBytes());
    }

    @Test
    public void checkPutMemory() {
        UpdateDoublesSketch qs1 = DoublesSketch.builder().build();
        for (int i = 0; i < 1000; ++i) {
            qs1.update((double)i);
        }
        int bytes = qs1.getCurrentUpdatableSerializedSizeBytes();
        WritableMemory dstMem = WritableMemory.writableWrap((byte[])new byte[bytes]);
        qs1.putMemory(dstMem, false);
        WritableMemory srcMem = dstMem;
        DoublesSketch qs2 = DoublesSketch.heapify((Memory)srcMem);
        Assert.assertEquals((double)qs1.getMinItem(), (double)qs2.getMinItem(), (double)0.0);
        Assert.assertEquals((double)qs1.getMaxItem(), (double)qs2.getMaxItem(), (double)0.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkPutMemoryTooSmall() {
        UpdateDoublesSketch qs1 = DoublesSketch.builder().build();
        for (int i = 0; i < 1000; ++i) {
            qs1.update((double)i);
        }
        int bytes = qs1.getCurrentCompactSerializedSizeBytes();
        WritableMemory dstMem = WritableMemory.writableWrap((byte[])new byte[bytes - 1]);
        qs1.putMemory(dstMem);
    }

    @Test
    public void testIt() {
        ByteBuffer bb = ByteBuffer.allocate(0x100000).order(ByteOrder.nativeOrder());
        WritableMemory mem = WritableMemory.writableWrap((ByteBuffer)bb);
        int k = 1024;
        UpdateDoublesSketch qsk = new DoublesSketchBuilder().setK(k).build();
        DoublesUnion u1 = DoublesUnion.heapify((DoublesSketch)qsk);
        u1.getResult().putMemory(mem);
        DoublesUnion u2 = DoublesUnion.heapify((Memory)mem);
        UpdateDoublesSketch qsk2 = u2.getResult();
        Assert.assertTrue((boolean)qsk2.isEmpty());
    }

    @Test
    public void checkEvenlySpacedQuantiles() {
        UpdateDoublesSketch qsk = HeapUpdateDoublesSketchTest.buildAndLoadQS(32, 1001);
        double[] values = qsk.getPartitionBoundaries((int)10).boundaries;
        for (int i = 0; i < values.length; ++i) {
            HeapUpdateDoublesSketchTest.println("" + values[i]);
        }
        Assert.assertEquals((int)values.length, (int)11);
    }

    @Test
    public void getQuantiles() {
        UpdateDoublesSketch sketch = HeapUpdateDoublesSketchTest.buildAndLoadQS(32, 0);
        sketch.update(1.0);
        sketch.update(2.0);
        sketch.update(3.0);
        sketch.update(4.0);
        double[] quantiles1 = sketch.getQuantiles(new double[]{0.0, 0.5, 1.0}, QuantileSearchCriteria.EXCLUSIVE);
        double[] quantiles2 = sketch.getPartitionBoundaries((int)2, (QuantileSearchCriteria)QuantileSearchCriteria.EXCLUSIVE).boundaries;
        Assert.assertEquals((double[])quantiles1, (double[])quantiles2);
        quantiles1 = sketch.getQuantiles(new double[]{0.0, 0.5, 1.0}, QuantileSearchCriteria.INCLUSIVE);
        quantiles2 = sketch.getPartitionBoundaries((int)2, (QuantileSearchCriteria)QuantileSearchCriteria.INCLUSIVE).boundaries;
        Assert.assertEquals((double[])quantiles1, (double[])quantiles2);
    }

    @Test
    public void checkEquallySpacedRanks() {
        int n = 10;
        double[] es = QuantilesUtil.equallyWeightedRanks((int)n);
        int len = es.length;
        for (int j = 0; j < len; ++j) {
            double f = es[j];
            Assert.assertEquals((double)f, (double)((double)j / 10.0), (double)((double)j / 10.0 * 0.001));
            HeapUpdateDoublesSketchTest.print(es[j] + ", ");
        }
        HeapUpdateDoublesSketchTest.println("");
    }

    @Test
    public void checkPMFonEmpty() {
        UpdateDoublesSketch qsk = HeapUpdateDoublesSketchTest.buildAndLoadQS(32, 1001);
        double[] array = new double[]{};
        double[] qOut = qsk.getQuantiles(array);
        Assert.assertEquals((int)qOut.length, (int)0);
        HeapUpdateDoublesSketchTest.println("qOut: " + qOut.length);
        double[] cdfOut = qsk.getCDF(array);
        HeapUpdateDoublesSketchTest.println("cdfOut: " + cdfOut.length);
        Assert.assertEquals((double)cdfOut[0], (double)1.0, (double)0.0);
    }

    @Test
    public void checkPuts() {
        long n1 = 1001L;
        UpdateDoublesSketch qsk = HeapUpdateDoublesSketchTest.buildAndLoadQS(32, (int)n1);
        long n2 = qsk.getN();
        Assert.assertEquals((long)n2, (long)n1);
        int bbCnt1 = qsk.getBaseBufferCount();
        long pat1 = qsk.getBitPattern();
        qsk.putBitPattern(pat1 + 1L);
        long pat2 = qsk.getBitPattern();
        Assert.assertEquals((long)(pat1 + 1L), (long)pat2);
        qsk.putBaseBufferCount(bbCnt1 + 1);
        int bbCnt2 = qsk.getBaseBufferCount();
        Assert.assertEquals((int)(bbCnt1 + 1), (int)bbCnt2);
        qsk.putN(n1 + 1L);
        long n3 = qsk.getN();
        Assert.assertEquals((long)(n1 + 1L), (long)n3);
        Assert.assertNull((Object)qsk.getMemory());
    }

    @Test
    public void serializeDeserializeCompact() {
        UpdateDoublesSketch sketch1 = DoublesSketch.builder().build();
        for (int i = 0; i < 1000; ++i) {
            sketch1.update((double)i);
        }
        UpdateDoublesSketch sketch2 = (UpdateDoublesSketch)DoublesSketch.heapify((Memory)Memory.wrap((byte[])sketch1.toByteArray()));
        for (int i = 0; i < 1000; ++i) {
            sketch2.update((double)(i + 1000));
        }
        Assert.assertEquals((double)sketch2.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch2.getMaxItem(), (double)1999.0);
        Assert.assertEquals((double)sketch2.getQuantile(0.5), (double)1000.0, (double)10.0);
    }

    @Test
    public void serializeDeserializeEmptyNonCompact() {
        UpdateDoublesSketch sketch1 = DoublesSketch.builder().build();
        byte[] byteArr = sketch1.toByteArray(false);
        Assert.assertEquals((int)byteArr.length, (int)sketch1.getSerializedSizeBytes());
        Memory mem = Memory.wrap((byte[])byteArr);
        UpdateDoublesSketch sketch2 = (UpdateDoublesSketch)DoublesSketch.heapify((Memory)mem);
        for (int i = 0; i < 1000; ++i) {
            sketch2.update((double)i);
        }
        Assert.assertEquals((double)sketch2.getMinItem(), (double)0.0);
        Assert.assertEquals((double)sketch2.getMaxItem(), (double)999.0);
        Assert.assertEquals((double)sketch2.getQuantile(0.5), (double)500.0, (double)4.0);
    }

    @Test
    public void getRankAndGetCdfConsistency() {
        int i;
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        int n = 1000000;
        double[] values = new double[1000000];
        for (int i2 = 0; i2 < 1000000; ++i2) {
            sketch.update((double)i2);
            values[i2] = i2;
        }
        double[] ranks = sketch.getCDF(values);
        for (i = 0; i < 1000000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i]), (double)1.0E-5, (String)("CDF vs rank for value " + i));
        }
        ranks = sketch.getCDF(values, QuantileSearchCriteria.INCLUSIVE);
        for (i = 0; i < 1000000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(values[i], QuantileSearchCriteria.INCLUSIVE), (double)1.0E-5, (String)("CDF vs rank for value " + i));
        }
    }

    @Test
    public void maxK() {
        UpdateDoublesSketch sketch = DoublesSketch.builder().setK(32768).build();
        Assert.assertEquals((int)sketch.getK(), (int)32768);
    }

    @Test
    public void checkBounds() {
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        for (int i = 0; i < 1000; ++i) {
            sketch.update((double)i);
        }
        double eps = sketch.getNormalizedRankError(false);
        double est = sketch.getQuantile(0.5);
        double ub = sketch.getQuantileUpperBound(0.5);
        double lb = sketch.getQuantileLowerBound(0.5);
        Assert.assertEquals((double)ub, (double)sketch.getQuantile(0.5 + eps));
        Assert.assertEquals((double)lb, (double)sketch.getQuantile(0.5 - eps));
        HeapUpdateDoublesSketchTest.println("Ext     : " + est);
        HeapUpdateDoublesSketchTest.println("UB      : " + ub);
        HeapUpdateDoublesSketchTest.println("LB      : " + lb);
    }

    @Test
    public void checkGetKFromEqs() {
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        int k = sketch.getK();
        double eps = DoublesSketch.getNormalizedRankError((int)k, (boolean)false);
        double epsPmf = DoublesSketch.getNormalizedRankError((int)k, (boolean)true);
        int kEps = DoublesSketch.getKFromEpsilon((double)eps, (boolean)false);
        int kEpsPmf = DoublesSketch.getKFromEpsilon((double)epsPmf, (boolean)true);
        Assert.assertEquals((int)kEps, (int)k);
        Assert.assertEquals((int)kEpsPmf, (int)k);
    }

    @Test
    public void tenItems() {
        int i;
        int i2;
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        for (i2 = 1; i2 <= 10; ++i2) {
            sketch.update((double)i2);
        }
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)10L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)10);
        for (i2 = 1; i2 <= 10; ++i2) {
            Assert.assertEquals((double)sketch.getRank((double)i2, QuantileSearchCriteria.EXCLUSIVE), (double)((double)(i2 - 1) / 10.0));
            Assert.assertEquals((double)sketch.getRank((double)i2, QuantileSearchCriteria.EXCLUSIVE), (double)((double)(i2 - 1) / 10.0));
            Assert.assertEquals((double)sketch.getRank((double)i2, QuantileSearchCriteria.INCLUSIVE), (double)((double)i2 / 10.0));
        }
        Assert.assertEquals((double)sketch.getQuantile(0.0, QuantileSearchCriteria.EXCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getQuantile(0.1, QuantileSearchCriteria.EXCLUSIVE), (double)2.0);
        Assert.assertEquals((double)sketch.getQuantile(0.2, QuantileSearchCriteria.EXCLUSIVE), (double)3.0);
        Assert.assertEquals((double)sketch.getQuantile(0.3, QuantileSearchCriteria.EXCLUSIVE), (double)4.0);
        Assert.assertEquals((double)sketch.getQuantile(0.4, QuantileSearchCriteria.EXCLUSIVE), (double)5.0);
        Assert.assertEquals((double)sketch.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE), (double)6.0);
        Assert.assertEquals((double)sketch.getQuantile(0.6, QuantileSearchCriteria.EXCLUSIVE), (double)7.0);
        Assert.assertEquals((double)sketch.getQuantile(0.7, QuantileSearchCriteria.EXCLUSIVE), (double)8.0);
        Assert.assertEquals((double)sketch.getQuantile(0.8, QuantileSearchCriteria.EXCLUSIVE), (double)9.0);
        Assert.assertEquals((double)sketch.getQuantile(0.9, QuantileSearchCriteria.EXCLUSIVE), (double)10.0);
        Assert.assertEquals((double)sketch.getQuantile(1.0, QuantileSearchCriteria.EXCLUSIVE), (double)10.0);
        Assert.assertEquals((double)sketch.getQuantile(0.0, QuantileSearchCriteria.INCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getQuantile(0.1, QuantileSearchCriteria.INCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getQuantile(0.2, QuantileSearchCriteria.INCLUSIVE), (double)2.0);
        Assert.assertEquals((double)sketch.getQuantile(0.3, QuantileSearchCriteria.INCLUSIVE), (double)3.0);
        Assert.assertEquals((double)sketch.getQuantile(0.4, QuantileSearchCriteria.INCLUSIVE), (double)4.0);
        Assert.assertEquals((double)sketch.getQuantile(0.5, QuantileSearchCriteria.INCLUSIVE), (double)5.0);
        Assert.assertEquals((double)sketch.getQuantile(0.6, QuantileSearchCriteria.INCLUSIVE), (double)6.0);
        Assert.assertEquals((double)sketch.getQuantile(0.7, QuantileSearchCriteria.INCLUSIVE), (double)7.0);
        Assert.assertEquals((double)sketch.getQuantile(0.8, QuantileSearchCriteria.INCLUSIVE), (double)8.0);
        Assert.assertEquals((double)sketch.getQuantile(0.9, QuantileSearchCriteria.INCLUSIVE), (double)9.0);
        Assert.assertEquals((double)sketch.getQuantile(1.0, QuantileSearchCriteria.INCLUSIVE), (double)10.0);
        double[] quantiles = sketch.getQuantiles(new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0});
        for (i = 0; i <= 10; ++i) {
            Assert.assertEquals((double)sketch.getQuantile((double)i / 10.0), (double)quantiles[i]);
        }
        quantiles = sketch.getQuantiles(new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0}, QuantileSearchCriteria.INCLUSIVE);
        for (i = 0; i <= 10; ++i) {
            Assert.assertEquals((double)sketch.getQuantile((double)i / 10.0, QuantileSearchCriteria.INCLUSIVE), (double)quantiles[i]);
        }
    }

    private static void checksForImproperK(int k) {
        String s = "Did not catch improper k: " + k;
        try {
            DoublesSketch.builder().setK(k);
            Assert.fail((String)s);
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            DoublesSketch.builder().setK(k).build();
            Assert.fail((String)s);
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            HeapUpdateDoublesSketch.newInstance((int)k);
            Assert.fail((String)s);
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    private static boolean sameStructurePredicate(DoublesSketch mq1, DoublesSketch mq2) {
        boolean b1;
        boolean bl = b1 = mq1.getK() == mq2.getK() && mq1.getN() == mq2.getN() && mq1.getCombinedBufferItemCapacity() >= ClassicUtil.computeCombinedBufferItemCapacity((int)mq1.getK(), (long)mq1.getN()) && mq2.getCombinedBufferItemCapacity() >= ClassicUtil.computeCombinedBufferItemCapacity((int)mq2.getK(), (long)mq2.getN()) && mq1.getBaseBufferCount() == mq2.getBaseBufferCount() && mq1.getBitPattern() == mq2.getBitPattern();
        boolean b2 = mq1.isEmpty() ? mq2.isEmpty() : mq1.getMinItem() == mq2.getMinItem() && mq1.getMaxItem() == mq2.getMaxItem();
        return b1 && b2;
    }

    static UpdateDoublesSketch buildAndLoadQS(int k, int n) {
        return HeapUpdateDoublesSketchTest.buildAndLoadQS(k, n, 0);
    }

    static UpdateDoublesSketch buildAndLoadQS(int k, int n, int startV) {
        UpdateDoublesSketch qs = DoublesSketch.builder().setK(k).build();
        for (int i = 1; i <= n; ++i) {
            qs.update((double)(startV + i));
        }
        return qs;
    }

    @Test
    public void printlnTest() {
        HeapUpdateDoublesSketchTest.println("PRINTING: " + this.getClass().getName());
        HeapUpdateDoublesSketchTest.print("PRINTING: " + this.getClass().getName() + ClassicUtil.LS);
    }

    static void println(String s) {
        HeapUpdateDoublesSketchTest.print(s + ClassicUtil.LS);
    }

    static void print(String s) {
    }
}

