/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDirectDoublesSketch;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllHeapDoublesSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.DoublesSortedView;
import org.apache.datasketches.quantilescommon.DoublesSortedViewIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllMiscDoublesTest {
    static final String LS = System.getProperty("line.separator");
    private final MemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();
    private static final boolean enablePrinting = false;

    @Test
    public void checkSortedViewConstruction() {
        KllDoublesSketch kll = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 20; ++i) {
            kll.update((double)i);
        }
        DoublesSortedView fsv = kll.getSortedView();
        long[] cumWeights = fsv.getCumulativeWeights();
        double[] values = fsv.getQuantiles();
        Assert.assertEquals((int)cumWeights.length, (int)20);
        Assert.assertEquals((int)values.length, (int)20);
        for (int i = 0; i < 20; ++i) {
            Assert.assertEquals((long)cumWeights[i], (long)(i + 1));
            Assert.assertEquals((double)values[i], (double)(i + 1));
        }
    }

    @Test
    public void checkBounds() {
        KllDoublesSketch kll = KllDoublesSketch.newHeapInstance();
        for (int i = 0; i < 1000; ++i) {
            kll.update((double)i);
        }
        double eps = kll.getNormalizedRankError(false);
        double est = kll.getQuantile(0.5);
        double ub = kll.getQuantileUpperBound(0.5);
        double lb = kll.getQuantileLowerBound(0.5);
        Assert.assertEquals((double)ub, (double)kll.getQuantile(0.5 + eps));
        Assert.assertEquals((double)lb, (double)kll.getQuantile(0.5 - eps));
        KllMiscDoublesTest.println("Ext     : " + est);
        KllMiscDoublesTest.println("UB      : " + ub);
        KllMiscDoublesTest.println("LB      : " + lb);
        double rest = kll.getRank(est);
        double restUB = kll.getRankUpperBound(rest);
        double restLB = kll.getRankLowerBound(rest);
        Assert.assertTrue((restUB - rest < 2.0 * eps ? 1 : 0) != 0);
        Assert.assertTrue((rest - restLB < 2.0 * eps ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions1() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(6L, (byte)3);
        KllDoublesSketch.heapify((Memory)wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions2() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(0L, (byte)1);
        KllDoublesSketch.heapify((Memory)wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions3() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        sk.update(1.0);
        sk.update(2.0);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(0L, (byte)1);
        KllDoublesSketch.heapify((Memory)wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions4() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(1L, (byte)0);
        KllDoublesSketch.heapify((Memory)wmem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyExceptions5() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])sk.toByteArray());
        wmem.putByte(2L, (byte)0);
        KllDoublesSketch.heapify((Memory)wmem);
    }

    @Test
    public void checkMisc() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)8);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        KllMiscDoublesTest.println(sk.toString(true, true));
        for (int i = 0; i < 20; ++i) {
            sk.update((double)i);
        }
        KllMiscDoublesTest.println(sk.toString(true, true));
        sk.toByteArray();
        double[] items = sk.getDoubleItemsArray();
        Assert.assertEquals((int)items.length, (int)16);
        int[] levels = sk.getLevelsArray(sk.sketchStructure);
        Assert.assertEquals((int)levels.length, (int)3);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
    }

    @Test
    public void visualCheckToString() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        int n = 21;
        for (int i = 1; i <= n; ++i) {
            sk.update((double)i);
        }
        KllMiscDoublesTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMaxItem(), (double)21.0);
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        KllDoublesSketch sk2 = KllDoublesSketch.newHeapInstance((int)20);
        n = 400;
        for (int i = 101; i <= n + 100; ++i) {
            sk2.update((double)i);
        }
        KllMiscDoublesTest.println("\n" + sk2.toString(true, true));
        Assert.assertEquals((int)sk2.getNumLevels(), (int)5);
        Assert.assertEquals((double)sk2.getMinItem(), (double)101.0);
        Assert.assertEquals((double)sk2.getMaxItem(), (double)500.0);
        Assert.assertEquals((int)sk2.getNumRetained(), (int)52);
        sk2.merge((KllSketch)sk);
        KllMiscDoublesTest.println(LS + sk2.toString(true, true));
        Assert.assertEquals((int)sk2.getNumLevels(), (int)5);
        Assert.assertEquals((double)sk2.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk2.getMaxItem(), (double)500.0);
        Assert.assertEquals((int)sk2.getNumRetained(), (int)56);
    }

    @Test
    public void viewHeapCompactions() {
        int k = 20;
        int n = 108;
        int compaction = 0;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)k);
        for (int i = 1; i <= n; ++i) {
            sk.update((double)i);
            if (sk.levelsArr[0] != 0) continue;
            KllMiscDoublesTest.println(LS + "#<<< BEFORE COMPACTION # " + ++compaction + " >>>");
            KllMiscDoublesTest.println(sk.toString(true, true));
            sk.update((double)(++i));
            KllMiscDoublesTest.println(LS + "#<<< AFTER COMPACTION  # " + compaction + " >>>");
            KllMiscDoublesTest.println(sk.toString(true, true));
            Assert.assertEquals((double)sk.getDoubleItemsArray()[sk.levelsArr[0]], (double)i);
        }
    }

    @Test
    public void viewDirectCompactions() {
        int k = 20;
        int n = 108;
        int sizeBytes = KllSketch.getMaxSerializedSizeBytes((int)k, (long)n, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        WritableMemory wmem = WritableMemory.allocate((int)sizeBytes);
        KllDoublesSketch sk = KllDoublesSketch.newDirectInstance((int)k, (WritableMemory)wmem, (MemoryRequestServer)this.memReqSvr);
        for (int i = 1; i <= n; ++i) {
            sk.update((double)i);
            if (sk.levelsArr[0] != 0) continue;
            KllMiscDoublesTest.println(sk.toString(true, true));
            sk.update((double)(++i));
            KllMiscDoublesTest.println(sk.toString(true, true));
            Assert.assertEquals((double)sk.getDoubleItemsArray()[sk.levelsArr[0]], (double)i);
        }
    }

    @Test
    public void viewCompactionAndSortedView() {
        int n = 43;
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= n; ++i) {
            sk.update((double)i);
        }
        KllMiscDoublesTest.println(sk.toString(true, true));
        DoublesSortedView sv = sk.getSortedView();
        DoublesSortedViewIterator itr = sv.iterator();
        KllMiscDoublesTest.println("### SORTED VIEW");
        KllMiscDoublesTest.printf("%12s%12s\n", "Value", "CumWeight");
        while (itr.next()) {
            double v = itr.getQuantile();
            long wt = itr.getWeight();
            KllMiscDoublesTest.printf("%12.1f%12d\n", v, wt);
        }
    }

    @Test
    public void checkGrowLevels() {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure)[2], (int)33);
    }

    @Test
    public void checkSketchInitializeDoubleHeap() {
        int k = 20;
        KllMiscDoublesTest.println("#### CASE: DOUBLE FULL HEAP");
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((double)i);
        }
        KllMiscDoublesTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((double)sk.getMaxItem(), (double)21.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscDoublesTest.println("#### CASE: DOUBLE HEAP EMPTY");
        sk = KllDoublesSketch.newHeapInstance((int)k);
        KllMiscDoublesTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscDoublesTest.println("#### CASE: DOUBLE HEAP SINGLE");
        sk = KllDoublesSketch.newHeapInstance((int)k);
        sk.update(1.0);
        KllMiscDoublesTest.println(sk.toString(true, true));
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((double)sk.getMaxItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeDoubleHeapifyCompactMem() {
        int k = 20;
        KllMiscDoublesTest.println("#### CASE: DOUBLE FULL HEAPIFIED FROM COMPACT");
        KllDoublesSketch sk2 = KllDoublesSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk2.update((double)i);
        }
        byte[] compBytes = sk2.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllMiscDoublesTest.println(KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true));
        KllDoublesSketch sk = KllDoublesSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((double)sk.getMaxItem(), (double)21.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscDoublesTest.println("#### CASE: DOUBLE EMPTY HEAPIFIED FROM COMPACT");
        sk2 = KllDoublesSketch.newHeapInstance((int)k);
        compBytes = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllDoublesSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscDoublesTest.println("#### CASE: DOUBLE SINGLE HEAPIFIED FROM COMPACT");
        sk2 = KllDoublesSketch.newHeapInstance((int)k);
        sk2.update(1.0);
        compBytes = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllDoublesSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((double)sk.getMaxItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeDoubleHeapifyUpdatableMem() {
        int k = 20;
        KllMiscDoublesTest.println("#### CASE: DOUBLE FULL HEAPIFIED FROM UPDATABLE");
        KllDoublesSketch sk2 = KllDoublesSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk2.update((double)i);
        }
        byte[] compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllMiscDoublesTest.println(KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true));
        KllHeapDoublesSketch sk = KllHeapDoublesSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((double)sk.getMaxItem(), (double)21.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscDoublesTest.println("#### CASE: DOUBLE EMPTY HEAPIFIED FROM UPDATABLE");
        sk2 = KllDoublesSketch.newHeapInstance((int)k);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllHeapDoublesSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        KllMiscDoublesTest.println("#### CASE: DOUBLE SINGLE HEAPIFIED FROM UPDATABLE");
        sk2 = KllDoublesSketch.newHeapInstance((int)k);
        sk2.update(1.0);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllHeapDoublesSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((double)sk.getMaxItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkMemoryToStringDoubleCompact() {
        int k = 20;
        KllMiscDoublesTest.println("#### CASE: DOUBLE FULL COMPACT");
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)k);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((double)i);
        }
        byte[] compBytes = sk.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        String s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscDoublesTest.println(s);
        KllDoublesSketch sk2 = KllDoublesSketch.heapify((Memory)wmem);
        byte[] compBytes2 = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscDoublesTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
        KllMiscDoublesTest.println("#### CASE: DOUBLE EMPTY COMPACT");
        sk = KllDoublesSketch.newHeapInstance((int)20);
        compBytes = sk.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscDoublesTest.println(s);
        sk2 = KllDoublesSketch.heapify((Memory)wmem);
        compBytes2 = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscDoublesTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
        KllMiscDoublesTest.println("#### CASE: DOUBLE SINGLE COMPACT");
        sk = KllDoublesSketch.newHeapInstance((int)20);
        sk.update(1.0);
        compBytes = sk.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscDoublesTest.println(s);
        sk2 = KllDoublesSketch.heapify((Memory)wmem);
        compBytes2 = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscDoublesTest.println(s);
        Assert.assertEquals((byte[])compBytes, (byte[])compBytes2);
    }

    @Test
    public void checkMemoryToStringDoubleUpdatable() {
        int k = 20;
        KllMiscDoublesTest.println("#### CASE: DOUBLE FULL UPDATABLE");
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)20);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((double)i);
        }
        byte[] upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])upBytes);
        String s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscDoublesTest.println(s);
        KllHeapDoublesSketch sk2 = KllHeapDoublesSketch.heapifyImpl((Memory)wmem);
        byte[] upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscDoublesTest.println(s);
        Assert.assertEquals((long)sk.getN(), (long)sk2.getN());
        Assert.assertEquals((double)sk.getMinItem(), (double)sk2.getMinItem());
        Assert.assertEquals((double)sk.getMaxItem(), (double)sk2.getMaxItem());
        Assert.assertEquals((int)sk.getNumRetained(), (int)sk2.getNumRetained());
        KllMiscDoublesTest.println("#### CASE: DOUBLE EMPTY UPDATABLE");
        sk = KllDoublesSketch.newHeapInstance((int)k);
        upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscDoublesTest.println(s);
        sk2 = KllHeapDoublesSketch.heapifyImpl((Memory)wmem);
        upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscDoublesTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
        KllMiscDoublesTest.println("#### CASE: DOUBLE SINGLE UPDATABL");
        sk = KllDoublesSketch.newHeapInstance((int)k);
        sk.update(1.0);
        upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscDoublesTest.println(s);
        sk2 = KllHeapDoublesSketch.heapifyImpl((Memory)wmem);
        upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        KllMiscDoublesTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscDoublesTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
    }

    @Test
    public void checkSimpleMerge() {
        int i;
        int k = 20;
        int m = 8;
        int n1 = 21;
        int n2 = 43;
        WritableMemory wmem = WritableMemory.allocate((int)3000);
        WritableMemory wmem2 = WritableMemory.allocate((int)3000);
        KllDirectDoublesSketch sk1 = KllDirectDoublesSketch.newDirectUpdatableInstance((int)k, (int)m, (WritableMemory)wmem, (MemoryRequestServer)this.memReqSvr);
        KllDirectDoublesSketch sk2 = KllDirectDoublesSketch.newDirectUpdatableInstance((int)k, (int)m, (WritableMemory)wmem2, (MemoryRequestServer)this.memReqSvr);
        for (i = 1; i <= n1; ++i) {
            sk1.update((double)i);
        }
        for (i = 1; i <= n2; ++i) {
            sk2.update((double)(i + 100));
        }
        sk1.merge((KllSketch)sk2);
        Assert.assertEquals((double)sk1.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk1.getMaxItem(), (double)143.0);
    }

    @Test
    public void checkGetSingleItem() {
        int k = 20;
        KllDoublesSketch skHeap = KllDoublesSketch.newHeapInstance((int)k);
        skHeap.update(1.0);
        Assert.assertTrue((boolean)(skHeap instanceof KllHeapDoublesSketch));
        Assert.assertEquals((double)skHeap.getDoubleSingleItem(), (double)1.0);
        WritableMemory srcMem = WritableMemory.writableWrap((byte[])KllHelper.toByteArray((KllSketch)skHeap, (boolean)true));
        KllDoublesSketch skDirect = KllDoublesSketch.writableWrap((WritableMemory)srcMem, (MemoryRequestServer)this.memReqSvr);
        Assert.assertTrue((boolean)(skDirect instanceof KllDirectDoublesSketch));
        Assert.assertEquals((double)skDirect.getDoubleSingleItem(), (double)1.0);
        Memory srcMem2 = Memory.wrap((byte[])skHeap.toByteArray());
        KllDoublesSketch skCompact = KllDoublesSketch.wrap((Memory)srcMem2);
        Assert.assertTrue((boolean)(skCompact instanceof KllDirectDoublesSketch.KllDirectCompactDoublesSketch));
        Assert.assertEquals((double)skCompact.getDoubleSingleItem(), (double)1.0);
    }

    @Test
    public void printlnTest() {
        String s = "PRINTING:  printf in " + this.getClass().getName();
        KllMiscDoublesTest.println(s);
        KllMiscDoublesTest.printf("%s\n", s);
    }

    private static final void printf(String format, Object ... args) {
    }

    private static final void println(Object o) {
    }
}

