/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.kll.KllDirectDoublesSketch;
import org.apache.datasketches.kll.KllDoublesSketch;
import org.apache.datasketches.kll.KllHeapDoublesSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.DoublesSortedView;
import org.apache.datasketches.quantilescommon.DoublesSortedViewIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllMiscDirectDoublesTest {
    static final String LS = System.getProperty("line.separator");
    private static final DefaultMemoryRequestServer memReqSvr = new DefaultMemoryRequestServer();
    private static final boolean enablePrinting = false;

    @Test
    public void checkBounds() {
        KllDoublesSketch kll = KllMiscDirectDoublesTest.getDirectDoublesSketch(200, 0);
        for (int i = 0; i < 1000; ++i) {
            kll.update((double)i);
        }
        double eps = kll.getNormalizedRankError(false);
        double est = kll.getQuantile(0.5);
        double ub = kll.getQuantileUpperBound(0.5);
        double lb = kll.getQuantileLowerBound(0.5);
        Assert.assertEquals((double)ub, (double)kll.getQuantile(0.5 + eps));
        Assert.assertEquals((double)lb, (double)kll.getQuantile(0.5 - eps));
        KllMiscDirectDoublesTest.println("Ext     : " + est);
        KllMiscDirectDoublesTest.println("UB      : " + ub);
        KllMiscDirectDoublesTest.println("LB      : " + lb);
        double rest = kll.getRank(est);
        double restUB = kll.getRankUpperBound(rest);
        double restLB = kll.getRankLowerBound(rest);
        Assert.assertTrue((restUB - rest < 2.0 * eps ? 1 : 0) != 0);
        Assert.assertTrue((rest - restLB < 2.0 * eps ? 1 : 0) != 0);
    }

    @Test
    public void checkMisc() {
        int k = 8;
        KllDoublesSketch sk = KllMiscDirectDoublesTest.getDirectDoublesSketch(8, 0);
        try {
            sk.getPartitionBoundaries(10);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        for (int i = 0; i < 20; ++i) {
            sk.update((double)i);
        }
        double[] items = sk.getDoubleItemsArray();
        Assert.assertEquals((int)items.length, (int)16);
        int[] levels = sk.getLevelsArray(sk.sketchStructure);
        Assert.assertEquals((int)levels.length, (int)3);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
    }

    public void visualCheckToString() {
        int k = 20;
        KllDoublesSketch sk = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        for (int i = 0; i < 10; ++i) {
            sk.update((double)(i + 1));
        }
        KllMiscDirectDoublesTest.println(sk.toString(true, true));
        KllDoublesSketch sk2 = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        for (int i = 0; i < 400; ++i) {
            sk2.update((double)(i + 1));
        }
        KllMiscDirectDoublesTest.println("\n" + sk2.toString(true, true));
        sk2.merge((KllSketch)sk);
        String s2 = sk2.toString(true, true);
        KllMiscDirectDoublesTest.println(LS + s2);
    }

    @Test
    public void viewDirectCompactions() {
        int k = 20;
        int u = 108;
        KllDoublesSketch sk = KllMiscDirectDoublesTest.getDirectDoublesSketch(k, 0);
        for (int i = 1; i <= u; ++i) {
            sk.update((double)i);
            if (sk.levelsArr[0] != 0) continue;
            KllMiscDirectDoublesTest.println(sk.toString(true, true));
            sk.update((double)(++i));
            KllMiscDirectDoublesTest.println(sk.toString(true, true));
            Assert.assertEquals((double)sk.getDoubleItemsArray()[sk.levelsArr[0]], (double)i);
        }
    }

    @Test
    public void viewCompactionAndSortedView() {
        int k = 20;
        KllDoublesSketch sk = KllMiscDirectDoublesTest.getDirectDoublesSketch(k, 0);
        KllMiscDirectDoublesTest.show(sk, 20);
        DoublesSortedView sv = sk.getSortedView();
        DoublesSortedViewIterator itr = sv.iterator();
        KllMiscDirectDoublesTest.printf("%12s%12s\n", "Value", "CumWeight");
        while (itr.next()) {
            double v = itr.getQuantile();
            long wt = itr.getWeight();
            KllMiscDirectDoublesTest.printf("%12.1f%12d\n", v, wt);
        }
    }

    private static void show(KllDoublesSketch sk, int limit) {
        for (int i = (int)sk.getN(); i < limit; ++i) {
            sk.update((double)(i + 1));
        }
        KllMiscDirectDoublesTest.println(sk.toString(true, true));
    }

    @Test
    public void checkSketchInitializeDoubleHeap() {
        int k = 20;
        KllDoublesSketch sk = KllMiscDirectDoublesTest.getDirectDoublesSketch(k, 0);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((double)i);
        }
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((double)sk.getMaxItem(), (double)21.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk = KllMiscDirectDoublesTest.getDirectDoublesSketch(k, 0);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk = KllMiscDirectDoublesTest.getDirectDoublesSketch(k, 0);
        sk.update(1.0);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((double)sk.getMaxItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeDoubleHeapifyCompactMem() {
        int k = 20;
        KllDoublesSketch sk2 = KllMiscDirectDoublesTest.getDirectDoublesSketch(k, 0);
        for (int i = 1; i <= k + 1; ++i) {
            sk2.update((double)i);
        }
        byte[] compBytes = sk2.toByteArray();
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllDoublesSketch sk = KllDoublesSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((double)sk.getMaxItem(), (double)21.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk2 = KllMiscDirectDoublesTest.getDirectDoublesSketch(k, 0);
        compBytes = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllDoublesSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk2 = KllMiscDirectDoublesTest.getDirectDoublesSketch(k, 0);
        sk2.update(1.0);
        compBytes = sk2.toByteArray();
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllDoublesSketch.heapify((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((double)sk.getMaxItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkSketchInitializeDoubleHeapifyUpdatableMem() {
        int k = 20;
        KllDoublesSketch sk2 = KllMiscDirectDoublesTest.getDirectDoublesSketch(k, 0);
        for (int i = 1; i <= k + 1; ++i) {
            sk2.update((double)i);
        }
        byte[] compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])compBytes);
        KllHeapDoublesSketch sk = KllHeapDoublesSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)(k + 1));
        Assert.assertEquals((int)sk.getNumRetained(), (int)11);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertTrue((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)33);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)3);
        Assert.assertEquals((double)sk.getMaxItem(), (double)21.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)2);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk2 = KllMiscDirectDoublesTest.getDirectDoublesSketch(k, 0);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllHeapDoublesSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)0L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)0);
        Assert.assertTrue((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        try {
            sk.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
        sk2 = KllMiscDirectDoublesTest.getDirectDoublesSketch(k, 0);
        sk2.update(1.0);
        compBytes = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])compBytes);
        sk = KllHeapDoublesSketch.heapifyImpl((Memory)wmem);
        Assert.assertEquals((int)sk.getK(), (int)k);
        Assert.assertEquals((long)sk.getN(), (long)1L);
        Assert.assertEquals((int)sk.getNumRetained(), (int)1);
        Assert.assertFalse((boolean)sk.isEmpty());
        Assert.assertFalse((boolean)sk.isEstimationMode());
        Assert.assertEquals((int)sk.getMinK(), (int)k);
        Assert.assertEquals((int)sk.getDoubleItemsArray().length, (int)20);
        Assert.assertEquals((int)sk.getLevelsArray(sk.sketchStructure).length, (int)2);
        Assert.assertEquals((double)sk.getMaxItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((int)sk.getNumLevels(), (int)1);
        Assert.assertFalse((boolean)sk.isLevelZeroSorted());
    }

    @Test
    public void checkMemoryToStringDoubleUpdatable() {
        int k = 20;
        KllMiscDirectDoublesTest.println("#### CASE: DOUBLE FULL UPDATABLE");
        KllDoublesSketch sk = KllMiscDirectDoublesTest.getDirectDoublesSketch(k, 0);
        for (int i = 1; i <= k + 1; ++i) {
            sk.update((double)i);
        }
        byte[] upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])upBytes);
        String s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        KllMiscDirectDoublesTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscDirectDoublesTest.println(s);
        KllDoublesSketch sk2 = KllDoublesSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        byte[] upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        KllMiscDirectDoublesTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscDirectDoublesTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
        KllMiscDirectDoublesTest.println("#### CASE: DOUBLE EMPTY UPDATABLE");
        sk = KllMiscDirectDoublesTest.getDirectDoublesSketch(k, 0);
        upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        KllMiscDirectDoublesTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscDirectDoublesTest.println(s);
        sk2 = KllDoublesSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        KllMiscDirectDoublesTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscDirectDoublesTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
        KllMiscDirectDoublesTest.println("#### CASE: DOUBLE SINGLE UPDATABL");
        sk = KllMiscDirectDoublesTest.getDirectDoublesSketch(k, 0);
        sk.update(1.0);
        upBytes = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        KllMiscDirectDoublesTest.println("step 1: sketch to byte[]/memory & analyze memory");
        KllMiscDirectDoublesTest.println(s);
        sk2 = KllDoublesSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        upBytes2 = KllHelper.toByteArray((KllSketch)sk2, (boolean)true);
        wmem = WritableMemory.writableWrap((byte[])upBytes2);
        s = KllPreambleUtil.toString((Memory)wmem, (KllSketch.SketchType)KllSketch.SketchType.DOUBLES_SKETCH, (boolean)true);
        KllMiscDirectDoublesTest.println("step 2: memory to heap sketch, to byte[]/memory & analyze memory. Should match above");
        KllMiscDirectDoublesTest.println(s);
        Assert.assertEquals((byte[])upBytes, (byte[])upBytes2);
    }

    @Test
    public void checkSimpleMerge() {
        int i;
        int k = 20;
        int n1 = 21;
        int n2 = 21;
        KllDoublesSketch sk1 = KllMiscDirectDoublesTest.getDirectDoublesSketch(k, 0);
        KllDoublesSketch sk2 = KllMiscDirectDoublesTest.getDirectDoublesSketch(k, 0);
        for (i = 1; i <= n1; ++i) {
            sk1.update((double)i);
        }
        for (i = 1; i <= n2; ++i) {
            sk2.update((double)(i + 100));
        }
        KllMiscDirectDoublesTest.println(sk1.toString(true, true));
        KllMiscDirectDoublesTest.println(sk2.toString(true, true));
        sk1.merge((KllSketch)sk2);
        KllMiscDirectDoublesTest.println(sk1.toString(true, true));
        Assert.assertEquals((double)sk1.getMaxItem(), (double)121.0);
        Assert.assertEquals((double)sk1.getMinItem(), (double)1.0);
    }

    @Test
    public void checkSizes() {
        KllDoublesSketch sk = KllMiscDirectDoublesTest.getDirectDoublesSketch(20, 0);
        for (int i = 1; i <= 21; ++i) {
            sk.update((double)i);
        }
        byte[] byteArr1 = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        int size1 = sk.currentSerializedSizeBytes(true);
        Assert.assertEquals((int)size1, (int)byteArr1.length);
        byte[] byteArr2 = sk.toByteArray();
        int size2 = sk.currentSerializedSizeBytes(false);
        Assert.assertEquals((int)size2, (int)byteArr2.length);
    }

    @Test
    public void checkNewInstance() {
        int k = 200;
        WritableMemory dstMem = WritableMemory.allocate((int)6000);
        KllDoublesSketch sk = KllDoublesSketch.newDirectInstance((int)k, (WritableMemory)dstMem, (MemoryRequestServer)memReqSvr);
        for (int i = 1; i <= 10000; ++i) {
            sk.update((double)i);
        }
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMaxItem(), (double)10000.0);
    }

    @Test
    public void checkDifferentM() {
        int k = 20;
        int m = 4;
        WritableMemory dstMem = WritableMemory.allocate((int)1000);
        KllDirectDoublesSketch sk = KllDirectDoublesSketch.newDirectUpdatableInstance((int)k, (int)m, (WritableMemory)dstMem, (MemoryRequestServer)memReqSvr);
        for (int i = 1; i <= 200; ++i) {
            sk.update((double)i);
        }
        Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
        Assert.assertEquals((double)sk.getMaxItem(), (double)200.0);
    }

    private static KllDoublesSketch getDirectDoublesSketch(int k, int n) {
        KllDoublesSketch sk = KllDoublesSketch.newHeapInstance((int)k);
        for (int i = 1; i <= n; ++i) {
            sk.update((double)i);
        }
        byte[] byteArr = KllHelper.toByteArray((KllSketch)sk, (boolean)true);
        WritableMemory wmem = WritableMemory.writableWrap((byte[])byteArr);
        KllDoublesSketch ddsk = KllDoublesSketch.writableWrap((WritableMemory)wmem, (MemoryRequestServer)memReqSvr);
        return ddsk;
    }

    @Test
    public void printlnTest() {
        String s = "PRINTING:  printf in " + this.getClass().getName();
        KllMiscDirectDoublesTest.println(s);
        KllMiscDirectDoublesTest.printf("%s\n", s);
    }

    private static final void printf(String format, Object ... args) {
    }

    private static final void println(Object o) {
    }
}

