/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllItemsSketch;
import org.apache.datasketches.kll.KllItemsSketchSortedView;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.GenericSortedViewIterator;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.testng.Assert;
import org.testng.annotations.Test;

public class KllItemsSketchTest {
    private static final double PMF_EPS_FOR_K_8 = 0.35;
    private static final double PMF_EPS_FOR_K_128 = 0.025;
    private static final double PMF_EPS_FOR_K_256 = 0.013;
    private static final double NUMERIC_NOISE_TOLERANCE = 1.0E-6;
    private ArrayOfStringsSerDe serDe = new ArrayOfStringsSerDe();
    private static final boolean enablePrinting = false;

    @Test
    public void empty() {
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sketch.update(null);
        Assert.assertTrue((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)0L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)0);
        try {
            sketch.getRank((Object)"", QuantileSearchCriteria.INCLUSIVE);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getQuantile(0.5);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getQuantiles(new double[]{0.0});
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getPMF((Object[])new String[]{""});
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sketch.getCDF((Object[])new String[]{""});
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        Assert.assertNotNull((Object)sketch.toString(true, true));
        Assert.assertNotNull((Object)sketch.toString());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void getQuantileInvalidArg() {
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sketch.update((Object)"A");
        sketch.getQuantile(-1.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void getQuantilesInvalidArg() {
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sketch.update((Object)"A");
        sketch.getQuantiles(new double[]{2.0});
    }

    @Test
    public void oneValue() {
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sketch.update((Object)"A");
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)1L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)1);
        Assert.assertEquals((double)sketch.getRank((Object)"A", QuantileSearchCriteria.EXCLUSIVE), (double)0.0);
        Assert.assertEquals((double)sketch.getRank((Object)"B", QuantileSearchCriteria.EXCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getRank((Object)"A", QuantileSearchCriteria.EXCLUSIVE), (double)0.0);
        Assert.assertEquals((double)sketch.getRank((Object)"B", QuantileSearchCriteria.EXCLUSIVE), (double)1.0);
        Assert.assertEquals((double)sketch.getRank((Object)"@", QuantileSearchCriteria.INCLUSIVE), (double)0.0);
        Assert.assertEquals((double)sketch.getRank((Object)"A", QuantileSearchCriteria.INCLUSIVE), (double)1.0);
        Assert.assertEquals((String)((String)sketch.getMinItem()), (String)"A");
        Assert.assertEquals((String)((String)sketch.getMaxItem()), (String)"A");
        Assert.assertEquals((String)((String)sketch.getQuantile(0.5, QuantileSearchCriteria.EXCLUSIVE)), (String)"A");
        Assert.assertEquals((String)((String)sketch.getQuantile(0.5, QuantileSearchCriteria.INCLUSIVE)), (String)"A");
    }

    @Test
    public void tenValues() {
        int i;
        int i2;
        int i3;
        Object[] tenStr = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J"};
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        for (i3 = 1; i3 <= 10; ++i3) {
            sketch.update((Object)tenStr[i3 - 1]);
        }
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)10L);
        Assert.assertEquals((int)sketch.getNumRetained(), (int)10);
        for (i3 = 1; i3 <= 10; ++i3) {
            Assert.assertEquals((double)sketch.getRank(tenStr[i3 - 1], QuantileSearchCriteria.EXCLUSIVE), (double)((double)(i3 - 1) / 10.0));
            Assert.assertEquals((double)sketch.getRank(tenStr[i3 - 1], QuantileSearchCriteria.INCLUSIVE), (double)((double)i3 / 10.0));
        }
        Object[] qArr = tenStr;
        double[] rOut = sketch.getRanks(qArr);
        for (i2 = 0; i2 < qArr.length; ++i2) {
            Assert.assertEquals((double)rOut[i2], (double)((double)(i2 + 1) / 10.0));
        }
        rOut = sketch.getRanks(qArr, QuantileSearchCriteria.EXCLUSIVE);
        for (i2 = 0; i2 < qArr.length; ++i2) {
            Assert.assertEquals((double)rOut[i2], (double)((double)i2 / 10.0));
        }
        for (i2 = 0; i2 <= 10; ++i2) {
            double rank = (double)i2 / 10.0;
            Object q = rank == 1.0 ? tenStr[i2 - 1] : tenStr[i2];
            Assert.assertEquals((String)((String)sketch.getQuantile(rank, QuantileSearchCriteria.EXCLUSIVE)), (String)q);
            q = rank == 0.0 ? tenStr[i2] : tenStr[i2 - 1];
            Assert.assertEquals((String)((String)sketch.getQuantile(rank, QuantileSearchCriteria.INCLUSIVE)), (String)q);
        }
        String[] quantiles = (String[])sketch.getQuantiles(new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0}, QuantileSearchCriteria.EXCLUSIVE);
        for (i = 0; i <= 10; ++i) {
            Assert.assertEquals((String)((String)sketch.getQuantile((double)i / 10.0, QuantileSearchCriteria.EXCLUSIVE)), (String)quantiles[i]);
        }
        quantiles = (String[])sketch.getQuantiles(new double[]{0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0}, QuantileSearchCriteria.INCLUSIVE);
        for (i = 0; i <= 10; ++i) {
            Assert.assertEquals((String)((String)sketch.getQuantile((double)i / 10.0, QuantileSearchCriteria.INCLUSIVE)), (String)quantiles[i]);
        }
    }

    @Test
    public void manyValuesEstimationMode() {
        int i;
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 1000000;
        int digits = Util.numDigits((int)1000000);
        for (i = 1; i <= 1000000; ++i) {
            sketch.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
            Assert.assertEquals((long)sketch.getN(), (long)i);
        }
        for (i = 1; i <= 1000000; ++i) {
            double trueRank = (double)i / 1000000.0;
            String s = Util.intToFixedLengthString((int)i, (int)digits);
            double r = sketch.getRank((Object)s);
            Assert.assertEquals((double)r, (double)trueRank, (double)0.013, (String)("for value " + s));
        }
        String s = Util.intToFixedLengthString((int)500000, (int)digits);
        double[] pmf = sketch.getPMF((Object[])new String[]{s});
        Assert.assertEquals((int)pmf.length, (int)2);
        Assert.assertEquals((double)pmf[0], (double)0.5, (double)0.013);
        Assert.assertEquals((double)pmf[1], (double)0.5, (double)0.013);
        Assert.assertEquals((String)((String)sketch.getMinItem()), (String)Util.intToFixedLengthString((int)1, (int)digits));
        Assert.assertEquals((String)((String)sketch.getMaxItem()), (String)Util.intToFixedLengthString((int)1000000, (int)digits));
        double[] fractions = new double[1001];
        double[] reverseFractions = new double[1001];
        for (int i2 = 0; i2 <= 1000; ++i2) {
            fractions[i2] = (double)i2 / 1000.0;
            reverseFractions[1000 - i2] = fractions[i2];
        }
        String[] quantiles = (String[])sketch.getQuantiles(fractions);
        String[] reverseQuantiles = (String[])sketch.getQuantiles(reverseFractions);
        String previousQuantile = "";
        for (int i3 = 0; i3 <= 1000; ++i3) {
            String quantile = (String)sketch.getQuantile(fractions[i3]);
            Assert.assertEquals((String)quantile, (String)quantiles[i3]);
            Assert.assertEquals((String)quantile, (String)reverseQuantiles[1000 - i3]);
            Assert.assertTrue((boolean)Util.le((Object)previousQuantile, (Object)quantile, Comparator.naturalOrder()));
            previousQuantile = quantile;
        }
    }

    @Test
    public void getRankGetCdfGetPmfConsistency() {
        int i;
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 1000;
        int digits = Util.numDigits((int)1000);
        Object[] quantiles = new String[1000];
        for (int i2 = 0; i2 < 1000; ++i2) {
            String str = Util.intToFixedLengthString((int)i2, (int)digits);
            sketch.update((Object)str);
            quantiles[i2] = str;
        }
        double[] ranks = sketch.getCDF(quantiles, QuantileSearchCriteria.EXCLUSIVE);
        double[] pmf = sketch.getPMF(quantiles, QuantileSearchCriteria.EXCLUSIVE);
        double sumPmf = 0.0;
        for (i = 0; i < 1000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(quantiles[i], QuantileSearchCriteria.EXCLUSIVE), (double)1.0E-6, (String)("rank vs CDF for value " + i));
            Assert.assertEquals((double)ranks[i], (double)(sumPmf += pmf[i]), (double)1.0E-6, (String)("CDF vs PMF for value " + i));
        }
        Assert.assertEquals((double)(sumPmf += pmf[1000]), (double)1.0, (double)1.0E-6);
        Assert.assertEquals((double)ranks[1000], (double)1.0, (double)1.0E-6);
        ranks = sketch.getCDF(quantiles, QuantileSearchCriteria.INCLUSIVE);
        pmf = sketch.getPMF(quantiles, QuantileSearchCriteria.INCLUSIVE);
        sumPmf = 0.0;
        for (i = 0; i < 1000; ++i) {
            Assert.assertEquals((double)ranks[i], (double)sketch.getRank(quantiles[i], QuantileSearchCriteria.INCLUSIVE), (double)1.0E-6, (String)("rank vs CDF for value " + i));
            Assert.assertEquals((double)ranks[i], (double)(sumPmf += pmf[i]), (double)1.0E-6, (String)("CDF vs PMF for value " + i));
        }
        Assert.assertEquals((double)(sumPmf += pmf[1000]), (double)1.0, (double)1.0E-6);
        Assert.assertEquals((double)ranks[1000], (double)1.0, (double)1.0E-6);
    }

    @Test
    public void merge() {
        KllItemsSketch sketch1 = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        KllItemsSketch sketch2 = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 10000;
        int digits = Util.numDigits((int)20000);
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
            sketch2.update((Object)Util.intToFixedLengthString((int)(20000 - i - 1), (int)digits));
        }
        Assert.assertEquals((String)((String)sketch1.getMinItem()), (String)Util.intToFixedLengthString((int)0, (int)digits));
        Assert.assertEquals((String)((String)sketch1.getMaxItem()), (String)Util.intToFixedLengthString((int)9999, (int)digits));
        Assert.assertEquals((String)((String)sketch2.getMinItem()), (String)Util.intToFixedLengthString((int)10000, (int)digits));
        Assert.assertEquals((String)((String)sketch2.getMaxItem()), (String)Util.intToFixedLengthString((int)19999, (int)digits));
        sketch1.merge((KllSketch)sketch2);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)20000L);
        Assert.assertEquals((String)((String)sketch1.getMinItem()), (String)Util.intToFixedLengthString((int)0, (int)digits));
        Assert.assertEquals((String)((String)sketch1.getMaxItem()), (String)Util.intToFixedLengthString((int)19999, (int)digits));
        String upperBound = Util.intToFixedLengthString((int)(10000 + (int)Math.ceil(130.0)), (int)digits);
        String lowerBound = Util.intToFixedLengthString((int)(10000 - (int)Math.ceil(130.0)), (int)digits);
        String median = (String)sketch1.getQuantile(0.5);
        Assert.assertTrue((boolean)Util.le((Object)median, (Object)upperBound, Comparator.naturalOrder()));
        Assert.assertTrue((boolean)Util.le((Object)lowerBound, (Object)median, Comparator.naturalOrder()));
    }

    @Test
    public void mergeLowerK() {
        KllItemsSketch sketch1 = KllItemsSketch.newHeapInstance((int)256, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        KllItemsSketch sketch2 = KllItemsSketch.newHeapInstance((int)128, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 10000;
        int digits = Util.numDigits((int)20000);
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
            sketch2.update((Object)Util.intToFixedLengthString((int)(20000 - i - 1), (int)digits));
        }
        Assert.assertEquals((String)((String)sketch1.getMinItem()), (String)Util.intToFixedLengthString((int)0, (int)digits));
        Assert.assertEquals((String)((String)sketch1.getMaxItem()), (String)Util.intToFixedLengthString((int)9999, (int)digits));
        Assert.assertEquals((String)((String)sketch2.getMinItem()), (String)Util.intToFixedLengthString((int)10000, (int)digits));
        Assert.assertEquals((String)((String)sketch2.getMaxItem()), (String)Util.intToFixedLengthString((int)19999, (int)digits));
        Assert.assertTrue((sketch1.getNormalizedRankError(false) < sketch2.getNormalizedRankError(false) ? 1 : 0) != 0);
        Assert.assertTrue((sketch1.getNormalizedRankError(true) < sketch2.getNormalizedRankError(true) ? 1 : 0) != 0);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(false), (double)sketch2.getNormalizedRankError(false));
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)sketch2.getNormalizedRankError(true));
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)20000L);
        Assert.assertEquals((String)((String)sketch1.getMinItem()), (String)Util.intToFixedLengthString((int)0, (int)digits));
        Assert.assertEquals((String)((String)sketch1.getMaxItem()), (String)Util.intToFixedLengthString((int)19999, (int)digits));
        String upperBound = Util.intToFixedLengthString((int)(10000 + (int)Math.ceil(500.0)), (int)digits);
        String lowerBound = Util.intToFixedLengthString((int)(10000 - (int)Math.ceil(500.0)), (int)digits);
        String median = (String)sketch1.getQuantile(0.5);
        Assert.assertTrue((boolean)Util.le((Object)median, (Object)upperBound, Comparator.naturalOrder()));
        Assert.assertTrue((boolean)Util.le((Object)lowerBound, (Object)median, Comparator.naturalOrder()));
    }

    @Test
    public void mergeEmptyLowerK() {
        KllItemsSketch sketch1 = KllItemsSketch.newHeapInstance((int)256, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        KllItemsSketch sketch2 = KllItemsSketch.newHeapInstance((int)128, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 10000;
        int digits = Util.numDigits((int)10000);
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        double rankErrorBeforeMerge = sketch1.getNormalizedRankError(true);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)rankErrorBeforeMerge);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertTrue((boolean)sketch2.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)10000L);
        Assert.assertEquals((String)((String)sketch1.getMinItem()), (String)Util.intToFixedLengthString((int)0, (int)digits));
        Assert.assertEquals((String)((String)sketch1.getMaxItem()), (String)Util.intToFixedLengthString((int)9999, (int)digits));
        String upperBound = Util.intToFixedLengthString((int)(5000 + (int)Math.ceil(130.0)), (int)digits);
        String lowerBound = Util.intToFixedLengthString((int)(5000 - (int)Math.ceil(130.0)), (int)digits);
        String median = (String)sketch1.getQuantile(0.5);
        Assert.assertTrue((boolean)Util.le((Object)median, (Object)upperBound, Comparator.naturalOrder()));
        Assert.assertTrue((boolean)Util.le((Object)lowerBound, (Object)median, Comparator.naturalOrder()));
        sketch2.merge((KllSketch)sketch1);
        Assert.assertFalse((boolean)sketch1.isEmpty());
        Assert.assertFalse((boolean)sketch2.isEmpty());
        Assert.assertEquals((long)sketch1.getN(), (long)10000L);
        Assert.assertEquals((long)sketch2.getN(), (long)10000L);
        Assert.assertEquals((String)((String)sketch1.getMinItem()), (String)Util.intToFixedLengthString((int)0, (int)digits));
        Assert.assertEquals((String)((String)sketch1.getMaxItem()), (String)Util.intToFixedLengthString((int)9999, (int)digits));
        Assert.assertEquals((String)((String)sketch2.getMinItem()), (String)Util.intToFixedLengthString((int)0, (int)digits));
        Assert.assertEquals((String)((String)sketch2.getMaxItem()), (String)Util.intToFixedLengthString((int)9999, (int)digits));
        upperBound = Util.intToFixedLengthString((int)(5000 + (int)Math.ceil(250.0)), (int)digits);
        lowerBound = Util.intToFixedLengthString((int)(5000 - (int)Math.ceil(250.0)), (int)digits);
        median = (String)sketch2.getQuantile(0.5);
        Assert.assertTrue((boolean)Util.le((Object)median, (Object)upperBound, Comparator.naturalOrder()));
        Assert.assertTrue((boolean)Util.le((Object)lowerBound, (Object)median, Comparator.naturalOrder()));
    }

    @Test
    public void mergeExactModeLowerK() {
        KllItemsSketch sketch1 = KllItemsSketch.newHeapInstance((int)256, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        KllItemsSketch sketch2 = KllItemsSketch.newHeapInstance((int)128, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 10000;
        int digits = Util.numDigits((int)10000);
        for (int i = 0; i < 10000; ++i) {
            sketch1.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        sketch2.update((Object)Util.intToFixedLengthString((int)1, (int)digits));
        double rankErrorBeforeMerge = sketch1.getNormalizedRankError(true);
        sketch1.merge((KllSketch)sketch2);
        Assert.assertEquals((double)sketch1.getNormalizedRankError(true), (double)rankErrorBeforeMerge);
    }

    @Test
    public void mergeMinMinValueFromOther() {
        KllItemsSketch sketch1 = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        KllItemsSketch sketch2 = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sketch1.update((Object)Util.intToFixedLengthString((int)1, (int)1));
        sketch2.update((Object)Util.intToFixedLengthString((int)2, (int)1));
        sketch2.merge((KllSketch)sketch1);
        Assert.assertEquals((String)((String)sketch2.getMinItem()), (String)Util.intToFixedLengthString((int)1, (int)1));
    }

    @Test
    public void mergeMinAndMaxFromOther() {
        KllItemsSketch sketch1 = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        KllItemsSketch sketch2 = KllItemsSketch.newHeapInstance((int)10, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 1000000;
        int digits = Util.numDigits((int)1000000);
        for (int i = 1; i <= 1000000; ++i) {
            sketch1.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        sketch2.merge((KllSketch)sketch1);
        Assert.assertEquals((String)((String)sketch2.getMinItem()), (String)Util.intToFixedLengthString((int)1, (int)digits));
        Assert.assertEquals((String)((String)sketch2.getMaxItem()), (String)Util.intToFixedLengthString((int)1000000, (int)digits));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void kTooSmall() {
        KllItemsSketch.newHeapInstance((int)7, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void kTooLarge() {
        KllItemsSketch.newHeapInstance((int)65536, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
    }

    @Test
    public void minK() {
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance((int)8, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 1000;
        int digits = Util.numDigits((int)1000);
        for (int i = 0; i < 1000; ++i) {
            sketch.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        Assert.assertEquals((int)sketch.getK(), (int)8);
        String upperBound = Util.intToFixedLengthString((int)(500 + (int)Math.ceil(350.0)), (int)digits);
        String lowerBound = Util.intToFixedLengthString((int)(500 - (int)Math.ceil(350.0)), (int)digits);
        String median = (String)sketch.getQuantile(0.5);
        Assert.assertTrue((boolean)Util.le((Object)median, (Object)upperBound, Comparator.naturalOrder()));
        Assert.assertTrue((boolean)Util.le((Object)lowerBound, (Object)median, Comparator.naturalOrder()));
    }

    @Test
    public void maxK() {
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance((int)65535, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 1000;
        int digits = Util.numDigits((int)1000);
        for (int i = 0; i < 1000; ++i) {
            sketch.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        Assert.assertEquals((int)sketch.getK(), (int)65535);
        String upperBound = Util.intToFixedLengthString((int)(500 + (int)Math.ceil(13.0)), (int)digits);
        String lowerBound = Util.intToFixedLengthString((int)(500 - (int)Math.ceil(13.0)), (int)digits);
        String median = (String)sketch.getQuantile(0.5);
        Assert.assertTrue((boolean)Util.le((Object)median, (Object)upperBound, Comparator.naturalOrder()));
        Assert.assertTrue((boolean)Util.le((Object)lowerBound, (Object)median, Comparator.naturalOrder()));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void outOfOrderSplitPoints() {
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        String s0 = Util.intToFixedLengthString((int)0, (int)1);
        String s1 = Util.intToFixedLengthString((int)1, (int)1);
        sketch.update((Object)s0);
        sketch.getCDF((Object[])new String[]{s1, s0});
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void nullSplitPoint() {
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sketch.update((Object)Util.intToFixedLengthString((int)0, (int)1));
        sketch.getCDF((Object[])new String[]{null});
    }

    @Test
    public void getQuantiles() {
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance(Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sketch.update((Object)"A");
        sketch.update((Object)"B");
        sketch.update((Object)"C");
        sketch.update((Object)"D");
        Object[] quantiles1 = (String[])sketch.getQuantiles(new double[]{0.0, 0.5, 1.0}, QuantileSearchCriteria.EXCLUSIVE);
        Object[] quantiles2 = (String[])sketch.getPartitionBoundaries((int)2, (QuantileSearchCriteria)QuantileSearchCriteria.EXCLUSIVE).boundaries;
        Assert.assertEquals((Object[])quantiles1, (Object[])quantiles2);
        quantiles1 = (String[])sketch.getQuantiles(new double[]{0.0, 0.5, 1.0}, QuantileSearchCriteria.INCLUSIVE);
        quantiles2 = (String[])sketch.getPartitionBoundaries((int)2, (QuantileSearchCriteria)QuantileSearchCriteria.INCLUSIVE).boundaries;
        Assert.assertEquals((Object[])quantiles1, (Object[])quantiles2);
    }

    @Test
    public void checkReset() {
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 100;
        int digits = Util.numDigits((int)100);
        for (int i = 1; i <= 100; ++i) {
            sketch.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        long n1 = sketch.getN();
        String min1 = (String)sketch.getMinItem();
        String max1 = (String)sketch.getMaxItem();
        sketch.reset();
        for (int i = 1; i <= 100; ++i) {
            sketch.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        long n2 = sketch.getN();
        String min2 = (String)sketch.getMinItem();
        String max2 = (String)sketch.getMaxItem();
        Assert.assertEquals((long)n2, (long)n1);
        Assert.assertEquals((String)min2, (String)min1);
        Assert.assertEquals((String)max2, (String)max1);
    }

    @Test
    public void checkReadOnlyUpdate() {
        KllItemsSketch sk1 = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Memory mem = Memory.wrap((byte[])sk1.toByteArray());
        KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        try {
            sk2.update((Object)"A");
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkNewDirectInstanceAndSmallSize() {
        KllItemsSketch sk1 = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Memory mem = Memory.wrap((byte[])sk1.toByteArray());
        KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int sizeBytes = sk2.currentSerializedSizeBytes(false);
        Assert.assertEquals((int)sizeBytes, (int)8);
        sk1.update((Object)"A");
        mem = Memory.wrap((byte[])sk1.toByteArray());
        sk2 = KllItemsSketch.wrap((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sizeBytes = sk2.currentSerializedSizeBytes(false);
        Assert.assertEquals((int)sizeBytes, (int)13);
        sk1.update((Object)"B");
        mem = Memory.wrap((byte[])sk1.toByteArray());
        sk2 = KllItemsSketch.wrap((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sizeBytes = sk2.currentSerializedSizeBytes(false);
        Assert.assertEquals((int)sizeBytes, (int)44);
    }

    @Test
    public void sortedView() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sk.update((Object)"A");
        sk.update((Object)"AB");
        sk.update((Object)"ABC");
        KllItemsSketchSortedView view = sk.getSortedView();
        GenericSortedViewIterator itr = view.iterator();
        Assert.assertEquals((boolean)itr.next(), (boolean)true);
        Assert.assertEquals((String)((String)itr.getQuantile()), (String)"A");
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.EXCLUSIVE), (long)0L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.INCLUSIVE), (long)1L);
        Assert.assertEquals((boolean)itr.next(), (boolean)true);
        Assert.assertEquals((String)((String)itr.getQuantile()), (String)"AB");
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.EXCLUSIVE), (long)1L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.INCLUSIVE), (long)2L);
        Assert.assertEquals((boolean)itr.next(), (boolean)true);
        Assert.assertEquals((String)((String)itr.getQuantile()), (String)"ABC");
        Assert.assertEquals((long)itr.getWeight(), (long)1L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.EXCLUSIVE), (long)2L);
        Assert.assertEquals((long)itr.getCumulativeWeight(QuantileSearchCriteria.INCLUSIVE), (long)3L);
        Assert.assertEquals((boolean)itr.next(), (boolean)false);
    }

    @Test
    public void checkCDF_PDF() {
        int i;
        double[] cdfI = new double[]{0.25, 0.5, 0.75, 1.0, 1.0};
        double[] cdfE = new double[]{0.0, 0.25, 0.5, 0.75, 1.0};
        double[] pmfI = new double[]{0.25, 0.25, 0.25, 0.25, 0.0};
        double[] pmfE = new double[]{0.0, 0.25, 0.25, 0.25, 0.25};
        double toll = 1.0E-10;
        KllItemsSketch sketch = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        String[] strIn = new String[]{"A", "AB", "ABC", "ABCD"};
        for (int i2 = 0; i2 < strIn.length; ++i2) {
            sketch.update((Object)strIn[i2]);
        }
        Object[] sp = new String[]{"A", "AB", "ABC", "ABCD"};
        KllItemsSketchTest.println("SplitPoints:");
        for (int i3 = 0; i3 < sp.length; ++i3) {
            KllItemsSketchTest.printf("%10s", sp[i3]);
        }
        KllItemsSketchTest.println("");
        KllItemsSketchTest.println("INCLUSIVE:");
        double[] cdf = sketch.getCDF(sp, QuantileSearchCriteria.INCLUSIVE);
        double[] pmf = sketch.getPMF(sp, QuantileSearchCriteria.INCLUSIVE);
        KllItemsSketchTest.printf("%10s%10s\n", "CDF", "PMF");
        for (i = 0; i < cdf.length; ++i) {
            KllItemsSketchTest.printf("%10.2f%10.2f\n", cdf[i], pmf[i]);
            Assert.assertEquals((double)cdf[i], (double)cdfI[i], (double)1.0E-10);
            Assert.assertEquals((double)pmf[i], (double)pmfI[i], (double)1.0E-10);
        }
        KllItemsSketchTest.println("EXCLUSIVE");
        cdf = sketch.getCDF(sp, QuantileSearchCriteria.EXCLUSIVE);
        pmf = sketch.getPMF(sp, QuantileSearchCriteria.EXCLUSIVE);
        KllItemsSketchTest.printf("%10s%10s\n", "CDF", "PMF");
        for (i = 0; i < cdf.length; ++i) {
            KllItemsSketchTest.printf("%10.2f%10.2f\n", cdf[i], pmf[i]);
            Assert.assertEquals((double)cdf[i], (double)cdfE[i], (double)1.0E-10);
            Assert.assertEquals((double)pmf[i], (double)pmfE[i], (double)1.0E-10);
        }
    }

    @Test
    public void checkWrapCase1Floats() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 21;
        int digits = Util.numDigits((int)21);
        for (int i = 1; i <= 21; ++i) {
            sk.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        Memory mem = Memory.wrap((byte[])sk.toByteArray());
        KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertTrue((boolean)mem.isReadOnly());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertFalse((boolean)sk2.isDirect());
    }

    @Test
    public void checkReadOnlyExceptions() {
        int[] intArr = new int[]{};
        int intV = 2;
        int idx = 1;
        KllItemsSketch sk1 = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Memory mem = Memory.wrap((byte[])sk1.toByteArray());
        KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        try {
            sk2.setLevelsArray(intArr);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setLevelsArrayAt(idx, intV);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkIsSameResource() {
        WritableMemory reg2;
        int cap = 128;
        WritableMemory wmem = WritableMemory.allocate((int)cap);
        WritableMemory reg1 = wmem.writableRegion(0L, 64L);
        Assert.assertFalse((reg1 == (reg2 = wmem.writableRegion(64L, 64L)) ? 1 : 0) != 0);
        Assert.assertFalse((boolean)reg1.isSameResource((Object)reg2));
        WritableMemory reg3 = wmem.writableRegion(0L, 64L);
        Assert.assertFalse((reg1 == reg3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)reg1.isSameResource((Object)reg3));
        byte[] byteArr1 = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe).toByteArray();
        reg1.putByteArray(0L, byteArr1, 0, byteArr1.length);
        KllItemsSketch sk1 = KllItemsSketch.wrap((Memory)reg1, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        byte[] byteArr2 = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe).toByteArray();
        reg2.putByteArray(0L, byteArr2, 0, byteArr2.length);
        Assert.assertFalse((boolean)sk1.isSameResource((Memory)reg2));
        byte[] byteArr3 = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe).toByteArray();
        reg3.putByteArray(0L, byteArr3, 0, byteArr3.length);
        Assert.assertTrue((boolean)sk1.isSameResource((Memory)reg3));
    }

    @Test
    public void checkHeapifyEmpty() {
        KllItemsSketch sk1 = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Memory mem = Memory.wrap((byte[])sk1.toByteArray());
        KllMemoryValidate memVal = new KllMemoryValidate(mem, KllSketch.SketchType.ITEMS_SKETCH, (ArrayOfItemsSerDe)this.serDe);
        Assert.assertEquals((Object)memVal.sketchStructure, (Object)KllSketch.SketchStructure.COMPACT_EMPTY);
        Assert.assertEquals((long)mem.getCapacity(), (long)8L);
        KllItemsSketch sk2 = KllItemsSketch.heapify((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertEquals((Object)sk2.sketchStructure, (Object)KllSketch.SketchStructure.UPDATABLE);
        Assert.assertEquals((long)sk2.getN(), (long)0L);
        Assert.assertFalse((boolean)sk2.isReadOnly());
        try {
            sk2.getMinItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.getMaxItem();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        KllItemsSketchTest.println(sk1.toString(true, true));
        KllItemsSketchTest.println("");
        KllItemsSketchTest.println(KllPreambleUtil.toString((Memory)mem, (KllSketch.SketchType)KllSketch.SketchType.ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe));
    }

    @Test
    public void checkHeapifySingleItem() {
        KllItemsSketch sk1 = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sk1.update((Object)"A");
        Memory mem = Memory.wrap((byte[])sk1.toByteArray());
        KllMemoryValidate memVal = new KllMemoryValidate(mem, KllSketch.SketchType.ITEMS_SKETCH, (ArrayOfItemsSerDe)this.serDe);
        Assert.assertEquals((Object)memVal.sketchStructure, (Object)KllSketch.SketchStructure.COMPACT_SINGLE);
        Assert.assertEquals((long)mem.getCapacity(), (long)memVal.sketchBytes);
        KllItemsSketch sk2 = KllItemsSketch.heapify((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertEquals((Object)sk2.sketchStructure, (Object)KllSketch.SketchStructure.UPDATABLE);
        Assert.assertEquals((long)sk2.getN(), (long)1L);
        Assert.assertFalse((boolean)sk2.isReadOnly());
        Assert.assertEquals((String)((String)sk2.getMinItem()), (String)"A");
        Assert.assertEquals((String)((String)sk2.getMaxItem()), (String)"A");
        KllItemsSketchTest.println(sk1.toString(true, true));
        KllItemsSketchTest.println("");
        KllItemsSketchTest.println(KllPreambleUtil.toString((Memory)mem, (KllSketch.SketchType)KllSketch.SketchType.ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe));
    }

    @Test
    public void checkHeapifyFewItems() {
        KllItemsSketch sk1 = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sk1.update((Object)"A");
        sk1.update((Object)"AB");
        sk1.update((Object)"ABC");
        Memory mem = Memory.wrap((byte[])sk1.toByteArray());
        KllMemoryValidate memVal = new KllMemoryValidate(mem, KllSketch.SketchType.ITEMS_SKETCH, (ArrayOfItemsSerDe)this.serDe);
        Assert.assertEquals((Object)memVal.sketchStructure, (Object)KllSketch.SketchStructure.COMPACT_FULL);
        Assert.assertEquals((long)mem.getCapacity(), (long)memVal.sketchBytes);
        KllItemsSketchTest.println(sk1.toString(true, true));
        KllItemsSketchTest.println("");
        KllItemsSketchTest.println(KllPreambleUtil.toString((Memory)mem, (KllSketch.SketchType)KllSketch.SketchType.ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe));
    }

    @Test
    public void checkHeapifyManyItems() {
        KllItemsSketch sk1 = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 109;
        int digits = Util.numDigits((int)109);
        for (int i = 1; i <= 109; ++i) {
            sk1.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        Memory mem = Memory.wrap((byte[])sk1.toByteArray());
        KllMemoryValidate memVal = new KllMemoryValidate(mem, KllSketch.SketchType.ITEMS_SKETCH, (ArrayOfItemsSerDe)this.serDe);
        Assert.assertEquals((Object)memVal.sketchStructure, (Object)KllSketch.SketchStructure.COMPACT_FULL);
        Assert.assertEquals((long)mem.getCapacity(), (long)memVal.sketchBytes);
        KllItemsSketchTest.println(sk1.toString(true, true));
        KllItemsSketchTest.println("");
        KllItemsSketchTest.println(KllPreambleUtil.toString((Memory)mem, (KllSketch.SketchType)KllSketch.SketchType.ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe));
    }

    @Test
    public void checkWrapCausingLevelsCompaction() {
        KllItemsSketch sk1 = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        int n = 109;
        int digits = Util.numDigits((int)109);
        for (int i = 1; i <= 109; ++i) {
            sk1.update((Object)Util.intToFixedLengthString((int)i, (int)digits));
        }
        Memory mem = Memory.wrap((byte[])sk1.toByteArray());
        KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)mem, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        Assert.assertTrue((boolean)mem.isReadOnly());
        Assert.assertTrue((boolean)sk2.isReadOnly());
        Assert.assertFalse((boolean)sk2.isDirect());
        KllItemsSketchTest.println(sk1.toString(true, true));
        KllItemsSketchTest.println("");
        KllItemsSketchTest.println(sk2.toString(true, true));
        KllItemsSketchTest.println("");
        KllItemsSketchTest.println(KllPreambleUtil.toString((Memory)mem, (KllSketch.SketchType)KllSketch.SketchType.ITEMS_SKETCH, (boolean)true, (ArrayOfItemsSerDe)this.serDe));
    }

    @Test
    public void checkExceptions() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        try {
            sk.getTotalItemsByteArr();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.getTotalItemsNumBytes();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk.setWritableMemory(null);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        byte[] byteArr = sk.toByteArray();
        KllItemsSketch sk2 = KllItemsSketch.wrap((Memory)Memory.wrap((byte[])byteArr), Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        try {
            sk2.incN();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setItemsArray(null);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setItemsArrayAt(0, null);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setLevelZeroSorted(false);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setMaxItem(null);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setMinItem(null);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setMinK(0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            sk2.setN(0L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkSortedViewAfterReset() {
        KllItemsSketch sk = KllItemsSketch.newHeapInstance((int)20, Comparator.naturalOrder(), (ArrayOfItemsSerDe)this.serDe);
        sk.update((Object)"1");
        KllItemsSketchSortedView sv = sk.getSortedView();
        String ssv = (String)sv.getQuantile(1.0, QuantileSearchCriteria.INCLUSIVE);
        Assert.assertEquals((String)ssv, (String)"1");
        sk.reset();
        try {
            sk.getSortedView();
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    private static final void printf(String format, Object ... args) {
    }

    private static final void println(Object o) {
    }
}

