/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches;

public enum InequalitySearch {
    LT{

        @Override
        int compare(double[] arr, int a, int b, double v) {
            return v <= arr[a] ? -1 : (arr[b] < v ? 1 : 0);
        }

        @Override
        int compare(float[] arr, int a, int b, float v) {
            return v <= arr[a] ? -1 : (arr[b] < v ? 1 : 0);
        }

        @Override
        int compare(long[] arr, int a, int b, long v) {
            return v <= arr[a] ? -1 : (arr[b] < v ? 1 : 0);
        }

        @Override
        int getIndex(double[] arr, int a, int b, double v) {
            return a;
        }

        @Override
        int getIndex(float[] arr, int a, int b, float v) {
            return a;
        }

        @Override
        int getIndex(long[] arr, int a, int b, long v) {
            return a;
        }

        @Override
        int resolve(int lo, int hi, int low, int high) {
            if (lo >= high) {
                return high;
            }
            return -1;
        }

        @Override
        String desc(double[] arr, int low, int high, double v, int idx) {
            if (idx == -1) {
                return "LT: " + v + " <= arr[" + low + "]=" + arr[low] + "; return -1";
            }
            if (idx == high) {
                return "LT: " + v + " > arr[" + high + "]=" + arr[high] + "; return arr[" + high + "]=" + arr[high];
            }
            return "LT: " + v + ": arr[" + idx + "]=" + arr[idx] + " < " + v + " <= arr[" + (idx + 1) + "]=" + arr[idx + 1] + "; return arr[" + idx + "]=" + arr[idx];
        }

        @Override
        String desc(float[] arr, int low, int high, float v, int idx) {
            if (idx == -1) {
                return "LT: " + v + " <= arr[" + low + "]=" + arr[low] + "; return -1";
            }
            if (idx == high) {
                return "LT: " + v + " > arr[" + high + "]=" + arr[high] + "; return arr[" + high + "]=" + arr[high];
            }
            return "LT: " + v + ": arr[" + idx + "]=" + arr[idx] + " < " + v + " <= arr[" + (idx + 1) + "]=" + arr[idx + 1] + "; return arr[" + idx + "]=" + arr[idx];
        }

        @Override
        String desc(long[] arr, int low, int high, long v, int idx) {
            if (idx == -1) {
                return "LT: " + v + " <= arr[" + low + "]=" + arr[low] + "; return -1";
            }
            if (idx == high) {
                return "LT: " + v + " > arr[" + high + "]=" + arr[high] + "; return arr[" + high + "]=" + arr[high];
            }
            return "LT: " + v + ": arr[" + idx + "]=" + arr[idx] + " < " + v + " <= arr[" + (idx + 1) + "]=" + arr[idx + 1] + "; return arr[" + idx + "]=" + arr[idx];
        }
    }
    ,
    LE{

        @Override
        int compare(double[] arr, int a, int b, double v) {
            return v < arr[a] ? -1 : (arr[b] <= v ? 1 : 0);
        }

        @Override
        int compare(float[] arr, int a, int b, float v) {
            return v < arr[a] ? -1 : (arr[b] <= v ? 1 : 0);
        }

        @Override
        int compare(long[] arr, int a, int b, long v) {
            return v < arr[a] ? -1 : (arr[b] <= v ? 1 : 0);
        }

        @Override
        int getIndex(double[] arr, int a, int b, double v) {
            return a;
        }

        @Override
        int getIndex(float[] arr, int a, int b, float v) {
            return a;
        }

        @Override
        int getIndex(long[] arr, int a, int b, long v) {
            return a;
        }

        @Override
        int resolve(int lo, int hi, int low, int high) {
            if (lo >= high) {
                return high;
            }
            return -1;
        }

        @Override
        String desc(double[] arr, int low, int high, double v, int idx) {
            if (idx == -1) {
                return "LE: " + v + " < arr[" + low + "]=" + arr[low] + "; return -1";
            }
            if (idx == high) {
                return "LE: " + v + " >= arr[" + high + "]=" + arr[high] + "; return arr[" + high + "]=" + arr[high];
            }
            return "LE: " + v + ": arr[" + idx + "]=" + arr[idx] + " <= " + v + " < arr[" + (idx + 1) + "]=" + arr[idx + 1] + "; return arr[" + idx + "]=" + arr[idx];
        }

        @Override
        String desc(float[] arr, int low, int high, float v, int idx) {
            if (idx == -1) {
                return "LE: " + v + " < arr[" + low + "]=" + arr[low] + "; return -1";
            }
            if (idx == high) {
                return "LE: " + v + " >= arr[" + high + "]=" + arr[high] + "; return arr[" + high + "]=" + arr[high];
            }
            return "LE: " + v + ": arr[" + idx + "]=" + arr[idx] + " <= " + v + " < arr[" + (idx + 1) + "]=" + arr[idx + 1] + "; return arr[" + idx + "]=" + arr[idx];
        }

        @Override
        String desc(long[] arr, int low, int high, long v, int idx) {
            if (idx == -1) {
                return "LE: " + v + " < arr[" + low + "]=" + arr[low] + "; return -1";
            }
            if (idx == high) {
                return "LE: " + v + " >= arr[" + high + "]=" + arr[high] + "; return arr[" + high + "]=" + arr[high];
            }
            return "LE: " + v + ": arr[" + idx + "]=" + arr[idx] + " <= " + v + " < arr[" + (idx + 1) + "]=" + arr[idx + 1] + "; return arr[" + idx + "]=" + arr[idx];
        }
    }
    ,
    EQ{

        @Override
        int compare(double[] arr, int a, int b, double v) {
            return v < arr[a] ? -1 : (arr[b] < v ? 1 : 0);
        }

        @Override
        int compare(float[] arr, int a, int b, float v) {
            return v < arr[a] ? -1 : (arr[b] < v ? 1 : 0);
        }

        @Override
        int compare(long[] arr, int a, int b, long v) {
            return v < arr[a] ? -1 : (arr[b] < v ? 1 : 0);
        }

        @Override
        int getIndex(double[] arr, int a, int b, double v) {
            return v == arr[a] ? a : (v == arr[b] ? b : -1);
        }

        @Override
        int getIndex(float[] arr, int a, int b, float v) {
            return v == arr[a] ? a : (v == arr[b] ? b : -1);
        }

        @Override
        int getIndex(long[] arr, int a, int b, long v) {
            return v == arr[a] ? a : (v == arr[b] ? b : -1);
        }

        @Override
        int resolve(int lo, int hi, int low, int high) {
            return -1;
        }

        @Override
        String desc(double[] arr, int low, int high, double v, int idx) {
            if (idx == -1) {
                if (v > arr[high]) {
                    return "EQ: " + v + " > arr[" + high + "]; return -1";
                }
                if (v < arr[low]) {
                    return "EQ: " + v + " < arr[" + low + "]; return -1";
                }
                return "EQ: " + v + " Cannot be found within arr[" + low + "], arr[" + high + "]; return -1";
            }
            return "EQ: " + v + " == arr[" + idx + "]; return " + idx;
        }

        @Override
        String desc(float[] arr, int low, int high, float v, int idx) {
            if (idx == -1) {
                if (v > arr[high]) {
                    return "EQ: " + v + " > arr[" + high + "]; return -1";
                }
                if (v < arr[low]) {
                    return "EQ: " + v + " < arr[" + low + "]; return -1";
                }
                return "EQ: " + v + " Cannot be found within arr[" + low + "], arr[" + high + "]; return -1";
            }
            return "EQ: " + v + " == arr[" + idx + "]; return " + idx;
        }

        @Override
        String desc(long[] arr, int low, int high, long v, int idx) {
            if (idx == -1) {
                if (v > arr[high]) {
                    return "EQ: " + v + " > arr[" + high + "]; return -1";
                }
                if (v < arr[low]) {
                    return "EQ: " + v + " < arr[" + low + "]; return -1";
                }
                return "EQ: " + v + " Cannot be found within arr[" + low + "], arr[" + high + "]; return -1";
            }
            return "EQ: " + v + " == arr[" + idx + "]; return " + idx;
        }
    }
    ,
    GE{

        @Override
        int compare(double[] arr, int a, int b, double v) {
            return v <= arr[a] ? -1 : (arr[b] < v ? 1 : 0);
        }

        @Override
        int compare(float[] arr, int a, int b, float v) {
            return v <= arr[a] ? -1 : (arr[b] < v ? 1 : 0);
        }

        @Override
        int compare(long[] arr, int a, int b, long v) {
            return v <= arr[a] ? -1 : (arr[b] < v ? 1 : 0);
        }

        @Override
        int getIndex(double[] arr, int a, int b, double v) {
            return b;
        }

        @Override
        int getIndex(float[] arr, int a, int b, float v) {
            return b;
        }

        @Override
        int getIndex(long[] arr, int a, int b, long v) {
            return b;
        }

        @Override
        int resolve(int lo, int hi, int low, int high) {
            if (hi <= low) {
                return low;
            }
            return -1;
        }

        @Override
        String desc(double[] arr, int low, int high, double v, int idx) {
            if (idx == -1) {
                return "GE: " + v + " > arr[" + high + "]=" + arr[high] + "; return -1";
            }
            if (idx == low) {
                return "GE: " + v + " <= arr[" + low + "]=" + arr[low] + "; return arr[" + low + "]=" + arr[low];
            }
            return "GE: " + v + ": arr[" + (idx - 1) + "]=" + arr[idx - 1] + " < " + v + " <= arr[" + idx + "]=" + arr[idx] + "; return arr[" + idx + "]=" + arr[idx];
        }

        @Override
        String desc(float[] arr, int low, int high, float v, int idx) {
            if (idx == -1) {
                return "GE: " + v + " > arr[" + high + "]=" + arr[high] + "; return -1";
            }
            if (idx == low) {
                return "GE: " + v + " <= arr[" + low + "]=" + arr[low] + "; return arr[" + low + "]=" + arr[low];
            }
            return "GE: " + v + ": arr[" + (idx - 1) + "]=" + arr[idx - 1] + " < " + v + " <= arr[" + idx + "]=" + arr[idx] + "; return arr[" + idx + "]=" + arr[idx];
        }

        @Override
        String desc(long[] arr, int low, int high, long v, int idx) {
            if (idx == -1) {
                return "GE: " + v + " > arr[" + high + "]=" + arr[high] + "; return -1";
            }
            if (idx == low) {
                return "GE: " + v + " <= arr[" + low + "]=" + arr[low] + "; return arr[" + low + "]=" + arr[low];
            }
            return "GE: " + v + ": arr[" + (idx - 1) + "]=" + arr[idx - 1] + " < " + v + " <= arr[" + idx + "]=" + arr[idx] + "; return arr[" + idx + "]=" + arr[idx];
        }
    }
    ,
    GT{

        @Override
        int compare(double[] arr, int a, int b, double v) {
            return v < arr[a] ? -1 : (arr[b] <= v ? 1 : 0);
        }

        @Override
        int compare(float[] arr, int a, int b, float v) {
            return v < arr[a] ? -1 : (arr[b] <= v ? 1 : 0);
        }

        @Override
        int compare(long[] arr, int a, int b, long v) {
            return v < arr[a] ? -1 : (arr[b] <= v ? 1 : 0);
        }

        @Override
        int getIndex(double[] arr, int a, int b, double v) {
            return b;
        }

        @Override
        int getIndex(float[] arr, int a, int b, float v) {
            return b;
        }

        @Override
        int getIndex(long[] arr, int a, int b, long v) {
            return b;
        }

        @Override
        int resolve(int lo, int hi, int low, int high) {
            if (hi <= low) {
                return low;
            }
            return -1;
        }

        @Override
        String desc(double[] arr, int low, int high, double v, int idx) {
            if (idx == -1) {
                return "GT: " + v + " >= arr[" + high + "]=" + arr[high] + "; return -1";
            }
            if (idx == low) {
                return "GT: " + v + " < arr[" + low + "]=" + arr[low] + "; return arr[" + low + "]=" + arr[low];
            }
            return "GT: " + v + ": arr[" + (idx - 1) + "]=" + arr[idx - 1] + " <= " + v + " < arr[" + idx + "]=" + arr[idx] + "; return arr[" + idx + "]=" + arr[idx];
        }

        @Override
        String desc(float[] arr, int low, int high, float v, int idx) {
            if (idx == -1) {
                return "GT: " + v + " >= arr[" + high + "]=" + arr[high] + "; return -1";
            }
            if (idx == low) {
                return "GT: " + v + " < arr[" + low + "]=" + arr[low] + "; return arr[" + low + "]=" + arr[low];
            }
            return "GT: " + v + ": arr[" + (idx - 1) + "]=" + arr[idx - 1] + " <= " + v + " < arr[" + idx + "]=" + arr[idx] + "; return arr[" + idx + "]=" + arr[idx];
        }

        @Override
        String desc(long[] arr, int low, int high, long v, int idx) {
            if (idx == -1) {
                return "GT: " + v + " >= arr[" + high + "]=" + arr[high] + "; return -1";
            }
            if (idx == low) {
                return "GT: " + v + " < arr[" + low + "]=" + arr[low] + "; return arr[" + low + "]=" + arr[low];
            }
            return "GT: " + v + ": arr[" + (idx - 1) + "]=" + arr[idx - 1] + " <= " + v + " < arr[" + idx + "]=" + arr[idx] + "; return arr[" + idx + "]=" + arr[idx];
        }
    };


    abstract int compare(double[] var1, int var2, int var3, double var4);

    abstract int compare(float[] var1, int var2, int var3, float var4);

    abstract int compare(long[] var1, int var2, int var3, long var4);

    abstract int getIndex(double[] var1, int var2, int var3, double var4);

    abstract int getIndex(float[] var1, int var2, int var3, float var4);

    abstract int getIndex(long[] var1, int var2, int var3, long var4);

    abstract int resolve(int var1, int var2, int var3, int var4);

    abstract String desc(double[] var1, int var2, int var3, double var4, int var6);

    abstract String desc(float[] var1, int var2, int var3, float var4, int var5);

    abstract String desc(long[] var1, int var2, int var3, long var4, int var6);

    public static int find(double[] arr, int low, int high, double v, InequalitySearch crit) {
        int lo = low;
        int hi = high - 1;
        while (lo <= hi) {
            int midA = lo + (hi - lo) / 2;
            int ret = crit.compare(arr, midA, midA + 1, v);
            if (ret == -1) {
                hi = midA - 1;
                continue;
            }
            if (ret == 1) {
                lo = midA + 1;
                continue;
            }
            return crit.getIndex(arr, midA, midA + 1, v);
        }
        return crit.resolve(lo, hi, low, high);
    }

    public static int find(float[] arr, int low, int high, float v, InequalitySearch crit) {
        int lo = low;
        int hi = high - 1;
        while (lo <= hi) {
            int mid = lo + (hi - lo) / 2;
            int ret = crit.compare(arr, mid, mid + 1, v);
            if (ret == -1) {
                hi = mid - 1;
                continue;
            }
            if (ret == 1) {
                lo = mid + 1;
                continue;
            }
            return crit.getIndex(arr, mid, mid + 1, v);
        }
        return crit.resolve(lo, hi, low, high);
    }

    public static int find(long[] arr, int low, int high, long v, InequalitySearch crit) {
        int lo = low;
        int hi = high - 1;
        while (lo <= hi) {
            int mid = lo + (hi - lo) / 2;
            int ret = crit.compare(arr, mid, mid + 1, v);
            if (ret == -1) {
                hi = mid - 1;
                continue;
            }
            if (ret == 1) {
                lo = mid + 1;
                continue;
            }
            return crit.getIndex(arr, mid, mid + 1, v);
        }
        return crit.resolve(lo, hi, low, high);
    }
}

