/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.Family;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IteratorTest {
    @Test
    public void checkDirectCompactSketch() {
        int k = 16;
        int maxBytes = Sketch.getMaxUpdateSketchBytes((int)k);
        WritableMemory wmem = WritableMemory.allocate((int)maxBytes);
        UpdateSketch sk1 = Sketches.updateSketchBuilder().setNominalEntries(k).build(wmem);
        IteratorTest.println(sk1.getClass().getSimpleName());
        for (int i = 0; i < k / 2; ++i) {
            sk1.update((long)i);
        }
        HashIterator itr1 = sk1.iterator();
        int count = 0;
        while (itr1.next()) {
            IteratorTest.println(++count + "\t" + Long.toHexString(itr1.get()));
        }
        Assert.assertEquals((int)count, (int)(k / 2));
        IteratorTest.println("");
        CompactSketch sk2 = sk1.compact();
        IteratorTest.println(sk2.getClass().getSimpleName());
        HashIterator itr2 = sk2.iterator();
        count = 0;
        while (itr2.next()) {
            IteratorTest.println(++count + "\t" + Long.toHexString(itr2.get()));
        }
        Assert.assertEquals((int)count, (int)(k / 2));
        IteratorTest.println("");
        CompactSketch sk3 = sk1.compact(false, WritableMemory.allocate((int)maxBytes));
        IteratorTest.println(sk3.getClass().getSimpleName());
        HashIterator itr3 = sk3.iterator();
        count = 0;
        while (itr3.next()) {
            IteratorTest.println(++count + "\t" + Long.toHexString(itr3.get()));
        }
        Assert.assertEquals((int)count, (int)(k / 2));
    }

    @Test
    public void checkHeapAlphaSketch() {
        int k = 512;
        int u = 8;
        UpdateSketch sk1 = Sketches.updateSketchBuilder().setNominalEntries(k).setFamily(Family.ALPHA).build();
        IteratorTest.println(sk1.getClass().getSimpleName());
        for (int i = 0; i < u; ++i) {
            sk1.update((long)i);
        }
        HashIterator itr1 = sk1.iterator();
        int count = 0;
        while (itr1.next()) {
            IteratorTest.println(++count + "\t" + Long.toHexString(itr1.get()));
        }
        Assert.assertEquals((int)count, (int)u);
    }

    @Test
    public void checkHeapQSSketch() {
        int k = 16;
        int u = 8;
        UpdateSketch sk1 = Sketches.updateSketchBuilder().setNominalEntries(k).build();
        IteratorTest.println(sk1.getClass().getSimpleName());
        for (int i = 0; i < u; ++i) {
            sk1.update((long)i);
        }
        HashIterator itr1 = sk1.iterator();
        int count = 0;
        while (itr1.next()) {
            IteratorTest.println(++count + "\t" + Long.toHexString(itr1.get()));
        }
        Assert.assertEquals((int)count, (int)u);
    }

    @Test
    public void checkSingleItemSketch() {
        int k = 16;
        int u = 1;
        UpdateSketch sk1 = Sketches.updateSketchBuilder().setNominalEntries(k).build();
        for (int i = 0; i < u; ++i) {
            sk1.update((long)i);
        }
        CompactSketch csk = sk1.compact();
        IteratorTest.println(csk.getClass().getSimpleName());
        HashIterator itr1 = csk.iterator();
        int count = 0;
        while (itr1.next()) {
            IteratorTest.println(++count + "\t" + Long.toHexString(itr1.get()));
        }
        Assert.assertEquals((int)count, (int)u);
    }

    @Test
    public void printlnTest() {
        IteratorTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

