/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.util.Arrays;
import org.apache.datasketches.Family;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.ConcurrentHeapQuickSelectSketch;
import org.apache.datasketches.theta.ConcurrentHeapThetaBuffer;
import org.apache.datasketches.theta.ConcurrentPropagationService;
import org.apache.datasketches.theta.ConcurrentSharedThetaSketch;
import org.apache.datasketches.theta.HeapQuickSelectSketch;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.datasketches.theta.UpdateSketchBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConcurrentHeapQuickSelectSketchTest {
    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBadSerVer() {
        int k;
        int lgK = 9;
        int u = k = 1 << lgK;
        SharedLocal sl = new SharedLocal(lgK);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertEquals((double)local.getEstimate(), (double)u, (double)0.0);
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)u);
        byte[] serArr = shared.toByteArray();
        WritableMemory mem = WritableMemory.writableWrap((byte[])serArr);
        Sketch sk = Sketch.heapify((Memory)mem, (long)sl.seed);
        Assert.assertTrue((boolean)(sk instanceof HeapQuickSelectSketch));
        mem.putByte(1L, (byte)0);
        Sketch.heapify((Memory)mem, (long)sl.seed);
    }

    @Test
    public void checkPropagationNotOrdered() {
        int lgK = 8;
        int k = 1 << lgK;
        int u = 200 * k;
        SharedLocal sl = new SharedLocal(lgK, 4, false, false);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        Assert.assertEquals((int)sl.bldr.getLocalLgNominalEntries(), (int)4);
        Assert.assertTrue((boolean)local.isEmpty());
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertTrue((shared.getRetainedEntries(true) <= u ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkIllegalSketchID_UpdateSketch() {
        int k;
        int lgK = 9;
        int u = k = 1 << lgK;
        SharedLocal sl = new SharedLocal(lgK);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        Assert.assertTrue((boolean)(shared instanceof ConcurrentHeapQuickSelectSketch));
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        Assert.assertTrue((boolean)shared.compact().isCompact());
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertEquals((double)local.getEstimate(), (double)u, (double)0.0);
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)u);
        byte[] byteArray = shared.toByteArray();
        WritableMemory mem = WritableMemory.writableWrap((byte[])byteArray);
        mem.putByte(2L, (byte)0);
        Sketch.heapify((Memory)mem, (long)sl.seed);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifySeedConflict() {
        int lgK = 9;
        long seed = 1021L;
        long seed2 = 9001L;
        SharedLocal sl = new SharedLocal(lgK, lgK, seed);
        byte[] byteArray = sl.shared.toByteArray();
        Memory srcMem = Memory.wrap((byte[])byteArray);
        Sketch.heapify((Memory)srcMem, (long)seed2);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHeapifyCorruptLgNomLongs() {
        int lgK = 4;
        SharedLocal sl = new SharedLocal(lgK);
        byte[] serArr = sl.shared.toByteArray();
        WritableMemory srcMem = WritableMemory.writableWrap((byte[])serArr);
        srcMem.putByte(3L, (byte)2);
        Sketch.heapify((Memory)srcMem, (long)9001L);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void checkIllegalHashUpdate() {
        int lgK = 4;
        SharedLocal sl = new SharedLocal(lgK);
        sl.shared.hashUpdate(1L);
    }

    @Test
    public void checkHeapifyByteArrayExact() {
        int k;
        int lgK = 9;
        int u = k = 1 << lgK;
        SharedLocal sl = new SharedLocal(lgK);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        byte[] serArr = shared.toByteArray();
        Memory srcMem = Memory.wrap((byte[])serArr);
        UpdateSketch recoveredShared = Sketches.heapifyUpdateSketch((Memory)srcMem);
        int bytes = Sketch.getMaxUpdateSketchBytes((int)k);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        shared = sl.bldr.buildSharedFromSketch(recoveredShared, wmem);
        UpdateSketch local2 = sl.bldr.buildLocal(shared);
        Assert.assertEquals((double)local2.getEstimate(), (double)u, (double)0.0);
        Assert.assertEquals((double)local2.getLowerBound(2), (double)u, (double)0.0);
        Assert.assertEquals((double)local2.getUpperBound(2), (double)u, (double)0.0);
        Assert.assertEquals((boolean)local2.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)local2.isEstimationMode(), (boolean)false);
        Assert.assertEquals((Object)local2.getResizeFactor(), (Object)local.getResizeFactor());
        local2.toString(true, true, 8, true);
    }

    @Test
    public void checkHeapifyByteArrayEstimating() {
        int lgK = 12;
        int k = 1 << lgK;
        int u = 2 * k;
        SharedLocal sl = new SharedLocal(lgK);
        UpdateSketch local = sl.local;
        UpdateSketch shared = sl.shared;
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        double localEst = local.getEstimate();
        double localLB = local.getLowerBound(2);
        double localUB = local.getUpperBound(2);
        Assert.assertEquals((boolean)local.isEstimationMode(), (boolean)true);
        byte[] serArr = shared.toByteArray();
        Memory srcMem = Memory.wrap((byte[])serArr);
        UpdateSketch recoveredShared = UpdateSketch.heapify((Memory)srcMem, (long)sl.seed);
        int bytes = Sketch.getMaxUpdateSketchBytes((int)k);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        shared = sl.bldr.buildSharedFromSketch(recoveredShared, wmem);
        UpdateSketch local2 = sl.bldr.buildLocal(shared);
        Assert.assertEquals((double)local2.getEstimate(), (double)localEst);
        Assert.assertEquals((double)local2.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)local2.getUpperBound(2), (double)localUB);
        Assert.assertEquals((boolean)local2.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)local2.isEstimationMode(), (boolean)true);
        Assert.assertEquals((Object)local2.getResizeFactor(), (Object)local.getResizeFactor());
    }

    @Test
    public void checkHeapifyMemoryEstimating() {
        int lgK = 9;
        int k = 1 << lgK;
        int u = 2 * k;
        boolean estimating = u > k;
        SharedLocal sl = new SharedLocal(lgK);
        UpdateSketch local = sl.local;
        UpdateSketch shared = sl.shared;
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        double localEst = local.getEstimate();
        double localLB = local.getLowerBound(2);
        double localUB = local.getUpperBound(2);
        Assert.assertEquals((boolean)local.isEstimationMode(), (boolean)estimating);
        Assert.assertFalse((boolean)local.isDirect());
        Assert.assertFalse((boolean)local.hasMemory());
        byte[] serArr = shared.toByteArray();
        Memory srcMem = Memory.wrap((byte[])serArr);
        UpdateSketch recoveredShared = UpdateSketch.heapify((Memory)srcMem, (long)9001L);
        int bytes = Sketch.getMaxUpdateSketchBytes((int)k);
        WritableMemory wmem = WritableMemory.allocate((int)bytes);
        shared = sl.bldr.buildSharedFromSketch(recoveredShared, wmem);
        UpdateSketch local2 = sl.bldr.buildLocal(shared);
        Assert.assertEquals((double)local2.getEstimate(), (double)localEst);
        Assert.assertEquals((double)local2.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)local2.getUpperBound(2), (double)localUB);
        Assert.assertEquals((boolean)local2.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)local2.isEstimationMode(), (boolean)estimating);
    }

    @Test
    public void checkHQStoCompactForms() {
        int lgK = 9;
        int k = 1 << lgK;
        int u = 4 * k;
        boolean estimating = u > k;
        int maxBytes = (k << 4) + (Family.QUICKSELECT.getMinPreLongs() << 3);
        SharedLocal sl = new SharedLocal(lgK);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        Assert.assertEquals((String)local.getClass().getSimpleName(), (String)"ConcurrentHeapThetaBuffer");
        Assert.assertFalse((boolean)local.isDirect());
        Assert.assertFalse((boolean)local.hasMemory());
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        shared.rebuild();
        double localEst = local.getEstimate();
        double localLB = local.getLowerBound(2);
        double localUB = local.getUpperBound(2);
        int sharedBytes = shared.getCurrentBytes();
        int sharedCompBytes = shared.getCompactBytes();
        Assert.assertEquals((int)sharedBytes, (int)maxBytes);
        Assert.assertEquals((boolean)local.isEstimationMode(), (boolean)estimating);
        CompactSketch comp1 = shared.compact(false, null);
        Assert.assertEquals((double)comp1.getEstimate(), (double)localEst);
        Assert.assertEquals((double)comp1.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)comp1.getUpperBound(2), (double)localUB);
        Assert.assertEquals((boolean)comp1.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)comp1.isEstimationMode(), (boolean)estimating);
        Assert.assertEquals((int)comp1.getCompactBytes(), (int)sharedCompBytes);
        Assert.assertEquals((String)comp1.getClass().getSimpleName(), (String)"HeapCompactSketch");
        CompactSketch comp2 = shared.compact(true, null);
        Assert.assertEquals((double)comp2.getEstimate(), (double)localEst);
        Assert.assertEquals((double)comp2.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)comp2.getUpperBound(2), (double)localUB);
        Assert.assertEquals((boolean)comp2.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)comp2.isEstimationMode(), (boolean)estimating);
        Assert.assertEquals((int)comp2.getCompactBytes(), (int)sharedCompBytes);
        Assert.assertEquals((String)comp2.getClass().getSimpleName(), (String)"HeapCompactSketch");
        byte[] memArr2 = new byte[sharedCompBytes];
        WritableMemory mem2 = WritableMemory.writableWrap((byte[])memArr2);
        CompactSketch comp3 = shared.compact(false, mem2);
        Assert.assertEquals((double)comp3.getEstimate(), (double)localEst);
        Assert.assertEquals((double)comp3.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)comp3.getUpperBound(2), (double)localUB);
        Assert.assertEquals((boolean)comp3.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)comp3.isEstimationMode(), (boolean)estimating);
        Assert.assertEquals((int)comp3.getCompactBytes(), (int)sharedCompBytes);
        Assert.assertEquals((String)comp3.getClass().getSimpleName(), (String)"DirectCompactSketch");
        mem2.clear();
        CompactSketch comp4 = shared.compact(true, mem2);
        Assert.assertEquals((double)comp4.getEstimate(), (double)localEst);
        Assert.assertEquals((double)comp4.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)comp4.getUpperBound(2), (double)localUB);
        Assert.assertEquals((boolean)comp4.isEmpty(), (boolean)false);
        Assert.assertEquals((boolean)comp4.isEstimationMode(), (boolean)estimating);
        Assert.assertEquals((int)comp4.getCompactBytes(), (int)sharedCompBytes);
        Assert.assertEquals((String)comp4.getClass().getSimpleName(), (String)"DirectCompactSketch");
        comp4.toString(false, true, 0, false);
    }

    @Test
    public void checkHQStoCompactEmptyForms() {
        int lgK = 9;
        SharedLocal sl = new SharedLocal(lgK);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        ConcurrentHeapQuickSelectSketchTest.println("lgArr: " + local.getLgArrLongs());
        local.toString(false, true, 0, false);
        boolean estimating = false;
        Assert.assertTrue((boolean)(local instanceof ConcurrentHeapThetaBuffer));
        double localEst = local.getEstimate();
        double localLB = local.getLowerBound(2);
        double localUB = local.getUpperBound(2);
        int compBytes = local.getCompactBytes();
        Assert.assertEquals((int)compBytes, (int)8);
        Assert.assertEquals((boolean)local.isEstimationMode(), (boolean)estimating);
        byte[] arr2 = new byte[compBytes];
        WritableMemory mem2 = WritableMemory.writableWrap((byte[])arr2);
        CompactSketch csk2 = shared.compact(false, mem2);
        Assert.assertEquals((double)csk2.getEstimate(), (double)localEst);
        Assert.assertEquals((double)csk2.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)csk2.getUpperBound(2), (double)localUB);
        Assert.assertEquals((boolean)csk2.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)csk2.isEstimationMode(), (boolean)estimating);
        Assert.assertTrue((boolean)csk2.isOrdered());
        CompactSketch csk3 = shared.compact(true, mem2);
        csk3.toString(false, true, 0, false);
        csk3.toString();
        Assert.assertEquals((double)csk3.getEstimate(), (double)localEst);
        Assert.assertEquals((double)csk3.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)csk3.getUpperBound(2), (double)localUB);
        Assert.assertEquals((boolean)csk3.isEmpty(), (boolean)true);
        Assert.assertEquals((boolean)csk3.isEstimationMode(), (boolean)estimating);
        Assert.assertTrue((boolean)csk3.isOrdered());
    }

    @Test
    public void checkExactMode() {
        int lgK = 12;
        int u = 1 << lgK;
        SharedLocal sl = new SharedLocal(lgK);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertEquals((double)local.getEstimate(), (double)u, (double)0.0);
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)u);
    }

    @Test
    public void checkEstMode() {
        int lgK = 12;
        int k = 1 << lgK;
        SharedLocal sl = new SharedLocal(lgK);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        int u = 3 * k;
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        int retained = shared.getRetainedEntries(false);
        Assert.assertTrue((retained > k ? 1 : 0) != 0);
    }

    @Test
    public void checkErrorBounds() {
        int lgK = 9;
        int k = 1 << lgK;
        SharedLocal sl = new SharedLocal(lgK);
        UpdateSketch local = sl.local;
        UpdateSketch shared = sl.shared;
        for (int i = 0; i < k; ++i) {
            local.update((long)i);
        }
        double est = local.getEstimate();
        double lb = local.getLowerBound(2);
        double ub = local.getUpperBound(2);
        Assert.assertEquals((double)est, (double)ub, (double)0.0);
        Assert.assertEquals((double)est, (double)lb, (double)0.0);
        int u = 2 * k;
        for (int i = k; i < u; ++i) {
            local.update((long)i);
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        est = local.getEstimate();
        lb = local.getLowerBound(2);
        ub = local.getUpperBound(2);
        Assert.assertTrue((est <= ub ? 1 : 0) != 0);
        Assert.assertTrue((est >= lb ? 1 : 0) != 0);
    }

    @Test
    public void checkRebuild() {
        int lgK = 4;
        int k = 1 << lgK;
        SharedLocal sl = new SharedLocal(lgK);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        int t = ((ConcurrentHeapThetaBuffer)local).getHashTableThreshold();
        for (int i = 0; i < t; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertTrue((local.getEstimate() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((shared.getRetainedEntries(false) > k ? 1 : 0) != 0);
        shared.rebuild();
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)k);
        Assert.assertEquals((int)shared.getRetainedEntries(true), (int)k);
        shared.rebuild();
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)k);
        Assert.assertEquals((int)shared.getRetainedEntries(true), (int)k);
    }

    @Test
    public void checkBuilder() {
        int lgK = 4;
        SharedLocal sl = new SharedLocal(lgK);
        Assert.assertEquals((int)sl.bldr.getLocalLgNominalEntries(), (int)lgK);
        Assert.assertEquals((int)sl.bldr.getLgNominalEntries(), (int)lgK);
        ConcurrentHeapQuickSelectSketchTest.println(sl.bldr.toString());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBuilderSmallNominal() {
        int lgK = 2;
        new SharedLocal(lgK);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkNegativeHashes() {
        int lgK = 9;
        SharedLocal sl = new SharedLocal(lgK);
        UpdateSketch local = sl.local;
        local.hashUpdate(-1L);
    }

    @Test
    public void checkResetAndStartingSubMultiple() {
        int lgK = 9;
        int k = 1 << lgK;
        SharedLocal sl = new SharedLocal(lgK);
        UpdateSketch shared = sl.shared;
        UpdateSketch local = sl.local;
        Assert.assertTrue((boolean)local.isEmpty());
        int u = 3 * k;
        for (int i = 0; i < u; ++i) {
            local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(shared);
        Assert.assertFalse((boolean)local.isEmpty());
        Assert.assertTrue((shared.getRetainedEntries(false) >= k ? 1 : 0) != 0);
        Assert.assertTrue((local.getThetaLong() < Long.MAX_VALUE ? 1 : 0) != 0);
        shared.reset();
        local.reset();
        Assert.assertTrue((boolean)local.isEmpty());
        Assert.assertEquals((int)shared.getRetainedEntries(false), (int)0);
        Assert.assertEquals((double)local.getEstimate(), (double)0.0, (double)0.0);
        Assert.assertEquals((long)local.getThetaLong(), (long)Long.MAX_VALUE);
    }

    @Test
    public void checkDQStoCompactEmptyForms() {
        int lgK = 9;
        SharedLocal sl = new SharedLocal(lgK);
        UpdateSketch local = sl.local;
        UpdateSketch shared = sl.shared;
        local.toString(false, true, 0, false);
        Assert.assertTrue((boolean)(local instanceof ConcurrentHeapThetaBuffer));
        double localEst = local.getEstimate();
        double localLB = local.getLowerBound(2);
        double uskUB = local.getUpperBound(2);
        Assert.assertFalse((boolean)local.isEstimationMode());
        int bytes = local.getCompactBytes();
        Assert.assertEquals((int)bytes, (int)8);
        byte[] memArr2 = new byte[bytes];
        WritableMemory mem2 = WritableMemory.writableWrap((byte[])memArr2);
        CompactSketch csk2 = shared.compact(false, mem2);
        Assert.assertEquals((double)csk2.getEstimate(), (double)localEst);
        Assert.assertEquals((double)csk2.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)csk2.getUpperBound(2), (double)uskUB);
        Assert.assertTrue((boolean)csk2.isEmpty());
        Assert.assertFalse((boolean)csk2.isEstimationMode());
        Assert.assertTrue((boolean)csk2.isOrdered());
        CompactSketch csk3 = shared.compact(true, mem2);
        csk3.toString(false, true, 0, false);
        csk3.toString();
        Assert.assertEquals((double)csk3.getEstimate(), (double)localEst);
        Assert.assertEquals((double)csk3.getLowerBound(2), (double)localLB);
        Assert.assertEquals((double)csk3.getUpperBound(2), (double)uskUB);
        Assert.assertTrue((boolean)csk3.isEmpty());
        Assert.assertFalse((boolean)csk3.isEstimationMode());
        Assert.assertTrue((boolean)csk2.isOrdered());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkMinReqBytes() {
        int lgK = 4;
        int k = 1 << lgK;
        SharedLocal sl = new SharedLocal(lgK);
        for (int i = 0; i < 4 * k; ++i) {
            sl.local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(sl.shared);
        byte[] byteArray = sl.shared.toByteArray();
        byte[] badBytes = Arrays.copyOfRange(byteArray, 0, 24);
        Memory mem = Memory.wrap((byte[])badBytes);
        Sketch.heapify((Memory)mem);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkThetaAndLgArrLongs() {
        int lgK = 4;
        int k = 1 << lgK;
        SharedLocal sl = new SharedLocal(lgK);
        for (int i = 0; i < k; ++i) {
            sl.local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(sl.shared);
        byte[] badArray = sl.shared.toByteArray();
        WritableMemory mem = WritableMemory.writableWrap((byte[])badArray);
        PreambleUtil.insertLgArrLongs((WritableMemory)mem, (int)4);
        PreambleUtil.insertThetaLong((WritableMemory)mem, (long)0x3FFFFFFFFFFFFFFFL);
        Sketch.heapify((Memory)mem);
    }

    @Test
    public void checkFamily() {
        SharedLocal sl = new SharedLocal();
        UpdateSketch local = sl.local;
        Assert.assertEquals((Object)local.getFamily(), (Object)Family.QUICKSELECT);
    }

    @Test
    public void checkBackgroundPropagation() {
        int i;
        int lgK = 4;
        int k = 1 << lgK;
        int u = 5 * k;
        SharedLocal sl = new SharedLocal(lgK);
        Assert.assertTrue((boolean)sl.local.isEmpty());
        for (i = 0; i < k; ++i) {
            sl.local.update((long)i);
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(sl.shared);
        Assert.assertFalse((boolean)sl.local.isEmpty());
        Assert.assertTrue((sl.local.getEstimate() > 0.0 ? 1 : 0) != 0);
        long theta1 = sl.sharedIf.getVolatileTheta();
        while (i < u) {
            sl.local.update((long)i);
            ++i;
        }
        ConcurrentHeapQuickSelectSketchTest.waitForBgPropagationToComplete(sl.shared);
        long theta2 = sl.sharedIf.getVolatileTheta();
        int entries = sl.shared.getRetainedEntries(false);
        Assert.assertTrue((entries > k || theta2 < theta1 ? 1 : 0) != 0, (String)("entries= " + entries + " k= " + k + " theta1= " + theta1 + " theta2= " + theta2));
        sl.shared.rebuild();
        Assert.assertEquals((int)sl.shared.getRetainedEntries(false), (int)k);
        Assert.assertEquals((int)sl.shared.getRetainedEntries(true), (int)k);
        sl.local.rebuild();
        Assert.assertEquals((int)sl.shared.getRetainedEntries(false), (int)k);
        Assert.assertEquals((int)sl.shared.getRetainedEntries(true), (int)k);
    }

    @Test
    public void checkBuilderExceptions() {
        UpdateSketchBuilder bldr = new UpdateSketchBuilder();
        try {
            bldr.setNominalEntries(8);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            bldr.setLocalNominalEntries(8);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            bldr.setLocalLogNominalEntries(3);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        bldr.setNumPoolThreads(4);
        Assert.assertEquals((int)bldr.getNumPoolThreads(), (int)4);
        bldr.setMaxConcurrencyError(0.04);
        Assert.assertEquals((double)bldr.getMaxConcurrencyError(), (double)0.04);
        bldr.setMaxNumLocalThreads(4);
        Assert.assertEquals((int)bldr.getMaxNumLocalThreads(), (int)4);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class})
    public void checkToByteArray() {
        SharedLocal sl = new SharedLocal();
        sl.local.toByteArray();
    }

    @Test
    public void printlnTest() {
        ConcurrentHeapQuickSelectSketchTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }

    static void waitForBgPropagationToComplete(UpdateSketch shared) {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ConcurrentSharedThetaSketch csts = (ConcurrentSharedThetaSketch)shared;
        csts.awaitBgPropagationTermination();
        ConcurrentPropagationService.resetExecutorService((long)Thread.currentThread().getId());
        csts.initBgPropagationService();
    }

    static class SharedLocal {
        static final long DefaultSeed = 9001L;
        final UpdateSketch shared;
        final ConcurrentSharedThetaSketch sharedIf;
        final UpdateSketch local;
        final int sharedLgK;
        final int localLgK;
        final long seed;
        final WritableMemory wmem;
        final UpdateSketchBuilder bldr = new UpdateSketchBuilder();

        SharedLocal() {
            this(9, 9, 9001L, false, true, 1);
        }

        SharedLocal(int lgK) {
            this(lgK, lgK, 9001L, false, true, 1);
        }

        SharedLocal(int sharedLgK, int localLgK) {
            this(sharedLgK, localLgK, 9001L, false, true, 1);
        }

        SharedLocal(int sharedLgK, int localLgK, long seed) {
            this(sharedLgK, localLgK, seed, false, true, 1);
        }

        SharedLocal(int sharedLgK, int localLgK, boolean useMem) {
            this(sharedLgK, localLgK, 9001L, useMem, true, 1);
        }

        SharedLocal(int sharedLgK, int localLgK, boolean useMem, boolean ordered) {
            this(sharedLgK, localLgK, 9001L, useMem, ordered, 1);
        }

        SharedLocal(int sharedLgK, int localLgK, long seed, boolean useMem, boolean ordered, int memMult) {
            this.sharedLgK = sharedLgK;
            this.localLgK = localLgK;
            this.seed = seed;
            if (useMem) {
                int bytes = (4 << sharedLgK) * memMult + Family.QUICKSELECT.getMaxPreLongs() << 3;
                this.wmem = WritableMemory.allocate((int)bytes);
            } else {
                this.wmem = null;
            }
            this.bldr.setLogNominalEntries(sharedLgK);
            this.bldr.setLocalLogNominalEntries(localLgK);
            this.bldr.setPropagateOrderedCompact(ordered);
            this.bldr.setSeed(this.seed);
            this.shared = this.bldr.buildShared(this.wmem);
            this.local = this.bldr.buildLocal(this.shared);
            this.sharedIf = (ConcurrentSharedThetaSketch)this.shared;
        }
    }
}

